/**
 * Note: This file was auto-generated by TI PinMux on 5/1/2017 at 5:28:16 PM.
 *
 * \file  66AK2G0x_pinmux_data.c
 *
 * \brief  This file contains the pin mux configurations for the boards.
 *         These are prepared based on how the peripherals are extended on
 *         the boards.
 *
 * \copyright Copyright (CU) 2017 Texas Instruments Incorporated -
 *             http://www.ti.com/
 */

/**
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
/* #include "csl_types.h" */
#include "types.h"
#include "pinmux.h"
#include "66AK2G0x_pinmux.h"

/** Peripheral Pin Configurations */

#ifndef BUILDCFG_MOD_PRU_ICSS
#define BUILDCFG_MOD_PRU_ICSS
#endif /* BUILDCFG_MOD_PRU_ICSS */

#ifndef BUILDCFG_MOD_PWMSS
#define BUILDCFG_MOD_PWMSS
#endif /* BUILDCFG_MOD_PWMSS */

#ifndef BUILDCFG_MOD_GPIO
#define BUILDCFG_MOD_GPIO
#endif /* BUILDCFG_MOD_GPIO */

#ifndef BUILDCFG_MOD_UART
#define BUILDCFG_MOD_UART
#endif /* BUILDCFG_MOD_UART */

#ifndef BUILDCFG_MOD_PCIE
#define BUILDCFG_MOD_PCIE
#endif /* BUILDCFG_MOD_PCIE */

#ifndef BUILDCFG_MOD_MMCSD
#define BUILDCFG_MOD_MMCSD
#endif /* BUILDCFG_MOD_MMCSD */

#ifndef BUILDCFG_MOD_DEBUGSS
#define BUILDCFG_MOD_DEBUGSS
#endif /* BUILDCFG_MOD_DEBUGSS */

#ifndef BUILDCFG_MOD_EMAC
#define BUILDCFG_MOD_EMAC
#endif /* BUILDCFG_MOD_EMAC */

#ifndef BUILDCFG_MOD_CPSW
#define BUILDCFG_MOD_CPSW
#endif /* BUILDCFG_MOD_CPSW */

#ifndef BUILDCFG_MOD_DDR
#define BUILDCFG_MOD_DDR
#endif /* BUILDCFG_MOD_DDR */

#ifndef BUILDCFG_MOD_MCSPI
#define BUILDCFG_MOD_MCSPI
#endif /* BUILDCFG_MOD_MCSPI */

#ifndef BUILDCFG_MOD_SYSTEM
#define BUILDCFG_MOD_SYSTEM
#endif /* BUILDCFG_MOD_SYSTEM */

#ifndef BUILDCFG_MOD_I2C
#define BUILDCFG_MOD_I2C
#endif /* BUILDCFG_MOD_I2C */

#ifndef BUILDCFG_MOD_QSPI
#define BUILDCFG_MOD_QSPI
#endif /* BUILDCFG_MOD_QSPI */


#if defined(BUILDCFG_MOD_PRU_ICSS)

static pinmuxPerCfg_t gPru_icss0PinCfg[] =
{
    {
       /* PRUSS0_IEP -> PR0_EDIO_OUTVALID -> L25 */
       PIN_DSS_FID, 0, \
       ( \
           PIN_MODE(2) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_IEP -> PR0_EDIO_DATA0 -> D23 */
       PIN_EHRPWM3_SYNCO, 0, \
       ( \
           PIN_MODE(1) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_IEP -> PR0_EDIO_DATA1 -> C22 */
       PIN_EHRPWM3_SYNCI, 0, \
       ( \
           PIN_MODE(1) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_IEP -> PR0_EDIO_DATA2 -> B22 */
       PIN_EHRPWM3_B, 0, \
       ( \
           PIN_MODE(1) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_IEP -> PR0_EDIO_DATA3 -> A23 */
       PIN_EHRPWM3_A, 0, \
       ( \
           PIN_MODE(1) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_IEP -> PR0_EDC_SYNC0_OUT -> A5 */
       PIN_PR0_PRU0_GPO19, 0, \
       ( \
           PIN_MODE(2) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_IEP -> PR0_EDC_SYNC1_OUT -> B10 */
       PIN_PR0_PRU1_GPO19, 0, \
       ( \
           PIN_MODE(2) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_IEP -> PR0_EDC_LATCH0_IN -> C5 */
       PIN_PR0_PRU0_GPO18, 0, \
       ( \
           PIN_MODE(2) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_IEP -> PR0_EDC_LATCH1_IN -> A9 */
       PIN_PR0_PRU1_GPO18, 0, \
       ( \
           PIN_MODE(2) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_MDIO -> PR0_MDIO_DATA -> A10 */
       PIN_PR0_MDIO_DATA, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {
       /* PRUSS0_MDIO -> PR0_MDIO_MDCLK -> C10 */
       PIN_PR0_MDIO_MDCLK, 0, \
       ( \
           PIN_MODE(0) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_MII -> pr0_mii_mt0_clk -> C9 */
       PIN_PR0_PRU1_GPO16, 0, \
       ( \
           PIN_MODE(12) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_MII -> pr0_mii0_txen -> C8 */
       PIN_PR0_PRU1_GPO15, 0, \
       ( \
           PIN_MODE(8) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_MII -> pr0_mii0_txd3 -> D9 */
       PIN_PR0_PRU1_GPO14, 0, \
       ( \
           PIN_MODE(8) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_MII -> pr0_mii0_txd2 -> B8 */
       PIN_PR0_PRU1_GPO13, 0, \
       ( \
           PIN_MODE(8) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_MII -> pr0_mii0_txd1 -> A8 */
       PIN_PR0_PRU1_GPO12, 0, \
       ( \
           PIN_MODE(8) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_MII -> pr0_mii0_txd0 -> E9 */
       PIN_PR0_PRU1_GPO11, 0, \
       ( \
           PIN_MODE(8) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_MII -> pr0_mii0_rxdv -> A3 */
       PIN_PR0_PRU0_GPO4, 0, \
       ( \
           PIN_MODE(12) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_MII -> pr0_mii_mr0_clk -> B2 */
       PIN_PR0_PRU0_GPO6, 0, \
       ( \
           PIN_MODE(12) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_MII -> pr0_mii0_rxd3 -> B1 */
       PIN_PR0_PRU0_GPO3, 0, \
       ( \
           PIN_MODE(12) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_MII -> pr0_mii0_rxd2 -> E4 */
       PIN_PR0_PRU0_GPO2, 0, \
       ( \
           PIN_MODE(12) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_MII -> pr0_mii0_crs -> C3 */
       PIN_PR0_PRU0_GPO10, 0, \
       ( \
           PIN_MODE(12) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_MII -> pr0_mii0_rxer -> E5 */
       PIN_PR0_PRU0_GPO5, 0, \
       ( \
           PIN_MODE(12) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_MII -> pr0_mii0_rxd1 -> A2 */
       PIN_PR0_PRU0_GPO1, 0, \
       ( \
           PIN_MODE(12) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_MII -> pr0_mii0_rxd0 -> D3 */
       PIN_PR0_PRU0_GPO0, 0, \
       ( \
           PIN_MODE(12) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_MII -> pr0_mii0_col -> C2 */
       PIN_PR0_PRU0_GPO9, 0, \
       ( \
           PIN_MODE(12) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_MII -> pr0_mii0_rxlink -> E6 */
       PIN_PR0_PRU0_GPO8, 0, \
       ( \
           PIN_MODE(12) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_MII -> pr0_mii_mt1_clk -> D6 */
       PIN_PR0_PRU0_GPO16, 0, \
       ( \
           PIN_MODE(12) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_MII -> pr0_mii1_txen -> E7 */
       PIN_PR0_PRU0_GPO15, 0, \
       ( \
           PIN_MODE(8) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_MII -> pr0_mii1_txd3 -> A4 */
       PIN_PR0_PRU0_GPO14, 0, \
       ( \
           PIN_MODE(8) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_MII -> pr0_mii1_txd2 -> B4 */
       PIN_PR0_PRU0_GPO13, 0, \
       ( \
           PIN_MODE(8) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_MII -> pr0_mii1_txd1 -> B3 */
       PIN_PR0_PRU0_GPO12, 0, \
       ( \
           PIN_MODE(8) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_MII -> pr0_mii1_txd0 -> D5 */
       PIN_PR0_PRU0_GPO11, 0, \
       ( \
           PIN_MODE(8) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_MII -> pr0_mii1_rxdv -> C6 */
       PIN_PR0_PRU1_GPO4, 0, \
       ( \
           PIN_MODE(12) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_MII -> pr0_mii_mr1_clk -> A7 */
       PIN_PR0_PRU1_GPO6, 0, \
       ( \
           PIN_MODE(12) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_MII -> pr0_mii1_rxd3 -> A6 */
       PIN_PR0_PRU1_GPO3, 0, \
       ( \
           PIN_MODE(12) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_MII -> pr0_mii1_rxd2 -> D7 */
       PIN_PR0_PRU1_GPO2, 0, \
       ( \
           PIN_MODE(12) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_MII -> pr0_mii1_crs -> C7 */
       PIN_PR0_PRU1_GPO10, 0, \
       ( \
           PIN_MODE(12) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_MII -> pr0_mii1_rxer -> E8 */
       PIN_PR0_PRU1_GPO5, 0, \
       ( \
           PIN_MODE(12) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_MII -> pr0_mii1_rxd1 -> B6 */
       PIN_PR0_PRU1_GPO1, 0, \
       ( \
           PIN_MODE(12) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_MII -> pr0_mii1_rxd0 -> B5 */
       PIN_PR0_PRU1_GPO0, 0, \
       ( \
           PIN_MODE(12) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_MII -> pr0_mii1_col -> B7 */
       PIN_PR0_PRU1_GPO9, 0, \
       ( \
           PIN_MODE(12) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_MII -> pr0_mii1_rxlink -> F9 */
       PIN_PR0_PRU1_GPO8, 0, \
       ( \
           PIN_MODE(12) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS1_MDIO -> PR1_MDIO_DATA -> E18 */
       PIN_PR1_MDIO_DATA, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {
       /* PRUSS1_MDIO -> PR1_MDIO_MDCLK -> D18 */
       PIN_PR1_MDIO_MDCLK, 0, \
       ( \
           PIN_MODE(0) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_UART0 -> PR0_UART0_RXD -> E25 */
       PIN_SPI3_SCSN1, 0, \
       ( \
           PIN_MODE(2) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_UART0 -> PR0_UART0_TXD -> E24 */
       PIN_SPI3_CLK, 0, \
       ( \
           PIN_MODE(2) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS1_eCAP0 -> PR1_eCAP0_eCAP_CAPIN_APWM_O -> R25 */
       PIN_DSS_VSYNC, 0, \
       ( \
           PIN_MODE(2) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS1_eCAP0 -> PR1_eCAP0_eCAP_SYNCIN -> P22 */
       PIN_DSS_HSYNC, 0, \
       ( \
           PIN_MODE(2) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS1_eCAP0 -> PR1_eCAP0_eCAP_SYNCOUT -> N25 */
       PIN_DSS_PCLK, 0, \
       ( \
           PIN_MODE(2) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS0_eCAP0 -> PR0_eCAP0_eCAP_CAPIN_APWM_O -> C24 */
       PIN_SPI3_SCSN0, 0, \
       ( \
           PIN_MODE(2) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS1_UART0 -> PR1_UART0_RXD -> C4 */
       PIN_PR0_PRU0_GPO17, 0, \
       ( \
           PIN_MODE(2) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* PRUSS1_UART0 -> PR1_UART0_TXD -> B9 */
       PIN_PR0_PRU1_GPO17, 0, \
       ( \
           PIN_MODE(2) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MyPRU-ICSS1_MII1 -> pr1_mii_mt0_clk -> D16 */
       PIN_PR1_PRU1_GPO16, 0, \
       ( \
           PIN_MODE(12) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MyPRU-ICSS1_MII1 -> pr1_mii0_txen -> C18 */
       PIN_PR1_PRU1_GPO15, 0, \
       ( \
           PIN_MODE(8) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MyPRU-ICSS1_MII1 -> pr1_mii0_txd3 -> D17 */
       PIN_PR1_PRU1_GPO14, 0, \
       ( \
           PIN_MODE(8) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MyPRU-ICSS1_MII1 -> pr1_mii0_txd2 -> C16 */
       PIN_PR1_PRU1_GPO13, 0, \
       ( \
           PIN_MODE(8) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MyPRU-ICSS1_MII1 -> pr1_mii0_txd1 -> B16 */
       PIN_PR1_PRU1_GPO12, 0, \
       ( \
           PIN_MODE(8) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MyPRU-ICSS1_MII1 -> pr1_mii0_txd0 -> E15 */
       PIN_PR1_PRU1_GPO11, 0, \
       ( \
           PIN_MODE(8) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MyPRU-ICSS1_MII1 -> pr1_mii0_rxdv -> D11 */
       PIN_PR1_PRU0_GPO4, 0, \
       ( \
           PIN_MODE(12) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MyPRU-ICSS1_MII1 -> pr1_mii_mr0_clk -> F12 */
       PIN_PR1_PRU0_GPO6, 0, \
       ( \
           PIN_MODE(12) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MyPRU-ICSS1_MII1 -> pr1_mii0_rxd3 -> C11 */
       PIN_PR1_PRU0_GPO3, 0, \
       ( \
           PIN_MODE(12) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MyPRU-ICSS1_MII1 -> pr1_mii0_rxd2 -> F10 */
       PIN_PR1_PRU0_GPO2, 0, \
       ( \
           PIN_MODE(12) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MyPRU-ICSS1_MII1 -> pr1_mii0_crs -> B12 */
       PIN_PR1_PRU0_GPO10, 0, \
       ( \
           PIN_MODE(12) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MyPRU-ICSS1_MII1 -> pr1_mii0_rxer -> E11 */
       PIN_PR1_PRU0_GPO5, 0, \
       ( \
           PIN_MODE(12) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MyPRU-ICSS1_MII1 -> pr1_mii0_rxd1 -> D10 */
       PIN_PR1_PRU0_GPO1, 0, \
       ( \
           PIN_MODE(12) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MyPRU-ICSS1_MII1 -> pr1_mii0_rxd0 -> E10 */
       PIN_PR1_PRU0_GPO0, 0, \
       ( \
           PIN_MODE(12) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MyPRU-ICSS1_MII1 -> pr1_mii0_col -> B11 */
       PIN_PR1_PRU0_GPO9, 0, \
       ( \
           PIN_MODE(12) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MyPRU-ICSS1_MII1 -> pr1_mii0_rxlink -> C12 */
       PIN_PR1_PRU0_GPO8, 0, \
       ( \
           PIN_MODE(12) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MyPRU-ICSS1_MII1 -> pr1_mii_mt1_clk -> C13 */
       PIN_PR1_PRU0_GPO16, 0, \
       ( \
           PIN_MODE(12) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MyPRU-ICSS1_MII1 -> pr1_mii1_txen -> F13 */
       PIN_PR1_PRU0_GPO15, 0, \
       ( \
           PIN_MODE(8) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MyPRU-ICSS1_MII1 -> pr1_mii1_txd3 -> B13 */
       PIN_PR1_PRU0_GPO14, 0, \
       ( \
           PIN_MODE(8) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MyPRU-ICSS1_MII1 -> pr1_mii1_txd2 -> A13 */
       PIN_PR1_PRU0_GPO13, 0, \
       ( \
           PIN_MODE(8) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MyPRU-ICSS1_MII1 -> pr1_mii1_txd1 -> A11 */
       PIN_PR1_PRU0_GPO12, 0, \
       ( \
           PIN_MODE(8) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MyPRU-ICSS1_MII1 -> pr1_mii1_txd0 -> A12 */
       PIN_PR1_PRU0_GPO11, 0, \
       ( \
           PIN_MODE(8) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MyPRU-ICSS1_MII1 -> pr1_mii1_rxdv -> D14 */
       PIN_PR1_PRU1_GPO4, 0, \
       ( \
           PIN_MODE(12) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MyPRU-ICSS1_MII1 -> pr1_mii_mr1_clk -> F14 */
       PIN_PR1_PRU1_GPO6, 0, \
       ( \
           PIN_MODE(12) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MyPRU-ICSS1_MII1 -> pr1_mii1_rxd3 -> E14 */
       PIN_PR1_PRU1_GPO3, 0, \
       ( \
           PIN_MODE(12) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MyPRU-ICSS1_MII1 -> pr1_mii1_rxd2 -> C14 */
       PIN_PR1_PRU1_GPO2, 0, \
       ( \
           PIN_MODE(12) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MyPRU-ICSS1_MII1 -> pr1_mii1_crs -> A16 */
       PIN_PR1_PRU1_GPO10, 0, \
       ( \
           PIN_MODE(12) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MyPRU-ICSS1_MII1 -> pr1_mii1_rxer -> A15 */
       PIN_PR1_PRU1_GPO5, 0, \
       ( \
           PIN_MODE(12) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MyPRU-ICSS1_MII1 -> pr1_mii1_rxd1 -> B14 */
       PIN_PR1_PRU1_GPO1, 0, \
       ( \
           PIN_MODE(12) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MyPRU-ICSS1_MII1 -> pr1_mii1_rxd0 -> A14 */
       PIN_PR1_PRU1_GPO0, 0, \
       ( \
           PIN_MODE(12) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MyPRU-ICSS1_MII1 -> pr1_mii1_col -> D15 */
       PIN_PR1_PRU1_GPO9, 0, \
       ( \
           PIN_MODE(12) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MyPRU-ICSS1_MII1 -> pr1_mii1_rxlink -> C15 */
       PIN_PR1_PRU1_GPO8, 0, \
       ( \
           PIN_MODE(12) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gPru_icssPinCfg[] =
{
    {0, TRUE, gPru_icss0PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_PRU_ICSS) */

#if defined(BUILDCFG_MOD_PWMSS)

static pinmuxPerCfg_t gPwmss2PinCfg[] =
{
    {
       /* eQEP2 -> eQEP2_A -> U23 */
       PIN_DSS_DATA4, 0, \
       ( \
           PIN_MODE(2) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* eQEP2 -> eQEP2_B -> V23 */
       PIN_DSS_DATA3, 0, \
       ( \
           PIN_MODE(2) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* eQEP2 -> eQEP2_I -> W22 */
       PIN_DSS_DATA2, 0, \
       ( \
           PIN_MODE(2) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* eQEP2 -> eQEP2_S -> U21 */
       PIN_DSS_DATA1, 0, \
       ( \
           PIN_MODE(2) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gPwmssPinCfg[] =
{
    {2, TRUE, gPwmss2PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_PWMSS) */

#if defined(BUILDCFG_MOD_GPIO)

static pinmuxPerCfg_t gGpio0PinCfg[] =
{
    {
       /* GPIO0 -> GPIO0_10 -> AA20 */
       PIN_GPMC_AD10, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_11 -> AD23 */
       PIN_GPMC_AD11, 0, \
       ( \
           PIN_MODE(3) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_12 -> AA21 */
       PIN_GPMC_AD12, 0, \
       ( \
           PIN_MODE(3) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_13 -> AB21 */
       PIN_GPMC_AD13, 0, \
       ( \
           PIN_MODE(3) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_14 -> AB22 */
       PIN_GPMC_AD14, 0, \
       ( \
           PIN_MODE(3) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_15 -> AA22 */
       PIN_GPMC_AD15, 0, \
       ( \
           PIN_MODE(3) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_16 -> AB23 */
       PIN_GPMC_CLK, 0, \
       ( \
           PIN_MODE(3) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_17 -> AC23 */
       PIN_GPMC_ADVN_ALE, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_19 -> Y22 */
       PIN_GPMC_WEN, 0, \
       ( \
           PIN_MODE(3) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_20 -> AC24 */
       PIN_GPMC_BEN0_CLE, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_21 -> AB24 */
       PIN_GPMC_BEN1, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_22 -> Y24 */
       PIN_GPMC_WAIT0, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_23 -> AA24 */
       PIN_GPMC_WAIT1, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_24 -> W25 */
       PIN_GPMC_WPN, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_25 -> AA25 */
       PIN_GPMC_DIR, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_28 -> W23 */
       PIN_GPMC_CSN2, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_29 -> Y25 */
       PIN_GPMC_CSN3, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_33 -> N24 */
       PIN_DSS_DATA20, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_34 -> T25 */
       PIN_DSS_DATA19, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_35 -> N22 */
       PIN_DSS_DATA18, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_36 -> R24 */
       PIN_DSS_DATA17, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_37 -> P23 */
       PIN_DSS_DATA16, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_38 -> R22 */
       PIN_DSS_DATA15, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_39 -> U25 */
       PIN_DSS_DATA14, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_40 -> P21 */
       PIN_DSS_DATA13, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_41 -> T24 */
       PIN_DSS_DATA12, 0, \
       ( \
           PIN_MODE(3) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_42 -> V25 */
       PIN_DSS_DATA11, 0, \
       ( \
           PIN_MODE(3) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_43 -> U24 */
       PIN_DSS_DATA10, 0, \
       ( \
           PIN_MODE(3) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_44 -> R21 */
       PIN_DSS_DATA9, 0, \
       ( \
           PIN_MODE(3) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_45 -> T22 */
       PIN_DSS_DATA8, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_46 -> U22 */
       PIN_DSS_DATA7, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_69 -> J3 */
       PIN_MMC1_SDCD, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_70 -> K3 */
       PIN_MMC1_SDWP, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_71 -> K2 */
       PIN_MMC1_POW, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_101 -> P3 */
       PIN_SPI2_SCSN0, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_102 -> P4 */
       PIN_SPI2_SCSN1, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_106 -> T2 */
       PIN_UART0_CTSN, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_107 -> U1 */
       PIN_UART0_RTSN, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_115 -> D4 */
       PIN_PR0_PRU0_GPO7, 0, \
       ( \
           PIN_MODE(3) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_135 -> D8 */
       PIN_PR0_PRU1_GPO7, 0, \
       ( \
           PIN_MODE(3) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_00 -> AC21 */
       PIN_GPMC_AD0, 0, \
       ( \
           PIN_MODE(3) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_01 -> AE20 */
       PIN_GPMC_AD1, 0, \
       ( \
           PIN_MODE(3) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_02 -> AD22 */
       PIN_GPMC_AD2, 0, \
       ( \
           PIN_MODE(3) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_03 -> AD20 */
       PIN_GPMC_AD3, 0, \
       ( \
           PIN_MODE(3) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_04 -> AE21 */
       PIN_GPMC_AD4, 0, \
       ( \
           PIN_MODE(3) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_05 -> AE22 */
       PIN_GPMC_AD5, 0, \
       ( \
           PIN_MODE(3) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_06 -> AC20 */
       PIN_GPMC_AD6, 0, \
       ( \
           PIN_MODE(3) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_07 -> AD21 */
       PIN_GPMC_AD7, 0, \
       ( \
           PIN_MODE(3) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_08 -> AE23 */
       PIN_GPMC_AD8, 0, \
       ( \
           PIN_MODE(3) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_09 -> AB20 */
       PIN_GPMC_AD9, 0, \
       ( \
           PIN_MODE(3) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxPerCfg_t gGpio1PinCfg[] =
{
    {
       /* GPIO1 -> GPIO1_13 -> E12 */
       PIN_PR1_PRU0_GPO7, 0, \
       ( \
           PIN_MODE(3) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO1 -> GPIO1_52 -> E21 */
       PIN_UART2_RXD, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {
       /* GPIO1 -> GPIO1_53 -> D21 */
       PIN_UART2_TXD, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {
       /* GPIO1 -> GPIO1_56 -> P5 */
       PIN_DCAN0_TX, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {
       /* GPIO1 -> GPIO1_57 -> R5 */
       PIN_DCAN0_RX, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {
       /* GPIO1 -> GPIO1_66 -> H22 */
       PIN_QSPI_CSN2, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO1 -> GPIO1_67 -> H21 */
       PIN_QSPI_CSN3, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gGpioPinCfg[] =
{
    {0, TRUE, gGpio0PinCfg},
    {1, TRUE, gGpio1PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_GPIO) */

#if defined(BUILDCFG_MOD_UART)

static pinmuxPerCfg_t gUart0PinCfg[] =
{
    {
       /* UART0 -> UART0_RXD -> T4 */
       PIN_UART0_RXD, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {
       /* UART0 -> UART0_TXD -> T1 */
       PIN_UART0_TXD, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gUartPinCfg[] =
{
    {0, TRUE, gUart0PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_UART) */

#if defined(BUILDCFG_MOD_PCIE)

static pinmuxPerCfg_t gPcie0PinCfg[] =
{
    {PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gPciePinCfg[] =
{
    {0, TRUE, gPcie0PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_PCIE) */

#if defined(BUILDCFG_MOD_MMCSD)

static pinmuxPerCfg_t gMmcsd1PinCfg[] =
{
    {
       /* MMC1 -> MMC1_CLK -> J4 */
       PIN_MMC1_CLK, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {
       /* MMC1 -> MMC1_CMD -> J2 */
       PIN_MMC1_CMD, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {
       /* MMC1 -> MMC1_DAT0 -> H3 */
       PIN_MMC1_DAT0, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {
       /* MMC1 -> MMC1_DAT1 -> F5 */
       PIN_MMC1_DAT1, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {
       /* MMC1 -> MMC1_DAT2 -> J5 */
       PIN_MMC1_DAT2, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {
       /* MMC1 -> MMC1_DAT3 -> H4 */
       PIN_MMC1_DAT3, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gMmcsdPinCfg[] =
{
    {1, TRUE, gMmcsd1PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_MMCSD) */

#if defined(BUILDCFG_MOD_DEBUGSS)

static pinmuxPerCfg_t gDebugss0PinCfg[] =
{
    {
       /* DEBUGSS -> EMU02 -> N23 */
       PIN_DSS_DATA23, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* DEBUGSS -> EMU03 -> P25 */
       PIN_DSS_DATA22, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* DEBUGSS -> EMU04 -> P24 */
       PIN_DSS_DATA21, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gDebugssPinCfg[] =
{
    {0, TRUE, gDebugss0PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_DEBUGSS) */

#if defined(BUILDCFG_MOD_EMAC)

static pinmuxPerCfg_t gEmac0PinCfg[] =
{
    {
       /* EMAC -> RGMII_RXD1 -> C23 */
       PIN_MII_RXD1, 0, \
       ( \
           PIN_MODE(1) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* EMAC -> RGMII_RXD2 -> B23 */
       PIN_MII_RXD2, 0, \
       ( \
           PIN_MODE(1) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* EMAC -> RGMII_RXD3 -> F22 */
       PIN_MII_RXD3, 0, \
       ( \
           PIN_MODE(1) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* EMAC -> RGMII_RXD0 -> B24 */
       PIN_MII_RXD0, 0, \
       ( \
           PIN_MODE(1) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* EMAC -> RGMII_TXD0 -> G23 */
       PIN_MII_TXD0, 0, \
       ( \
           PIN_MODE(1) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* EMAC -> RGMII_TXD1 -> G24 */
       PIN_MII_TXD1, 0, \
       ( \
           PIN_MODE(1) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* EMAC -> RGMII_TXD2 -> G25 */
       PIN_MII_TXD2, 0, \
       ( \
           PIN_MODE(1) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* EMAC -> RGMII_TXD3 -> D25 */
       PIN_MII_TXD3, 0, \
       ( \
           PIN_MODE(1) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* EMAC -> RGMII_TXC -> C25 */
       PIN_MII_TXCLK, 0, \
       ( \
           PIN_MODE(1) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* EMAC -> RGMII_TXCTL -> H25 */
       PIN_MII_TXEN, 0, \
       ( \
           PIN_MODE(1) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* EMAC -> RGMII_RXC -> A22 */
       PIN_MII_RXCLK, 0, \
       ( \
           PIN_MODE(1) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* EMAC -> RGMII_RXCTL -> A24 */
       PIN_MII_RXDV, 0, \
       ( \
           PIN_MODE(1) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gEmacPinCfg[] =
{
    {0, TRUE, gEmac0PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_EMAC) */

#if defined(BUILDCFG_MOD_CPSW)

static pinmuxPerCfg_t gCpsw0PinCfg[] =
{
    {
       /* MDIO -> MDIO_CLK -> U3 */
       PIN_MDIO_CLK, 0, \
       ( \
           PIN_MODE(0) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MDIO -> MDIO_DATA -> V3 */
       PIN_MDIO_DATA, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gCpswPinCfg[] =
{
    {0, TRUE, gCpsw0PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_CPSW) */

#if defined(BUILDCFG_MOD_DDR)

static pinmuxPerCfg_t gDdr0PinCfg[] =
{
    {PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gDdrPinCfg[] =
{
    {0, TRUE, gDdr0PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_DDR) */

#if defined(BUILDCFG_MOD_MCSPI)

static pinmuxPerCfg_t gMcspi0PinCfg[] =
{
    {
       /* SPI0 -> SPI0_CLK -> M2 */
       PIN_SPI0_CLK, 0, \
       ( \
           PIN_MODE(0) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* SPI0 -> SPI0_SOMI -> M1 */
       PIN_SPI0_SOMI, 0, \
       ( \
           PIN_MODE(0) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* SPI0 -> SPI0_SIMO -> N4 */
       PIN_SPI0_SIMO, 0, \
       ( \
           PIN_MODE(0) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* SPI0 -> SPI0_SCSn0 -> M3 */
       PIN_SPI0_SCSN0, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {
       /* SPI0 -> SPI0_SCSn1 -> M4 */
       PIN_SPI0_SCSN1, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxPerCfg_t gMcspi1PinCfg[] =
{
    {
       /* SPI1 -> SPI1_CLK -> N2 */
       PIN_SPI1_CLK, 0, \
       ( \
           PIN_MODE(0) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* SPI1 -> SPI1_SOMI -> N1 */
       PIN_SPI1_SOMI, 0, \
       ( \
           PIN_MODE(0) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* SPI1 -> SPI1_SIMO -> P2 */
       PIN_SPI1_SIMO, 0, \
       ( \
           PIN_MODE(0) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* SPI1 -> SPI1_SCSn0 -> P1 */
       PIN_SPI1_SCSN0, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {
       /* SPI1 -> SPI1_SCSn1 -> N3 */
       PIN_SPI1_SCSN1, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gMcspiPinCfg[] =
{
    {0, TRUE, gMcspi0PinCfg},
    {1, TRUE, gMcspi1PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_MCSPI) */

#if defined(BUILDCFG_MOD_SYSTEM)

static pinmuxPerCfg_t gSystem0PinCfg[] =
{
    {
       /* SYSTEM -> SYSCLKOUT -> M21 */
       PIN_SYSCLKOUT, 0, \
       ( \
           PIN_MODE(0) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* SYSTEM -> LRESETn -> V2 */
       PIN_LRESETN, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {
       /* SYSTEM -> LRESETNMIENn -> V1 */
       PIN_LRESETNMIENN, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {
       /* SYSTEM -> RESETSTATn -> Y2 */
       PIN_RESETSTATN, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* SYSTEM -> NMIn -> W1 */
       PIN_NMIN, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {
       /* SYSTEM -> BOOTCOMPLETE -> Y3 */
       PIN_BOOTCOMPLETE, 0, \
       ( \
           PIN_MODE(0) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* SYSTEM -> OBSPLL_LOCK -> N5 */
       PIN_OBSPLL_LOCK, 0, \
       ( \
           PIN_MODE(0) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gSystemPinCfg[] =
{
    {0, TRUE, gSystem0PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_SYSTEM) */

#if defined(BUILDCFG_MOD_I2C)

static pinmuxPerCfg_t gI2c0PinCfg[] =
{
    {
       /* I2C0 -> I2C0_SCL -> U5 */
       PIN_I2C0_SCL, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {
       /* I2C0 -> I2C0_SDA -> W5 */
       PIN_I2C0_SDA, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxPerCfg_t gI2c1PinCfg[] =
{
    {
       /* I2C1 -> I2C1_SCL -> V6 */
       PIN_I2C1_SCL, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {
       /* I2C1 -> I2C1_SDA -> W4 */
       PIN_I2C1_SDA, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxPerCfg_t gI2c2PinCfg[] =
{
    {
       /* I2C2 -> I2C2_SCL -> V5 */
       PIN_I2C2_SCL, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {
       /* I2C2 -> I2C2_SDA -> V4 */
       PIN_I2C2_SDA, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gI2cPinCfg[] =
{
    {0, TRUE, gI2c0PinCfg},
    {1, TRUE, gI2c1PinCfg},
    {2, TRUE, gI2c2PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_I2C) */

#if defined(BUILDCFG_MOD_QSPI)

static pinmuxPerCfg_t gQspi0PinCfg[] =
{
    {
       /* QSPI -> QSPI_CLK -> K25 */
       PIN_QSPI_CLK, 0, \
       ( \
           PIN_MODE(0) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* QSPI -> QSPI_RCLK -> K24 */
       PIN_QSPI_RCLK, 0, \
       ( \
           PIN_MODE(0) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* QSPI -> QSPI_CSn0 -> J25 */
       PIN_QSPI_CSN0, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {
       /* QSPI -> QSPI_D0 -> J23 */
       PIN_QSPI_D0, 0, \
       ( \
           PIN_MODE(0) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* QSPI -> QSPI_D1 -> J22 */
       PIN_QSPI_D1, 0, \
       ( \
           PIN_MODE(0) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* QSPI -> QSPI_D2 -> J21 */
       PIN_QSPI_D2, 0, \
       ( \
           PIN_MODE(0) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* QSPI -> QSPI_D3 -> J24 */
       PIN_QSPI_D3, 0, \
       ( \
           PIN_MODE(0) | \
           ((0x38) & (~PIN_PULL_UD_EN & ~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gQspiPinCfg[] =
{
    {0, TRUE, gQspi0PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_QSPI) */



pinmuxBoardCfg_t gK2G0xPinmuxData[] =
{
#if defined(BUILDCFG_MOD_PRU_ICSS)
    {CHIPDB_MOD_ID_PRU_ICSS, gPru_icssPinCfg},
#endif /* if defined(BUILDCFG_MOD_PRU_ICSS) */
#if defined(BUILDCFG_MOD_PWMSS)
    {CHIPDB_MOD_ID_PWMSS, gPwmssPinCfg},
#endif /* if defined(BUILDCFG_MOD_PWMSS) */
#if defined(BUILDCFG_MOD_GPIO)
    {CHIPDB_MOD_ID_GPIO, gGpioPinCfg},
#endif /* if defined(BUILDCFG_MOD_GPIO) */
#if defined(BUILDCFG_MOD_UART)
    {CHIPDB_MOD_ID_UART, gUartPinCfg},
#endif /* if defined(BUILDCFG_MOD_UART) */
#if defined(BUILDCFG_MOD_PCIE)
    {CHIPDB_MOD_ID_PCIE, gPciePinCfg},
#endif /* if defined(BUILDCFG_MOD_PCIE) */
#if defined(BUILDCFG_MOD_MMCSD)
    {CHIPDB_MOD_ID_MMCSD, gMmcsdPinCfg},
#endif /* if defined(BUILDCFG_MOD_MMCSD) */
#if defined(BUILDCFG_MOD_DEBUGSS)
    {CHIPDB_MOD_ID_DEBUGSS, gDebugssPinCfg},
#endif /* if defined(BUILDCFG_MOD_DEBUGSS) */
#if defined(BUILDCFG_MOD_EMAC)
    {CHIPDB_MOD_ID_EMAC, gEmacPinCfg},
#endif /* if defined(BUILDCFG_MOD_EMAC) */
#if defined(BUILDCFG_MOD_CPSW)
    {CHIPDB_MOD_ID_CPSW, gCpswPinCfg},
#endif /* if defined(BUILDCFG_MOD_CPSW) */
#if defined(BUILDCFG_MOD_DDR)
    {CHIPDB_MOD_ID_DDR, gDdrPinCfg},
#endif /* if defined(BUILDCFG_MOD_DDR) */
#if defined(BUILDCFG_MOD_MCSPI)
    {CHIPDB_MOD_ID_MCSPI, gMcspiPinCfg},
#endif /* if defined(BUILDCFG_MOD_MCSPI) */
#if defined(BUILDCFG_MOD_SYSTEM)
    {CHIPDB_MOD_ID_SYSTEM, gSystemPinCfg},
#endif /* if defined(BUILDCFG_MOD_SYSTEM) */
#if defined(BUILDCFG_MOD_I2C)
    {CHIPDB_MOD_ID_I2C, gI2cPinCfg},
#endif /* if defined(BUILDCFG_MOD_I2C) */
#if defined(BUILDCFG_MOD_QSPI)
    {CHIPDB_MOD_ID_QSPI, gQspiPinCfg},
#endif /* if defined(BUILDCFG_MOD_QSPI) */
    {CHIPDB_MOD_ID_INVALID}
};
