/**
 *   @file  idkam571x_pinmux.c
 *
 *   @brief
 *      This is the pin configuration for EVM AM572x.
 *
 *  \par
 *  ============================================================================
 *  @n   (C) Copyright 2009-2015, Texas Instruments, Inc.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  \par
*/

#include <ti/csl/cslr_device.h>
#include <ti/drv/mmcsd/soc/MMCSD_v1.h>
#include "board_internal.h"
#include "idkam571x_pinmux.h"
#include "iodelay_config.h"
#include "am570x_pinmux.h"

#define IO_DELAY
#define IO_DELAY_STACK_SIZE 128
extern void Board_ioStack(void *sp, void (fn)(const boardPadDelayCfg_t *pPadCfgData, uint32_t padArraySize), const boardPadDelayCfg_t *pPadCfgData, uint32_t padArraySize);

/**
 * \brief  Temporary stack used for IO delay code
 */
#if defined(_TMS320C6X)
#pragma DATA_SECTION (ioStack, "BOARD_IO_DELAY_DATA");
far uint32_t ioStack[IO_DELAY_STACK_SIZE];
#elif defined(__TI_ARM_V7M4__)
#pragma DATA_SECTION (ioStack, "BOARD_IO_DELAY_DATA");
uint32_t ioStack[IO_DELAY_STACK_SIZE];
#else
uint32_t ioStack[IO_DELAY_STACK_SIZE] __attribute__((section("BOARD_IO_DELAY_DATA")));
#endif

#if !defined(__TI_ARM_V7M4__)
#if defined(_TMS320C6X)
#pragma CODE_SECTION (boardPadGetSize, "BOARD_IO_DELAY_CODE");
mmcBoardPadCfgTable_t* boardGetPinmuxCfg(mmcBoardPadCfgTable_t *ptr, int32_t mode);
#else
mmcBoardPadCfgTable_t* boardGetPinmuxCfg(mmcBoardPadCfgTable_t *ptr, int32_t mode)
__attribute__((section("BOARD_IO_DELAY_CODE")));
#endif
#endif

#define CTRL_CORE_PAD_GPMC_A14_PULLUP_RX_MODE_1     (0x00060001U)
#define CTRL_CORE_PAD_GPMC_A15_PULLUP_RX_MODE_1     (0x00060001U)
#define CTRL_CORE_PAD_GPMC_A16_PULLUP_RX_MODE_1     (0x00060001U)
#define CTRL_CORE_PAD_GPMC_A17_PULLUP_RX_MODE_1     (0x00060001U)
#define CTRL_CORE_PAD_GPMC_A18_PULLUP_MODE_1        (0x00020001U)
#define CTRL_CORE_PAD_GPMC_CS2_PULLUP_MODE_1        (0x00020001U)
#define CTRL_CORE_PAD_GPMC_A13_PULLUP_MODE_1        (0x00020001U)
#define CTRL_CORE_PAD_GPMC_CS3_PULLUP_MODE_1        (0x00020001U)
#define CTRL_CORE_PAD_GPMC_A3_PULLUP_MODE_1         (0x00020001U)
#define CTRL_CORE_PAD_GPMC_A4_PULLUP_MODE_1         (0x00020001U)

#define CTRL_CORE_PAD_VIN1A_D15_PILLUP              (0x20000 | 0x0E)

#define CTRL_CORE_PAD_MCSPI2_SCLK                   (0x3C0U)      //SPI2_SCLK
#define CTRL_CORE_PAD_MCSPI2_D1                     (0x3C4U)      //SPI2_D1
#define CTRL_CORE_PAD_MCSPI2_D0                     (0x3C8U)      //SPI2_D0
#define CTRL_CORE_PAD_MCSPI2_CS0                    (0x3CCU)      //SPI2_CS0

#define CTRL_CORE_PAD_MCASP4_ACLKX_PUPDD_RX_MODE    0xc0002 //(0x00040003U)
#define CTRL_CORE_PAD_MCASP4_FSX_PUPDD_RX_MODE      0xc0002 //(0x00040003U)
#define CTRL_CORE_PAD_MCASP4_AXR1_PUPDD_RX_MODE     0x60002 //(0x00040003U)

extern const boardPadDelayCfg_t pad[];

void PinmuxI2cConfig (Uint32 instNum)
{
    Uint32 regVal = 0U;

    switch(instNum)
    {
        case 1:
            regVal = 0U;
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_I2C1_SDA_I2C1_SDA_WAKEUPENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_I2C1_SDA_I2C1_SDA_INPUTENABLE, ENABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_I2C1_SDA_I2C1_SDA_PULLTYPESELECT, PULL_UP);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_I2C1_SDA_I2C1_SDA_PULLUDENABLE, ENABLE);
            ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_I2C1_SDA = regVal;

            regVal = 0U;
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_I2C1_SCL_I2C1_SCL_WAKEUPENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_I2C1_SCL_I2C1_SCL_INPUTENABLE, ENABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_I2C1_SCL_I2C1_SCL_PULLTYPESELECT, PULL_UP);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_I2C1_SCL_I2C1_SCL_PULLUDENABLE, ENABLE);
            ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_I2C1_SCL = regVal;
            break;

        case 3:
            regVal = 0U;
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_I2C3_SDA_I2C3_SDA_WAKEUPENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_I2C3_SDA_I2C3_SDA_INPUTENABLE, ENABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_I2C3_SDA_I2C3_SDA_PULLTYPESELECT, PULL_UP);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_I2C3_SDA_I2C3_SDA_PULLUDENABLE, ENABLE);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_I2C3_SDA_I2C3_SDA_MUXMODE, 0U);
            ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_I2C3_SDA = regVal;

            regVal = 0U;
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_I2C3_SCL_I2C3_SCL_WAKEUPENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_I2C3_SCL_I2C3_SCL_INPUTENABLE, ENABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_I2C3_SCL_I2C3_SCL_PULLTYPESELECT, PULL_UP);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_I2C3_SCL_I2C3_SCL_PULLUDENABLE, ENABLE);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_I2C3_SCL_I2C3_SCL_MUXMODE, 0U);
            ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_I2C3_SCL = regVal;
            break;

        case 5:
            regVal = 0U;
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR0_MCASP1_AXR0_WAKEUPENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR0_MCASP1_AXR0_INPUTENABLE, ENABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR0_MCASP1_AXR0_PULLTYPESELECT, PULL_UP);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR0_MCASP1_AXR0_PULLUDENABLE, ENABLE);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR0_MCASP1_AXR0_MUXMODE, 0U);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR0_MCASP1_AXR0_MODESELECT, MUX_MODE);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR0_MCASP1_AXR0_DELAYMODE, 0U);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR0_MCASP1_AXR0_MUXMODE, 10U);
           ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MCASP1_AXR0 = regVal;

            regVal = 0U;
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR1_MCASP1_AXR1_WAKEUPENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR1_MCASP1_AXR1_INPUTENABLE, ENABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR1_MCASP1_AXR1_PULLTYPESELECT, PULL_UP);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR1_MCASP1_AXR1_PULLUDENABLE, ENABLE);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR1_MCASP1_AXR1_MUXMODE, 0U);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR0_MCASP1_AXR0_MODESELECT, MUX_MODE);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR0_MCASP1_AXR0_DELAYMODE, 0U);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR0_MCASP1_AXR0_MUXMODE, 10U);
            ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MCASP1_AXR1 = regVal;
            break;

        default:
            break;
    }
}

void PinmuxMmcConfig (Uint32 instNum)
{
    Uint32 regVal = 0U;

    switch(instNum)
    {
        case 1:
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_CLK_MMC1_CLK_WAKEUPENABLE, DISABLE);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_CLK_MMC1_CLK_ACTIVE, 1U);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_CLK_MMC1_CLK_PULLTYPESELECT, PULL_DOWN);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_CLK_MMC1_CLK_PULLUDENABLE, ENABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_CLK_MMC1_CLK_MODESELECT, MUX_MODE);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_CLK_MMC1_CLK_DELAYMODE, 0U);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_CLK_MMC1_CLK_MUXMODE, 0U);
            ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MMC1_CLK = regVal;

            regVal = 0U;
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_CMD_MMC1_CMD_WAKEUPENABLE, DISABLE);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_CMD_MMC1_CMD_ACTIVE, 1U);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_CMD_MMC1_CMD_PULLTYPESELECT, PULL_UP);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_CMD_MMC1_CMD_PULLUDENABLE, ENABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_CMD_MMC1_CMD_MODESELECT, MUX_MODE);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_CMD_MMC1_CMD_DELAYMODE, 0U);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_CMD_MMC1_CMD_MUXMODE, 0U);
            ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MMC1_CMD = regVal;

            regVal = 0U;
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_DAT0_MMC1_DAT0_WAKEUPENABLE, DISABLE);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_DAT0_MMC1_DAT0_ACTIVE, 1U);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_DAT0_MMC1_DAT0_PULLTYPESELECT, PULL_UP);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_DAT0_MMC1_DAT0_PULLUDENABLE, ENABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_DAT0_MMC1_DAT0_MODESELECT, MUX_MODE);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_DAT0_MMC1_DAT0_DELAYMODE, 0U);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_DAT0_MMC1_DAT0_MUXMODE, 0U);
            ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MMC1_DAT0 = regVal;

            regVal = 0U;
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_DAT1_MMC1_DAT1_WAKEUPENABLE, DISABLE);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_DAT1_MMC1_DAT1_ACTIVE, 1U);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_DAT1_MMC1_DAT1_PULLTYPESELECT, PULL_UP);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_DAT1_MMC1_DAT1_PULLUDENABLE, ENABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_DAT1_MMC1_DAT1_MODESELECT, MUX_MODE);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_DAT1_MMC1_DAT1_DELAYMODE, 0U);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_DAT1_MMC1_DAT1_MUXMODE, 0U);
            ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MMC1_DAT1 = regVal;

            regVal = 0U;
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_DAT2_MMC1_DAT2_WAKEUPENABLE, DISABLE);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_DAT2_MMC1_DAT2_ACTIVE, 1U);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_DAT2_MMC1_DAT2_PULLTYPESELECT, PULL_UP);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_DAT2_MMC1_DAT2_PULLUDENABLE, ENABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_DAT2_MMC1_DAT2_MODESELECT, MUX_MODE);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_DAT2_MMC1_DAT2_DELAYMODE, 0U);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_DAT2_MMC1_DAT2_MUXMODE, 0U);
            ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MMC1_DAT2 = regVal;

            regVal = 0U;
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_DAT3_MMC1_DAT3_WAKEUPENABLE, DISABLE);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_DAT3_MMC1_DAT3_ACTIVE, 1U);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_DAT3_MMC1_DAT3_PULLTYPESELECT, PULL_UP);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_DAT3_MMC1_DAT3_PULLUDENABLE, ENABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_DAT3_MMC1_DAT3_MODESELECT, MUX_MODE);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_DAT3_MMC1_DAT3_DELAYMODE, 0U);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_DAT3_MMC1_DAT3_MUXMODE, 0U);
            ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MMC1_DAT3 = regVal;

            regVal = 0U;
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_SDCD_MMC1_SDCD_WAKEUPENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_SDCD_MMC1_SDCD_SLEWCONTROL, SLOW_SLEW);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_SDCD_MMC1_SDCD_INPUTENABLE, ENABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_SDCD_MMC1_SDCD_PULLTYPESELECT, PULL_UP);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_SDCD_MMC1_SDCD_PULLUDENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_SDCD_MMC1_SDCD_MODESELECT, MUX_MODE);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_SDCD_MMC1_SDCD_DELAYMODE, 0U);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC1_SDCD_MMC1_SDCD_MUXMODE, 14U);
            ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MMC1_SDCD = regVal;
            break;

        case 2:
            regVal = 0U;
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A23_GPMC_A23_WAKEUPENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A23_GPMC_A23_SLEWCONTROL, FAST_SLEW);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A23_GPMC_A23_INPUTENABLE, ENABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A23_GPMC_A23_PULLTYPESELECT, PULL_DOWN);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A23_GPMC_A23_PULLUDENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A23_GPMC_A23_MODESELECT, MUX_MODE);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A23_GPMC_A23_DELAYMODE, 0U);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A23_GPMC_A23_MUXMODE, 1U);
            ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_GPMC_A23 = regVal;

            regVal = 0U;
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_CS1_GPMC_CS1_WAKEUPENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_CS1_GPMC_CS1_SLEWCONTROL, FAST_SLEW);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_CS1_GPMC_CS1_INPUTENABLE, ENABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_CS1_GPMC_CS1_PULLTYPESELECT, PULL_UP);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_CS1_GPMC_CS1_PULLUDENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_CS1_GPMC_CS1_MODESELECT, MUX_MODE);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_CS1_GPMC_CS1_DELAYMODE, 0U);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_CS1_GPMC_CS1_MUXMODE, 1U);
            ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_GPMC_CS1 = regVal;

            regVal = 0U;
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A24_GPMC_A24_WAKEUPENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A24_GPMC_A24_SLEWCONTROL, FAST_SLEW);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A24_GPMC_A24_INPUTENABLE, ENABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A24_GPMC_A24_PULLTYPESELECT, PULL_UP);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A24_GPMC_A24_PULLUDENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A24_GPMC_A24_MODESELECT, MUX_MODE);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A24_GPMC_A24_DELAYMODE, 0U);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A24_GPMC_A24_MUXMODE, 1U);
            ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_GPMC_A24 = regVal;

            regVal = 0U;
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A25_GPMC_A25_WAKEUPENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A25_GPMC_A25_SLEWCONTROL, FAST_SLEW);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A25_GPMC_A25_INPUTENABLE, ENABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A25_GPMC_A25_PULLTYPESELECT, PULL_UP);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A25_GPMC_A25_PULLUDENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A25_GPMC_A25_MODESELECT, MUX_MODE);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A25_GPMC_A25_DELAYMODE, 0U);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A25_GPMC_A25_MUXMODE, 1U);
            ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_GPMC_A25 = regVal;

            regVal = 0U;
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A26_GPMC_A26_WAKEUPENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A26_GPMC_A26_SLEWCONTROL, FAST_SLEW);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A26_GPMC_A26_INPUTENABLE, ENABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A26_GPMC_A26_PULLTYPESELECT, PULL_UP);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A26_GPMC_A26_PULLUDENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A26_GPMC_A26_MODESELECT, MUX_MODE);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A26_GPMC_A26_DELAYMODE, 0U);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A26_GPMC_A26_MUXMODE, 1U);
            ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_GPMC_A26 = regVal;

            regVal = 0U;
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A27_GPMC_A27_WAKEUPENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A27_GPMC_A27_SLEWCONTROL, FAST_SLEW);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A27_GPMC_A27_INPUTENABLE, ENABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A27_GPMC_A27_PULLTYPESELECT, PULL_UP);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A27_GPMC_A27_PULLUDENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A27_GPMC_A27_MODESELECT, MUX_MODE);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A27_GPMC_A27_DELAYMODE, 0U);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A27_GPMC_A27_MUXMODE, 1U);
            ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_GPMC_A27 = regVal;

            regVal = 0U;
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A19_GPMC_A19_WAKEUPENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A19_GPMC_A19_SLEWCONTROL, FAST_SLEW);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A19_GPMC_A19_INPUTENABLE, ENABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A19_GPMC_A19_PULLTYPESELECT, PULL_UP);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A19_GPMC_A19_PULLUDENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A19_GPMC_A19_MODESELECT, MUX_MODE);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A19_GPMC_A19_DELAYMODE, 0U);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A19_GPMC_A19_MUXMODE, 1U);
            ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_GPMC_A19 = regVal;

            regVal = 0U;
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A20_GPMC_A20_WAKEUPENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A20_GPMC_A20_SLEWCONTROL, FAST_SLEW);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A20_GPMC_A20_INPUTENABLE, ENABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A20_GPMC_A20_PULLTYPESELECT, PULL_UP);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A20_GPMC_A20_PULLUDENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A20_GPMC_A20_MODESELECT, MUX_MODE);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A20_GPMC_A20_DELAYMODE, 0U);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A20_GPMC_A20_MUXMODE, 1U);
            ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_GPMC_A20 = regVal;

            regVal = 0U;
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A21_GPMC_A21_WAKEUPENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A21_GPMC_A21_SLEWCONTROL, FAST_SLEW);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A21_GPMC_A21_INPUTENABLE, ENABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A21_GPMC_A21_PULLTYPESELECT, PULL_UP);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A21_GPMC_A21_PULLUDENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A21_GPMC_A21_MODESELECT, MUX_MODE);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A21_GPMC_A21_DELAYMODE, 0U);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A21_GPMC_A21_MUXMODE, 1U);
            ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_GPMC_A21 = regVal;

            regVal = 0U;
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A22_GPMC_A22_WAKEUPENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A22_GPMC_A22_SLEWCONTROL, FAST_SLEW);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A22_GPMC_A22_INPUTENABLE, ENABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A22_GPMC_A22_PULLTYPESELECT, PULL_UP);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A22_GPMC_A22_PULLUDENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A22_GPMC_A22_MODESELECT, MUX_MODE);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A22_GPMC_A22_DELAYMODE, 0U);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_A22_GPMC_A22_MUXMODE, 1U);
            ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_GPMC_A22 = regVal;

            regVal = 0U;
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VOUT1_FLD_VOUT1_FLD_WAKEUPENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VOUT1_FLD_VOUT1_FLD_SLEWCONTROL, SLOW_SLEW);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VOUT1_FLD_VOUT1_FLD_INPUTENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VOUT1_FLD_VOUT1_FLD_PULLTYPESELECT, PULL_UP);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VOUT1_FLD_VOUT1_FLD_PULLUDENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VOUT1_FLD_VOUT1_FLD_MODESELECT, MUX_MODE);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VOUT1_FLD_VOUT1_FLD_DELAYMODE, 0U);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VOUT1_FLD_VOUT1_FLD_MUXMODE, 15U);
            ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_VOUT1_FLD = regVal;
            break;

        case 3:
            regVal = 0U;
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_CLK_MMC3_CLK_WAKEUPENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_CLK_MMC3_CLK_INPUTENABLE, ENABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_CLK_MMC3_CLK_PULLTYPESELECT, PULL_DOWN);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_CLK_MMC3_CLK_PULLUDENABLE, ENABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_CLK_MMC3_CLK_MODESELECT, MUX_MODE);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_CLK_MMC3_CLK_DELAYMODE, 0U);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_CLK_MMC3_CLK_MUXMODE, 0U);
            ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MMC3_CLK = regVal;

            regVal = 0U;
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_CMD_MMC3_CMD_WAKEUPENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_CMD_MMC3_CMD_INPUTENABLE, ENABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_CMD_MMC3_CMD_PULLTYPESELECT, PULL_UP);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_CMD_MMC3_CMD_PULLUDENABLE, ENABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_CMD_MMC3_CMD_MODESELECT, MUX_MODE);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_CMD_MMC3_CMD_DELAYMODE, 0U);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_CMD_MMC3_CMD_MUXMODE, 0U);
            ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MMC3_CMD = regVal;

            regVal = 0U;
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT0_MMC3_DAT0_WAKEUPENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT0_MMC3_DAT0_INPUTENABLE, ENABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT0_MMC3_DAT0_PULLTYPESELECT, PULL_UP);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT0_MMC3_DAT0_PULLUDENABLE, ENABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT0_MMC3_DAT0_MODESELECT, MUX_MODE);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT0_MMC3_DAT0_DELAYMODE, 0U);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT0_MMC3_DAT0_MUXMODE, 0U);
            ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MMC3_DAT0 = regVal;

            regVal = 0U;
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT1_MMC3_DAT1_WAKEUPENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT1_MMC3_DAT1_INPUTENABLE, ENABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT1_MMC3_DAT1_PULLTYPESELECT, PULL_UP);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT1_MMC3_DAT1_PULLUDENABLE, ENABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT1_MMC3_DAT1_MODESELECT, MUX_MODE);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT1_MMC3_DAT1_DELAYMODE, 0U);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT1_MMC3_DAT1_MUXMODE, 0U);
            ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MMC3_DAT1 = regVal;

            regVal = 0U;
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT2_MMC3_DAT2_WAKEUPENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT2_MMC3_DAT2_INPUTENABLE, ENABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT2_MMC3_DAT2_PULLTYPESELECT, PULL_UP);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT2_MMC3_DAT2_PULLUDENABLE, ENABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT2_MMC3_DAT2_MODESELECT, MUX_MODE);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT2_MMC3_DAT2_DELAYMODE, 0U);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT2_MMC3_DAT2_MUXMODE, 0U);
            ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MMC3_DAT2 = regVal;

            regVal = 0U;
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT3_MMC3_DAT3_WAKEUPENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT3_MMC3_DAT3_INPUTENABLE, ENABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT3_MMC3_DAT3_PULLTYPESELECT, PULL_UP);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT3_MMC3_DAT3_PULLUDENABLE, ENABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT3_MMC3_DAT3_MODESELECT, MUX_MODE);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT3_MMC3_DAT3_DELAYMODE, 0U);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT3_MMC3_DAT3_MUXMODE, 0U);
            ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MMC3_DAT3 = regVal;
            break;

        default:
            break;
    }
}

void PinmuxUartConfig (instNum)
{
    Uint32 regVal = 0U;

    switch(instNum)
    {

      case 1:
            regVal = 0U;
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_UART1_RXD_UART1_RXD_WAKEUPENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_UART1_RXD_UART1_RXD_SLEWCONTROL, SLOW_SLEW);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_UART1_RXD_UART1_RXD_INPUTENABLE, ENABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_UART1_RXD_UART1_RXD_PULLTYPESELECT, PULL_UP);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_UART1_RXD_UART1_RXD_PULLUDENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_UART1_RXD_UART1_RXD_MODESELECT, MUX_MODE);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_UART1_RXD_UART1_RXD_DELAYMODE, 0U);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_UART1_RXD_UART1_RXD_MUXMODE, 0U);
            ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_UART1_RXD = regVal;

            regVal = 0U;
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_UART1_TXD_UART1_TXD_WAKEUPENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_UART1_TXD_UART1_TXD_SLEWCONTROL, SLOW_SLEW);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_UART1_TXD_UART1_TXD_INPUTENABLE, ENABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_UART1_TXD_UART1_TXD_PULLTYPESELECT, PULL_UP);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_UART1_TXD_UART1_TXD_PULLUDENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_UART1_TXD_UART1_TXD_MODESELECT, MUX_MODE);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_UART1_TXD_UART1_TXD_DELAYMODE, 0U);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_UART1_TXD_UART1_TXD_MUXMODE, 0U);
            ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_UART1_TXD = regVal;
            break;

      case 3:
            regVal = 0U;
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_UART2_RTSN_UART2_RTSN_WAKEUPENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_UART2_RTSN_UART2_RTSN_SLEWCONTROL, SLOW_SLEW);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_UART2_RTSN_UART2_RTSN_INPUTENABLE, ENABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_UART2_RTSN_UART2_RTSN_PULLTYPESELECT, PULL_UP);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_UART2_RTSN_UART2_RTSN_PULLUDENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_UART2_RTSN_UART2_RTSN_MODESELECT, MUX_MODE);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_UART2_RTSN_UART2_RTSN_DELAYMODE, 0U);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_UART2_RTSN_UART2_RTSN_MUXMODE, 1U);
            ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_UART2_RTSN = regVal;

            regVal = 0U;
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_UART2_CTSN_UART2_CTSN_WAKEUPENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_UART2_CTSN_UART2_CTSN_SLEWCONTROL, SLOW_SLEW);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_UART2_CTSN_UART2_CTSN_INPUTENABLE, ENABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_UART2_CTSN_UART2_CTSN_PULLTYPESELECT, PULL_UP);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_UART2_CTSN_UART2_CTSN_PULLUDENABLE, DISABLE);
            CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_UART2_CTSN_UART2_CTSN_MODESELECT, MUX_MODE);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_UART2_CTSN_UART2_CTSN_DELAYMODE, 0U);
            CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_UART2_CTSN_UART2_CTSN_MUXMODE, 2U);
            ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_UART2_CTSN = regVal;
            break;

      default:
            break;
    }
}

void PinmuxPruIcssConfig (void)
{

    /* pru1 eth 0 */
    Uint32 regVal = 0U;
#if 0
    /***************************************************************************************************
    * pru1 eth 0: Not wired for default IDK
    ****************************************************************************************************/

    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D10_VIN2A_D10_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D10_VIN2A_D10_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D10_VIN2A_D10_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D10_VIN2A_D10_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D10_VIN2A_D10_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D10_VIN2A_D10_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D10_VIN2A_D10_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D10_VIN2A_D10_MUXMODE,11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_VIN2A_D10 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D11_VIN2A_D11_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D11_VIN2A_D11_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D11_VIN2A_D11_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D11_VIN2A_D11_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D11_VIN2A_D11_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D11_VIN2A_D11_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D11_VIN2A_D11_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D11_VIN2A_D11_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_VIN2A_D11 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXC_RGMII0_RXC_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXC_RGMII0_RXC_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXC_RGMII0_RXC_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXC_RGMII0_RXC_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXC_RGMII0_RXC_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXC_RGMII0_RXC_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXC_RGMII0_RXC_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXC_RGMII0_RXC_MUXMODE, 11U);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_RGMII0_RXC = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD2_RGMII0_RXD2_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD2_RGMII0_RXD2_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD2_RGMII0_RXD2_INPUTENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD2_RGMII0_RXD2_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD2_RGMII0_RXD2_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD2_RGMII0_RXD2_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD2_RGMII0_RXD2_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD2_RGMII0_RXD2_MUXMODE, 11U);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_RGMII0_RXD2 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD0_RGMII0_RXD0_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD0_RGMII0_RXD0_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD0_RGMII0_RXD0_INPUTENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD0_RGMII0_RXD0_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD0_RGMII0_RXD0_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD0_RGMII0_RXD0_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD0_RGMII0_RXD0_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD0_RGMII0_RXD0_MUXMODE, 11U);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_RGMII0_RXD0 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD3_RGMII0_RXD3_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD3_RGMII0_RXD3_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD3_RGMII0_RXD3_INPUTENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD3_RGMII0_RXD3_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD3_RGMII0_RXD3_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD3_RGMII0_RXD3_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD3_RGMII0_RXD3_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD3_RGMII0_RXD3_MUXMODE, 11U);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_RGMII0_RXD3 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXCTL_RGMII0_RXCTL_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXCTL_RGMII0_RXCTL_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXCTL_RGMII0_RXCTL_INPUTENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXCTL_RGMII0_RXCTL_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXCTL_RGMII0_RXCTL_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXCTL_RGMII0_RXCTL_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXCTL_RGMII0_RXCTL_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXCTL_RGMII0_RXCTL_MUXMODE, 11U);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_RGMII0_RXCTL = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_UART3_TXD_UART3_TXD_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal,CONTROL_CORE_PAD_IO_PAD_UART3_TXD_UART3_TXD_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_UART3_TXD_UART3_TXD_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_UART3_TXD_UART3_TXD_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_UART3_TXD_UART3_TXD_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_UART3_TXD_UART3_TXD_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_UART3_TXD_UART3_TXD_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_UART3_TXD_UART3_TXD_MUXMODE, 11U);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_UART3_TXD = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_UART3_RXD_UART3_RXD_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal,CONTROL_CORE_PAD_IO_PAD_UART3_RXD_UART3_RXD_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_UART3_RXD_UART3_RXD_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_UART3_RXD_UART3_RXD_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_UART3_RXD_UART3_RXD_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_UART3_RXD_UART3_RXD_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_UART3_RXD_UART3_RXD_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_UART3_RXD_UART3_RXD_MUXMODE, 11U);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_UART3_RXD = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD2_RGMII0_TXD2_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal,CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD2_RGMII0_TXD2_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD2_RGMII0_TXD2_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD2_RGMII0_TXD2_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD2_RGMII0_TXD2_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD2_RGMII0_TXD2_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD2_RGMII0_TXD2_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD2_RGMII0_TXD2_MUXMODE, 11U);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_RGMII0_TXD2 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD0_RGMII0_TXD0_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal,CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD0_RGMII0_TXD0_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD0_RGMII0_TXD0_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD0_RGMII0_TXD0_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD0_RGMII0_TXD0_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD0_RGMII0_TXD0_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD0_RGMII0_TXD0_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD0_RGMII0_TXD0_MUXMODE, 11U);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_RGMII0_TXD0 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD1_RGMII0_TXD1_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal,CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD1_RGMII0_TXD1_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD1_RGMII0_TXD1_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD1_RGMII0_TXD1_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD1_RGMII0_TXD1_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD1_RGMII0_TXD1_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD1_RGMII0_TXD1_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD1_RGMII0_TXD1_MUXMODE, 11U);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_RGMII0_TXD1 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXCTL_RGMII0_TXCTL_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal,CONTROL_CORE_PAD_IO_PAD_RGMII0_TXCTL_RGMII0_TXCTL_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXCTL_RGMII0_TXCTL_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXCTL_RGMII0_TXCTL_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXCTL_RGMII0_TXCTL_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXCTL_RGMII0_TXCTL_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXCTL_RGMII0_TXCTL_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXCTL_RGMII0_TXCTL_MUXMODE, 11U);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_RGMII0_TXCTL = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXC_RGMII0_TXC_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal,CONTROL_CORE_PAD_IO_PAD_RGMII0_TXC_RGMII0_TXC_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXC_RGMII0_TXC_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXC_RGMII0_TXC_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXC_RGMII0_TXC_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal,CONTROL_CORE_PAD_IO_PAD_RGMII0_TXC_RGMII0_TXC_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXC_RGMII0_TXC_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXC_RGMII0_TXC_MUXMODE, 11U);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_RGMII0_TXC = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD3_RGMII0_TXD3_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal,CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD3_RGMII0_TXD3_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD3_RGMII0_TXD3_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD3_RGMII0_TXD3_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD3_RGMII0_TXD3_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD3_RGMII0_TXD3_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD3_RGMII0_TXD3_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD3_RGMII0_TXD3_MUXMODE, 11U);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_RGMII0_TXD3 = regVal;


    regVal = 0U;
   CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MDIO_MCLK_MDIO_MCLK_MUXMODE, 0xFU);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MDIO_MCLK = regVal;


    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MDIO_D_MDIO_D_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal,CONTROL_CORE_PAD_IO_PAD_MDIO_D_MDIO_D_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MDIO_D_MDIO_D_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MDIO_D_MDIO_D_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MDIO_D_MDIO_D_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MDIO_D_MDIO_D_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MDIO_D_MDIO_D_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MDIO_D_MDIO_D_MUXMODE, 0xffU);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MDIO_D = regVal;


    /***************************************************************************************************
    * pru1 eth 1 Not wired for default IDK
    ****************************************************************************************************/
    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D6_VIN2A_D6_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D6_VIN2A_D6_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D6_VIN2A_D6_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D6_VIN2A_D6_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D6_VIN2A_D6_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D6_VIN2A_D6_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D6_VIN2A_D6_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D6_VIN2A_D6_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_VIN2A_D6 = regVal;


    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D7_VIN2A_D7_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D7_VIN2A_D7_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D7_VIN2A_D7_INPUTENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D7_VIN2A_D7_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D7_VIN2A_D7_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D7_VIN2A_D7_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D7_VIN2A_D7_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D7_VIN2A_D7_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_VIN2A_D7 = regVal;


    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D13_VIN2A_D13_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D13_VIN2A_D13_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D13_VIN2A_D13_INPUTENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D13_VIN2A_D13_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D13_VIN2A_D13_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D13_VIN2A_D13_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D13_VIN2A_D13_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D13_VIN2A_D13_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_VIN2A_D13 = regVal;


    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D12_VIN2A_D12_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D12_VIN2A_D12_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D12_VIN2A_D12_INPUTENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D12_VIN2A_D12_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D12_VIN2A_D12_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D12_VIN2A_D12_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D12_VIN2A_D12_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D12_VIN2A_D12_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_VIN2A_D12 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D9_VIN2A_D9_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D9_VIN2A_D9_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D9_VIN2A_D9_INPUTENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D9_VIN2A_D9_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D9_VIN2A_D9_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D9_VIN2A_D9_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D9_VIN2A_D9_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D9_VIN2A_D9_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_VIN2A_D9 = regVal;


    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D8_VIN2A_D8_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D8_VIN2A_D8_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D8_VIN2A_D8_INPUTENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D8_VIN2A_D8_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D8_VIN2A_D8_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D8_VIN2A_D8_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D8_VIN2A_D8_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D8_VIN2A_D8_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_VIN2A_D8 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D14_VIN2A_D14_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D14_VIN2A_D14_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D14_VIN2A_D14_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D14_VIN2A_D14_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D14_VIN2A_D14_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D14_VIN2A_D14_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D14_VIN2A_D14_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D14_VIN2A_D14_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_VIN2A_D14 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D15_VIN2A_D15_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D15_VIN2A_D15_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D15_VIN2A_D15_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D15_VIN2A_D15_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D15_VIN2A_D15_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D15_VIN2A_D15_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D15_VIN2A_D15_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D15_VIN2A_D15_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_VIN2A_D15 = regVal;


    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D20_VIN2A_D20_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D20_VIN2A_D20_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D20_VIN2A_D20_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D20_VIN2A_D20_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D20_VIN2A_D20_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D20_VIN2A_D20_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D20_VIN2A_D20_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D20_VIN2A_D20_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_VIN2A_D20 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D19_VIN2A_D19_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D19_VIN2A_D19_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D19_VIN2A_D19_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D19_VIN2A_D19_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D19_VIN2A_D19_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D19_VIN2A_D19_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D19_VIN2A_D19_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D19_VIN2A_D19_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_VIN2A_D19 = regVal;


    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D18_VIN2A_D18_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D18_VIN2A_D18_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D18_VIN2A_D18_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D18_VIN2A_D18_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D18_VIN2A_D18_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D18_VIN2A_D18_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D18_VIN2A_D18_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D18_VIN2A_D18_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_VIN2A_D18 = regVal;

     regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D17_VIN2A_D17_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D17_VIN2A_D17_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D17_VIN2A_D17_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D17_VIN2A_D17_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D17_VIN2A_D17_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D17_VIN2A_D17_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D17_VIN2A_D17_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D17_VIN2A_D17_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_VIN2A_D17 = regVal;

     regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D16_VIN2A_D16_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D16_VIN2A_D16_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D16_VIN2A_D16_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D16_VIN2A_D16_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D16_VIN2A_D16_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D16_VIN2A_D16_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D16_VIN2A_D16_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D16_VIN2A_D16_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_VIN2A_D16 = regVal;


    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D23_VIN2A_D23_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D23_VIN2A_D23_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D23_VIN2A_D23_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D23_VIN2A_D23_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D23_VIN2A_D23_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D23_VIN2A_D23_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D23_VIN2A_D23_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D23_VIN2A_D23_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_VIN2A_D23 = regVal;

    regVal = 0U;
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D22_VIN2A_D22_MUXMODE, 0xFU);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_VIN2A_D22 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D21_VIN2A_D21_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D21_VIN2A_D21_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D21_VIN2A_D21_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D21_VIN2A_D21_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D21_VIN2A_D21_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D21_VIN2A_D21_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D21_VIN2A_D21_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D21_VIN2A_D21_MUXMODE, 0xff);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_VIN2A_D21 = regVal;

#endif
    /***************************************************************************************************
    * pru2 eth 0
    ****************************************************************************************************/
    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_ACLKX_MCASP1_ACLKX_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_ACLKX_MCASP1_ACLKX_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_ACLKX_MCASP1_ACLKX_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_ACLKX_MCASP1_ACLKX_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_ACLKX_MCASP1_ACLKX_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_ACLKX_MCASP1_ACLKX_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_ACLKX_MCASP1_ACLKX_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_ACLKX_MCASP1_ACLKX_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MCASP1_ACLKX = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_FSX_MCASP1_FSX_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_FSX_MCASP1_FSX_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_FSX_MCASP1_FSX_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_FSX_MCASP1_FSX_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_FSX_MCASP1_FSX_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_FSX_MCASP1_FSX_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_FSX_MCASP1_FSX_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_FSX_MCASP1_FSX_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MCASP1_FSX = regVal;


    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR1_MCASP1_AXR1_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR1_MCASP1_AXR1_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR1_MCASP1_AXR1_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR1_MCASP1_AXR1_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR1_MCASP1_AXR1_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR1_MCASP1_AXR1_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR1_MCASP1_AXR1_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR1_MCASP1_AXR1_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MCASP1_AXR1 = regVal;


    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR8_MCASP1_AXR8_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR8_MCASP1_AXR8_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR8_MCASP1_AXR8_INPUTENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR8_MCASP1_AXR8_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR8_MCASP1_AXR8_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR8_MCASP1_AXR8_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR8_MCASP1_AXR8_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR8_MCASP1_AXR8_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MCASP1_AXR8 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR12_MCASP1_AXR12_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR12_MCASP1_AXR12_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR12_MCASP1_AXR12_INPUTENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR12_MCASP1_AXR12_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR12_MCASP1_AXR12_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR12_MCASP1_AXR12_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR12_MCASP1_AXR12_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR12_MCASP1_AXR12_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MCASP1_AXR12 = regVal;


    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR11_MCASP1_AXR11_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR11_MCASP1_AXR11_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR11_MCASP1_AXR11_INPUTENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR11_MCASP1_AXR11_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR11_MCASP1_AXR11_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR11_MCASP1_AXR11_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR11_MCASP1_AXR11_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR11_MCASP1_AXR11_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MCASP1_AXR11 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR10_MCASP1_AXR10_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR10_MCASP1_AXR10_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR10_MCASP1_AXR10_INPUTENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR10_MCASP1_AXR10_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR10_MCASP1_AXR10_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR10_MCASP1_AXR10_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR10_MCASP1_AXR10_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR10_MCASP1_AXR10_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MCASP1_AXR10 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR9_MCASP1_AXR9_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR9_MCASP1_AXR9_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR9_MCASP1_AXR9_INPUTENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR9_MCASP1_AXR9_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR9_MCASP1_AXR9_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR9_MCASP1_AXR9_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR9_MCASP1_AXR9_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR9_MCASP1_AXR9_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MCASP1_AXR9 = regVal;


    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR13_MCASP1_AXR13_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR13_MCASP1_AXR13_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR13_MCASP1_AXR13_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR13_MCASP1_AXR13_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR13_MCASP1_AXR13_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR13_MCASP1_AXR13_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR13_MCASP1_AXR13_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR13_MCASP1_AXR13_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MCASP1_AXR13 = regVal;

         regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR14_MCASP1_AXR14_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR14_MCASP1_AXR14_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR14_MCASP1_AXR14_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR14_MCASP1_AXR14_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR14_MCASP1_AXR14_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR14_MCASP1_AXR14_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR14_MCASP1_AXR14_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR14_MCASP1_AXR14_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MCASP1_AXR14 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR0_MCASP1_AXR0_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR0_MCASP1_AXR0_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR0_MCASP1_AXR0_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR0_MCASP1_AXR0_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR0_MCASP1_AXR0_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR0_MCASP1_AXR0_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR0_MCASP1_AXR0_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR0_MCASP1_AXR0_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MCASP1_AXR0 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP2_AXR2_MCASP2_AXR2_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP2_AXR2_MCASP2_AXR2_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP2_AXR2_MCASP2_AXR2_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP2_AXR2_MCASP2_AXR2_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP2_AXR2_MCASP2_AXR2_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP2_AXR2_MCASP2_AXR2_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP2_AXR2_MCASP2_AXR2_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP2_AXR2_MCASP2_AXR2_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MCASP2_AXR2 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP2_FSX_MCASP2_FSX_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP2_FSX_MCASP2_FSX_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP2_FSX_MCASP2_FSX_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP2_FSX_MCASP2_FSX_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP2_FSX_MCASP2_FSX_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP2_FSX_MCASP2_FSX_MODESELECT, MUX_MODE);
    CSL_FINS(regVal,CONTROL_CORE_PAD_IO_PAD_MCASP2_FSX_MCASP2_FSX_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP2_FSX_MCASP2_FSX_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MCASP2_FSX = regVal;



    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP2_ACLKX_MCASP2_ACLKX_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP2_ACLKX_MCASP2_ACLKX_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP2_ACLKX_MCASP2_ACLKX_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP2_ACLKX_MCASP2_ACLKX_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP2_ACLKX_MCASP2_ACLKX_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP2_ACLKX_MCASP2_ACLKX_MODESELECT, MUX_MODE);
    CSL_FINS(regVal,CONTROL_CORE_PAD_IO_PAD_MCASP2_ACLKX_MCASP2_ACLKX_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP2_ACLKX_MCASP2_ACLKX_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MCASP2_ACLKX = regVal;


         regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR15_MCASP1_AXR15_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR15_MCASP1_AXR15_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR15_MCASP1_AXR15_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR15_MCASP1_AXR15_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR15_MCASP1_AXR15_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR15_MCASP1_AXR15_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR15_MCASP1_AXR15_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR15_MCASP1_AXR15_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MCASP1_AXR15 = regVal;



    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP3_ACLKX_MCASP3_ACLKX_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP3_ACLKX_MCASP3_ACLKX_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP3_ACLKX_MCASP3_ACLKX_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP3_ACLKX_MCASP3_ACLKX_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP3_ACLKX_MCASP3_ACLKX_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP3_ACLKX_MCASP3_ACLKX_MODESELECT, MUX_MODE);
    CSL_FINS(regVal,CONTROL_CORE_PAD_IO_PAD_MCASP3_ACLKX_MCASP3_ACLKX_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP3_ACLKX_MCASP3_ACLKX_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MCASP3_ACLKX = regVal;



    regVal = 0U;

    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP3_FSX_MCASP3_FSX_MUXMODE, 0xFU);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MCASP3_FSX = regVal;

    regVal = 0U;
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR3_MCASP1_AXR3_MUXMODE, 0xFU);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MCASP1_AXR3 = regVal;

    /***************************************************************************************************
    * pru2 eth 1
    ****************************************************************************************************/
    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPIO6_10_GPIO6_10_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPIO6_10_GPIO6_10_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPIO6_10_GPIO6_10_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPIO6_10_GPIO6_10_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPIO6_10_GPIO6_10_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPIO6_10_GPIO6_10_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_GPIO6_10_GPIO6_10_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_GPIO6_10_GPIO6_10_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_GPIO6_10 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPIO6_11_GPIO6_11_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPIO6_11_GPIO6_11_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPIO6_11_GPIO6_11_INPUTENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPIO6_11_GPIO6_11_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPIO6_11_GPIO6_11_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_GPIO6_11_GPIO6_11_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_GPIO6_11_GPIO6_11_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_GPIO6_11_GPIO6_11_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_GPIO6_11 = regVal;


    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT1_MMC3_DAT1_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT1_MMC3_DAT1_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT1_MMC3_DAT1_INPUTENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT1_MMC3_DAT1_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT1_MMC3_DAT1_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT1_MMC3_DAT1_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT1_MMC3_DAT1_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT1_MMC3_DAT1_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MMC3_DAT1 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT0_MMC3_DAT0_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT0_MMC3_DAT0_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT0_MMC3_DAT0_INPUTENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT0_MMC3_DAT0_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT0_MMC3_DAT0_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT0_MMC3_DAT0_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT0_MMC3_DAT0_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT0_MMC3_DAT0_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MMC3_DAT0 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_CMD_MMC3_CMD_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_CMD_MMC3_CMD_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_CMD_MMC3_CMD_INPUTENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_CMD_MMC3_CMD_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_CMD_MMC3_CMD_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_CMD_MMC3_CMD_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_CMD_MMC3_CMD_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_CMD_MMC3_CMD_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MMC3_CMD = regVal;


     regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_CLK_MMC3_CLK_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_CLK_MMC3_CLK_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_CLK_MMC3_CLK_INPUTENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_CLK_MMC3_CLK_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_CLK_MMC3_CLK_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_CLK_MMC3_CLK_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_CLK_MMC3_CLK_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_CLK_MMC3_CLK_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MMC3_CLK = regVal;


   regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT2_MMC3_DAT2_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT2_MMC3_DAT2_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT2_MMC3_DAT2_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT2_MMC3_DAT2_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT2_MMC3_DAT2_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT2_MMC3_DAT2_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT2_MMC3_DAT2_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT2_MMC3_DAT2_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MMC3_DAT2 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT3_MMC3_DAT3_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT3_MMC3_DAT3_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT3_MMC3_DAT3_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT3_MMC3_DAT3_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT3_MMC3_DAT3_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT3_MMC3_DAT3_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT3_MMC3_DAT3_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT3_MMC3_DAT3_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MMC3_DAT3 = regVal;

     regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP3_AXR0_MCASP3_AXR0_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal,CONTROL_CORE_PAD_IO_PAD_MCASP3_AXR0_MCASP3_AXR0_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP3_AXR0_MCASP3_AXR0_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP3_AXR0_MCASP3_AXR0_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP3_AXR0_MCASP3_AXR0_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal,CONTROL_CORE_PAD_IO_PAD_MCASP3_AXR0_MCASP3_AXR0_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP3_AXR0_MCASP3_AXR0_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP3_AXR0_MCASP3_AXR0_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MCASP3_AXR0 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT7_MMC3_DAT7_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT7_MMC3_DAT7_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT7_MMC3_DAT7_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT7_MMC3_DAT7_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT7_MMC3_DAT7_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT7_MMC3_DAT7_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT7_MMC3_DAT7_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT7_MMC3_DAT7_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MMC3_DAT7 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT6_MMC3_DAT6_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT6_MMC3_DAT6_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT6_MMC3_DAT6_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT6_MMC3_DAT6_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT6_MMC3_DAT6_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT6_MMC3_DAT6_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT6_MMC3_DAT6_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT6_MMC3_DAT6_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MMC3_DAT6 = regVal;


    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT5_MMC3_DAT5_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT5_MMC3_DAT5_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT5_MMC3_DAT5_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT5_MMC3_DAT5_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT5_MMC3_DAT5_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT5_MMC3_DAT5_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT5_MMC3_DAT5_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT5_MMC3_DAT5_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MMC3_DAT5 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT4_MMC3_DAT4_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT4_MMC3_DAT4_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT4_MMC3_DAT4_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT4_MMC3_DAT4_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT4_MMC3_DAT4_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT4_MMC3_DAT4_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT4_MMC3_DAT4_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MMC3_DAT4_MMC3_DAT4_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MMC3_DAT4 = regVal;


     regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_XREF_CLK1_XREF_CLK1_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_XREF_CLK1_XREF_CLK1_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_XREF_CLK1_XREF_CLK1_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_XREF_CLK1_XREF_CLK1_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_XREF_CLK1_XREF_CLK1_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_XREF_CLK1_XREF_CLK1_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_XREF_CLK1_XREF_CLK1_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_XREF_CLK1_XREF_CLK1_MUXMODE, 11U);
     ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_XREF_CLK1 = regVal;



    regVal = 0U;
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_XREF_CLK0_XREF_CLK0_MUXMODE, 0xFU);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_XREF_CLK0 = regVal;

    regVal = 0U;
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP3_AXR1_MCASP3_AXR1_MUXMODE, 0xFU);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MCASP3_AXR1 = regVal;

}
void PinmuxCpswConfig (void)
{
    Uint32 regVal = 0U;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MDIO_MCLK_MDIO_MCLK_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MDIO_MCLK_MDIO_MCLK_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MDIO_MCLK_MDIO_MCLK_INPUTENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MDIO_MCLK_MDIO_MCLK_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MDIO_MCLK_MDIO_MCLK_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MDIO_MCLK_MDIO_MCLK_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MDIO_MCLK_MDIO_MCLK_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MDIO_MCLK_MDIO_MCLK_MUXMODE, 0U);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MDIO_MCLK = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MDIO_D_MDIO_D_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MDIO_D_MDIO_D_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MDIO_D_MDIO_D_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MDIO_D_MDIO_D_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MDIO_D_MDIO_D_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_MDIO_D_MDIO_D_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MDIO_D_MDIO_D_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MDIO_D_MDIO_D_MUXMODE, 0U);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MDIO_D = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXC_RGMII0_TXC_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXC_RGMII0_TXC_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXC_RGMII0_TXC_INPUTENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXC_RGMII0_TXC_PULLTYPESELECT, PULL_DOWN);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXC_RGMII0_TXC_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXC_RGMII0_TXC_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXC_RGMII0_TXC_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXC_RGMII0_TXC_MUXMODE, 0U);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_RGMII0_TXC = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXCTL_RGMII0_TXCTL_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXCTL_RGMII0_TXCTL_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXCTL_RGMII0_TXCTL_INPUTENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXCTL_RGMII0_TXCTL_PULLTYPESELECT, PULL_DOWN);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXCTL_RGMII0_TXCTL_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXCTL_RGMII0_TXCTL_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXCTL_RGMII0_TXCTL_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXCTL_RGMII0_TXCTL_MUXMODE, 0U);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_RGMII0_TXCTL = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD0_RGMII0_TXD0_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD0_RGMII0_TXD0_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD0_RGMII0_TXD0_INPUTENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD0_RGMII0_TXD0_PULLTYPESELECT, PULL_DOWN);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD0_RGMII0_TXD0_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD0_RGMII0_TXD0_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD0_RGMII0_TXD0_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD0_RGMII0_TXD0_MUXMODE, 0U);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_RGMII0_TXD0 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD1_RGMII0_TXD1_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD1_RGMII0_TXD1_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD1_RGMII0_TXD1_INPUTENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD1_RGMII0_TXD1_PULLTYPESELECT, PULL_DOWN);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD1_RGMII0_TXD1_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD1_RGMII0_TXD1_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD1_RGMII0_TXD1_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD1_RGMII0_TXD1_MUXMODE, 0U);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_RGMII0_TXD1 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD2_RGMII0_TXD2_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD2_RGMII0_TXD2_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD2_RGMII0_TXD2_INPUTENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD2_RGMII0_TXD2_PULLTYPESELECT, PULL_DOWN);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD2_RGMII0_TXD2_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD2_RGMII0_TXD2_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD2_RGMII0_TXD2_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD2_RGMII0_TXD2_MUXMODE, 0U);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_RGMII0_TXD2 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD3_RGMII0_TXD3_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD3_RGMII0_TXD3_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD3_RGMII0_TXD3_INPUTENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD3_RGMII0_TXD3_PULLTYPESELECT, PULL_DOWN);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD3_RGMII0_TXD3_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD3_RGMII0_TXD3_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD3_RGMII0_TXD3_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_TXD3_RGMII0_TXD3_MUXMODE, 0U);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_RGMII0_TXD3 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXC_RGMII0_RXC_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXC_RGMII0_RXC_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXC_RGMII0_RXC_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXC_RGMII0_RXC_PULLTYPESELECT, PULL_DOWN);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXC_RGMII0_RXC_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXC_RGMII0_RXC_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXC_RGMII0_RXC_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXC_RGMII0_RXC_MUXMODE, 0U);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_RGMII0_RXC = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXCTL_RGMII0_RXCTL_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXCTL_RGMII0_RXCTL_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXCTL_RGMII0_RXCTL_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXCTL_RGMII0_RXCTL_PULLTYPESELECT, PULL_DOWN);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXCTL_RGMII0_RXCTL_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXCTL_RGMII0_RXCTL_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXCTL_RGMII0_RXCTL_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXCTL_RGMII0_RXCTL_MUXMODE, 0U);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_RGMII0_RXCTL = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD0_RGMII0_RXD0_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD0_RGMII0_RXD0_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD0_RGMII0_RXD0_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD0_RGMII0_RXD0_PULLTYPESELECT, PULL_DOWN);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD0_RGMII0_RXD0_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD0_RGMII0_RXD0_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD0_RGMII0_RXD0_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD0_RGMII0_RXD0_MUXMODE, 0U);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_RGMII0_RXD0 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD1_RGMII0_RXD1_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD1_RGMII0_RXD1_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD1_RGMII0_RXD1_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD1_RGMII0_RXD1_PULLTYPESELECT, PULL_DOWN);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD1_RGMII0_RXD1_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD1_RGMII0_RXD1_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD1_RGMII0_RXD1_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD1_RGMII0_RXD1_MUXMODE, 0U);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_RGMII0_RXD1 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD2_RGMII0_RXD2_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD2_RGMII0_RXD2_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD2_RGMII0_RXD2_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD2_RGMII0_RXD2_PULLTYPESELECT, PULL_DOWN);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD2_RGMII0_RXD2_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD2_RGMII0_RXD2_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD2_RGMII0_RXD2_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD2_RGMII0_RXD2_MUXMODE, 0U);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_RGMII0_RXD2 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD3_RGMII0_RXD3_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD3_RGMII0_RXD3_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD3_RGMII0_RXD3_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD3_RGMII0_RXD3_PULLTYPESELECT, PULL_DOWN);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD3_RGMII0_RXD3_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD3_RGMII0_RXD3_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD3_RGMII0_RXD3_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_RGMII0_RXD3_RGMII0_RXD3_MUXMODE, 0U);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_RGMII0_RXD3 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D12_VIN2A_D12_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D12_VIN2A_D12_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D12_VIN2A_D12_INPUTENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D12_VIN2A_D12_PULLTYPESELECT, PULL_DOWN);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D12_VIN2A_D12_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D12_VIN2A_D12_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D12_VIN2A_D12_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D12_VIN2A_D12_MUXMODE, 3U);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_VIN2A_D12 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D13_VIN2A_D13_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D13_VIN2A_D13_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D13_VIN2A_D13_INPUTENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D13_VIN2A_D13_PULLTYPESELECT, PULL_DOWN);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D13_VIN2A_D13_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D13_VIN2A_D13_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D13_VIN2A_D13_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D13_VIN2A_D13_MUXMODE, 3U);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_VIN2A_D13 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D17_VIN2A_D17_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D17_VIN2A_D17_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D17_VIN2A_D17_INPUTENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D17_VIN2A_D17_PULLTYPESELECT, PULL_DOWN);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D17_VIN2A_D17_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D17_VIN2A_D17_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D17_VIN2A_D17_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D17_VIN2A_D17_MUXMODE, 3U);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_VIN2A_D17 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D16_VIN2A_D16_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D16_VIN2A_D16_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D16_VIN2A_D16_INPUTENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D16_VIN2A_D16_PULLTYPESELECT, PULL_DOWN);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D16_VIN2A_D16_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D16_VIN2A_D16_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D16_VIN2A_D16_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D16_VIN2A_D16_MUXMODE, 3U);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_VIN2A_D16 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D15_VIN2A_D15_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D15_VIN2A_D15_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D15_VIN2A_D15_INPUTENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D15_VIN2A_D15_PULLTYPESELECT, PULL_DOWN);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D15_VIN2A_D15_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D15_VIN2A_D15_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D15_VIN2A_D15_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D15_VIN2A_D15_MUXMODE, 3U);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_VIN2A_D15 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D14_VIN2A_D14_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D14_VIN2A_D14_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D14_VIN2A_D14_INPUTENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D14_VIN2A_D14_PULLTYPESELECT, PULL_DOWN);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D14_VIN2A_D14_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D14_VIN2A_D14_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D14_VIN2A_D14_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D14_VIN2A_D14_MUXMODE, 3U);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_VIN2A_D14 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D18_VIN2A_D18_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D18_VIN2A_D18_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D18_VIN2A_D18_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D18_VIN2A_D18_PULLTYPESELECT, PULL_UP);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D18_VIN2A_D18_PULLUDENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D18_VIN2A_D18_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D18_VIN2A_D18_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D18_VIN2A_D18_MUXMODE, 3U);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_VIN2A_D18 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D19_VIN2A_D19_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D19_VIN2A_D19_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D19_VIN2A_D19_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D19_VIN2A_D19_PULLTYPESELECT, PULL_DOWN);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D19_VIN2A_D19_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D19_VIN2A_D19_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D19_VIN2A_D19_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D19_VIN2A_D19_MUXMODE, 3U);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_VIN2A_D19 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D23_VIN2A_D23_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D23_VIN2A_D23_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D23_VIN2A_D23_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D23_VIN2A_D23_PULLTYPESELECT, PULL_DOWN);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D23_VIN2A_D23_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D23_VIN2A_D23_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D23_VIN2A_D23_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D23_VIN2A_D23_MUXMODE, 3U);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_VIN2A_D23 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D22_VIN2A_D22_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D22_VIN2A_D22_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D22_VIN2A_D22_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D22_VIN2A_D22_PULLTYPESELECT, PULL_DOWN);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D22_VIN2A_D22_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D22_VIN2A_D22_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D22_VIN2A_D22_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D22_VIN2A_D22_MUXMODE, 3U);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_VIN2A_D22 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D21_VIN2A_D21_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D21_VIN2A_D21_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D21_VIN2A_D21_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D21_VIN2A_D21_PULLTYPESELECT, PULL_DOWN);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D21_VIN2A_D21_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D21_VIN2A_D21_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D21_VIN2A_D21_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D21_VIN2A_D21_MUXMODE, 3U);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_VIN2A_D21 = regVal;

    regVal = 0U;
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D20_VIN2A_D20_WAKEUPENABLE, DISABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D20_VIN2A_D20_SLEWCONTROL, SLOW_SLEW);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D20_VIN2A_D20_INPUTENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D20_VIN2A_D20_PULLTYPESELECT, PULL_DOWN);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D20_VIN2A_D20_PULLUDENABLE, ENABLE);
    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D20_VIN2A_D20_MODESELECT, MUX_MODE);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D20_VIN2A_D20_DELAYMODE, 0U);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_D20_VIN2A_D20_MUXMODE, 3U);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_VIN2A_D20 = regVal;
}

void PinmuxGpioLedConfig (int alpha)
{
    Uint32 regVal = 0U;

    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_XREF_CLK2_XREF_CLK2_MUXMODE, 0xEU);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_XREF_CLK2 = regVal;

    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_VIN2A_VSYNC0_VIN2A_VSYNC0_MUXMODE, 0xEU);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_VIN2A_VSYNC0 = regVal;

    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP2_AXR4_MCASP2_AXR4_MUXMODE, 0xEU);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MCASP2_AXR4 = regVal;

    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP2_AXR5_MCASP2_AXR5_MUXMODE, 0xEU);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MCASP2_AXR5 = regVal;

    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP2_AXR6_MCASP2_AXR6_MUXMODE, 0xEU);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MCASP2_AXR6 = regVal;

    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_MCASP2_AXR7_MCASP2_AXR7_MUXMODE, 0xEU);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_MCASP2_AXR7 = regVal;

    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_SPI1_D0_SPI1_D0_MUXMODE, 0xEU);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_SPI1_D0 = regVal;

    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_SPI1_D1_SPI1_D1_MUXMODE, 0xEU);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_SPI1_D1 = regVal;

    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_SPI1_CS0_SPI1_CS0_MUXMODE, 0xEU);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_SPI1_CS0 = regVal;

    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_SPI1_CS1_SPI1_CS1_MUXMODE, 0xEU);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_SPI1_CS1 = regVal;

    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_WEN_GPMC_WEN_MUXMODE, 0xEU);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_GPMC_WEN = regVal;

    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_BEN0_GPMC_BEN0_MUXMODE, 0xEU);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_GPMC_BEN0 = regVal;

    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_BEN1_GPMC_BEN1_MUXMODE, 0xEU);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_GPMC_BEN1 = regVal;

    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_WAIT0_GPMC_WAIT0_MUXMODE, 0xEU);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_GPMC_WAIT0 = regVal;

    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_CS3_GPMC_CS3_MUXMODE, 0xEU);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_GPMC_CS3 = regVal;

    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_GPMC_CS0_GPMC_CS0_MUXMODE, 0xEU);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_GPMC_CS0 = regVal;

    if (alpha)
    {
          CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_UART2_RTSN_UART2_RTSN_MUXMODE, 0xEU);
          ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_UART2_RTSN = regVal;

          CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_UART2_CTSN_UART2_CTSN_MUXMODE, 0xEU);
          ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_UART2_CTSN = regVal;
    }
    else
    {
          CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_UART1_TXD_UART1_TXD_MUXMODE, 0xEU);
          ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_UART1_TXD = regVal;

          CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_UART1_RXD_UART1_RXD_MUXMODE, 0xEU);
          ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_UART1_RXD = regVal;
    }
}

void PinmuxGpioHapticsConfig(void)
{
    Uint32 regVal = 0U;

    CSL_FINST(regVal, CONTROL_CORE_PAD_IO_PAD_SPI1_SCLK_SPI1_SCLK_PULLTYPESELECT, PULL_UP);
    CSL_FINS(regVal, CONTROL_CORE_PAD_IO_PAD_SPI1_SCLK_SPI1_SCLK_MUXMODE, 0xEU);
    ((CSL_padRegsOvly) CSL_MPU_CORE_PAD_IO_REGISTERS_REGS)->PAD_SPI1_SCLK = regVal;

}


void PinmuxQSPIConfig()
{
    /* QSPI_RTCLK */
    HW_WR_REG32((CSL_MPU_CORE_PAD_IO_REGISTERS_REGS + CTRL_CORE_PAD_GPMC_A13),
        (0x00060001));

    /* QSPI_D3 */
    HW_WR_REG32((CSL_MPU_CORE_PAD_IO_REGISTERS_REGS + CTRL_CORE_PAD_GPMC_A14),
        (CTRL_CORE_PAD_GPMC_A14_PULLUP_RX_MODE_1));

    /* QSPI_D2  */
    HW_WR_REG32((CSL_MPU_CORE_PAD_IO_REGISTERS_REGS + CTRL_CORE_PAD_GPMC_A15),
        (CTRL_CORE_PAD_GPMC_A15_PULLUP_RX_MODE_1));

    /* QSPI_D0 */
    HW_WR_REG32((CSL_MPU_CORE_PAD_IO_REGISTERS_REGS + CTRL_CORE_PAD_GPMC_A16),
        (CTRL_CORE_PAD_GPMC_A16_PULLUP_RX_MODE_1));

    /* QSPI_D1 */
    HW_WR_REG32((CSL_MPU_CORE_PAD_IO_REGISTERS_REGS + CTRL_CORE_PAD_GPMC_A17),
        (CTRL_CORE_PAD_GPMC_A17_PULLUP_RX_MODE_1));

    /* QSPI_CLK */
    HW_WR_REG32((CSL_MPU_CORE_PAD_IO_REGISTERS_REGS + CTRL_CORE_PAD_GPMC_A18),
        (0x00060001));

    /* QSPI_CSn */
    HW_WR_REG32((CSL_MPU_CORE_PAD_IO_REGISTERS_REGS + CTRL_CORE_PAD_GPMC_CS2),
        (0x00060001));

    /* QSPI_CSn */
    HW_WR_REG32((CSL_MPU_CORE_PAD_IO_REGISTERS_REGS + CTRL_CORE_PAD_GPMC_CS3),
        (CTRL_CORE_PAD_GPMC_CS3_PULLUP_MODE_1));

    /* QSPI_CLK */
    HW_WR_REG32((CSL_MPU_CORE_PAD_IO_REGISTERS_REGS + CTRL_CORE_PAD_GPMC_A3),
        (CTRL_CORE_PAD_GPMC_A3_PULLUP_MODE_1));

    /* QSPI_CLK */
    HW_WR_REG32((CSL_MPU_CORE_PAD_IO_REGISTERS_REGS + CTRL_CORE_PAD_GPMC_A4),
        (CTRL_CORE_PAD_GPMC_A4_PULLUP_MODE_1));
}

void PinmuxMCSPIConfig()
{
    /* GPIO3_19 */
    HW_WR_REG32((CSL_MPU_CORE_PAD_IO_REGISTERS_REGS + CTRL_CORE_PAD_VIN1A_D15),
        (CTRL_CORE_PAD_VIN1A_D15_PILLUP));

    /* SPI3_SCLK */
    HW_WR_REG32((CSL_MPU_CORE_PAD_IO_REGISTERS_REGS + CTRL_CORE_PAD_MCASP4_ACLKX),
        (CTRL_CORE_PAD_MCASP4_ACLKX_PUPDD_RX_MODE));

    /* SPI3_D1 */
    HW_WR_REG32((CSL_MPU_CORE_PAD_IO_REGISTERS_REGS + CTRL_CORE_PAD_MCASP4_FSX),
        (CTRL_CORE_PAD_MCASP4_FSX_PUPDD_RX_MODE));

    /* SPI3_CS0 */
    HW_WR_REG32((CSL_MPU_CORE_PAD_IO_REGISTERS_REGS + CTRL_CORE_PAD_MCASP4_AXR1),
        (CTRL_CORE_PAD_MCASP4_AXR1_PUPDD_RX_MODE));


    /* SPI2_SCLK */
    HW_WR_REG32((CSL_MPU_CORE_PAD_IO_REGISTERS_REGS + CTRL_CORE_PAD_MCSPI2_SCLK),
        0x00050000);

	/* SPI2_D0 */
    HW_WR_REG32((CSL_MPU_CORE_PAD_IO_REGISTERS_REGS + CTRL_CORE_PAD_MCSPI2_D0),
        0x00050000);

	/* SPI2_D1 */
    HW_WR_REG32((CSL_MPU_CORE_PAD_IO_REGISTERS_REGS + CTRL_CORE_PAD_MCSPI2_D1),
        0x00060000);

    /* SPI2_CS0 */
    HW_WR_REG32((CSL_MPU_CORE_PAD_IO_REGISTERS_REGS + CTRL_CORE_PAD_MCSPI2_CS0),
        0x00060000);

}

void ManualPinmux()
{
    PinmuxQSPIConfig();
    PinmuxMCSPIConfig();
    PinmuxI2cConfig(1U);
    PinmuxI2cConfig(3U);
    PinmuxI2cConfig(5U);
    PinmuxMmcConfig(1U);
    PinmuxMmcConfig(2U);
    PinmuxMmcConfig(3U);
    PinmuxGpioHapticsConfig();
    PinmuxCpswConfig();
    PinmuxPruIcssConfig();
}

void AM570xPinmux()
{
    const boardPinmuxBoardCfg_t *pPinmuxData;
    uint32_t i = 0;
    uint32_t tmpRegVal;

    pPinmuxData = &gBoardTda2xxPinMuxData[0U];

    for (i = 0; (DEVICE_ID_INVALID != pPinmuxData[i].moduleId); i++)
    {
        tmpRegVal = HW_RD_REG32(SOC_CORE_PAD_IO_REGISTERS_BASE + pPinmuxData[i].regOffset);
        tmpRegVal &= ~(0xF000FU);
        tmpRegVal |= (pPinmuxData[i].regVal & 0xF000FU);
        HW_WR_REG32((SOC_CORE_PAD_IO_REGISTERS_BASE + pPinmuxData[i].regOffset), tmpRegVal);
    }
    return;
}

Board_STATUS Board_pinmuxConfig (void)
{
    Board_IDInfo id;
    Board_STATUS ret = BOARD_SOK;

    ret = Board_getIDInfo(&id);
    if (ret != BOARD_SOK)
    {
        return ret;
    }

    /* Check if DRA chip (AM570x) */
    if ((id.boardName[0] == 'D') &&
        (id.boardName[1] == 'R') &&
        (id.boardName[2] == 'A'))
    {
        AM570xPinmux();
    }
    /* Check if version is 1.0 or 1.1 */
    else if ((id.version[0] == '1' && id.version[2] == '0') ||
        (id.version[0] == '1' && id.version[2] == '1'))
    {
        PinmuxUartConfig(1);
        PinmuxGpioLedConfig(1);
        ManualPinmux();
    }
    else
    {
#if defined(NO_IO_DELAY) || defined(__TI_ARM_V7M4__)
        PinmuxUartConfig(3);
        PinmuxGpioLedConfig(0);
        ManualPinmux();
#elif defined(IO_DELAY)
        uint32_t size;
        /* i890: MMC1 IOs and PBIAS Must Be Powered-Up before Isolation:
         * Power-up the MMC1 IOs and PBIAS before starting the Isolation Sequence. This can be
         * done by setting the CTRL_CORE_CONTROL_PBIAS[27] SDCARD_BIAS_PWRDNZ
         * and CTRL_CORE_CONTROL_PBIAS[26] SDCARD_IO_PWRDNZ bits to 1.
         */
        CSL_control_core_padRegs *hCtrlCorePad =
               (CSL_control_core_padRegs *) CSL_MPU_CTRL_MODULE_CORE_CORE_PAD_REGISTERS_REGS;
        Uint32 regVal = hCtrlCorePad->CONTROL_PBIAS;
        CSL_FINST(regVal, CONTROL_CORE_PAD_CONTROL_PBIAS_SDCARD_BIAS_PWRDNZ, DISABLE);
        CSL_FINST(regVal, CONTROL_CORE_PAD_CONTROL_PBIAS_SDCARD_IO_PWRDNZ, DISABLE);
        hCtrlCorePad->CONTROL_PBIAS = regVal;

        /* Check to make sure IO Delay stack and functions are in local memory */
        if (((uint32_t) &ioStack >= 0x80000000) || ((uint32_t)BoardCtrlPadIoDelayConfig >= 0x80000000))
            return BOARD_PINMUX_BAD_MEM_REGION;

        size = boardPadGetSize();

#if defined(_TMS320C6X)
        Board_ioStack(ioStack+IO_DELAY_STACK_SIZE, BoardCtrlPadIoDelayConfig, pad, size);
#else
        asm("STR r13, [%0]\n"::"r"(&ioStack[IO_DELAY_STACK_SIZE-1]));
        asm("MOV r13, %0\n"::"r"(&ioStack[IO_DELAY_STACK_SIZE-2]));
        /* Configure the pinmux and virtual/manual timing modes for all pads. */
        BoardCtrlPadIoDelayConfig(pad, size);
        asm("MOV r13, %0\n"::"r"(ioStack[IO_DELAY_STACK_SIZE-1]));
#endif /* End of IO Delay config with relocation */

#endif /* End of NO_IO_DELAY/IO_DELAY check */
    }

    return BOARD_SOK;
}

int32_t BoardMmcCtrlPadConfig(int32_t mode, uint32_t instance)
{
#if !defined(__TI_ARM_V7M4__)
    mmcBoardPadCfgTable_t *pinmuxCfgTbl = NULL;
    mmcBoardPadCfgTable_t *ctrlPadCfg = NULL;

    /* Get the pointer to the table containing the MMC runtime config table */
    pinmuxCfgTbl = BoardGetMmcCtrlPadPinmuxTable(instance);

    /* Get the pointer to the MMC configuration mode pin mux configuration */
    ctrlPadCfg = boardGetPinmuxCfg(pinmuxCfgTbl, mode);

    if(ctrlPadCfg != NULL)
    {
         /* Check to make sure IO Delay stack and functions are in local memory */
        if (((uint32_t) &ioStack >= 0x80000000) || ((uint32_t)BoardCtrlPadIoDelayConfig >= 0x80000000))
            return BOARD_PINMUX_BAD_MEM_REGION;

#if defined(_TMS320C6X)
        Board_ioStack(ioStack+IO_DELAY_STACK_SIZE, BoardCtrlPadIoDelayConfig, ctrlPadCfg->mmcPadCfg, ctrlPadCfg->noPins);
#else
        asm("STR r13, [%0]\n"::"r"(&ioStack[IO_DELAY_STACK_SIZE-1]));
        asm("MOV r13, %0\n"::"r"(&ioStack[IO_DELAY_STACK_SIZE-2]));
        /* Configure the pinmux and virtual/manual timing modes for all pads. */
        BoardCtrlPadIoDelayConfig(ctrlPadCfg->mmcPadCfg, ctrlPadCfg->noPins);
        asm("MOV r13, %0\n"::"r"(ioStack[IO_DELAY_STACK_SIZE-1]));
#endif /* End of IO Delay config with relocation */
    }
    else
    {
        return BOARD_PINMUX_INVALID_MODE;
    }
#endif

    return BOARD_SOK;
}

mmcBoardPadCfgTable_t * boardGetPinmuxCfg(mmcBoardPadCfgTable_t *ptr, int32_t mode)
{
    mmcBoardPadCfgTable_t *padCfg =  NULL;

    while(ptr->mmcMode != MMC_MODE_INVALID)
    {
        if((mode == ptr->mmcMode) && (ptr->mmcPadCfg != NULL))
        {
            padCfg = ptr;
            break;
        }
        ptr++;
    }

    return padCfg;
}

MMCSD_Error MMCSD_iodelayFxn (uint32_t instanceNum,
                              MMCSD_v1_IodelayParams *iodelayParams)
{
    Int32 mmcMode = MMC_MODE_INVALID;

    switch (instanceNum)
    {
        case 1:
            if ((MMCSD_LOOPBACK_ANY == iodelayParams->loopBackType) ||
                (MMCSD_LOOPBACK_PAD == iodelayParams->loopBackType))
            {
                if (MMCSD_TRANSPEED_DEFAULT == iodelayParams->transferSpeed)
                {
                    mmcMode = MMC1_DEFAULT_PLB;
                }
                else if(MMCSD_TRANSPEED_HS == iodelayParams->transferSpeed)
                {
                    mmcMode = MMC1_HS_PLB;
                }
                else if(MMCSD_TRANSPEED_SDR12 == iodelayParams->transferSpeed)
                {
                    mmcMode = MMC1_SDR12_PLB;
                }
                else if(MMCSD_TRANSPEED_SDR50 == iodelayParams->transferSpeed)
                {
                    mmcMode = MMC1_SDR50_PLB;
                }
                else if(MMCSD_TRANSPEED_DDR50 == iodelayParams->transferSpeed)
                {
                    mmcMode = MMC1_DDR50_PLB;
                }
                else if(MMCSD_TRANSPEED_SDR104 == iodelayParams->transferSpeed)
                {
                    mmcMode = MMC1_SDR104;
                }
            }
            if (MMCSD_LOOPBACK_INTERNAL == iodelayParams->loopBackType)
            {
                if(MMCSD_TRANSPEED_DDR50 == iodelayParams->transferSpeed)
                {
                    mmcMode = MMC1_DDR50_ILB;
                }
                else if(MMCSD_TRANSPEED_DEFAULT == iodelayParams->transferSpeed)
                {
                    mmcMode = MMC1_DS_ILB;
                }
                else if(MMCSD_TRANSPEED_HS == iodelayParams->transferSpeed)
                {
                    mmcMode = MMC1_HS_ILB;
                }
                else if(MMCSD_TRANSPEED_SDR12 == iodelayParams->transferSpeed)
                {
                    mmcMode = MMC1_SDR12_ILB;
                }
                else if(MMCSD_TRANSPEED_SDR25 == iodelayParams->transferSpeed)
                {
                    mmcMode = MMC1_SDR25_ILB;
                }
                else if(MMCSD_TRANSPEED_SDR50 == iodelayParams->transferSpeed)
                {
                    mmcMode = MMC1_SDR50_ILB;
                }
            }
            break;

        case 2:
            if ((MMCSD_LOOPBACK_ANY == iodelayParams->loopBackType) ||
                (MMCSD_LOOPBACK_PAD == iodelayParams->loopBackType))
            {
                if (MMCSD_TRANSPEED_DEFAULT == iodelayParams->transferSpeed)
                {
                    mmcMode = MMC2_DEFAULT_STD_PLB;
                }
                else if(MMCSD_TRANSPEED_HS == iodelayParams->transferSpeed)
                {
                    mmcMode = MMC2_DEFAULT_HS_PLB;
                }
                else if(MMCSD_TRANSPEED_DDR50 == iodelayParams->transferSpeed)
                {
                    mmcMode = MMC2_DDR_PLB;
                }
                else if(MMCSD_TRANSPEED_HS200 == iodelayParams->transferSpeed)
                {
                    mmcMode = MMC2_HS200;
                }
            }
            if (MMCSD_LOOPBACK_INTERNAL == iodelayParams->loopBackType)
            {
                if(MMCSD_TRANSPEED_DDR50 == iodelayParams->transferSpeed)
                {
                    mmcMode = MMC2_DDR_ILB;
                }
            }
            break;

        case 3:
            if (MMCSD_TRANSPEED_DEFAULT == iodelayParams->transferSpeed)
            {
                mmcMode = MMC3_DEFAULT;
            }
            else if(MMCSD_TRANSPEED_HS == iodelayParams->transferSpeed)
            {
                mmcMode = MMC3_HS;
            }
            else if(MMCSD_TRANSPEED_SDR12 == iodelayParams->transferSpeed)
            {
                mmcMode = MMC3_SDR12;
            }
            else if(MMCSD_TRANSPEED_SDR25 == iodelayParams->transferSpeed)
            {
                mmcMode = MMC3_SDR25;
            }
            else if(MMCSD_TRANSPEED_DDR50 == iodelayParams->transferSpeed)
            {
                mmcMode = MMC3_SDR50;
            }
            break;

        case 4:
            if (MMCSD_TRANSPEED_DEFAULT == iodelayParams->transferSpeed)
            {
                mmcMode = MMC4_DEFAULT;
            }
            else if(MMCSD_TRANSPEED_HS == iodelayParams->transferSpeed)
            {
                mmcMode = MMC4_HS;
            }
            else if(MMCSD_TRANSPEED_SDR12 == iodelayParams->transferSpeed)
            {
                mmcMode = MMC4_SDR12;
            }
            else if(MMCSD_TRANSPEED_SDR25 == iodelayParams->transferSpeed)
            {
                mmcMode = MMC4_SDR25;
            }
            break;

        default:
            break;
    }

    if (MMC_MODE_INVALID != mmcMode)
    {
        BoardMmcCtrlPadConfig(mmcMode, instanceNum);
    }

    return MMCSD_OK;
}
