/******************************************************************************
 * Copyright (c) 2017 Texas Instruments Incorporated - http://www.ti.com
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *****************************************************************************/

#include <ti/csl/soc/tda2xx/hw_ctrl_core_pad_io.h>

/** \brief Invalid device ID. */
#define DEVICE_ID_INVALID               (0xFFFFFFFFU)

/**
 *  \brief Device ID.
 */
typedef enum
{
    DEVICE_ID_EEPROM = 0x0000U,
    /**< EEPROM device ID */
    DEVICE_ID_TMP102,
    /**< TMP102 Temperature sensor device ID */
    DEVICE_ID_PMIC,
    /**< PMIC device ID */
    DEVICE_ID_QSPI,
    /**< QSPI Flash device ID */
    DEVICE_ID_UART,
    /**< UART  device ID */
    DEVICE_ID_GPIO,
    /**< GPIO device ID */
    DEVICE_ID_LCD,
    /**< LCD device ID */
    DEVICE_ID_SD_CARD,
    /**< SD_CARD device ID */
    DEVICE_ID_NOR,
    /**< NOR flash device ID */
    DEVICE_ID_MCASP,
    /**< McASP device ID */
    DEVICE_ID_MCSPI,
    /**< MCSPI  device ID */
    DEVICE_ID_MAILBOX,
    /**< MAILBOX device ID */
    DEVICE_ID_OV1063X,
    /**< ov1063x OV sensor device ID */
    DEVICE_ID_I2C,
    /**< I2c device ID */
    DEVICE_ID_NORFLASH,
    /**< Nor Flash device ID */
    DEVICE_ID_MMC,
    /**< MMC device ID */
    DEVICE_ID_EMAC0PHY,
    /**< EMAC0PHY device ID */
    DEVICE_ID_MAX
    /**< Max device ID. */
} deviceId_t;

/**
 *  \brief Device Module ID.
 */
typedef enum
{
    DEVICE_MODULE_ID_VIP = 0x0000U,
    /**< VIP Module device ID */
    DEVICE_MODULE_ID_DCTRL,
    /**< VIP Module device ID */
    DEVICE_MODULE_ID_MAX
    /**< Max device ID. */
} deviceModuleId_t;

/**
 *  \name DSS DPI1 Module Instance ID
 *
 */
/** \brief DSS DISPC OVLY DPI1 Instance 0. */
#define DEVICE_MODULE_DSS_DISPC_OVLY_DPI1_INST_ID_0   ((uint32_t) 0x0U)
/** \brief DSS DISPC OVLY DPI1 Instance 1. */
#define DEVICE_MODULE_DSS_DISPC_OVLY_DPI3_INST_ID_1   ((uint32_t) 0x1U)

/**
 *  \name VIP Module instance ID
 *
 */
/** \brief VIP instance 0. */
#define DEVICE_MODULE_VIP1_S0_PORTA_INST_ID_0   ((uint32_t) 0x0U)
/** \brief VIP instance 1. */
#define DEVICE_MODULE_VIP1_S0_PORTB_INST_ID_0   ((uint32_t) 0x1U)
/** \brief VIP instance 2. */
#define DEVICE_MODULE_VIP1_S1_PORTA_INST_ID_0   ((uint32_t) 0x2U)
/** \brief VIP instance 3. */
#define DEVICE_MODULE_VIP1_S1_PORTB_INST_ID_0   ((uint32_t) 0x3U)

/**
 *  \name LCD instance ID
 *
 */
/** \brief LCD instance 0. */
#define DEVICE_LCD_INST_ID_0   ((uint32_t) 0x0U)
/** \brief LCD instance 1. */
#define DEVICE_LCD_INST_ID_1   ((uint32_t) 0x1U)

/**
 *  \name EEPROM instance ID
 *
 */
/** \brief EEPROM instance 0. */
#define DEVICE_EEPROM_INST_ID_0   ((uint32_t) 0x0U)

/**
 *  \name TEMP Sensor instance ID
 *
 */
/** \brief TEMP Sensor instance 0. */
#define DEVICE_TEMP_SENSOR_INST_ID_0   ((uint32_t) 0x0U)

/**
 *  \name I2c instance ID
 *
 */
/** \brief I2c instance 0. */
#define DEVICE_I2C_INST_ID_0   ((uint32_t) 0x0U)
/** \brief I2c instance 1. */
#define DEVICE_I2C_INST_ID_1   ((uint32_t) 0x1U)
/** \brief I2c instance 2. */
#define DEVICE_I2C_INST_ID_2   ((uint32_t) 0x2U)
/** \brief I2c instance 3. */
#define DEVICE_I2C_INST_ID_3   ((uint32_t) 0x3U)
/** \brief I2c instance 4. */
#define DEVICE_I2C_INST_ID_4   ((uint32_t) 0x4U)

/**
 *  \name OV1063X Sensor instance ID
 *
 */
/** \brief OV1063X Sensor instance 0. */
#define DEVICE_OV1063X_INST_ID_0   ((uint32_t) 0x0U)
/** \brief OV1063X Sensor instance 1. */
#define DEVICE_OV1063X_INST_ID_1   ((uint32_t) 0x1U)

/**
 *  \name UART instance ID
 *
 */
/** \brief UART instance 1. */
#define DEVICE_UART_INST_ID_1     ((uint32_t) 0x1U)
/** \brief UART instance 2. */
#define DEVICE_UART_INST_ID_2     ((uint32_t) 0x2U)
/** \brief UART instance 1. */
#define DEVICE_UART_INST_ID_3     ((uint32_t) 0x3U)

/**
 *  \name MCSPI instance ID
 *
 */
/** \brief MCSPI instance 1. */
#define DEVICE_MCSPI_INST_ID_1     ((uint32_t) 0x1U)
/** \brief MCSPI instance 2. */
#define DEVICE_MCSPI_INST_ID_2     ((uint32_t) 0x2U)
/** \brief MCSPI instance 3. */
#define DEVICE_MCSPI_INST_ID_3     ((uint32_t) 0x3U)
/** \brief MCSPI instance 4. */
#define DEVICE_MCSPI_INST_ID_4     ((uint32_t) 0x4U)

/**
 *  \name NOR FLASH instance ID
 *
 */
/** \brief NOR FLASH instance 0. */
#define DEVICE_NORFLASH_INST_ID_0 ((uint32_t) 0x0U)

/**
 *  \name MMC instance ID
 *
 */
/** \brief MMC instance 4. */
#define DEVICE_MMC_INST_ID_2     ((uint32_t) 0x2U)
#define DEVICE_MMC_INST_ID_4     ((uint32_t) 0x4U)

/**
 *  \name EMAC0PHY instance ID
 *
 */
/** \brief EMAC0PHY instance 0. */
#define DEVICE_EMAC0PHY_INST_ID_0     ((uint32_t) 0x0U)

/**
 *  \brief Structure defining the pin configuration of a board.
 */
typedef struct boardPinmuxBoardCfg
{
    uint32_t moduleId;
    /**< Module ID */
    uint32_t instNum;
    /**< Instance number of the ip */
    uint32_t boardMode;
    /**< Device specific modes */
    uint32_t regOffset;
    /**< Register offset */
    uint32_t regVal;
    /**< Register value */
}boardPinmuxBoardCfg_t;

/**
 *  \brief Device specific modes
 */
typedef enum
{
    BOARD_MODE_DEFAULT,
    /**< This enum could be passed if the mode is a don't care and the
     *   mode select function returns success after selecting the default
     *   mode (if applicable). */
    BOARD_MODE_VIDEO_24BIT,
    /**< 24-bit video mode. */
    BOARD_MODE_VIDEO_16BIT,
    /**< 16-bit video mode. */
    BOARD_MODE_VIDEO_14BIT,
    /**< 14-bit video mode. */
    BOARD_MODE_VIDEO_12BIT,
    /**< 12-bit video mode. */
    BOARD_MODE_VIDEO_10BIT,
    /**< 10-bit video mode. */
    BOARD_MODE_VIDEO_8BIT,
    /**< 8-bit video mode. */
    BOARD_MODE_VIDEO_8BIT_TDM,
    /**< 8-bit TDM (RGB interleaved) video mode. */
    BOARD_MODE_VIDEO_BT656,
    /**< 8-bit BT656 video mode. */
    BOARD_MODE_VIDEO_BT1120,
    /**< 16-bit BT1120 video mode. */
    BOARD_MODE_MAX
    /**< Max board modes. */
} boardMode_t;

boardPinmuxBoardCfg_t gBoardTda2xxPinMuxData[] =
{
    /* pin mux for UART1 RXD pin */
    {DEVICE_ID_UART,         DEVICE_UART_INST_ID_1,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_UART1_RXD, 0x40000},
    /* pin mux for UART1 TXD pin */
    {DEVICE_ID_UART,         DEVICE_UART_INST_ID_1,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_UART1_TXD, 0x0},
    /* pin mux for UART2 RXD pin */
    {DEVICE_ID_UART,         DEVICE_UART_INST_ID_2,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_UART2_RXD, 0x40000},
    /* pin mux for UART2 TXD pin */
    {DEVICE_ID_UART,         DEVICE_UART_INST_ID_2,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_UART2_TXD, 0x0},
    /* pin mux for UART3 RXD pin */
    {DEVICE_ID_UART,         DEVICE_UART_INST_ID_3,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_UART3_RXD, 0x40001},
    /* pin mux for UART3 TXD pin */
    {DEVICE_ID_UART,         DEVICE_UART_INST_ID_3,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_UART3_TXD, 0x1},
    /* pin mux for SPI2 SCLK pin */
    {DEVICE_ID_MCSPI,        DEVICE_MCSPI_INST_ID_2,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_SPI2_SCLK, 0x50000},
    /* pin mux for SPI2 D0 pin */
     {DEVICE_ID_MCSPI,        DEVICE_MCSPI_INST_ID_2,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_SPI2_D0, 0x50000},
    /* pin mux for SPI2 D1 pin */
     {DEVICE_ID_MCSPI,        DEVICE_MCSPI_INST_ID_2,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_SPI2_D1, 0x60000},
    /* pin mux for SPI2 CS0 pin */
     {DEVICE_ID_MCSPI,        DEVICE_MCSPI_INST_ID_2,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_SPI2_CS0, 0x60000},
    /* pin mux for I2C1 mux */
    {DEVICE_ID_I2C,          DEVICE_I2C_INST_ID_0,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_I2C1_SDA, 0x60000},
    {DEVICE_ID_I2C,          DEVICE_I2C_INST_ID_0,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_I2C1_SCL, 0x60000},
    /* pin mux for I2C2 mux */
    {DEVICE_ID_I2C,          DEVICE_I2C_INST_ID_1,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_I2C2_SDA, 0x60000},
    {DEVICE_ID_I2C,          DEVICE_I2C_INST_ID_1,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_I2C2_SCL, 0x60000},
    /* pin mux for VOUT1 mux  */
    {DEVICE_MODULE_ID_DCTRL, DEVICE_MODULE_DSS_DISPC_OVLY_DPI1_INST_ID_0,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_VOUT1_CLK, 0x40000},
    {DEVICE_MODULE_ID_DCTRL, DEVICE_MODULE_DSS_DISPC_OVLY_DPI1_INST_ID_0,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_VOUT1_DE, 0x40000},
    {DEVICE_MODULE_ID_DCTRL, DEVICE_MODULE_DSS_DISPC_OVLY_DPI1_INST_ID_0,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_VOUT1_FLD, 0x40000},
    {DEVICE_MODULE_ID_DCTRL, DEVICE_MODULE_DSS_DISPC_OVLY_DPI1_INST_ID_0,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_VOUT1_HSYNC, 0x40000},
    {DEVICE_MODULE_ID_DCTRL, DEVICE_MODULE_DSS_DISPC_OVLY_DPI1_INST_ID_0,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_VOUT1_VSYNC, 0x40000},
    {DEVICE_MODULE_ID_DCTRL, DEVICE_MODULE_DSS_DISPC_OVLY_DPI1_INST_ID_0,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_VOUT1_D0, 0x40000},
    {DEVICE_MODULE_ID_DCTRL, DEVICE_MODULE_DSS_DISPC_OVLY_DPI1_INST_ID_0,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_VOUT1_D1, 0x40000},
    {DEVICE_MODULE_ID_DCTRL, DEVICE_MODULE_DSS_DISPC_OVLY_DPI1_INST_ID_0,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_VOUT1_D2, 0x40000},
    {DEVICE_MODULE_ID_DCTRL, DEVICE_MODULE_DSS_DISPC_OVLY_DPI1_INST_ID_0,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_VOUT1_D3, 0x40000},
    {DEVICE_MODULE_ID_DCTRL, DEVICE_MODULE_DSS_DISPC_OVLY_DPI1_INST_ID_0,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_VOUT1_D4, 0x40000},
    {DEVICE_MODULE_ID_DCTRL, DEVICE_MODULE_DSS_DISPC_OVLY_DPI1_INST_ID_0,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_VOUT1_D5, 0x40000},
    {DEVICE_MODULE_ID_DCTRL, DEVICE_MODULE_DSS_DISPC_OVLY_DPI1_INST_ID_0,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_VOUT1_D6, 0x40000},
    {DEVICE_MODULE_ID_DCTRL, DEVICE_MODULE_DSS_DISPC_OVLY_DPI1_INST_ID_0,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_VOUT1_D7, 0x40000},
    {DEVICE_MODULE_ID_DCTRL, DEVICE_MODULE_DSS_DISPC_OVLY_DPI1_INST_ID_0,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_VOUT1_D8, 0x40000},
    {DEVICE_MODULE_ID_DCTRL, DEVICE_MODULE_DSS_DISPC_OVLY_DPI1_INST_ID_0,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_VOUT1_D9, 0x40000},
    {DEVICE_MODULE_ID_DCTRL, DEVICE_MODULE_DSS_DISPC_OVLY_DPI1_INST_ID_0,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_VOUT1_D10, 0x40000},
    {DEVICE_MODULE_ID_DCTRL, DEVICE_MODULE_DSS_DISPC_OVLY_DPI1_INST_ID_0,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_VOUT1_D11, 0x40000},
    {DEVICE_MODULE_ID_DCTRL, DEVICE_MODULE_DSS_DISPC_OVLY_DPI1_INST_ID_0,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_VOUT1_D12, 0x40000},
    {DEVICE_MODULE_ID_DCTRL, DEVICE_MODULE_DSS_DISPC_OVLY_DPI1_INST_ID_0,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_VOUT1_D13, 0x40000},
    {DEVICE_MODULE_ID_DCTRL, DEVICE_MODULE_DSS_DISPC_OVLY_DPI1_INST_ID_0,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_VOUT1_D14, 0x40000},
    {DEVICE_MODULE_ID_DCTRL, DEVICE_MODULE_DSS_DISPC_OVLY_DPI1_INST_ID_0,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_VOUT1_D15, 0x40000},
    {DEVICE_MODULE_ID_DCTRL, DEVICE_MODULE_DSS_DISPC_OVLY_DPI1_INST_ID_0,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_VOUT1_D16, 0x40000},
    {DEVICE_MODULE_ID_DCTRL, DEVICE_MODULE_DSS_DISPC_OVLY_DPI1_INST_ID_0,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_VOUT1_D17, 0x40000},
    {DEVICE_MODULE_ID_DCTRL, DEVICE_MODULE_DSS_DISPC_OVLY_DPI1_INST_ID_0,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_VOUT1_D18, 0x40000},
    {DEVICE_MODULE_ID_DCTRL, DEVICE_MODULE_DSS_DISPC_OVLY_DPI1_INST_ID_0,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_VOUT1_D19, 0x40000},
    {DEVICE_MODULE_ID_DCTRL, DEVICE_MODULE_DSS_DISPC_OVLY_DPI1_INST_ID_0,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_VOUT1_D20, 0x40000},
    {DEVICE_MODULE_ID_DCTRL, DEVICE_MODULE_DSS_DISPC_OVLY_DPI1_INST_ID_0,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_VOUT1_D21, 0x40000},
    {DEVICE_MODULE_ID_DCTRL, DEVICE_MODULE_DSS_DISPC_OVLY_DPI1_INST_ID_0,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_VOUT1_D22, 0x40000},
    {DEVICE_MODULE_ID_DCTRL, DEVICE_MODULE_DSS_DISPC_OVLY_DPI1_INST_ID_0,
     BOARD_MODE_DEFAULT, CTRL_CORE_PAD_VOUT1_D23, 0x40000},
    /* pin mux for VIN1A mux  */
    {DEVICE_MODULE_ID_VIP,   DEVICE_MODULE_VIP1_S0_PORTA_INST_ID_0,
     (BOARD_MODE_VIDEO_8BIT | BOARD_MODE_VIDEO_10BIT | BOARD_MODE_VIDEO_12BIT |
      BOARD_MODE_VIDEO_14BIT | BOARD_MODE_VIDEO_16BIT | BOARD_MODE_VIDEO_24BIT),
     CTRL_CORE_PAD_VIN1A_CLK0, 0x40000},
    {DEVICE_MODULE_ID_VIP,   DEVICE_MODULE_VIP1_S0_PORTA_INST_ID_0,
     (BOARD_MODE_VIDEO_8BIT | BOARD_MODE_VIDEO_10BIT | BOARD_MODE_VIDEO_12BIT |
      BOARD_MODE_VIDEO_14BIT | BOARD_MODE_VIDEO_16BIT | BOARD_MODE_VIDEO_24BIT),
     CTRL_CORE_PAD_VIN1A_DE0, 0x40000},
    {DEVICE_MODULE_ID_VIP,   DEVICE_MODULE_VIP1_S0_PORTA_INST_ID_0,
     (BOARD_MODE_VIDEO_8BIT | BOARD_MODE_VIDEO_10BIT | BOARD_MODE_VIDEO_12BIT |
      BOARD_MODE_VIDEO_14BIT | BOARD_MODE_VIDEO_16BIT | BOARD_MODE_VIDEO_24BIT),
     CTRL_CORE_PAD_VIN1A_FLD0, 0x40000},
    {DEVICE_MODULE_ID_VIP,   DEVICE_MODULE_VIP1_S0_PORTA_INST_ID_0,
     (BOARD_MODE_VIDEO_8BIT | BOARD_MODE_VIDEO_10BIT | BOARD_MODE_VIDEO_12BIT |
      BOARD_MODE_VIDEO_14BIT | BOARD_MODE_VIDEO_16BIT | BOARD_MODE_VIDEO_24BIT),
     CTRL_CORE_PAD_VIN1A_HSYNC0, 0x40000},
    {DEVICE_MODULE_ID_VIP,   DEVICE_MODULE_VIP1_S0_PORTA_INST_ID_0,
     (BOARD_MODE_VIDEO_8BIT | BOARD_MODE_VIDEO_10BIT | BOARD_MODE_VIDEO_12BIT |
      BOARD_MODE_VIDEO_14BIT | BOARD_MODE_VIDEO_16BIT | BOARD_MODE_VIDEO_24BIT),
     CTRL_CORE_PAD_VIN1A_VSYNC0, 0x40000},
    {DEVICE_MODULE_ID_VIP,   DEVICE_MODULE_VIP1_S0_PORTA_INST_ID_0,
     (BOARD_MODE_VIDEO_BT1120 | BOARD_MODE_VIDEO_BT656 |
      BOARD_MODE_VIDEO_8BIT |
      BOARD_MODE_VIDEO_10BIT | BOARD_MODE_VIDEO_12BIT |
      BOARD_MODE_VIDEO_14BIT |
      BOARD_MODE_VIDEO_16BIT | BOARD_MODE_VIDEO_24BIT),
     CTRL_CORE_PAD_VIN1A_D0, 0x40000},
    {DEVICE_MODULE_ID_VIP,   DEVICE_MODULE_VIP1_S0_PORTA_INST_ID_0,
     (BOARD_MODE_VIDEO_BT1120 | BOARD_MODE_VIDEO_BT656 |
      BOARD_MODE_VIDEO_8BIT |
      BOARD_MODE_VIDEO_10BIT | BOARD_MODE_VIDEO_12BIT |
      BOARD_MODE_VIDEO_14BIT |
      BOARD_MODE_VIDEO_16BIT | BOARD_MODE_VIDEO_24BIT),
     CTRL_CORE_PAD_VIN1A_D1, 0x40000},
    {DEVICE_MODULE_ID_VIP,   DEVICE_MODULE_VIP1_S0_PORTA_INST_ID_0,
     (BOARD_MODE_VIDEO_BT1120 | BOARD_MODE_VIDEO_BT656 |
      BOARD_MODE_VIDEO_8BIT |
      BOARD_MODE_VIDEO_10BIT | BOARD_MODE_VIDEO_12BIT |
      BOARD_MODE_VIDEO_14BIT |
      BOARD_MODE_VIDEO_16BIT | BOARD_MODE_VIDEO_24BIT),
     CTRL_CORE_PAD_VIN1A_D2, 0x40000},
    {DEVICE_MODULE_ID_VIP,   DEVICE_MODULE_VIP1_S0_PORTA_INST_ID_0,
     (BOARD_MODE_VIDEO_BT1120 | BOARD_MODE_VIDEO_BT656 |
      BOARD_MODE_VIDEO_8BIT |
      BOARD_MODE_VIDEO_10BIT | BOARD_MODE_VIDEO_12BIT |
      BOARD_MODE_VIDEO_14BIT |
      BOARD_MODE_VIDEO_16BIT | BOARD_MODE_VIDEO_24BIT),
     CTRL_CORE_PAD_VIN1A_D3, 0x40000},
    {DEVICE_MODULE_ID_VIP,   DEVICE_MODULE_VIP1_S0_PORTA_INST_ID_0,
     (BOARD_MODE_VIDEO_BT1120 | BOARD_MODE_VIDEO_BT656 |
      BOARD_MODE_VIDEO_8BIT |
      BOARD_MODE_VIDEO_10BIT | BOARD_MODE_VIDEO_12BIT |
      BOARD_MODE_VIDEO_14BIT |
      BOARD_MODE_VIDEO_16BIT | BOARD_MODE_VIDEO_24BIT),
     CTRL_CORE_PAD_VIN1A_D4, 0x40000},
    {DEVICE_MODULE_ID_VIP,   DEVICE_MODULE_VIP1_S0_PORTA_INST_ID_0,
     (BOARD_MODE_VIDEO_BT1120 | BOARD_MODE_VIDEO_BT656 |
      BOARD_MODE_VIDEO_8BIT |
      BOARD_MODE_VIDEO_10BIT | BOARD_MODE_VIDEO_12BIT |
      BOARD_MODE_VIDEO_14BIT |
      BOARD_MODE_VIDEO_16BIT | BOARD_MODE_VIDEO_24BIT),
     CTRL_CORE_PAD_VIN1A_D5, 0x40000},
    {DEVICE_MODULE_ID_VIP,   DEVICE_MODULE_VIP1_S0_PORTA_INST_ID_0,
     (BOARD_MODE_VIDEO_BT1120 | BOARD_MODE_VIDEO_BT656 |
      BOARD_MODE_VIDEO_8BIT |
      BOARD_MODE_VIDEO_10BIT | BOARD_MODE_VIDEO_12BIT |
      BOARD_MODE_VIDEO_14BIT |
      BOARD_MODE_VIDEO_16BIT | BOARD_MODE_VIDEO_24BIT),
     CTRL_CORE_PAD_VIN1A_D6, 0x40000},
    {DEVICE_MODULE_ID_VIP,   DEVICE_MODULE_VIP1_S0_PORTA_INST_ID_0,
     (BOARD_MODE_VIDEO_BT1120 | BOARD_MODE_VIDEO_BT656 |
      BOARD_MODE_VIDEO_8BIT |
      BOARD_MODE_VIDEO_10BIT | BOARD_MODE_VIDEO_12BIT |
      BOARD_MODE_VIDEO_14BIT |
      BOARD_MODE_VIDEO_16BIT | BOARD_MODE_VIDEO_24BIT),
     CTRL_CORE_PAD_VIN1A_D7, 0x40000},
    {DEVICE_MODULE_ID_VIP,   DEVICE_MODULE_VIP1_S0_PORTA_INST_ID_0,
     (BOARD_MODE_VIDEO_BT1120 | BOARD_MODE_VIDEO_10BIT |
      BOARD_MODE_VIDEO_12BIT |
      BOARD_MODE_VIDEO_14BIT | BOARD_MODE_VIDEO_16BIT | BOARD_MODE_VIDEO_24BIT),
     CTRL_CORE_PAD_VIN1A_D8, 0x40000},
    {DEVICE_MODULE_ID_VIP,   DEVICE_MODULE_VIP1_S0_PORTA_INST_ID_0,
     (BOARD_MODE_VIDEO_BT1120 | BOARD_MODE_VIDEO_10BIT |
      BOARD_MODE_VIDEO_12BIT |
      BOARD_MODE_VIDEO_14BIT | BOARD_MODE_VIDEO_16BIT | BOARD_MODE_VIDEO_24BIT),
     CTRL_CORE_PAD_VIN1A_D9, 0x40000},
    {DEVICE_MODULE_ID_VIP,   DEVICE_MODULE_VIP1_S0_PORTA_INST_ID_0,
     (BOARD_MODE_VIDEO_BT1120 | BOARD_MODE_VIDEO_12BIT |
      BOARD_MODE_VIDEO_14BIT |
      BOARD_MODE_VIDEO_16BIT | BOARD_MODE_VIDEO_24BIT),
     CTRL_CORE_PAD_VIN1A_D10, 0x40000},
    {DEVICE_MODULE_ID_VIP,   DEVICE_MODULE_VIP1_S0_PORTA_INST_ID_0,
     (BOARD_MODE_VIDEO_BT1120 | BOARD_MODE_VIDEO_12BIT |
      BOARD_MODE_VIDEO_14BIT |
      BOARD_MODE_VIDEO_16BIT | BOARD_MODE_VIDEO_24BIT),
     CTRL_CORE_PAD_VIN1A_D11, 0x40000},
    {DEVICE_MODULE_ID_VIP,   DEVICE_MODULE_VIP1_S0_PORTA_INST_ID_0,
     (BOARD_MODE_VIDEO_BT1120 | BOARD_MODE_VIDEO_14BIT |
      BOARD_MODE_VIDEO_16BIT |
      BOARD_MODE_VIDEO_24BIT), CTRL_CORE_PAD_VIN1A_D12, 0x40000},
    {DEVICE_MODULE_ID_VIP,   DEVICE_MODULE_VIP1_S0_PORTA_INST_ID_0,
     (BOARD_MODE_VIDEO_BT1120 | BOARD_MODE_VIDEO_14BIT |
      BOARD_MODE_VIDEO_16BIT |
      BOARD_MODE_VIDEO_24BIT), CTRL_CORE_PAD_VIN1A_D13, 0x40000},
    {DEVICE_MODULE_ID_VIP,   DEVICE_MODULE_VIP1_S0_PORTA_INST_ID_0,
     (BOARD_MODE_VIDEO_BT1120 | BOARD_MODE_VIDEO_16BIT | BOARD_MODE_VIDEO_24BIT),
     CTRL_CORE_PAD_VIN1A_D14, 0x40000},
    {DEVICE_MODULE_ID_VIP,   DEVICE_MODULE_VIP1_S0_PORTA_INST_ID_0,
     (BOARD_MODE_VIDEO_BT1120 | BOARD_MODE_VIDEO_16BIT | BOARD_MODE_VIDEO_24BIT),
     CTRL_CORE_PAD_VIN1A_D15, 0x40000},
    {DEVICE_MODULE_ID_VIP,   DEVICE_MODULE_VIP1_S0_PORTA_INST_ID_0,
     (BOARD_MODE_VIDEO_24BIT), CTRL_CORE_PAD_VIN1A_D16, 0x40000},
    {DEVICE_MODULE_ID_VIP,   DEVICE_MODULE_VIP1_S0_PORTA_INST_ID_0,
     (BOARD_MODE_VIDEO_24BIT), CTRL_CORE_PAD_VIN1A_D17, 0x40000},
    {DEVICE_MODULE_ID_VIP,   DEVICE_MODULE_VIP1_S0_PORTA_INST_ID_0,
     (BOARD_MODE_VIDEO_24BIT), CTRL_CORE_PAD_VIN1A_D18, 0x40000},
    {DEVICE_MODULE_ID_VIP,   DEVICE_MODULE_VIP1_S0_PORTA_INST_ID_0,
     (BOARD_MODE_VIDEO_24BIT), CTRL_CORE_PAD_VIN1A_D19, 0x40000},
    {DEVICE_MODULE_ID_VIP,   DEVICE_MODULE_VIP1_S0_PORTA_INST_ID_0,
     (BOARD_MODE_VIDEO_24BIT), CTRL_CORE_PAD_VIN1A_D20, 0x40000},
    {DEVICE_MODULE_ID_VIP,   DEVICE_MODULE_VIP1_S0_PORTA_INST_ID_0,
     (BOARD_MODE_VIDEO_24BIT), CTRL_CORE_PAD_VIN1A_D21, 0x40000},
    {DEVICE_MODULE_ID_VIP,   DEVICE_MODULE_VIP1_S0_PORTA_INST_ID_0,
     (BOARD_MODE_VIDEO_24BIT), CTRL_CORE_PAD_VIN1A_D22, 0x40000},
    {DEVICE_MODULE_ID_VIP,   DEVICE_MODULE_VIP1_S0_PORTA_INST_ID_0,
     (BOARD_MODE_VIDEO_24BIT), CTRL_CORE_PAD_VIN1A_D23, 0x40000},
     /* Pinmux config for eMMC */
    {DEVICE_ID_MMC, DEVICE_MMC_INST_ID_2, BOARD_MODE_DEFAULT,
    CTRL_CORE_PAD_GPMC_A23, 0x40001},
    {DEVICE_ID_MMC, DEVICE_MMC_INST_ID_2, BOARD_MODE_DEFAULT,
    CTRL_CORE_PAD_GPMC_CS1, 0x60001},
    {DEVICE_ID_MMC, DEVICE_MMC_INST_ID_2, BOARD_MODE_DEFAULT,
    CTRL_CORE_PAD_GPMC_A24, 0x60001},
    {DEVICE_ID_MMC, DEVICE_MMC_INST_ID_2, BOARD_MODE_DEFAULT,
     CTRL_CORE_PAD_GPMC_A25, 0x60001},
    {DEVICE_ID_MMC, DEVICE_MMC_INST_ID_2, BOARD_MODE_DEFAULT,
     CTRL_CORE_PAD_GPMC_A26, 0x60001},
    {DEVICE_ID_MMC, DEVICE_MMC_INST_ID_2, BOARD_MODE_DEFAULT,
     CTRL_CORE_PAD_GPMC_A27, 0x60001},
    {DEVICE_ID_MMC, DEVICE_MMC_INST_ID_2, BOARD_MODE_DEFAULT,
     CTRL_CORE_PAD_GPMC_A19, 0x60001},
    {DEVICE_ID_MMC, DEVICE_MMC_INST_ID_2, BOARD_MODE_DEFAULT,
     CTRL_CORE_PAD_GPMC_A20, 0x60001},
    {DEVICE_ID_MMC, DEVICE_MMC_INST_ID_2, BOARD_MODE_DEFAULT,
     CTRL_CORE_PAD_GPMC_A21, 0x60001},
    {DEVICE_ID_MMC, DEVICE_MMC_INST_ID_2, BOARD_MODE_DEFAULT,
     CTRL_CORE_PAD_GPMC_A22, 0x60001},

    {DEVICE_ID_INVALID,      0,                                          0,0, 0},
};

