/*
 * AIC.c
 *
 *  Created on: Jan 10, 2018
 *      Author: aaron.jencks
 */

#include "common.h"

int AIC3206_Initialize();
void read_sample(short *l_chan1, short *r_chan1, short *l_chan2, short *r_chan2);
void read_samples(short *l_chan1, short *r_chan1, short *l_chan2, short *r_chan2, unsigned int num);

int AIC3206_Initialize()
{
    int result = 0;

    // Initializes the audio codec

    /* Configure AIC3206 */
    AIC3206_write( 0,  0x00 );  // Select page 0
    AIC3206_write( 1,  0x01 );  // Reset codec
    //C55x_delay_msec(1);             // Wait 1ms after reset
    AIC3206_write( 0,  0x01 );  // Select page 1
    AIC3206_write( 1,  0x08 );  // Disable crude AVDD generation from DVDD
    AIC3206_write( 2,  0x01 );  // Enable Analog Blocks, use LDO power
    AIC3206_write( 123,0x05 );  // Force reference to power up in 40ms
    //C55x_delay_msec(40);            // Wait at least 40ms
    sleep(40);
    AIC3206_write( 0,  0x00 );  // Select page 0

    /* PLL and Clocks config and Power Up  */
    AIC3206_write( 27, 0x0d );  // BCLK and WCLK are set as o/p; AIC3206(Master)
    AIC3206_write( 28, 0x00 );  // Data ofset = 0
    AIC3206_write( 4,  0x03 );  // PLL setting: PLLCLK <- MCLK, CODEC_CLKIN <-PLL CLK
    AIC3206_write( 6,  0x07 );  // PLL setting: J=7
    AIC3206_write( 7,  0x06 );  // PLL setting: HI_BYTE(D=1680)
    AIC3206_write( 8,  0x90 );  // PLL setting: LO_BYTE(D=1680)
    AIC3206_write( 30, 0x88 );  // For 32 bit clocks per frame in Master mode ONLY
                                // BCLK=DAC_CLK/N =(12288000/8) = 1.536MHz = 32*fs
    AIC3206_write( 5,  0x91 );  // PLL setting: Power up PLL, P=1 and R=1
    //C55x_delay_msec(10);        // Wait for PLL to come up
    sleep(10);
    AIC3206_write( 13, 0x00 );  // Hi_Byte(DOSR) for DOSR = 128 decimal or 0x0080 DAC oversamppling
    AIC3206_write( 14, 0x80 );  // Lo_Byte(DOSR) for DOSR = 128 decimal or 0x0080
    AIC3206_write( 20, 0x80 );  // AOSR for AOSR = 128 decimal or 0x0080 for decimation filters 1 to 6
    AIC3206_write( 11, 0x82 );  // Power up NDAC and set NDAC value to 2
    AIC3206_write( 12, 0x87 );  // Power up MDAC and set MDAC value to 7
    AIC3206_write( 18, 0x87 );  // Power up NADC and set NADC value to 7
    AIC3206_write( 19, 0x82 );  // Power up MADC and set MADC value to 2

    /* DAC ROUTING and Power Up */
    AIC3206_write( 0,  0x01 );  // Select page 1
    AIC3206_write( 12, 0x08 );  // LDAC AFIR routed to HPL
    AIC3206_write( 13, 0x08 );  // RDAC AFIR routed to HPR
    AIC3206_write( 0,  0x00 );  // Select page 0
    AIC3206_write( 64, 0x02 );  // Left vol=right vol
    AIC3206_write( 65, 0x00 );  // Left DAC gain to 0dB VOL; Right tracks Left
    AIC3206_write( 63, 0xd4 );  // Power up left,right data paths and set channel
    AIC3206_write( 0,  0x01 );  // Select page 1
    AIC3206_write( 16, 0x00 );  // Unmute HPL , 0dB gain
    AIC3206_write( 17, 0x00 );  // Unmute HPR , 0dB gain
    AIC3206_write( 9 , 0x30 );  // Power up HPL,HPR
    //C55x_delay_msec(1);         // Wait 1 msec
    sleep(1);

    /* ADC ROUTING and Power Up */
    AIC3206_write( 0,  0x01 );  // Select page 1
    AIC3206_write( 52, 0x30 );  // STEREO 1 Jack
                                // IN2_L to LADC_P through 40 kohm
    AIC3206_write( 55, 0x30 );  // IN2_R to RADC_P through 40 kohmm
    AIC3206_write( 54, 0x03 );  // CM_1 (common mode) to LADC_M through 40 kohm
    AIC3206_write( 57, 0xc0 );  // CM_1 (common mode) to RADC_M through 40 kohm
    AIC3206_write( 59, 0x00 );  // MIC_PGA_L unmute
    AIC3206_write( 60, 0x00 );  // MIC_PGA_R unmute
    AIC3206_write( 0,  0x00 );  // Select page 0
    AIC3206_write( 81, 0xc0 );  // Powerup Left and Right ADC
    AIC3206_write( 82, 0x00 );  // Unmute Left and Right ADC
    AIC3206_write( 0,  0x00 );  // Select page 0
    //C55x_delay_msec(1);         // Wait 1 msec
    sleep(1);

    // Sets up the I2s interface

    result = initialise_i2s_interface();
    if(result != 0)
    {
        printf("Failed to initialize i2s interface!");
        return result;
    }

    return result;
}

void read_sample(short *l_chan1, short *r_chan1, short *l_chan2, short *r_chan2)
{
    // Receives a sample from the audio codec.
    ioport CSL_I2sRegs  *regs1;
    ioport CSL_I2sRegs  *regs2;
    regs1 = hI2s1->hwRegs;
    regs2 = hI2s2->hwRegs;

    while((0x08 & regs1->I2SINTFL) == 0);    // Wait for receive interrupt to be pending
    *l_chan1 = regs1->I2SRXLT1;               // 16 bit left channel receive audio data
    *r_chan1 = regs1->I2SRXRT1;               // 16 bit right channel receive audio data

    while((0x08 & regs2->I2SINTFL) == 0);    // Wait for receive interrupt to be pending
    *l_chan2 = regs2->I2SRXLT1;               // 16 bit left channel receive audio data
    *r_chan2 = regs2->I2SRXRT1;               // 16 bit right channel receive audio data
}

void read_samples(short *l_chan1, short *r_chan1, short *l_chan2, short *r_chan2, unsigned int num)
{
    // Reads num samples from the audio codec
    int i = 0;
    for(i = 0; i < num; i++)
    {
        read_sample((l_chan1 + i), (r_chan1 + i), (l_chan2 + i), (r_chan2 + i)); // Reads a sample from the codec
    }
}

