/*
 * FFT.c
 *
 * Description:
 *  Performs the FFT functions on the samples collected.
 *
 *  Created on: Jan 5, 2018
 *      Author: aaron.jencks
 */

// Included Libraries
#include <stdlib.h>
#include <math.h>
#include <tms320.h>
#include <stdio.h>
#include <dsplib.h>
#include "hwafft.h"

//#include "t2.h"
//#include "t3.h"
//#include "t4.h"
//#include "t5.h"
//#include "t6.h"
//#include "t7.h"
//#include "t8.h"
//#include "t10.h"
//#include "t11.h"
//#include "t12.h"

/* --- Special buffers required for HWAFFT ---*/
#pragma DATA_SECTION(complex_buffer, "cmplxBuf");
Int32 complex_buffer[1024];

#pragma DATA_SECTION(bitreversed_buffer, "brBuf");
#pragma DATA_ALIGN(bitreversed_buffer, 2048);
Int32 bitreversed_buffer[1024];

#pragma DATA_SECTION(temporary_buffer,"tmpBuf");
Int32 temporary_buffer[1024];
/* -------------------------------------------*/

long *data;
long *data_br;
unsigned short fft_flag;
unsigned short scale_flag;
long *scratch;
unsigned short out_sel;
long *result;

void FFT_PerformTransform(short* x, short *fft_real, short *fft_imag, unsigned short num);
int FFT_Initialize();

int FFT_Initialize()
{
    fft_flag = FFT_FLAG;
    scale_flag = SCALE_FLAG;
    return 0;
}

void FFT_PerformTransform(short* x, short *fft_real, short *fft_imag, unsigned short num)
{
    // Performs the FFT transform on the data
    //rfft(x, num, SCALE);

    //hwafft_br(x, data_br, DATA_LEN_1024);
    Uint16 i, data_selection;
    Int32 *complex_data, *bitrev_data, *temp_data, *fft_data;

    /* Initialize relevant pointers */
    bitrev_data  = bitreversed_buffer;
    temp_data    = temporary_buffer;
    complex_data = complex_buffer;

    /* Convert real data to "pseudo"-complex data (real, 0) */
    /* Int32 complex = Int16 real (MSBs) + Int16 imag (LSBs) */
    for (i = 0; i < 1024; i++) {
        *(complex_data + i) = ( (Int32) (*(x + i)) ) << 16;
    }

    /* Perform bit-reversing */
    hwafft_br(complex_data, bitrev_data, 1024);

    /* Perform FFT */
    if (1) {
        data_selection = hwafft_1024pts(bitrev_data, temp_data, FFT_FLAG, SCALE_FLAG);
    } else {
        data_selection = hwafft_1024pts(bitrev_data, temp_data, FFT_FLAG, NOSCALE_FLAG);
    }

    /* Return appropriate data pointer */
    if (data_selection) {
        fft_data = temp_data;
    } else {
        fft_data = bitrev_data;
    }

    /* Extract real and imaginary parts */
    for (i = 0; i < 1024; i++) {
        *(fft_real + i) = (Int16)((*(fft_data + i)) >> 16);
        *(fft_imag + i) = (Int16)((*(fft_data + i)) & 0x0000FFFF);
    }

}
