/*
 * common.c
 *
 *  Created on: Jan 11, 2018
 *      Author: aaron.jencks
 */

#include <stdio.h>
#include <time.h>
#include "common.h"

CSL_I2sHandle   hI2s1 = 0;
CSL_I2sHandle   hI2s2 = 0;

void sleep(unsigned int msec);
TEST_STATUS AIC3206_write(Uint16 regnum, Uint16 regval);
TEST_STATUS initialise_i2s_interface(void);

void sleep(unsigned int msec)
{
    // Pauses the program for msec milliseconds
    clock_t start, stop;
    start = clock();
    do
    {
        stop = clock();

    } while((stop - start)>msec);
}

TEST_STATUS AIC3206_write(Uint16 regnum, Uint16 regval)
{
    Int16 retVal;
    Uint16 startStop            = ((CSL_I2C_START) | (CSL_I2C_STOP));
    Uint16 cmd[2];
    cmd[0] = regnum & 0x007F;       // 7-bit Device Register
    cmd[1] = regval;                // 8-bit Register Data

    //C55x_delay_msec(3);
    sleep(3);

    /* I2C Write */
    retVal = I2C_write(cmd, 2, AIC3206_I2C_ADDR,
             TRUE, startStop, CSL_I2C_MAX_TIMEOUT);
     if(retVal != 0)
     {
        //C55x_msgWrite("I2C Write failed\n\r");
        //return -1;
     }

     return (0);
}

TEST_STATUS initialise_i2s_interface(void)
{
    I2S_Config      hwConfig;
    Int16           result = 0;

    /* Open the device with instance 0 */
    hI2s2 = I2S_open(I2S_INSTANCE2, I2S_POLLED, I2S_CHAN_STEREO);
    hI2s2 = I2S_open(I2S_INSTANCE1, I2S_POLLED, I2S_CHAN_STEREO);

    /* Set the value for the configure structure */
    hwConfig.dataType           = I2S_STEREO_ENABLE;
    hwConfig.loopBackMode       = I2S_LOOPBACK_DISABLE;
    hwConfig.fsPol              = I2S_FSPOL_LOW;
    hwConfig.clkPol             = I2S_RISING_EDGE;
    hwConfig.datadelay          = I2S_DATADELAY_ONEBIT;
    hwConfig.datapack           = I2S_DATAPACK_ENABLE;
    hwConfig.signext            = I2S_SIGNEXT_DISABLE;
    hwConfig.wordLen            = I2S_WORDLEN_32;
    hwConfig.i2sMode            = I2S_SLAVE;
    hwConfig.FError             = I2S_FSERROR_ENABLE;
    hwConfig.OuError            = I2S_OUERROR_ENABLE;

    /* Configure hardware registers */
    result += I2S_setup(hI2s1, &hwConfig);
    result += I2S_transEnable(hI2s1, TRUE);
    result += I2S_setup(hI2s2, &hwConfig);
    result += I2S_transEnable(hI2s2, TRUE);

    return result;

}
