/*
 * uart.h
 *
 *  Created on: Jan 8, 2018
 *      Author: aaron.jencks
 */

#ifndef UART_H_
#define UART_H_

// These map addresses to these pointers, for more information on their meaning, and how to assign values to them see
// the C5515 UART user guide.

#define RBR         ((ioport volatile unsigned*)0x1B00) // Receiver Buffer
#define THR         ((ioport volatile unsigned*)0x1B00) // Transmitter Holding Register
#define IER         ((ioport volatile unsigned*)0x1B02) // Interrupt Enable Register
#define IIR         ((ioport volatile unsigned*)0x1B04) // Interrupt Identification Register
#define FCR         ((ioport volatile unsigned*)0x1B04) // FIFO Control Register
#define LCR         ((ioport volatile unsigned*)0x1B06) // Line Control Register
#define MCR         ((ioport volatile unsigned*)0x1B08) // Modern Control Register
#define LSR         ((ioport volatile unsigned*)0x1B0A) // Line Status Register
#define SCR         ((ioport volatile unsigned*)0x1B0E) // Scratch Register
#define DLL         ((ioport volatile unsigned*)0x1B10) // Divisor LSB Latch
#define DLH         ((ioport volatile unsigned*)0x1B12) // Divisor MSB Latch
#define PWREMU_MGMT ((ioport volatile unsigned*)0x1B18)

// Defines the functions that are called by main.c but are actually in uart2.c
extern int UART_Initialize();                                                       // Initializes the UART transmitter
extern void UART_Close();                                                           // Closes the UART transmitter
extern int UART_Write(char* string);                                                // Transmits a string of characters via the UART


#endif /* UART_H_ */
