/*
* module name       : c7x_cellSum_4x4
*
* module descripton : Computes 4x4 non-overlapping cell sums
*
* Copyright (C) 2015-2019 Texas Instruments Incorporated - http://www.ti.com/
*
* ALL RIGHTS RESERVED
*/

--heap_size  0x2000
--stack_size 0x2000

MEMORY
{
	L1DSRAM			: org = 0x64E00000, len = 0x4000
	L2SRAM_CINIT	: org = 0x64800000, len = 0x000100
	L2SRAM			: org = 0x64800100, len = 0x07FF00
	MSMCSRAM		: org = 0x70000000, len = 0x800000
	DDR_PCODE1		: org = 0x80000000,	len = 0x01000000
	DDR_PCODE2		: org = 0x81000000,	len = 0x01000000
}

SECTIONS
{
	// L2
	.boot_pcode:		> L2SRAM_CINIT
	{
		rts7100_le.lib<*> (.text:_c_int00)
	}

	// DDR
	.bss				> DDR_PCODE2
	.cio				> DDR_PCODE2
	.sysmem				> DDR_PCODE2
	.cinit				> DDR_PCODE2
	.init_array			> DDR_PCODE2
	.const				> DDR_PCODE2
	.text				> DDR_PCODE2
	.stack				> DDR_PCODE2
	.data				> DDR_PCODE2
}
