/*
*
* Copyright (c) 2024 Texas Instruments Incorporated
*
* All rights reserved not granted herein.
*
* Limited License.
*
* Texas Instruments Incorporated grants a world-wide, royalty-free, non-exclusive
* license under copyrights and patents it now or hereafter owns or controls to make,
* have made, use, import, offer to sell and sell ("Utilize") this software subject to the
* terms herein.  With respect to the foregoing patent license, such license is granted
* solely to the extent that any such patent is necessary to Utilize the software alone.
* The patent license shall not apply to any combinations which include this software,
* other than combinations with devices manufactured by or for TI ("TI Devices").
* No hardware patent is licensed hereunder.
*
* Redistributions must preserve existing copyright notices and reproduce this license
* (including the above copyright notice and the disclaimer and (if applicable) source
* code license limitations below) in the documentation and/or other materials provided
* with the distribution
*
* Redistribution and use in binary form, without modification, are permitted provided
* that the following conditions are met:
*
* No reverse engineering, decompilation, or disassembly of this software is
* permitted with respect to any software provided in binary form.
*
* any redistribution and use are licensed by TI for use only with TI Devices.
*
* Nothing shall obligate TI to provide you with source code for the software
* licensed and provided to you in object code.
*
* If software source code is provided to you, modification and redistribution of the
* source code are permitted provided that the following conditions are met:
*
* any redistribution and use of the source code, including any resulting derivative
* works, are licensed by TI for use only with TI Devices.
*
* any redistribution and use of any object code compiled from the source code
* and any resulting derivative works, are licensed by TI for use only with TI Devices.
*
* Neither the name of Texas Instruments Incorporated nor the names of its suppliers
*
* may be used to endorse or promote products derived from this software without
* specific prior written permission.
*
* DISCLAIMER.
*
* THIS SOFTWARE IS PROVIDED BY TI AND TI'S LICENSORS "AS IS" AND ANY EXPRESS
* OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL TI AND TI'S LICENSORS BE LIABLE FOR ANY DIRECT, INDIRECT,
* INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
* BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
* OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
* OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
* OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/

/**
 *
 * \file  Fls_NOR_Device.h
 *
 * \brief    This file contains generated pre compile configuration file
 *           for FLS MCAL driver
 */

  /*****************************************************************************
    Project: bootloader
    Date   : 2025-11-14 14:41:39
    This file is generated by EB Tresos
    Do not modify this file, otherwise the software may behave in unexpected way.
 ******************************************************************************/

#ifndef FLS_NOR_DEVICE_H_
#define FLS_NOR_DEVICE_H_

/**************************************************************************
                            Macro Definitions
 **************************************************************************/

/* Selected Flash W25Q32JW */

/* NOR Sector Size in bytes  */ 
#define NOR_BLOCK_SIZE              (65536U)

/* NOR Block Size in bytes  */ 
#define NOR_UNIFORM_SECTOR_SIZE     (4096U)

/* NOR Hybrid Sector Size in bytes */
#define NOR_SECTOR_SIZE             (4096U)

/* Total NOR Size in bytes */
#define NOR_SIZE                    (4194304U)

/* Number of 4K sectors in the NOR flash */
#define NOR_NUM_4K_SECTORS          (1024U)

/* Total number of sectors in the NOR flash */
#define NOR_NUM_SECTORS             (NOR_SIZE / NOR_UNIFORM_SECTOR_SIZE)

/* Total number of blocks in the NOR flash */
#define NOR_NUM_BLOCKS              (NOR_SIZE / NOR_BLOCK_SIZE)

/* Page size of the NOR flash in bytes */
#define NOR_PAGE_SIZE               (256U)

/* Number of pages per sector */
#define NOR_NUM_PAGES_PER_SECTOR    (NOR_SECTOR_SIZE / NOR_PAGE_SIZE)

/* Number of pages per block */
#define NOR_NUM_PAGES_PER_BLOCK     (NOR_BLOCK_SIZE / NOR_PAGE_SIZE)

/* Value of erased data */
#define NOR_ERASED_DATA             (0xffU)

/* Offset for the bottom of the 4K sector */
#define NOR_4K_SECT_BOT_END_OFFSET  (0x3fffffU)

/* Number of sectors in the BE (Block Erase) region */
#define NOR_BE_SECTOR_NUM           (-1U)

/* Bulk Erase command for the NOR flash */
#define NOR_CMD_BULK_ERASE          (0xc7U)

/* Write Register command */
#define NOR_CMD_WRREG               (0x31U)

/* Write Enable command */
#define NOR_CMD_WREN                (0x6U)

/* Write Disable command */
#define NOR_CMD_WRDIS               (0x4U)

/* Read Status Register command */
#define NOR_CMD_RDSR                (0x5U)

/* Read Status Register 2 command */
#define NOR_CMD_RDSR2               (0x35U)

/* Register Read command */
#define NOR_CMD_RDREG               (0x0U)

/* Read Configuration Register command */
#define NOR_CMD_RDCR                (0x0U)

#define NOR_CMD_RDID                 (0x9fU)

/* Software Reset Enable command */
#define NOR_CMD_SRSTE               (0x66U)

/* Software Reset command */
#define NOR_CMD_SFRST               (0x99U)

/* Block Erase command */
#define NOR_CMD_BLOCK_ERASE         (0xd8U)

/* Sector Erase command */
#define NOR_CMD_SECTOR_ERASE        (0x20U)

/* Standard Read command */
#define NOR_CMD_READ                (0x3U)

/* Fast Read command */
#define NOR_CMD_FAST_READ           (0xbU)

/* Octal Read command (calculated based on sector size) */
#define NOR_CMD_OCTAL_READ          (0xebU)

/* Octal DDR Read command (calculated based on NOR size and sector size) */
#define NOR_CMD_OCTAL_DDR_READ      (0x0U)

/* Page Program command */
#define NOR_CMD_PAGE_PROG           (0x2U)

/* Octal Program command */
#define NOR_CMD_OCTAL_PROG          (0x32U)

/* Write VCR (Volatile Configuration Register) command */
#define NOR_CMD_WRITE_VCR           (0x0U)

/* Read VCR (Volatile Configuration Register) command */
#define NOR_CMD_READ_VCR            (0x0U)

/* Offset for the volatile register */
#define NOR_VREG_OFFSET             (0x0U)

/* Offset for the non-volatile register */
#define NOR_NVREG_OFFSET            (0x0U)

/* Non-Volatile Status Register 1 address */
#define NOR_STS1_NVREG_ADDR         (0x0U)

/* Non-Volatile Status Register 2 address */
#define NOR_STS2_NVREG_ADDR         (0x1U)

/* Non-Volatile Configuration Register 1 address */
#define NOR_CFG1_NVREG_ADDR         (0x2U)

/* Non-Volatile Configuration Register 2 address */
#define NOR_CFG2_NVREG_ADDR         (0x3U)

/* Non-Volatile Configuration Register 3 address */
#define NOR_CFG3_NVREG_ADDR         (0x4U)

/* Non-Volatile Configuration Register 4 address */
#define NOR_CFG4_NVREG_ADDR         (0x5U)

/* Non-Volatile Configuration Register 5 address */
#define NOR_CFG5_NVREG_ADDR         (0x6U)

/* Volatile Status Register 1 address */
#define NOR_STS1_VREG_ADDR          (0x800000U)

/* Volatile Status Register 2 address */
#define NOR_STS2_VREG_ADDR          (0x800001U)

/* Volatile Configuration Register 1 address */
#define NOR_CFG1_VREG_ADDR          (0x800002U)

/* Volatile Configuration Register 2 address */
#define NOR_CFG2_VREG_ADDR          (0x800003U)

/* Volatile Configuration Register 3 address */
#define NOR_CFG3_VREG_ADDR          (0x800004U)

/* Volatile Configuration Register 4 address */
#define NOR_CFG4_VREG_ADDR          (0x800005U)

/* Volatile Configuration Register 5 address */
#define NOR_CFG5_VREG_ADDR         (0x800006U)

/** Read ID command definitions **/
#define NOR_RDID_NUM_BYTES          (0x3U)
#define NOR_MANF_ID                 (0xefU)  /* Manufacturer ID */
#define NOR_DEVICE_ID               (0x6016U)  /* Device ID */

/** Status Register: Write-in-Progress bit **/
#define NOR_SR_WIP                  ((1U) << 0U)

/** Status Register: Program enabled bit **/
#define NOR_SR_WRPGEN               ((1U) << 1U)

/** Configuration Register: TBPARM bit **/
#define NOR_CR_TBPARM               ((1U) << 2U)

/** Dummy cycles for various Read operations **/
#define NOR_SINGLE_READ_DUMMY_CYCLE         ((0U))
#define NOR_SINGLE_CMD_READ_DUMMY_CYCLE     (1U)
#define NOR_OCTAL_SDR_CMD_READ_DUMMY_CYCLE  (4U)
#define NOR_OCTAL_DDR_CMD_READ_DUMMY_CYCLE  (2U)
#define NOR_OCTAL_READ_DUMMY_CYCLE          (24U)
#define NOR_OCTAL_READ_DUMMY_CYCLE_LC       (0xbU)
#define NOR_OCTAL_READ_DUMMY_CYCLE_INDAC    (20U)
#define NOR_OCTAL_READ_DUMMY_CYCLE_LC_INDAC (0x8U)

/** Read ID Command Lengths **/
#define NOR_RDID_CMD_LENGTH_SINGLE          (1U)
#define NOR_RDID_CMD_LENGTH_OCTAL           (5U)

/** Timeouts (in microseconds) **/
#define NOR_PAGE_PROG_TIMEOUT               (400U)
#define NOR_SECTOR_ERASE_TIMEOUT            (600000U)
#define NOR_WRR_WRITE_TIMEOUT               (600000U)
#define NOR_BULK_ERASE_TIMEOUT              (110000000U)


#endif /* DEVICE_H_ */

/* Nothing past this point */
