/*
 * Decompiled with CFR 0.152.
 */
package ndkbenchmark;

import java.applet.Applet;
import java.awt.Font;
import java.awt.Graphics;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.StringTokenizer;

public class NDKBenchmark
extends Applet {
    private static final long serialVersionUID = 1L;
    float time;
    String sResponse;
    String ndkBenchMarkTest;
    int packetSize;
    int packetNum;
    String testeeIP;
    static int packetDir;
    static int packetProto;
    static boolean waiting;
    Thread tester;
    SendRecvThread sthread;
    ReceiverThread rthread;
    SendRecvTCPThread stthread;
    Font bodyFont;
    Graphics myg;

    @Override
    public void init() {
        waiting = true;
        this.bodyFont = new Font("Courier", 0, 18);
        this.execute();
    }

    @Override
    public void paint(Graphics g) {
        int y = 40;
        g.setFont(this.bodyFont);
        this.myg = this.getGraphics();
        if (waiting) {
            g.drawString(this.sResponse, 20, y);
        } else {
            StringTokenizer st = new StringTokenizer(this.sResponse, "\n");
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                g.drawString(s, 20, y += 30);
            }
        }
    }

    public void execute() {
        String p = this.getParameter("packets");
        int pktSize = Integer.parseInt(p.trim());
        String dir = this.getParameter("direction");
        packetDir = Integer.parseInt(dir.trim());
        String sendIPAddr = this.getParameter("ipaddress");
        String proto = this.getParameter("protocol");
        packetProto = Integer.parseInt(proto.trim());
        try {
            if (packetProto == 0) {
                this.tester = new UDPTester(pktSize, sendIPAddr);
                this.tester.start();
            } else {
                this.tester = new TCPTester(pktSize, sendIPAddr);
                this.tester.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class ReceiverThread
    extends Thread {
        DatagramSocket socket;
        public int port;
        private boolean stopped = false;

        public ReceiverThread(int port) throws SocketException {
            this.socket = new DatagramSocket(port);
        }

        public void halt() {
            this.stopped = true;
        }

        @Override
        public void run() {
            byte[] buffer = new byte[65507];
            while (!this.stopped) {
                DatagramPacket dp = new DatagramPacket(buffer, buffer.length);
                try {
                    this.socket.receive(dp);
                    NDKBenchmark.this.sResponse = new String(dp.getData(), 0, dp.getLength());
                    waiting = false;
                    NDKBenchmark.this.paint(NDKBenchmark.this.myg);
                    continue;
                }
                catch (IOException ex) {
                    System.err.println(ex);
                    continue;
                }
                break;
            }
            return;
        }
    }

    class SendRecvTCPThread
    extends Thread {
        public InetAddress server;
        public boolean stopped = false;
        public int port;
        public int size;
        public int i;

        public SendRecvTCPThread(InetAddress address, int port, int size) throws SocketException {
            this.server = address;
            this.port = port;
            this.size = size;
        }

        public void halt() {
            this.stopped = true;
        }

        @Override
        public void run() {
            try {
                if (packetDir == 1) {
                    byte[] data = new byte[1500];
                    int i = 0;
                    NDKBenchmark.this.sResponse = "Sending TCP test packets...";
                    NDKBenchmark.this.paint(NDKBenchmark.this.myg);
                    Socket stcp = new Socket(this.server, this.port);
                    OutputStream outstream = stcp.getOutputStream();
                    DataOutputStream osr = new DataOutputStream(outstream);
                    while (waiting && i < this.size * 1000) {
                        osr.write(data, 0, 1000);
                        ++i;
                    }
                    stcp.close();
                } else {
                    byte[] data = new byte[1000];
                    ServerSocket stcp = new ServerSocket(this.port);
                    Socket stcps = stcp.accept();
                    InputStream instream = stcps.getInputStream();
                    DataInputStream isr = new DataInputStream(instream);
                    NDKBenchmark.this.sResponse = "Receiving TCP test packets...";
                    NDKBenchmark.this.paint(NDKBenchmark.this.myg);
                    while (waiting) {
                        isr.read(data);
                    }
                    stcp.close();
                    stcps.close();
                }
            }
            catch (IOException ex) {
                System.err.println(ex);
            }
        }
    }

    class SendRecvThread
    extends Thread {
        public InetAddress server;
        public DatagramSocket socket;
        public boolean stopped = false;
        public int port;
        public int size;

        public SendRecvThread(InetAddress address, int port, int size) throws SocketException {
            this.server = address;
            this.port = port;
            this.socket = new DatagramSocket(10001);
            this.size = size;
        }

        public void halt() {
            this.stopped = true;
        }

        public DatagramSocket getSocket() {
            return this.socket;
        }

        @Override
        public void run() {
            try {
                if (packetDir == 1) {
                    byte[] data = new byte[1000];
                    NDKBenchmark.this.sResponse = "Sending UDP test packets...";
                    NDKBenchmark.this.paint(NDKBenchmark.this.myg);
                    DatagramPacket output = new DatagramPacket(data, data.length, this.server, this.port);
                    while (waiting) {
                        this.socket.send(output);
                    }
                } else {
                    byte[] start = new byte[5];
                    NDKBenchmark.this.sResponse = "Receiving UDP test packets...";
                    NDKBenchmark.this.paint(NDKBenchmark.this.myg);
                    DatagramPacket output = new DatagramPacket(start, start.length, this.server, this.port);
                    this.socket.send(output);
                    byte[] tmp = new byte[1000];
                    DatagramPacket dp = new DatagramPacket(tmp, tmp.length);
                    while (waiting) {
                        this.socket.receive(dp);
                    }
                }
            }
            catch (IOException ex) {
                System.err.println(ex);
            }
        }
    }

    class TCPTester
    extends Thread {
        Socket stcp;
        int pktSize;
        int pktDir;
        String sendIPAddr;

        public TCPTester(int packetSize, String sendIPAddr) throws SocketException {
            this.pktSize = packetSize;
            this.sendIPAddr = sendIPAddr;
        }

        @Override
        public void run() {
            try {
                NDKBenchmark.this.rthread = new ReceiverThread(7000);
                NDKBenchmark.this.rthread.start();
                NDKBenchmark.this.stthread = new SendRecvTCPThread(InetAddress.getByName(this.sendIPAddr), 10001, this.pktSize);
                NDKBenchmark.this.stthread.start();
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }

    class UDPTester
    extends Thread {
        DatagramSocket socket;
        int pktSize;
        int pktDir;
        String sendIPAddr;

        public UDPTester(int packetSize, String sendIPAddr) throws SocketException {
            this.pktSize = packetSize;
            this.sendIPAddr = sendIPAddr;
        }

        @Override
        public void run() {
            try {
                NDKBenchmark.this.rthread = new ReceiverThread(7000);
                NDKBenchmark.this.rthread.start();
                NDKBenchmark.this.sthread = new SendRecvThread(InetAddress.getByName(this.sendIPAddr), 10001, this.pktSize);
                NDKBenchmark.this.sthread.start();
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }
}

