/*----------------------------------------------------------------------------------*/
/* Copyrighted 2016 by Locus Location Systems								  		*/
/*                                                                            		*/
/* Filename: 	wtd.c  	                                                 	  		*/
/* version: 	1.00                                                          		*/
/* Description: Prepare config registers to perform HARD reset when WATCHDOG expires*/
/* Notes: 25 sec timeout															*/
/*----------------------------------------------------------------------------------*/
/* Revision History                                                           		*/
/* Ver      Date     History	   				                              		*/
/* ----  ----------  -------------------------------------------------------------- */
/* 1.00   01/24/2016  Original Version										  		*/
/* Author: Murad Qahwash									  				  		*/
#include "wdt.h"
#include <ti/sysbios/knl/Clock.h>

CSL_TmrHandle   wdTmr;

void WDT_init(void)
{
	CSL_PllcHandle  hPllc;
	CSL_TmrContext  context;
    CSL_TmrObj                  TmrObj;
    CSL_Status                  status;
    CSL_TmrHwSetup              hwSetup = CSL_TMR_HWSETUP_DEFAULTS;
    CSL_TmrEnamode              TimeCountMode = CSL_TMR_ENAMODE_CONT;
    Uint16  loadVal;

    Uint32 coreId;

    coreId = 0;//platform_get_coreid();

    //Unlock the kicker to ensure Boot configuration MMR is writeable
	CSL_BootCfgUnlockKicker();

    // Unlock registers for Core 0
//    CSL_BootCfgSetResetMuxLockStatus (coreId, 0);

	//Set the output mode for core x to ensure that the WD Timer generates a device reset to C6678
    CSL_BootCfgSetResetMuxOutputMode (coreId, 5);

	//Sets up the Key and Software Reset bit in Reset control register (RSTCTRL) contents. unlock RSTCFG register
//	hPllc = CSL_PLLC_open (0);    // Opens PLLC Instance 0
//	CSL_PLLC_setResetCtrlReg (hPllc, CSL_PLLC_RSTCTRL_VALID_KEY, 1);

	//Sets up the contents of Reset configuration register (RSTCFG) - Generate HARD reset when watchdog expires
//	CSL_PLLC_setResetCfgReg (hPllc, 0, 0, 0);

    // Lock registers for Core 0
//    CSL_BootCfgSetResetMuxLockStatus (coreId, 1);

	// Lock the kicker mechanism
    CSL_BootCfgLockKicker();


    // Prepare timer to act as a Watchdog timer
    //Clear local data structures
    memset(&TmrObj, 0, sizeof(CSL_TmrObj));

    /* Initialize the timer CSL module */
    CSL_tmrInit(NULL);

	/* Open the timer. */
    wdTmr = CSL_tmrOpen(&TmrObj, CSL_TMR_0, NULL, &status);
//    if (wdTmr == NULL)
//        return -1;

    /* Set the timer mode to WATCHDOG mode */
    hwSetup.tmrTimerMode    = CSL_TMR_TIMMODE_WDT;
    hwSetup.tmrPulseWidthLo = CSL_TMR_PWID_THREECLKS;
    hwSetup.tmrClksrcLo     = CSL_TMR_CLKSRC_INTERNAL; //(internal clock source = CPU/6 clock frequency = 1GHz/6)
    hwSetup.tmrClockPulseLo = CSL_TMR_CP_PULSE;
    hwSetup.tmrClockPulseHi = CSL_TMR_CP_PULSE;
    hwSetup.tmrIpGateLo     = CSL_TMR_CLOCK_INP_NOGATE;

    /* load the PRDLO */
    hwSetup.tmrTimerPeriodLo = 0x0;

    /* load the PRDHI */
    hwSetup.tmrTimerPeriodHi = 0x1;

    /* Configure the timer. */
    CSL_tmrHwSetup(wdTmr, &hwSetup);

    /* Reset the Timer */
//    CSL_tmrHwControl(wdTmr, CSL_TMR_CMD_RESET64, NULL);

    /* Start the timer in CONTINUOUS Mode. */
    CSL_tmrHwControl(wdTmr, CSL_TMR_CMD_START_WDT, (void *)&TimeCountMode);

    /* Watchdog timer service key1 */
    loadVal = CSL_TMR_WDTCR_WDKEY_CMD1;
    CSL_tmrHwControl(wdTmr, CSL_TMR_CMD_LOAD_WDKEY, (Uint16 *)&loadVal);

    /* Watchdog timer service key2 */
    loadVal = CSL_TMR_WDTCR_WDKEY_CMD2;
    CSL_tmrHwControl(wdTmr, CSL_TMR_CMD_LOAD_WDKEY, (Uint16 *)&loadVal);
}

void WDT_reset(void)
{
	Uint16  loadVal;

    /* Watchdog timer service key1 */
    loadVal = CSL_TMR_WDTCR_WDKEY_CMD1;
    CSL_tmrHwControl(wdTmr, CSL_TMR_CMD_LOAD_WDKEY, (Uint16 *)&loadVal);

    /* Watchdog timer service key2 */
    loadVal = CSL_TMR_WDTCR_WDKEY_CMD2;
    CSL_tmrHwControl(wdTmr, CSL_TMR_CMD_LOAD_WDKEY, (Uint16 *)&loadVal);
}

