@echo off 
rem Modify default CG TOOL path if necessary
set C6000_CG_DIR="C:\ti\ccsv6\tools\compiler\c6000_7.4.8\"


rem Setup utility path
set IBL_ROOT_DIR="C:\ti\mcsdk_2_01_02_06\tools\boot_loader\ibl"

set TARGET=8682

set ENDIAN=little
set PATH=%PATH%;%SystemRoot%\system32;%SystemRoot%;


echo C6000_CG_DIR set as: %C6000_CG_DIR%
echo TARGET set as: %TARGET%
echo IBL_ROOT_DIR set as : %IBL_ROOT_DIR%

echo Converting .out to HEX ...
if %ENDIAN% == little (                     
%C6000_CG_DIR%\bin\hex6x -a -boot -bootorg 0x400 -e _c_int00 -order L -memwidth=32 -romwidth=32 -o post_%TARGET%_1.b ..\DSPC%TARGET%E_32bit_BAR\DSPC%TARGET%_eeprom_1.out
)

%IBL_ROOT_DIR%\src\util\btoccs\b2ccs post_%TARGET%_1.b post_%TARGET%_1.ccs


if %ENDIAN% == little (
%C6000_CG_DIR%\bin\hex6x -order L post_%TARGET%_1.rmd ..\DSPC%TARGET%E_32bit_BAR\DSPC%TARGET%_eeprom_1.out
)


if %ENDIAN% == little (
%IBL_ROOT_DIR%\src\util\bconvert\bconvert64x -le post2_%TARGET%_1.b post_%TARGET%_1.b 
)

%IBL_ROOT_DIR%\src\util\btoccs\b2i2c post_%TARGET%_1.b post_%TARGET%_1.i2c.b

%IBL_ROOT_DIR%\src\util\btoccs\b2ccs post_%TARGET%_1.i2c.b post_1.i2c.ccs

echo Generating I2C ROM data ...
%IBL_ROOT_DIR%\src\util\romparse\romparse -rom_base 0x50 reboot_1.i2cmap
%IBL_ROOT_DIR%\src\util\btoccs\ccs2bin -swap i2crom.ccs  post_%TARGET%_1_i2crom.bin
copy post_%TARGET%_1_i2crom.bin ..\bin\eeprom_1_post_%TARGET%.bin

del *.ccs *.b *.bin