/**
 * \file   plat_delay.c
 *
 * \brief  File containing APIs that facilitate execution delays
 *
 * 
*/

/*
 * Copyright (C) 2013 Texas Instruments Incorporated - http://www.ti.com/
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "plat_delay.h"
#include "hw_types.h"
/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
typedef void (*MS_DELAY_FN_PTR)(unsigned int);
/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* ========================================================================== */
/*                 Internal Function Declarations                             */
/* ========================================================================== */ 
/**
 * \brief   Routine imposing delay using a tight loop 
 *
 * \param   delay
 *
 *
 * \return  None
 *
 **/ 
void DEALYLoop(unsigned int delay);


/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */
MS_DELAY_FN_PTR  msDelayFnPtr = NULL;
/* ========================================================================== */
/*                          Function Definitions                              */
/* ========================================================================== */
void DELAYMicroSeconds(unsigned int duration)
{
    DEALYLoop( duration * 2 );
}

void DELAYMilliSeconds(unsigned int duration)
{
    if(msDelayFnPtr)
    {
        (*msDelayFnPtr)(duration);

    }

	while(duration > 0)
	{
		DELAYMicroSeconds(1000);
		duration--;
	}

}

void DELAYSeconds( unsigned int duration)
{
    while(duration > 0)
    {
        DEALYLoop( duration * 3 );
        DELAYMilliSeconds(1000);
        duration--;
    }

}

void DELAYRegisterMSDelayfn(void* fnPtr)
{   
    if(fnPtr)
    {
        msDelayFnPtr = (MS_DELAY_FN_PTR)fnPtr;
    }
}
/* -------------------------------------------------------------------------- */
/*                 Internal Function Definitions                              */
/* -------------------------------------------------------------------------- */
void DEALYLoop(unsigned int delay)
{
    volatile unsigned int loopCntr;
    for ( loopCntr = 0 ; loopCntr < delay ; loopCntr++ ){ };
}

