/**
 * \file   plat_gpio.c
 *
 * \brief  GPIO Platform source file for AM335x
 *
 * 
*/

/*
 * Copyright (C) 2013 Texas Instruments Incorporated - http://www.ti.com/
 */
/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "plat_gpio.h"
#include "stdio.h"
#include "soc_AM335x.h"
#include "hw_cm_wkup.h"
#include "hw_cm_per.h"
#include "hw_types.h"
#include "gpio.h"
#include "plat_utils.h"
/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* ========================================================================== */
/*                 Internal Function Declarations                             */
/* ========================================================================== */
/**
 * \brief   
 *
 * \param   
 *
 * \return  None.
 *
 **/
 void GPIOEnablePins();
/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */
extern unsigned char am335x_board_type;

/* ========================================================================== */
/*                          Function Definitions                              */
/* ========================================================================== */
void GPIOClockEnable(int instance)
{
    if(instance & GPIO_INSTANCE_0)
    {
        HWREG( SOC_CM_WKUP_REGS + CM_WKUP_GPIO0_CLKCTRL )  |=
                CM_WKUP_GPIO0_CLKCTRL_MODULEMODE_ENABLE;
    }
    if(instance & GPIO_INSTANCE_1)
    {
        HWREG( SOC_PRCM_REGS + CM_PER_GPIO1_CLKCTRL )      |= 
                CM_PER_GPIO1_CLKCTRL_MODULEMODE_ENABLE;
    }
	if(instance & GPIO_INSTANCE_2)
    {
        HWREG( SOC_PRCM_REGS + CM_PER_GPIO2_CLKCTRL )      |= 
                CM_PER_GPIO2_CLKCTRL_MODULEMODE_ENABLE;
    }
    if(instance & GPIO_INSTANCE_3)
    {
        HWREG( SOC_PRCM_REGS + CM_PER_GPIO3_CLKCTRL )      |= 
                CM_PER_GPIO3_CLKCTRL_MODULEMODE_ENABLE;
    }
}


void GPIOInit()
{
    GPIOClockEnable(GPIO_INSTANCE_ALL);
    GPIOEnablePins();
}


/* -------------------------------------------------------------------------- */
/*                 Internal Function Definitions                              */
/* -------------------------------------------------------------------------- */
void GPIOEnablePins()
{
    if(AM335X_BOARD_TYPE_ICE == am335x_board_type)
    {
        GPIODirModeSet(SOC_GPIO_0_REGS, 0, GPIO_DIR_OUTPUT);
        GPIODirModeSet(SOC_GPIO_0_REGS, 1, GPIO_DIR_OUTPUT);
        GPIODirModeSet(SOC_GPIO_0_REGS, 12, GPIO_DIR_OUTPUT);
        GPIODirModeSet(SOC_GPIO_0_REGS, 13, GPIO_DIR_OUTPUT);
        GPIODirModeSet(SOC_GPIO_0_REGS, 16, GPIO_DIR_OUTPUT);
        GPIODirModeSet(SOC_GPIO_0_REGS, 17, GPIO_DIR_OUTPUT);
        
        GPIODirModeSet(SOC_GPIO_3_REGS, 0, GPIO_DIR_OUTPUT);    //RunLed
        GPIODirModeSet(SOC_GPIO_3_REGS, 1, GPIO_DIR_OUTPUT);    //ErrLed
        GPIODirModeSet(SOC_GPIO_3_REGS, 2, GPIO_DIR_OUTPUT);    //ACT0Led
        GPIODirModeSet(SOC_GPIO_3_REGS, 3, GPIO_DIR_OUTPUT);    //ACT1Led
        GPIODirModeSet(SOC_GPIO_3_REGS, 17, GPIO_DIR_OUTPUT);
        GPIODirModeSet(SOC_GPIO_3_REGS, 18, GPIO_DIR_OUTPUT);    
    }
    else if(AM335X_BOARD_TYPE_ICE_V2 == am335x_board_type)
    {
        GPIODirModeSet(SOC_GPIO_0_REGS, 16, GPIO_DIR_OUTPUT);   //Tri-color LED - D1 Greem
        GPIODirModeSet(SOC_GPIO_0_REGS, 17, GPIO_DIR_OUTPUT);   //Tri-color LED - D1 Red
        GPIODirModeSet(SOC_GPIO_0_REGS, 19, GPIO_DIR_OUTPUT);   //Tri-color LED - D2 Orange
        GPIODirModeSet(SOC_GPIO_0_REGS, 20, GPIO_DIR_OUTPUT);   //Tri-color LED - D2 Green
        GPIODirModeSet(SOC_GPIO_1_REGS, 30, GPIO_DIR_OUTPUT);   //Tri-color LED - D2 Red
        GPIODirModeSet(SOC_GPIO_3_REGS, 9, GPIO_DIR_OUTPUT);    //Tri-color LED - D1 Orange    
        GPIODirModeSet(SOC_GPIO_3_REGS, 18, GPIO_DIR_OUTPUT);    //HVS LDn  
        
        GPIODirModeSet(SOC_GPIO_3_REGS, 4, GPIO_DIR_OUTPUT);    //SYSBOOT /PHY ISOLATION PIN
        GPIODirModeSet(SOC_GPIO_3_REGS, 10, GPIO_DIR_OUTPUT);
        GPIODirModeSet(SOC_GPIO_0_REGS, 7, GPIO_DIR_OUTPUT);
        GPIODirModeSet(SOC_GPIO_0_REGS, 18, GPIO_DIR_OUTPUT);
        GPIODirModeSet(SOC_GPIO_2_REGS, 5, GPIO_DIR_OUTPUT);    
    }
    else if(AM335X_BOARD_TYPE_IDK == am335x_board_type)
    {
        GPIODirModeSet(SOC_GPIO_0_REGS, 29 , GPIO_DIR_OUTPUT);      //ACT1Led
        GPIODirModeSet(SOC_GPIO_2_REGS, 12 , GPIO_DIR_OUTPUT);      //RunLed
        GPIODirModeSet(SOC_GPIO_3_REGS, 20 , GPIO_DIR_OUTPUT);      //ErrLed
        GPIODirModeSet(SOC_GPIO_3_REGS, 21 , GPIO_DIR_OUTPUT);      //ACT0Led
        
        GPIODirModeSet(SOC_GPIO_0_REGS, 13 , GPIO_DIR_OUTPUT);   //gpio0[13] -> INDUS_LDn 
        GPIODirModeSet(SOC_GPIO_0_REGS, 19 , GPIO_DIR_OUTPUT);   //gpio0[19] / XDMA_EVENT_INTR0 
        GPIODirModeSet(SOC_GPIO_1_REGS, 9 , GPIO_DIR_OUTPUT);    //gpio1[9] / uart0_rtsn
    }

}
