/**
 * \file   plat_led.c
 *
 * \brief  LED Driver source file
 *
 * 
*/

/*
 * Copyright (C) 2013 Texas Instruments Incorporated - http://www.ti.com/
 */
/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "plat_led.h"
#include "soc_AM335x.h"
#include "plat_gpio.h"
#include "gpio_v2.h"
#include "plat_i2c.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* ========================================================================== */
/*                 Internal Function Declarations                             */
/* ========================================================================== */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */
extern unsigned char am335x_board_type;

unsigned char sys_led_status = 0;
volatile unsigned char i2c_inst = 0;

/* ========================================================================== */
/*                          Function Definitions                              */
/* ========================================================================== */
void LEDInit()
{
    if(AM335X_BOARD_TYPE_IDK == am335x_board_type )
        i2c_inst = 1;
    else
        i2c_inst = 0;
        
	GPIOInit();
    
    I2CInit(i2c_inst);
    
	sys_led_status = 0;
	LEDDIGOUTSetVal(sys_led_status);
}


void LEDGPIOSetVal(unsigned int instance, unsigned int pinNumber,
		unsigned int bitValue)
{
	unsigned int baseAddr = 0;
	switch(instance)
	{
		case 0:
			baseAddr = SOC_GPIO_0_REGS;
		break;
		case 1:
			baseAddr = SOC_GPIO_1_REGS;
		break;
		case 2:
			baseAddr = SOC_GPIO_2_REGS;
		break;
		case 3:
			baseAddr = SOC_GPIO_3_REGS;
		break;		
		default:
		return;
	}
	GPIOPinWrite(baseAddr, pinNumber,bitValue);
}



/*
 *	set_led_on - Sets the specified LED to ON position 
 *  led - LED number Range{1 - 8}
 */
void LEDDIGOUTOn(unsigned char led)
{
    unsigned char out_buff[2] = { 0x44 };
    unsigned char data_written;
	if((!led) ||(led > 8))
		return ;
	sys_led_status |= (1 << (led - 1));
    out_buff[1] = sys_led_status;
    I2CWrite(i2c_inst,LED_I2C_SALVE_ADDR,out_buff,2,&data_written);
}

/*
 *	set_led_off - Sets the specified LED to OFF position 
 *  led - LED number Range{1 - 8}
 */
void LEDDIGOUTOff(unsigned char led)
{
    unsigned char out_buff[2] = { 0x44 };
    unsigned char data_written;
	if((!led) ||(led > 8))
		return ;
        
	sys_led_status &= ((1 << (led - 1)) & 0xFF);
    out_buff[1] = sys_led_status;
    I2CWrite(i2c_inst,LED_I2C_SALVE_ADDR,out_buff,2,&data_written);
}


/*
 *	set_led - Sets multiple LEDs at a single shot 
 *  led_val - led value to be applied
 */
void LEDDIGOUTSetVal(unsigned char led_val)
{
    unsigned char out_buff[2] = { 0x44 };
    unsigned char data_written;
	sys_led_status = led_val;
    out_buff[1] = sys_led_status;
    I2CWrite(i2c_inst,LED_I2C_SALVE_ADDR,out_buff,2,&data_written);
}


void LEDDriveRun(unsigned char ledFlag)
{
    unsigned int bitValue = (ledFlag?GPIO_PIN_HIGH:GPIO_PIN_LOW);
	if(AM335X_BOARD_TYPE_IDK == am335x_board_type )
	{
		GPIOPinWrite(SOC_GPIO_2_REGS, 12,bitValue);
	}	
	else if(AM335X_BOARD_TYPE_ICE == am335x_board_type )
	{
		GPIOPinWrite(SOC_GPIO_3_REGS, 0,bitValue);
	}
    else if(AM335X_BOARD_TYPE_ICE_V2 == am335x_board_type )
    {
        GPIOPinWrite(SOC_GPIO_0_REGS, 16,bitValue);
    }
    
}
void LEDDriveError(unsigned char ledFlag)
{
    unsigned int bitValue = (ledFlag?GPIO_PIN_HIGH:GPIO_PIN_LOW);
	if(AM335X_BOARD_TYPE_IDK == am335x_board_type )
	{
		//*((unsigned int*) 0x481AE194)  = 0x00100000;		// set bit 20
		GPIOPinWrite(SOC_GPIO_3_REGS, 20,bitValue);
	}	
	else if(AM335X_BOARD_TYPE_ICE == am335x_board_type )
	{
		GPIOPinWrite(SOC_GPIO_3_REGS, 1,bitValue);
	}
    else if(AM335X_BOARD_TYPE_ICE_V2 == am335x_board_type )
    {
        GPIOPinWrite(SOC_GPIO_1_REGS, 30,bitValue);
    }    
    
}

void LEDDriveACT0(unsigned char ledFlag)
{
    unsigned int bitValue = (ledFlag?GPIO_PIN_HIGH:GPIO_PIN_LOW);
	if(AM335X_BOARD_TYPE_IDK == am335x_board_type )
	{
		GPIOPinWrite(SOC_GPIO_3_REGS, 21,bitValue);
	}	
	else if(AM335X_BOARD_TYPE_ICE == am335x_board_type )
	{
		GPIOPinWrite(SOC_GPIO_3_REGS, 2,bitValue);
	}

}

void LEDDriveACT1(unsigned char ledFlag)
{
    unsigned int bitValue = (ledFlag?GPIO_PIN_HIGH:GPIO_PIN_LOW);
	if(AM335X_BOARD_TYPE_IDK == am335x_board_type )
	{
		GPIOPinWrite(SOC_GPIO_0_REGS,29 ,bitValue);
	}	
	else if(AM335X_BOARD_TYPE_ICE == am335x_board_type )
	{
		GPIOPinWrite(SOC_GPIO_3_REGS,3 ,bitValue);
	}
}

void LEDDriveTriColorLeds(unsigned int ledFlags)
{
    if(AM335X_BOARD_TYPE_ICE == am335x_board_type )
	{
    	LEDGPIOSetVal(0,16,((ledFlags & LED5G)&& 1));
    	LEDGPIOSetVal(0,17,((ledFlags & LED5R)&& 1));
    	LEDGPIOSetVal(0,29,((ledFlags & LED5B)&& 1));
    	LEDGPIOSetVal(0,0,((ledFlags & LED6G)&& 1));
    	LEDGPIOSetVal(0,1,((ledFlags & LED6R)&& 1));
    	LEDGPIOSetVal(0,13,((ledFlags & LED6B)&& 1));
	}	
	else if(AM335X_BOARD_TYPE_ICE_V2 == am335x_board_type )
	{
		LEDGPIOSetVal(0,16 ,(ledFlags & LED5G) && 1);
		LEDGPIOSetVal(0,17 ,(ledFlags & LED5R) && 1);
		LEDGPIOSetVal(3,9 ,(ledFlags & LED5O) && 1);
		
		LEDGPIOSetVal(0,20 ,(ledFlags & LED6G) && 1);
		LEDGPIOSetVal(1,30 ,(ledFlags & LED6R) && 1);
		LEDGPIOSetVal(0,19 ,(ledFlags & LED6O) && 1);
		
    }
}

