/**
 * \file   plat_mux.c
 *
 * \brief  Routines which does pinumxing related functions
 *
 * 
*/

/*
 * Copyright (C) 2013 Texas Instruments Incorporated - http://www.ti.com/
 */

 
/* TODO - This file is driver level as well..can be considered for moving to drivers */
/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "plat_mux.h"
#include "hw/hw_types.h"
#include "hw/soc_AM335x.h"
#include "armv7a/am335x/evmAM335x.h"
/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* ========================================================================== */
/*                 Internal Function Declarations                             */
/* ========================================================================== */ 
/**
 * \brief   
 *
 * \param   
 *
 *
 * \return  
 *
 **/ 
/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* ========================================================================== */
/*                          Function Definitions                              */
/* ========================================================================== */

void PinMuxConfig(MUX_CONFIG muxConfig[])
{
    unsigned short itr = 0;
    if(NULL == muxConfig )
        return;
        
    while(muxConfig[itr].offset != 0xFFFFFFFF )
    {
        HWREG(SOC_CONTROL_REGS + muxConfig[itr].offset) = muxConfig[itr].muxmode | muxConfig[itr].value ;
        itr++;
    }
}

void PRUSSPinMuxConfig(unsigned long regVal)
{
	//PRUSS_CFG_BASE + MUX_SEL_REG
	HWREG( 0x4a326000 + 0x40) = regVal;
}

/* -------------------------------------------------------------------------- */
/*                 Internal Function Definitions                              */
/* -------------------------------------------------------------------------- */


