/*
 * udpHello.c
 *
 * This program implements a UDP echo server, which echos back any
 * input it receives.
 *
 * Copyright (C) 2007 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

#include <ti/ndk/inc/netmain.h>
#ifdef ADD_UDP_RECV_TASK
#include <xdc/std.h>
#include <xdc/runtime/System.h>

#include <ti/runtime/openmp/omp.h> // For OMP

#define MAX_HISTORY_LEN 1000

#pragma DATA_ALIGN (g_rcvBuf, 128);
char g_rcvBuf[1372 * 10];

unsigned int g_sum = 0;
unsigned int g_recvBufIndex = 0;
unsigned int g_recvResHistory[MAX_HISTORY_LEN];
extern char* LocalIPAddr;

#endif
//
// dtask_udp_hello() - UDP Echo Server Daemon Function
// (SOCK_DGRAM, port 7)
//
// Returns "1" if socket 's' is still open, and "0" if its been closed
//
int dtask_udp_hello( SOCKET s, UINT32 unused )
{
    struct sockaddr_in sin1;
    struct timeval     to;
    int                i,tmp;
    char               *pBuf;
    HANDLE             hBuffer;

    (void)unused;

    // Configure our socket timeout to be 3 seconds
    to.tv_sec  = 3;
    to.tv_usec = 0;
    setsockopt( s, SOL_SOCKET, SO_SNDTIMEO, &to, sizeof( to ) );
    setsockopt( s, SOL_SOCKET, SO_RCVTIMEO, &to, sizeof( to ) );

    for(;;)
    {
        tmp = sizeof( sin1 );
        i = (int)recvncfrom( s, (void **)&pBuf, 0, (PSA)&sin1, &tmp, &hBuffer );

        // Spit any data back out
        if( i >= 0 )
        {
            sendto( s, pBuf, i, 0, (PSA)&sin1, sizeof(sin1) );
            recvncfree( hBuffer );
        }
        else
            break;
    }

    // Since the socket is still open, return "1"
    // (we need to leave UDP sockets open)
    return(1);    
}


#ifdef ADD_UDP_RECV_TASK

Void task_udp_recv(UArg unused0, UArg unused1)
{
    int i;
    SOCKET StreamSock = 0;
    struct sockaddr_in StreamAppAddr;

    System_printf("task_udp_recv is started\n");

	fdOpenSession( TaskSelf() );

	System_printf("OMP Test Start ...\n");
	#pragma omp parallel
	{
		System_printf("Just test for OMP. Should be printed on each core ...\n");
	}
	System_printf("OMP Test End\n");

	StreamSock = socket(AF_INET, SOCK_DGRAM, 0);
	if (StreamSock == INVALID_SOCKET) {
		System_abort("Failed to create socket\n");
	}

	memset(&StreamAppAddr, 0, sizeof(StreamAppAddr));
	StreamAppAddr.sin_family = AF_INET;
	StreamAppAddr.sin_port = htons(60001);
	inet_pton(AF_INET, LocalIPAddr, &(StreamAppAddr.sin_addr));

	if (bind(StreamSock, (struct sockaddr *)&StreamAppAddr, sizeof(StreamAppAddr)) == SOCKET_ERROR){
		System_abort("Failed to create socket\n");
	}

	System_printf("Now keep waiting for incoming UDP packet ...\n");
	while(1) {
		//Just receive incoming UPD packet and dump the response size to g_recvResHistory array
		i = (int)recv(StreamSock, g_rcvBuf, sizeof(g_rcvBuf), 0);
		if( i >= 0 )
		{
			g_recvResHistory[g_recvBufIndex] = i;
			g_sum += i;
			g_recvBufIndex++;
			if (g_recvBufIndex >= MAX_HISTORY_LEN)
				g_recvBufIndex = 0;
		}
		else
		{
			System_printf("Failure to receive data\n");
			break;
		}
	}

	fdCloseSession( TaskSelf() );
}
#endif


