#include "display.h"

#include <QApplication>
#include <QFile>
#include <QTextStream>
#include <QWidget>

CDisplay* CDisplay::instance_ = nullptr;

void writeLog(double value)
{
    const auto samples = 5 * 60 * 60; // minutes * seconds * fps
    static double buffer[samples];
    static auto sampleCount = 0;
    buffer[sampleCount] = value;
    sampleCount++;
    if (samples == sampleCount)
    {
        QFile file("log.txt");
        file.open(QIODevice::Text | QIODevice::Truncate | QIODevice::WriteOnly);
        QTextStream stream(&file);
        for (auto i = 0; i < sampleCount; i++)
        {
            stream << buffer[i] << endl;
        }
        file.close();
        QApplication::quit();
    }
}

void CDisplay::log()
{
    auto current = paintTimer_.nsecsElapsed();
    static double last = current;
    auto difference = (current - last) / 1e9; // difference in seconds
    writeLog(difference);
    last = current;

}

CDisplay::CDisplay()
{
    QSurfaceFormat format;
    format.setDepthBufferSize(24);
    format.setSwapBehavior(QSurfaceFormat::SingleBuffer);
    format.setSwapInterval(0);
    setFormat(format);
    paintTimer_.start();
}

void CDisplay::paintGL()
{
    update();
    log();
}
