#pragma once

#include <QElapsedTimer>
#include <QOpenGLFunctions>
#include <QOpenGLWindow>

class CDisplay : public QOpenGLWindow, protected QOpenGLFunctions
{
     Q_OBJECT
public:
    CDisplay();

    static CDisplay* instance() { return instance_; }

    void log();
    void paintGL();
    void setInstance() { instance_ = this; }
protected:
    static CDisplay *instance_;
    QElapsedTimer paintTimer_;
};
