/*
 * device_async_mem.h
*/

/*
 * Copyright (C) 2012 Texas Instruments Incorporated - http://www.ti.com/ 
*/
/* 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/
/* --------------------------------------------------------------------------
  FILE        : device_async_mem.h
  PROJECT     : TI Booting and Flashing Utilities
  AUTHOR      : Daniel Allred
  DESC        : Provides device differentiation for the project files. This
                file MUST be modified to match the device/platform specifics.
----------------------------------------------------------------------------- */

#ifndef _DEVICE_ASYNC_MEM_H_
#define _DEVICE_ASYNC_MEM_H_

#include "tistdtypes.h"
#include "async_mem.h"

// Prevent C++ name mangling
#ifdef __cplusplus
extern far "c" {
#endif

/***********************************************************
* Global Macro Declarations                                *
***********************************************************/

#define DEVICE_ASYNC_MEM_INTERFACE_CNT  (1)
#define DEVICE_ASYNC_MEM0_REGION_CNT    (4)

#define DEVICE_ASYNC_MEM_NORBOOT_INTERFACE    (0)
#define DEVICE_ASYNC_MEM_NORBOOT_REGION       (0)

#define DEVICE_ASYNC_MEM_NANDBOOT_INTERFACE   (0)
#define DEVICE_ASYNC_MEM_NANDBOOT_REGION      (1)
#define DEVICE_ASYNC_MEM_NANDBOOT_BUSWIDTH    (DEVICE_BUSWIDTH_8BIT)

#define DEVICE_ASYNC_MEM_ONENAND_INTERFACE    (0)
#define DEVICE_ASYNC_MEM_ONENAND_REGION       (0)


/***********************************************************
* Global Typedef Declarations                              *
***********************************************************/


/***********************************************************
* Global Variable Declarations                             *
***********************************************************/

extern __FAR__ const ASYNC_MEM_DEVICE_InterfaceObj DEVICE_ASYNC_MEM_interfaces[];
extern __FAR__ const ASYNC_MEM_DEVICE_InfoObj DEVICE_ASYNC_MEM_info;


/***********************************************************
* Global Function Declarations                             *
***********************************************************/


/***********************************************************
* End file                                                 *
***********************************************************/

#ifdef __cplusplus
}
#endif

#endif // End _DEVICE_ASYNC_MEM_H_

