/*
 * tps65023.c
*/

/*
 * Copyright (C) 2012 Texas Instruments Incorporated - http://www.ti.com/ 
*/
/* 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

/*
 * TI Booting and Flashing Utilities
 *
 * This file provides low-level init functions for use in the UBL for booting
 * an application.
 *
 * Copyright (C) 2009 Texas Instruments Incorporated - http://www.ti.com/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation version 2.
 *
 * This program is distributed "as is" WITHOUT ANY WARRANTY of any
 * kind, whether express or implied; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

/* --------------------------------------------------------------------------
  AUTHOR      : Platform Support Group
 --------------------------------------------------------------------------- */
 
// General type include
#include "tistdtypes.h"

// Device specific CSL
#include "device.h"

// Util functions
#include "util.h" 

//I2C functions
#include "i2c.h"

//TPS 65023 functions
#include "tps65023.h"

static TPS_ConfigObj tpsConfigObj[TPS_MAX_NUM_DEVICES];

Uint32 TPS65023_open(Uint32 instance)
{
  Uint32 status = E_PASS;
  
  switch(instance)
  {
	case 0:
		tpsConfigObj[0].i2cConfig.addrMode  = I2C_ADDRESSING_7BIT;
		tpsConfigObj[0].i2cConfig.i2cclkh   = DEVICE_I2C_CLKH;
  		tpsConfigObj[0].i2cConfig.i2cclkl   = DEVICE_I2C_CLKL;
  		tpsConfigObj[0].i2cConfig.ownAddr   = DEVICE_I2C_OWN_ADDRESS;
  		tpsConfigObj[0].i2cConfig.prescalar = DEVICE_I2C_CLK_PRESCALE;
  
		tpsConfigObj[0].hI2cInfo = NULL;
  		tpsConfigObj[0].hI2cInfo = \
    		I2C_open(0, I2C_ROLE_MASTER, I2C_MODE_AUTO_STOP, &tpsConfigObj[0].i2cConfig);
  
  		status = (tpsConfigObj[0].hI2cInfo ? E_PASS : E_FAIL) ;
  
  		if(status == E_PASS) {
			tpsConfigObj[0].hI2cInfo->slaveAddr = DEVICE_I2C_TPS65023_PMIC_SLAVE_ADDR;
  		}
	break;
	default:
		status = E_FAIL;
	break;
  }

  return status;
}

Uint8 TPS65023_reg_read(Uint32 instance, Uint8 regOffset, Uint8 *buf )
{
    Uint32 status = E_PASS;

	if(instance >= TPS_MAX_NUM_DEVICES) return E_FAIL;

    status = I2C_writeBytes(tpsConfigObj[instance].hI2cInfo,1u, &regOffset);

    if(status != E_PASS){
		status = I2C_readBytes(tpsConfigObj[instance].hI2cInfo,1u, buf);
	}
    
    return status;
}

Uint32 TPS65023_reg_write(Uint32 instance, Uint8 regOffset, Uint8 regVal)
{

  Uint32  status  = E_PASS;
  Uint8   buf[2];

  if(instance >= TPS_MAX_NUM_DEVICES) return E_FAIL; 

  buf[0] = regOffset;
  buf[1] = regVal;

  status = I2C_writeBytes(tpsConfigObj[instance].hI2cInfo, 2u,&buf[0]);    

  return status;
}

Uint32 TPS65023_set_DCDC1_voltage(Uint32 instance, Uint16 volt)
{
  Uint32  status  = E_PASS;

  if(instance >= TPS_MAX_NUM_DEVICES) return E_FAIL;   

  status = TPS65023_open(instance);
  
  switch (volt)
  {
    /* For valid values just go and set the register value */
    case TPS_VDCDC1_MILLIVOLT_800  :
    case TPS_VDCDC1_MILLIVOLT_825  :
    case TPS_VDCDC1_MILLIVOLT_850  :
    case TPS_VDCDC1_MILLIVOLT_875  :
    case TPS_VDCDC1_MILLIVOLT_900  :
    case TPS_VDCDC1_MILLIVOLT_925  :
    case TPS_VDCDC1_MILLIVOLT_950  :
    case TPS_VDCDC1_MILLIVOLT_975  :
    case TPS_VDCDC1_MILLIVOLT_1000 :
    case TPS_VDCDC1_MILLIVOLT_1025 :
    case TPS_VDCDC1_MILLIVOLT_1050 :
    case TPS_VDCDC1_MILLIVOLT_1075 :
    case TPS_VDCDC1_MILLIVOLT_1100 :
    case TPS_VDCDC1_MILLIVOLT_1125 :
    case TPS_VDCDC1_MILLIVOLT_1150 :
    case TPS_VDCDC1_MILLIVOLT_1175 :
    case TPS_VDCDC1_MILLIVOLT_1200 :
    case TPS_VDCDC1_MILLIVOLT_1225 :
    case TPS_VDCDC1_MILLIVOLT_1250 :
    case TPS_VDCDC1_MILLIVOLT_1275 :
    case TPS_VDCDC1_MILLIVOLT_1300 :
    case TPS_VDCDC1_MILLIVOLT_1325 :
    case TPS_VDCDC1_MILLIVOLT_1350 :
    case TPS_VDCDC1_MILLIVOLT_1375 :
    case TPS_VDCDC1_MILLIVOLT_1400 :
    case TPS_VDCDC1_MILLIVOLT_1425 :
    case TPS_VDCDC1_MILLIVOLT_1450 :
    case TPS_VDCDC1_MILLIVOLT_1475 :
    case TPS_VDCDC1_MILLIVOLT_1500 :
    case TPS_VDCDC1_MILLIVOLT_1525 :
    case TPS_VDCDC1_MILLIVOLT_1550 :
    case TPS_VDCDC1_MILLIVOLT_1600 :
         /*
          1. Set the value of desired voltage in DEFCORE register
          DEFCORE register, Set to 1.31V
         */
        status = TPS65023_reg_write(instance, TPS_REG_OFFSET_DEFCORE, volt);
        
        if(status == E_PASS) {
        /* 
          2. Start the transition
          Set GO bit in CTRL2 register
         */
        	status = TPS65023_reg_write(instance, TPS_REG_OFFSET_CONCTRL2, 0x80);
		}
        
    break;

   default:
        status = E_FAIL;
   }
  
  return status;
}
