
// Includes

// generic
#include <std.h>

// psp
//#include "psp_i2c.h"
//#include "dda_i2c.h"
//#include "psp_common.h"

#include "i2c_control.h"

#define CSL_I2C_OWN_ADDR            (0x2F)
//#define I2C_BUS_FREQ            (10000u)

// for configuration
#define CSL_I2C_SYS_CLK          (12)    // In MHz
#define CSL_I2C_BUS_FREQ         (100)    // In KHz

// for reading
//#define CSL_I2C_DATA_SIZE        (16)
//#define CSL_I2C_EEPROM_ADDR      (0x50)
//#define CSL_I2CEEPROM_ADDR_SIZE  (2)

//Uint16      hi2c = NULL;
CSL_Status      i2cStatus;
CSL_I2cSetup    i2cSetup;


void i2c_initialize(void)
{
    i2cSetup.addrMode    = CSL_I2C_ADDR_7BIT;
    i2cSetup.bitCount    = CSL_I2C_BC_8BITS;
    i2cSetup.loopBack    = CSL_I2C_LOOPBACK_DISABLE;
    i2cSetup.freeMode    = CSL_I2C_FREEMODE_DISABLE;
    i2cSetup.repeatMode  = CSL_I2C_REPEATMODE_DISABLE;
    i2cSetup.ownAddr     = CSL_I2C_OWN_ADDR;
    i2cSetup.sysInputClk = CSL_I2C_SYS_CLK;
    i2cSetup.i2cBusFreq  = CSL_I2C_BUS_FREQ;

    i2cStatus = I2C_init(CSL_I2C0); // initializes the i2c bus for all future com
    //hi2c = I2C_Init(I2C_OWN_ADDR, 100000); // initializes the i2c bus for all future com

    i2cStatus = I2C_setup(&i2cSetup);
}

void i2c_delay(Uint16 delay)
{
    Uint16 j;

    for (j=0;j<delay;++j) asm(" NOP");
}
