
#ifndef _DISPLAY_CONTROL_H_
#define _DISPLAY_CONTROL_H_

//#include <cslr.h>
//#include <tistdtypes.h>
//#include <csl_general.h>

// High level display commands
Int16 printchar(unsigned char a);                                           // Print a character on the display (current pos)
Int16 printstring(char *string);                                            // Print the null terminated string on the display (current pos)
void  print_top(char *string);                                              // Print string on top line
void  print_bottom(char *string);                                           // Print string on bottom line
Int16 print_two(char *topline, char *bottomline);                           // Print first string on top line and second string on bottom line
Int16 print_SEI_message();                                                  // Print SEI ID message
Int16 print_charROM();                                                      // Print TI message from Char ROM
void  display_bargraph (Uint16 *levels, Int16 size, Int32 min, Int32 max);  // Print a bar graph using array of size with levels between min and max

// Low Level OLED controller commands
Int16 oled_init();                                                          // Initialize OLED display
Int16 oled_clear();                                                         // Clear OLED display
Int16 oled_hscroll();                                                       // Place display in horizontal scroll mode
Int16 oled_hvscroll();                                                      // Place display in horizontal and vertical scroll mode
Int16 oled_scroll_on();                                                     // Turn on scrolling
Int16 oled_scroll_off();                                                    // Turn off scrolling
Int16 oled_page0();                                                         // Switch to page 0 (bottom line)
Int16 oled_page1();                                                         // Switch to page 1 (top line)
void  oled_vertical_mode();                                                 // Place display controller in vertical mode (auto increment vertically)
void  oled_horizontal_mode();                                               // Place display controller in horizontal mode (auto increment horizontally)
void  oled_page_mode();                                                     // Place display in page mode (auto increment to next page at end of line)
void  oledOn();                                                             // Turn the display on
void  oledOff();                                                            // Turn the display off (sleep)
void  oledFullOn();                                                         // Light up the entire display
void  oledFullOff();                                                        // Shut off the entire display
void  oled_page_column0();                                                  // Set the column start address to 0 - page mode only
void  oled_hv_address_range();                                              // Set hv range for this display - h and v mode only

#endif
