/***************************************************************************************************************
*
*  File name:        FS_RamTst.h
*  Copyright:        Neusoft Corporation. All rights reserved.
*  Notes:            FS RamTst
*  History:
*  Revision        Data        Name              Comment
*  ----------------------------------------------------------------------------------------------------------
*  1.0            2022.04.02  SuiGuoqing     New Create  *
**************************************************************************************************************/


#ifndef FS_RAMTST_H_
#define FS_RAMTST_H_

/**************************************************************************************************************
*  Includes
**************************************************************************************************************/
#include <stdint.h>
#include <ti/csl/hw_types.h>
#include <Std_Types.h>

#include "Rte_IoHwAbSelf.h"

#include "FS_RamTst_ECC.h"
#include "FS_RamTst_pbist.h"

#include <ti/drv/sciclient/sciclient.h>

#include "FS_ESM_Types.h"
#include "FS_ESM_Cfg.h"

#include "app_utils.h"
/**************************************************************************************************************
*  Symbols definition
**************************************************************************************************************/
#define MSG_NORMAL      (0x02U)
/* FS RamTstģ鿪 */
#define REACHFS_RAMTST_ON                                           (0x01U)
#define REACHFS_RAMTST_OFF                                          (0x02U)
          
#define REACHFS_RAMTST_SWITCH                                       REACHFS_RAMTST_ON
          
/* Ĵȴcounter */          
#define FSRAMTST_WAIT_CNT                                           (1000U)
                                        
/* ECCԼȴעcounter */
#define FSRAMTST_WAIT_ERR_CNT                                       (1000U)
                                        
/* ECCԼcounter */                                        
#define FSRAMTST_SELFTST_CNT                                        (3U)

/* PBISTcounter */                                        
#define FSRAMTST_PBISTTST_CNT                                       (3U)
          
/* ʧ/ɹ */
#define FSRAMTST_ERROR                                              (1U)
#define FSRAMTST_NO_ERROR                                           (0U)

/* Ƿִд˲ */
#define FSRAMTST_TO_DO                                              (1U)
#define FSRAMTST_NOT_TO_DO                                          (0U)

/* PBIST INSTANCE */
#define FSRAMTST_PBIST_INSTANCE_CNT                                 (3U)

/* MCU Interrupt ID  */
#define FSRAMTST_MCU_INTRPTID_CNT                                   (12U)

/* WKUP Interrupt ID  */
#define FSRAMTST_WKUP_INTRPTID_CNT                                  (2U)

/* PBIST err code */
#define FSRAMTST_PBIST_PASS                                         ( (int32_t) (0))

/* ĴƫƵַ */  
#define OADDR_ECC_VECTOR                                            (0x00000008U)

#define OADDR_ECC_CTRL                                              (0x00000014U)
#define OADDR_ECC_ERR_CTRL1                                         (0x00000018U)
#define OADDR_ECC_ERR_CTRL2                                         (0x0000001CU)
#define OADDR_ECC_ERR_STAT1                                         (0x00000020U)
#define OADDR_ECC_ERR_STAT2                                         (0x00000024U)
#define OADDR_ECC_ERR_STAT3                                         (0x00000028U)

#define OADDR_ECC_CBASS_CTRL                                        (0x00000014U)
#define OADDR_ECC_CBASS_ERR_CTRL1                                   (0x00000018U)
#define OADDR_ECC_CBASS_ERR_CTRL2                                   (0x0000001CU)
#define OADDR_ECC_CBASS_ERR_STAT1                                   (0x00000020U)
#define OADDR_ECC_CBASS_ERR_STAT2                                   (0x00000024U)

#define OADDR_ECC_SEC_EOI_REG                                       (0x0000003CU)
#define OADDR_ECC_SEC_STATUS_REG0                                   (0x00000040U)
#define OADDR_ECC_SEC_STATUS_REG1                                   (0x00000044U)
#define OADDR_ECC_SEC_STATUS_REG2                                   (0x00000048U)
#define OADDR_ECC_SEC_STATUS_REG3                                   (0x0000004CU)
#define OADDR_ECC_SEC_ENABLE_SET_REG0                               (0x00000080U)
#define OADDR_ECC_SEC_ENABLE_SET_REG1                               (0x00000084U)
#define OADDR_ECC_SEC_ENABLE_SET_REG2                               (0x00000088U)
#define OADDR_ECC_SEC_ENABLE_SET_REG3                               (0x0000008CU)

#define OADDR_ECC_DED_EOI_REG                                       (0x0000013CU)
#define OADDR_ECC_DED_STATUS_REG0                                   (0x00000140U)
#define OADDR_ECC_DED_STATUS_REG1                                   (0x00000144U)
#define OADDR_ECC_DED_STATUS_REG2                                   (0x00000148U)
#define OADDR_ECC_DED_STATUS_REG3                                   (0x0000014CU)
#define OADDR_ECC_DED_ENABLE_SET_REG0                               (0x00000180U)
#define OADDR_ECC_DED_ENABLE_SET_REG1                               (0x00000184U)
#define OADDR_ECC_DED_ENABLE_SET_REG2                               (0x00000188U)
#define OADDR_ECC_DED_ENABLE_SET_REG3                               (0x0000018CU)

#define OADDR_ECC_AGGR_ENABLE_SET                                   (0x00000200U)

/* Ĵֶ */
    /* ECC_VECTOR */
#define ECC_VECTOR_ECC_VECTOR_MASK                                  (0x000007FFU)
#define ECC_VECTOR_ECC_VECTOR_SHIFT                                 (0U)
    
#define ECC_VECTOR_RD_SVBUS_MASK                                    (0x00008000U)
#define ECC_VECTOR_RD_SVBUS_SHIFT                                   (15U)
    
#define ECC_VECTOR_RD_SVBUS_ADDRESS_MASK                            (0x00FF0000U)
#define ECC_VECTOR_RD_SVBUS_ADDRESS_SHIFT                           (16U)
    
#define ECC_VECTOR_RD_SVBUS_DONE_MASK                               (0x01000000U)
#define ECC_VECTOR_RD_SVBUS_DONE_SHIFT                              (24U)

    /* ECC_CTRL */
#define ECC_CTRL_CHECK_PARITY_MASK                                  (0x00000080U)
#define ECC_CTRL_CHECK_PARITY_SHIFT                                 (7U)

#define ECC_CTRL_ENABLE_RMW_MASK                                    (0x00000004U)
#define ECC_CTRL_ENABLE_RMW_SHIFT                                   (2U)

#define ECC_CTRL_ECC_CHECK_MASK                                     (0x00000002U)
#define ECC_CTRL_ECC_CHECK_SHIFT                                    (1U)

#define ECC_CTRL_ECC_ENABLE_MASK                                    (0x00000001U)
#define ECC_CTRL_ECC_ENABLE_SHIFT                                   (0U)

#define ECC_CTRL_CHECK_SVBUS_TIMEOUT_MASK                           (0x00000100U)
#define ECC_CTRL_CHECK_SVBUS_TIMEOUT_SHIFT                          (8U)

    /* ECC_AGGR_ENABLE_SET */
#define ECC_AGGR_ENABLE_SET_PARITY_MASK                             (0x00000001U) 
#define ECC_AGGR_ENABLE_SET_PARITY_SHIFT                            (0U)

#define ECC_AGGR_ENABLE_SET_TIMEOUT_MASK                            (0x00000002U) 
#define ECC_AGGR_ENABLE_SET_TIMEOUT_SHIFT                           (1U)

    /* ECC_ERR_STAT1 */
#define ECC_ERR_STAT1_ECC_SEC_ADC_MASK                              (0x00000001U)
#define ECC_ERR_STAT1_ECC_SEC_ADC_SHIFT                             (0U)

#define ECC_ERR_STAT1_ECC_SEC_MASK                                  (0x00000003U)
#define ECC_ERR_STAT1_ECC_SEC_SHIFT                                 (0U)

#define ECC_ERR_STAT1_ECC_DED_ADC_MASK                              (0x00000002U)
#define ECC_ERR_STAT1_ECC_DED_ADC_SHIFT                             (1U)

#define ECC_ERR_STAT1_ECC_DED_MASK                                  (0x0000000CU)
#define ECC_ERR_STAT1_ECC_DED_SHIFT                                 (2U)

#define ECC_ERR_STAT1_PARITY_ERR_MASK                               (0x00000060U)
#define ECC_ERR_STAT1_PARITY_ERR_SHIFT                              (5U)

#define ECC_ERR_STAT1_CLR_ECC_SEC_ADC_MASK                          (0x00000100U)
#define ECC_ERR_STAT1_CLR_ECC_SEC_ADC_SHIFT                         (8U)

#define ECC_ERR_STAT1_CLR_ECC_SEC_MASK                              (0x00000300U)
#define ECC_ERR_STAT1_CLR_ECC_SEC_SHIFT                             (8U)

#define ECC_ERR_STAT1_CLR_ECC_DED_ADC_MASK                          (0x00000200U)
#define ECC_ERR_STAT1_CLR_ECC_DED_ADC_SHIFT                         (9U)

#define ECC_ERR_STAT1_CLR_ECC_DED_MASK                              (0x00000C00U)
#define ECC_ERR_STAT1_CLR_ECC_DED_SHIFT                             (10U)

#define ECC_ERR_STAT1_CLR_PARITY_ERR_MASK                           (0x00006000U)
#define ECC_ERR_STAT1_CLR_PARITY_ERR_SHIFT                          (13U)

    /* ECC_ERR_STAT3 */
#define ECC_ERR_STAT3_SVBUS_TIMEOUT_ERR_MASK                        (0x00000002U)
#define ECC_ERR_STAT3_SVBUS_TIMEOUT_ERR_SHIFT                       (1U)

#define ECC_ERR_STAT3_CLR_SVBUS_TIMEOUT_ERR_MASK                    (0x00000200U)
#define ECC_ERR_STAT3_CLR_SVBUS_TIMEOUT_ERR_SHIFT                   (9U)

    /* ECC_SEC_EOI_REG */
#define ECC_SEC_EOI_REG_EOI_WR_MASK                                 (0x00000001U)
#define ECC_SEC_EOI_REG_EOI_WR_SHIFT                                (0U)

    /* ECC_DED_EOI_REG */
#define ECC_DED_EOI_REG_EOI_WR_MASK                                 (0x00000001U)
#define ECC_DED_EOI_REG_EOI_WR_SHIFT                                (0U)

    /* ECC_CTRL */
#define ECC_CTRL_ERROR_ONCE_MASK                                    (0x00000040U)
#define ECC_CTRL_ERROR_ONCE_SHIFT                                   (6U)

#define ECC_CTRL_FORCE_SEC_MASK                                     (0x00000008U)
#define ECC_CTRL_FORCE_SEC_SHIFT                                    (3U)

#define ECC_CTRL_FORCE_DED_MASK                                     (0x00000010U)
#define ECC_CTRL_FORCE_DED_SHIFT                                    (4U)

    /* ECC_ERR_CTRL1 */
#define ECC_ERR_CTRL1_ECC_ROW_MASK                                  (0xFFFFFFFFU)
#define ECC_ERR_CTRL1_ECC_ROW_SHIFT                                 (0U)

    /* ECC_ERR_CTRL2 */
#define ECC_ERR_CTRL2_ECC_BIT1_MASK                                 (0x0000FFFFU)
#define ECC_ERR_CTRL2_ECC_BIT1_SHIFT                                (0U)

#define ECC_ERR_CTRL2_ECC_BIT2_MASK                                 (0xFFFF0000U)
#define ECC_ERR_CTRL2_ECC_BIT2_SHIFT                                (16U)

    /* ECC_CBASS_CTRL */
#define ECC_CBASS_CTRL_ECC_CHECK_MASK                               (0x00000002U)
#define ECC_CBASS_CTRL_ECC_CHECK_SHIFT                              (1U)

#define ECC_CBASS_CTRL_FORCE_N_BIT_MASK                             (0x00000020U)
#define ECC_CBASS_CTRL_FORCE_N_BIT_SHIFT                            (5U)

#define ECC_CBASS_CTRL_FORCE_SE_MASK                                (0x00000008U)
#define ECC_CBASS_CTRL_FORCE_SE_SHIFT                               (3U)

#define ECC_CBASS_CTRL_FORCE_DE_MASK                                (0x00000010U)
#define ECC_CBASS_CTRL_FORCE_DE_SHIFT                               (4U)

    /* ECC_CBASS_ERR_CTRL1 */
#define ECC_CBASS_ERR_CTRL1_ECC_BIT1_MASK                           (0x01FF0000U)
#define ECC_CBASS_ERR_CTRL1_ECC_BIT1_SHIFT                          (16U)

#define ECC_CBASS_ERR_CTRL1_ECC_GRP_MASK                            (0x0000FFFFU)
#define ECC_CBASS_ERR_CTRL1_ECC_GRP_SHIFT                           (0U)

    /* ECC_CBASS_ERR_CTRL2 */
#define ECC_CBASS_ERR_CTRL2_ECC_BIT2_MASK                           (0x000001FFU)
#define ECC_CBASS_ERR_CTRL2_ECC_BIT2_SHIFT                          (0U)


/* ECC_CBASS_ERR_STAT1 */
#define ECC_CBASS_ERR_STAT1_COR_PEND_MASK                           (0x00000003U)
#define ECC_CBASS_ERR_STAT1_COR_PEND_SHIFT                          (0U)

#define ECC_CBASS_ERR_STAT1_COR_PEND_CLR_MASK                       (0x00000300U)
#define ECC_CBASS_ERR_STAT1_COR_PEND_CLR_SHIFT                      (8U)

#define ECC_CBASS_ERR_STAT1_UNC_PEND_MASK                           (0x0000000CU)
#define ECC_CBASS_ERR_STAT1_UNC_PEND_SHIFT                          (2U)

#define ECC_CBASS_ERR_STAT1_UNC_PEND_CLR_MASK                       (0x00000C00U)
#define ECC_CBASS_ERR_STAT1_UNC_PEND_CLR_SHIFT                      (10U)

#define ECC_CBASS_ERR_STAT1_INJ_COR_PEND_CLR_MASK                   (0x00003000U)
#define ECC_CBASS_ERR_STAT1_INJ_COR_PEND_CLR_SHIFT                  (12U)

#define ECC_CBASS_ERR_STAT1_INJ_UNC_PEND_CLR_MASK                   (0x0000C000U)
#define ECC_CBASS_ERR_STAT1_INJ_UNC_PEND_CLR_SHIFT                  (14U)

/* Ĵֵֶ */  
    /* ECCĴд */  
#define FSRAMTST_VALUE_RD_SVBUS_SETRD                               (1U)
#define FSRAMTST_VALUE_RD_SVBUS_SETWR                               (0U)
#define FSRAMTST_VALUE_RD_SVBUS_DONE_RDDONE                         (1U)
    /* ʼ */          
#define FSRAMTST_VALUE_CHECK_PARITY_EN                              (1U)
#define FSRAMTST_VALUE_ENABLE_RMW_EN                                (1U)
#define FSRAMTST_VALUE_ECC_CHECK_EN                                 (1U)
#define FSRAMTST_VALUE_ECC_ENABLE_EN                                (1U)
#define FSRAMTST_VALUE_CHECK_SVBUS_TIMEOUT_EN                       (1U)
#define FSRAMTST_VALUE_TIMEOUT_EN                                   (1U)
#define FSRAMTST_VALUE_PARITY_EN                                    (1U)

    /* ϼ Correctable */
#define FSRAMTST_VALUE_ECC_SEC_CONFIRM_ERR_ADC                      (1U)          
#define FSRAMTST_VALUE_ECC_SEC_CONFIRM_ERR                          (3U)
#define FSRAMTST_VALUE_CLR_ECC_SEC_CLR_ERR_ADC                      (1U)
#define FSRAMTST_VALUE_CLR_ECC_SEC_CLR_ERR                          (3U)
#define FSRAMTST_VALUE_SEC_EOI_WR_END_INT                           (1U)

#define FSRAMTST_VALUE_COR_PEND                                     (1U)
#define FSRAMTST_VALUE_COR_PEND_CLR                                 (1U)

    /* ϼ Uncorrectable */   
#define FSRAMTST_VALUE_ECC_DED_CONFIRM_ERR_ADC                      (1U)       
#define FSRAMTST_VALUE_ECC_DED_CONFIRM_ERR                          (3U)
#define FSRAMTST_VALUE_CLR_ECC_DED_CLR_ERR_ADC                      (1U)
#define FSRAMTST_VALUE_CLR_ECC_DED_CLR_ERR                          (3U)
#define FSRAMTST_VALUE_PARITY_ERR_CONFIRM_ERR                       (3U)
#define FSRAMTST_VALUE_CLR_PARITY_ERR_CLR_ERR                       (3U)
#define FSRAMTST_VALUE_SVBUS_TIMEOUT_CONFIRM_ERR                    (1U)
#define FSRAMTST_VALUE_SVBUS_TIMEOUT_ERR_CLR_ERR                    (1U)
#define FSRAMTST_VALUE_DED_EOI_WR_END_INT                           (1U)

#define FSRAMTST_VALUE_UNC_PEND                                     (1U)
#define FSRAMTST_VALUE_UNC_PEND_CLR                                 (1U)

    /*  ECCԼ */          
#define FSRAMTST_VALUE_ERROR_ONCE_SIM_ERR                           (1U)
#define FSRAMTST_VALUE_SET_CORR_ERR                                 (1U)
#define FSRAMTST_VALUE_SET_UNCORR_ERR                               (1U)
#define FSRAMTST_VALUE_FORCE_WAIT_ERR_COMPLETE                      (0U)
#define FSRAMTST_VALUE_ECC_NO_ERR                                   (0U)
#define FSRAMTST_VALUE_ERR_BIT                                      (0U)
#define FSRAMTST_VALUE_ERR_ECC_ROW                                  (0U)

#define FSRAMTST_VALUE_FORCE_N_BIT                                  (0U)
#define FSRAMTST_VALUE_ERR_GRP                                      (0U)
#define FSRAMTST_VALUE_FORCE_SE                                     (1U)
#define FSRAMTST_VALUE_FORCE_DE                                     (1U)
                                  
/* Ϣ */          
#define FSRAMTST_MODX_ECCID_CORR_ERR                                (0x00000001U)  /* ECCɻָ */
#define FSRAMTST_MODX_ECCID_UNCORR_ERR                              (0x00000002U)  /* ECCɻָ */
#define FSRAMTST_MODX_ECCID_INTERFACE_ERR                           (0x00000004U)  /* ECCӿڳʱ */
#define FSRAMTST_MODX_ECCID_PARITY_ERR                              (0x00000008U)  /* żУ */
#define FSRAMTST_ECC_CORR_SELFTST_ERR                               (0x00000010U)  /* ECCԼ */
#define FSRAMTST_ECC_UNCORR_SELFTST_ERR                             (0x00000020U)  /* ECCԼ */
#define FSRAMTST_PBSIT_HW_POST_FAILED                               (0x00000040U)  /* PBISTӲPOST */
#define FSRAMTST_PBSIT_MOD_SELFTST_FAILED                           (0x00000080U)  /* PBIST Լ */
#define FSRAMTST_PBSIT_MOD_FAILED                                   (0x00000100U)  /* PBSIT  */

/*************************************************************************************************************
*  Type definition
**************************************************************************************************************/
/* ҪдECCĴƫƵֶַ */
typedef struct {
    uint32_t u32EccId;
    uint32_t u32EccRegBaseAddr;
    uint32_t u32EccRegOffsetAddr;
    uint32_t u32FeildMask;
    uint32_t u32FeildShift;
} InfoOfEccReg_st;

typedef enum {
  FS_RAMTST_SELFTST_CORR,
  FS_RAMTST_SELFTST_UNCORR
} FS_RamTst_ErrType_en;

typedef enum {
  ECC_SEC_ENABLE_SET_REG_N,
  ECC_DED_ENABLE_SET_REG_N,
  ECC_SEC_STATUS_REG_N,
  ECC_DED_STATUS_REG_N
} RegN_en;

typedef struct {
    uint32_t u32INTRPTId;
    SDL_ECC_MemType eccMemType;
}FS_RamTst_INTRPTIdToMod_st;

/*************************************************************************************************************
*  Global variable
**************************************************************************************************************/
/* Ϸĵַ */
extern uint32_t gU32RamTstErrAddr;

/*************************************************************************************************************
*  Declare
**************************************************************************************************************/
/* ʼ */
void FS_RamTst_Init(void);

/* ϼ */
void FS_RamTst_ECCCorrISR(FS_ESM_InstanceType enInstType, uint32_t u32EsmINTRPTId);
void FS_RamTst_ECCUncorrISR(FS_ESM_InstanceType enInstType, uint32_t u32EsmINTRPTId);

/* Ĵ */
uint8_t FS_RamTst_RegCheck(void);

/* ECCԼ */
void FS_RamTst_ECCSelfTst(void);

/* PBIST */
void FS_RamTst_PBSITTst(void);

/* ں㱨 */
void FS_RamTst_MainFunc(void);

#endif
