/*
 * data.h
 *
 *  Created on: Feb 18, 2014
 *      Author: mpigsley
 */

#ifndef DATA_H_
#define DATA_H_

#define NUM_FILT_TAPS 76
#define SIG_LENGTH 24000
#define BLOCK_SIZE 48

/* Filter Taps (76) where M = 75 */
const int16_t taps[] = {
	   -11,    -10,    -13,    -14,    -13,     -9,      0,     13,
		30,     50,     71,     90,    102,    105,     94,     67,
		22,    -40,   -116,   -202,   -288,   -365,   -420,   -441,
	  -416,   -336,   -192,     17,    290,    619,    990,   1387,
	  1788,   2170,   2511,   2788,   2984,   3085,   3085,   2984,
	  2788,   2511,   2170,   1788,   1387,    990,    619,    290,
		17,   -192,   -336,   -416,   -441,   -420,   -365,   -288,
	  -202,   -116,    -40,     22,     67,     94,    105,    102,
		90,     71,     50,     30,     13,      0,     -9,    -13,
	   -14,    -13,    -10,    -11,
};

/* Pre-generated input sig, X * 16-bit signed samples */
const int16_t sig[] = {
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330
};

#endif /* DATA_H_ */
