/*
 * data.h
 *
 *  Created on: Feb 18, 2014
 *      Author: mpigsley
 */

#ifndef DATA_H_
#define DATA_H_

#define NUM_FILT_TAPS 50
#define SIG_LENGTH 24000
#define BLOCK_SIZE 48

/* Filter Taps (50) where M = 49 */
const int16_t taps[] = {
        -7,    -16,    -31,    -53,    -82,   -117,   -157,   -195,   -228,   -246,   -240,   -202,   -121,      8,    190,    425,
       708,   1030,   1377,   1730,   2070,   2374,   2624,   2800,   2892,   2892,   2800,   2624,   2374,   2070,   1730,   1377,
      1030,    708,    425,    190,      8,   -121,   -202,   -240,   -246,   -228,   -195,   -157,   -117,    -82,    -53,    -31,
       -16,     -7,
};

/* Pre-generated input sig, 24000 * 16-bit signed samples */
const int16_t sig[] = {
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16384,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16383,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330,
         0,  10330,  18429,  22653,  22380,  18165,  11585,   4806,      0,  -1247,   1637,   8052,  16383,  24435,  30014,  31520,
     28377,  21190,  11585,   1782,  -5997, -10114,  -9948,  -6053,      0,   6053,   9948,  10114,   5997,  -1782, -11585, -21190,
    -28377, -31520, -30014, -24435, -16384,  -8052,  -1637,   1247,      0,  -4806, -11585, -18165, -22380, -22653, -18429, -10330
};

#endif /* DATA_H_ */
