/******************************************************************************
**+-------------------------------------------------------------------------+**
**|                            ****                                         |**
**|                            ****                                         |**
**|                            ******o***                                   |**
**|                      ********_///_****                                  |**
**|                      ***** /_//_/ ****                                  |**
**|                       ** ** (__/ ****                                   |**
**|                           *********                                     |**
**|                            ****                                         |**
**|                            ***                                          |**
**|                                                                         |**
**|         Copyright (c) 2006 - 2010    Texas Instruments Incorporated     |**
**|                        ALL RIGHTS RESERVED                              |**
**|                                                                         |**
**| Permission is hereby granted to licensees of Texas Instruments          |**
**| Incorporated (TI) products to use this computer program for the sole    |**
**| purpose of implementing a licensee product based on TI products.        |**
**| No other rights to reproduce, use, or disseminate this computer         |**
**| program, whether in part or in whole, are granted.                      |**
**|                                                                         |**
**| TI makes no representation or warranties with respect to the            |**
**| performance of this computer program, and specifically disclaims        |**
**| any responsibility for any damages, special or consequential,           |**
**| connected with the use of this program.                                 |**
**|                                                                         |**
**+-------------------------------------------------------------------------+**
******************************************************************************/
#include <stdio.h>
#include "data_types.h"
#include "register_system.h"
#include "register_cpu.h"
#include "lcd.h"
#include "sar.h"
#include "rtc.h"
#include "control.h"
#include "i2s.h"
#include "dma.h"
#include "timer.h"


void InitSystem(void);
void ConfigPort(void);
void SYS_GlobalIntEnable(void);
void SYS_GlobalIntDisable(void);
void BlinkLED(void);

Uint16 key;
Uint16 fLedBlinkOn =0;
Uint16 stDMA =0;
Uint16 fSineWave = 0;
Uint16 fMenu = 1;
extern Uint16 Conunt_RTC;
extern void AIC3254_init(void);

void main(void)
{
    InitSystem();
    ConfigPort();

    SYS_GlobalIntEnable();
    
    IER0 = 0x0010;      // enable timer int      
    IER1 = 0x0004;      // enable RTC int

    init_LCD(0);
	menu1_on_LCD();
    Init_SAR();
    Timer0Init();
	reset_RTC();
	enable_rtc_second_int();

	AIC3254_init();
	set_i2s2_master();
    enable_i2s2();

    
                        
    while(1)
    {
		StartTimer0();
		*(ioport volatile unsigned *)0x0001 = 0x0001;
		asm("	idle");

        key = Get_Sar_Key();
        
        if(fMenu ==1)
        {
            switch(key)
            {
                case SW7:
                    if(fMenu ==1)
                    {
                        fMenu =2;
                        fLedBlinkOn=0;
                        draw_line();
                    }                
                break;
                case SW8:

                break;
                case SW9:
                    // enable LED blinking
                        fLedBlinkOn =1;                
                break;
                case SW10:
                    // disable LED blinking
                        fLedBlinkOn =0;            
                break;
                case SW11:
                    wait(1000);
                break;
                case SW6:
                    wait(1000);
                break;
                case SW12:
		    		reset_RTC();
                break;
                case SW13:
		    		wait(1000);
                break;
                case SW14:
		    		wait(1000);
                break;
                case SW15:

                break;
                
            }
            if(fMenu ==2)
                continue;
            BlinkLED();
            //Audio_out();   
            display_RTC();     
        }
        else
        {
            switch(key)
            {
                case SW7:
                    if(fMenu ==2)
                    {
                        fMenu =1;
                        if(stDMA ==1)
                        {
                            set_dma1_ch0_stop();
		    		        set_dma1_ch1_stop();
		    		        stDMA =0;
		    		    }                
                        menu1_on_LCD();
                    }
                break;
                case SW8:

                break;
                case SW9:
                    if(stDMA ==1)
                    {
                        set_dma1_ch0_stop();
		    		    set_dma1_ch1_stop();
		    		    draw_line();
		    		    stDMA =0;
		    		}                
                break;
                case SW10:
                    if(stDMA ==0)
                    {
                        fSineWave =1;
                        set_dma1_ch0_i2s2_Lout();
		    		    set_dma1_ch1_i2s2_Rout();
		    		    draw_sine_1k();
		    		    stDMA =1;
		    		}
                break;
                case SW11:
		    		wait(1000);            
                break;
                case SW6:
		    		wait(1000);
                break;
                case SW12:
                    if(stDMA ==0)
                    {
                        fSineWave =2;
                        set_dma1_ch0_i2s2_Lout();
		    		    set_dma1_ch1_i2s2_Rout();
		    		    draw_sine_2k();
		    		    stDMA =1;
		    		}

                break;
                case SW13:
		    		wait(1000);
                break;
                case SW14:
		    		wait(1000);
                break;
                case SW15:


                break;
                
            }
        }
                
	}

}

void InitSystem(void)
{
	Uint16 i;
// PLL set up from RTC
    // bypass PLL
    CONFIG_MSW = 0x0;

#if (PLL_100M ==1)
    PLL_CNTL2 = 0x8000;
    PLL_CNTL4 = 0x0000;
    PLL_CNTL3 = 0x0806;
    PLL_CNTL1 = 0x82FA;
    
#elif (PLL_12M ==1)
    PLL_CNTL2 = 0x8000;
    PLL_CNTL4 = 0x0200;
    PLL_CNTL3 = 0x0806;
    PLL_CNTL1 = 0x82ED;
#elif (PLL_98M ==1)    
    PLL_CNTL1 =  0x8BE8;
    PLL_CNTL2 =  0x8000;
    PLL_CNTL3 =  0x0806;
    PLL_CNTL4 =  0x0000; 
    
#endif



    while ( (PLL_CNTL3 & 0x0008) == 0);
    // Switch to PLL clk
    CONFIG_MSW = 0x1;

// clock gating
// enable all clocks
    IDLE_PCGCR = 0;
    IDLE_PCGCR_MSW = 0xFF84;
    

// reset peripherals
    PER_RSTCOUNT = 0x02;
    PER_RESET = 0x00fb;    
    for (i=0; i< 200; i++);
    
}

void ConfigPort(void)
{
    //  configure ports
    PERIPHSEL0 = 0x4A00;        // parallel port: mode 4, serial port: mode 2 
    
}


void SYS_GlobalIntEnable(void)
{
    asm(" BIT (ST1, #ST1_INTM) = #0");
}

void SYS_GlobalIntDisable(void)
{
    asm(" BIT (ST1, #ST1_INTM) = #1");
}

void BlinkLED(void)
{
    Uint16 temp;

    if(fLedBlinkOn ==0)
        return;
            
    if(Conunt_RTC > 0)
    {
        Conunt_RTC =0;
        
        temp = ST1_55;
        if((temp&0x2000) == 0)
        {
            // turn on LED
            temp |= 0x2000;
        }
        else
        {
            // turn off LED
            temp &=0xDFFF;
        }
        ST1_55 = temp; 
    }
    
}
