/**
 *  \file linker.cmd
 *
 *  \brief This file is the linker script for am5x required for building
 *         SBL with the gcc toolchain.
 *
 */

INPUT(
    "C:\ti\pdk_am57xx_1_0_6\packages\ti\board\lib\idkAM571x\a15\release\ti.board.aa15fg"
    "C:\ti\pdk_am57xx_1_0_6\packages\ti\drv\spi\lib\a15\release\ti.drv.spi.aa15fg"
    "C:\ti\pdk_am57xx_1_0_6\packages\ti\drv\i2c\lib\a15\release\ti.drv.i2c.aa15fg"
    "C:\ti\pdk_am57xx_1_0_6\packages\ti\drv\uart\lib\am571x\a15\release\ti.drv.uart.aa15fg"
    "C:\ti\pdk_am57xx_1_0_6\packages\ti\csl\lib\am571x\a15\release\ti.csl.aa15fg"
    "C:\ti\pdk_am57xx_1_0_6\packages\ti\csl\lib\am571x\a15\release\ti.csl.init.aa15fg"
    "C:\ti\pdk_am57xx_1_0_6\packages\ti\osal\lib\nonos\a15\release\ti.osal.aa15fg"
    "C:\ti\pdk_am57xx_1_0_6\packages\ti\fs\fatfs\lib\a15\release\ti.fs.fatfs.aa15fg"
    "C:\ti\pdk_am57xx_1_0_6\packages\ti\drv\mmcsd\lib\a15\release\ti.drv.mmcsd.aa15fg"
    "C:\ti\bios_6_46_04_53\packages\gnu\targets\arm\rtsv7A\lib\syscalls.aa15fg"
)

MEMORY
{
    DDR0 :   o = 0x80000400,  l = (0x40000000 - 0x400) /* external DDR Bank 0 */
    OCMC_RAM1 (RWIX): org = 0x40300000 ,  len = 0x0001FFFF  /* OCMCRAM1 region meant for IO delay relocation */
    MMU_TABLE (RW): org = 0x40370000, len = 0x10000 /* OCMCRAM1 region meant to hold MMU table */
    DSP1TRAMPOLINE (RWIX): org = 0x40330000, len = 0x800 /* Memory area reserved for DSP1 Trampoline */
    DSP2TRAMPOLINE (RWIX): org = 0x40330800, len = 0x800 /* Memory area reserved for DSP2 Trampoline */
    SBL_MEM  (RWIX): org = 0x40331000, len = 0x0004EFFF  /* OCMCRAM1 Region meant for SBL */
    OCMC_RAM2 (RWIX): org = 0x40400000  , len = 0x00100000  /* OCMC RAM        */
    OCMC_RAM3 (RWIX): org = 0x40500000 ,  len = 0x00100000  /* OCMC RAM        */
}

OUTPUT_FORMAT("elf32-littlearm", "elf32-littlearm", "elf32-littlearm")
OUTPUT_ARCH(arm)

SECTIONS
{
        .startcode :
        {
            . = ALIGN(4);
            *(.public.*)
            *sbl_init.ao (.text)
        } >SBL_MEM

        .text :
        {
            . = ALIGN(4);
            *(.text*)
            *(.rodata*)
        } >SBL_MEM

        .data :
        {
            . = ALIGN(4);
            *(.data*)
        } >SBL_MEM

        .bss :
        {
            . = ALIGN(4);
            __bss_start__ = .;
            *(.bss*)
            *(COMMON)
            __bss_end__ = .;
        } >SBL_MEM

        .heap :
        {
            . = ALIGN(4);
            __end__ = .;
            end = __end__;
            __HeapBase = __end__;
            *(.heap*)
            . = . + 0x400;
            __HeapLimit = .;
        } >SBL_MEM

        .stack :
        {
            . = ALIGN(4);
            __StackLimit = . ;
            *(.stack*)
            . = . + 0x10000;
            __StackTop = .;
        } >SBL_MEM
        __stack = __StackTop;

        SBL_MMU_TABLE :
        {
            *(SBL_MMU_TABLE*)
        } > MMU_TABLE
}

