/**
 * \file    demoTouch.c
 *
 * \brief   This file contains Touch Screen related functions.
 */

/*
* Copyright (C) 2012 Texas Instruments Incorporated - http://www.ti.com/ 
*
*  Redistribution and use in source and binary forms, with or without 
*  modification, are permitted provided that the following conditions 
*  are met:
*
*    Redistributions of source code must retain the above copyright 
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the 
*    documentation and/or other materials provided with the   
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include "math.h"
#include "hw_types.h"
#include "i2c.h"
#include "psc.h"
#include "interrupt.h"
#include "TL6748.h"
#include "soc_C6748.h"
#include "hw_psc_C6748.h"
#include "demoTouch.h"
#include "uartStdio.h"

#include "hw_types.h"
#include "hw_syscfg0_OMAPL138.h"	// SYSCFG0_PINMUX(x)
#include "gpio.h"					// GPIO_DIR_INTPUT
#include "interrupt.h"
#include "spi.h"
#include "hw_spi.h"
#include "grlib.h"

/******************************************************************************
**                      INTERNAL MACRO DEFINITIONS
*******************************************************************************/
#define PINMUX5_GPIO2_12_ENABLE    (SYSCFG_PINMUX5_PINMUX5_15_12_GPIO2_12 << \
								    SYSCFG_PINMUX5_PINMUX5_15_12_SHIFT)

#define SIMO_SOMI_CLK_CS1        0x00000E02

#define DEFAULT_XSCALE                    (0.5096)//(0.4134366)
#define DEFAULT_YSCALE                    (0.260162)//(0.3001876)
#define LCD_HEIGHT                        (480)

#define XOFFSET                           (-22.73)//(-22.0031)//(-20)
#define YOFFSET                           (-76.84)//(-20)

#define TOUCH_AD_LEFT     60
#define TOUCH_AD_RIGHT    1992 /*A/Dתصֵ*/
#define TOUCH_AD_TOP      1927
#define TOUCH_AD_BOTTOM   85
#define g_sContext sContext

float xscale = DEFAULT_XSCALE;
float yscale = DEFAULT_YSCALE;
float xoffset = XOFFSET;
float yoffset = YOFFSET;

char touch_flag = 0;
extern unsigned char Flag;
//extern tContext g_sContext;   // ȫʾ
extern tContext sContext;


/*******************************************************************************
**                   INTERNAL FUNCTION PROTOTYPES
*******************************************************************************/
void tsc2046ReadAxis(char mode, int*p1);

/*******************************************************************************
**                     FUNCTION DEFINITIONS
*******************************************************************************/
static void Delay(volatile unsigned int delay)
{
    while(delay--);
}

/*
** Registers the touch ISR.
*/
void TouchIntRegister(unsigned int cpuINT)
{
    IntRegister(cpuINT, TouchIsr);
    IntEventMap(cpuINT, SYS_INT_GPIO_B2INT);
}

/*
 * touch ISR
 */
void TouchIsr(void)
{
//	int xCoOd = 0, yCoOd = 0;

	/* Disable the interrupts for pins of bank 2 in GPIO.*/
	GPIOBankIntDisable(SOC_GPIO_0_REGS, 2);

	//Clear the system interrupt status in the DSPINTC
	IntEventClear(SYS_INT_GPIO_B2INT);

	if (GPIOPinIntStatus(SOC_GPIO_0_REGS, 45) == GPIO_INT_PEND)
	{
		touch_flag = 1;
	}

//	TouchCoOrdGet(&xCoOd, &yCoOd);
//	if((xCoOd>=20) && (xCoOd<=70) && (yCoOd>=400) && (yCoOd<=450))
//	{
//		Flag = 3;
//	}
//	if((xCoOd>=290) && (xCoOd<=340) && (yCoOd>=400) && (yCoOd<=450))
//	{
//		Flag = 3;
//	}

	/* Clears the Interrupt Status of GP2[12] in GPIO.*/
	GPIOPinIntClear(SOC_GPIO_0_REGS, 45);

	/* Enable interrupts for pins of bank 2.*/
	GPIOBankIntEnable(SOC_GPIO_0_REGS, 2);
}

/*
 * TOUCH GPIO2_12 SETUP
 */
void TouchGPIOSetup(void)
{
	volatile unsigned int savePinMux = 0;

	savePinMux = HWREG(SOC_SYSCFG_0_REGS + SYSCFG0_PINMUX(5)) & \
						 ~(SYSCFG_PINMUX5_PINMUX5_15_12);

	HWREG(SOC_SYSCFG_0_REGS + SYSCFG0_PINMUX(5)) = \
    		 (PINMUX5_GPIO2_12_ENABLE | savePinMux);

	/*GPIO2[12]Ϊģʽ*/
	GPIODirModeSet(SOC_GPIO_0_REGS, 45, GPIO_DIR_INPUT);

	/*GPIO2[12]Ϊ½شжģʽ*/
	GPIOIntTypeSet(SOC_GPIO_0_REGS, 45, GPIO_INT_TYPE_FALLEDGE);

	/*GPIO2[150]ж*/
	GPIOBankIntEnable(SOC_GPIO_0_REGS, 2);

}

//ʼ
void TouchInitXY(void)
{
	xscale=(float)800.0 / (TOUCH_AD_RIGHT - TOUCH_AD_LEFT);//õxscale
	xoffset=(float)(800.0 - xscale * TOUCH_AD_RIGHT);//õxoff

	yscale=(float)480.0 / (TOUCH_AD_TOP - TOUCH_AD_BOTTOM);//õyscale
	yoffset=(float)(480.0 - yscale * TOUCH_AD_TOP);//õyoff
}

/*
** Initializes the touch screen 
*/
void TouchInit(void)
{
    //volatile unsigned int delay = 0xffff;
	unsigned int  val = SIMO_SOMI_CLK_CS1;
	unsigned char dcs = 0x01;
	unsigned char cs  = 0x01;

	TouchInitXY();

    TouchGPIOSetup();

    // ʼж
	TouchIntRegister(C674X_MASK_INT4);
	IntEnable(C674X_MASK_INT4);

    /* Waking up the SPI1 instance. */
	PSCModuleControl(SOC_PSC_1_REGS, HW_PSC_SPI1, PSC_POWERDOMAIN_ALWAYS_ON,
					 PSC_MDCTL_NEXT_ENABLE);
	/* Performing the Pin Multiplexing for SPI1. */
	SPIPinMuxSetup(1);
    /*
	** Using the Chip Select(CS) 1 pin of SPI1 to communicate with SPI touch screen.
	** AM1808 EVM mandates us to do so.
	*/
	SPI1CSPinMuxSetup(1);

	SPIReset(SOC_SPI_1_REGS);

	SPIOutOfReset(SOC_SPI_1_REGS);

	SPIModeConfigure(SOC_SPI_1_REGS, SPI_MASTER_MODE); //ģʽ

	SPIClkConfigure(SOC_SPI_1_REGS, 228000000, 1000000, SPI_DATA_FORMAT0);

	SPIPinControl(SOC_SPI_1_REGS, 0, 0, &val);//ʹSIMO_SOMI_CLK_CS1

	SPIDefaultCSSet(SOC_SPI_1_REGS, (dcs<<1)); //CS1ʱΪߵƽ

	/* Configures SPI Data Format Register */
	/* Configures the polarity and phase of SPI clock */
	 SPIConfigClkFormat(SOC_SPI_1_REGS,
					   (SPI_CLK_POL_LOW | SPI_CLK_OUTOFPHASE),  //SPI_CLK_POL_LOW     - Clock is Low  Before and after data transfer.SPI_CLK_POL_HIGH
					   SPI_DATA_FORMAT0);					//SPI_CLK_INPHASE     - Clock is not Delayed.
	 	 	 	 	 	 	 	 	 	 	 	 	 	 	//SPI_CLK_OUTOFPHASE  - Clock is Delayed by half clock cycle.

	 /* Configures SPI to transmit MSB bit First during data transfer */
	 SPIShiftMsbFirst(SOC_SPI_1_REGS, SPI_DATA_FORMAT0);

	 /* Sets the Charcter length */
	 SPICharLengthSet(SOC_SPI_1_REGS, 8, SPI_DATA_FORMAT0);

	 /* Selects the SPI Data format register to used and Sets CSHOLD
      * to assert CS pin(line)
      */
	 SPIDat1Config(SOC_SPI_1_REGS, (SPI_CSHOLD | SPI_DATA_FORMAT0), (cs<<1));

	 /* Enable SPI communication */
	 SPIEnable(SOC_SPI_1_REGS);
}

int Read_touch_ad(void)
{
	int result=0,re1,re2;

	SPITransmitData1(SOC_SPI_1_REGS, 0);
	while( (HWREG(SOC_SPI_1_REGS + SPI_SPIBUF) & 0x80000000 ) );
	re1 = SPIDataReceive(SOC_SPI_1_REGS);

	SPITransmitData1(SOC_SPI_1_REGS, 0);
	while( (HWREG(SOC_SPI_1_REGS + SPI_SPIBUF) & 0x80000000 ) );
	re2 = SPIDataReceive(SOC_SPI_1_REGS);

	result = (re1<<4) + (re2>>4);

	/* Deasserts the CS pin(line) */
	//SPIDat1Config(SOC_SPI_1_REGS, SPI_DATA_FORMAT0, (cs<<1));

	return result;
}

/*
** Reads the x or y cordinates based on mode value
*/
void tsc2046ReadAxis(char mode, int*p1)//, char*p2)
{
    unsigned int result1=0;
    unsigned char count=0,t,t1;
    unsigned int databuffer[30],temp;

    switch(mode)
    {
    case 0:
    	do{
			SPIDat1Config(SOC_SPI_1_REGS, (SPI_CSHOLD | SPI_DATA_FORMAT0), (1<<1));
			SPITransmitData1(SOC_SPI_1_REGS, 0x93);
			Delay(0xf);
			while( (HWREG(SOC_SPI_1_REGS + SPI_SPIBUF) & 0x80000000 ) );
			databuffer[count] = Read_touch_ad();
			count++;
    	}while(count<10);//(PEN==0)&&

    	SPIDat1Config(SOC_SPI_1_REGS, SPI_DATA_FORMAT0, (1<<1));
    	if(count == 10)
    	{
    		 do                                            //X
			{
				t1=0;
				for(t=0;t<count-1;t++)
				{
					if(databuffer[t]>databuffer[t+1])//
					{
						temp=databuffer[t+1];
						databuffer[t+1]=databuffer[t];
						databuffer[t]=temp;
						t1=1;
					}
				}
			}while(t1);
    	}

    	break;
    case 1:
    	//SPIDat1Config(SOC_SPI_1_REGS, (SPI_CSHOLD | SPI_DATA_FORMAT0), (1<<1));
    	//SPITransmitData1(SOC_SPI_1_REGS, 0xd3);
		//while( (HWREG(SOC_SPI_1_REGS + SPI_SPIBUF) & 0x80000000 ) );

		do{
			SPIDat1Config(SOC_SPI_1_REGS, (SPI_CSHOLD | SPI_DATA_FORMAT0), (1<<1));
			SPITransmitData1(SOC_SPI_1_REGS, 0xd3);
			Delay(0xf);
			while( (HWREG(SOC_SPI_1_REGS + SPI_SPIBUF) & 0x80000000 ) );
			databuffer[count] = Read_touch_ad();
			count++;
			//Delay(0xf);
		}while(count<10);//(PEN==0)&&


		SPIDat1Config(SOC_SPI_1_REGS, SPI_DATA_FORMAT0, (1<<1));
		if(count == 10)
		{
			 do                                            //X
			{
				t1=0;
				for(t=0;t<count-1;t++)
				{
					if(databuffer[t]>databuffer[t+1])//
					{
						temp=databuffer[t+1];
						databuffer[t+1]=databuffer[t];
						databuffer[t]=temp;
						t1=1;
					}
				}
			}while(t1);
		}

		break;
    }

    for(count=3;count<8;count++)
    {
    	result1 = result1 + databuffer[count];
    }
    *p1 = result1/5;
}

void tsc2046ReadAxis1(char mode, int*p1,unsigned char ee)//, char*p2)
{
    int result1;
    unsigned char cs  = 0x01;

    switch(mode)
    {
    case 0:
    	SPITransmitData1(SOC_SPI_1_REGS, ee);
    	while( (HWREG(SOC_SPI_1_REGS + SPI_SPIBUF) & 0x80000000 ) );

    	result1 = Read_touch_ad();
    	break;
    case 1:
    	SPITransmitData1(SOC_SPI_1_REGS, 0xd0);
		while( (HWREG(SOC_SPI_1_REGS + SPI_SPIBUF) & 0x80000000 ) );

		result1 = Read_touch_ad();
		break;
    }
    *p1 = result1;
    /* Deasserts the CS pin(line) */
    	SPIDat1Config(SOC_SPI_1_REGS, SPI_DATA_FORMAT0, (cs<<1));
}

/*
** This function tells if a touch is detected. 
*/
unsigned int TouchDetect(void)
{
    return ((0 == touch_flag) ? FALSE : TRUE);
}

/*
** This function resolves the coordinates of the location on the 
** touch screen being touched.
*/
void TouchCoOrdGet(int *pX, int *pY)
{
    unsigned short xpos, ypos;
    char x = 1, y =0;
    int rx1 = 0;
    int ry1 = 0;
    unsigned int xDpos = 0;
    int yDpos = 0;

    /* read x-cordinates */
    tsc2046ReadAxis(x, &rx1);

    /* read y cordinates */
    tsc2046ReadAxis(y, &ry1);

    SPITransmitData1(SOC_SPI_1_REGS, 0x90);
    while( (HWREG(SOC_SPI_1_REGS + SPI_SPIBUF) & 0x80000000 ) );

    //while(!PEN);  //ȴͷ

    xpos = rx1;

    ypos = ry1;

    xDpos = xpos * xscale + xoffset;
    yDpos = ypos * yscale + yoffset;

    yDpos = LCD_HEIGHT - yDpos;

    if(yDpos < 0)
    {
        yDpos = 0;
    }

    /* put touch screen in stand by mode.So that next
     * can be detected 
     */          
    *pX =(int)xDpos;
    *pY = yDpos;
}

//У׼ûȡADֵ
void TouchGetAdjust(int *pX, int *pY)
{
    char x = 1, y =0;
    int rx1 = 0;
    int ry1 = 0;

    /* read x-cordinates */
    tsc2046ReadAxis(x, &rx1);

    /* read y cordinates */
    tsc2046ReadAxis(y, &ry1);

    SPITransmitData1(SOC_SPI_1_REGS, 0x90);
    while( (HWREG(SOC_SPI_1_REGS + SPI_SPIBUF) & 0x80000000 ) );

    //while(!PEN);  //ȴͷ
    *pX =rx1;
    *pY = ry1;
}

//һ
//У׼õ
//x,y:
//color:ɫ
void TP_Drow_Touch_Point(int x,int y,int color)
{


	GrContextForegroundSet(&g_sContext, color);
	GrLineDraw(&g_sContext,x-12,y,x+13,y);//
	GrLineDraw(&g_sContext,x,y-12,x,y+13);
	GrPixelDraw(&g_sContext, x+1, y+1);
	GrPixelDraw(&g_sContext, x-1, y+1);
	GrPixelDraw(&g_sContext, x+1, y-1);
	GrPixelDraw(&g_sContext, x-1, y-1);
	GrCircleDraw(&g_sContext, x, y,6);
}

//У׼
//õĸУ׼
void TP_Adjust(void)
{
	int pos_temp[4][2];//껺ֵ
	char  cnt=0;
	int d1,d2;
	int tem1,tem2;
	float fac;
	//u16 outtime=0;
 	cnt=0;
 	tRectangle sRect;
 	int x;
 	int y;

	// ʾ̧ͷɫ
	sRect.sXMin = 0;
	sRect.sYMin = 0;
	sRect.sXMax = 799;
	sRect.sYMax = 479;
	GrContextForegroundSet(&g_sContext, ClrDarkBlue);
	GrRectFill(&g_sContext, &sRect);

	GrContextForegroundSet(&g_sContext, ClrRed);
	GrStringDrawCentered(&g_sContext, "Touch Screen Calibration", -1,
	                         GrContextDpyWidthGet(&g_sContext) / 2,
	                         GrContextDpyHeightGet(&g_sContext) / 2, 0);

	TP_Drow_Touch_Point(20,20,ClrRed);//1

	while(1)//10ûа,Զ˳
	{
		if(TRUE == TouchDetect())
		{
			Delay(0x4FFFF);
			TouchGetAdjust(&x, &y);
			while(!PEN)
			{
				TouchGetAdjust(&x, &y);
			}
			touch_flag = 0;

			pos_temp[cnt][0] = x;
			pos_temp[cnt][1] = y;
			cnt++;
			switch(cnt)
			{
				case 1:
					TP_Drow_Touch_Point(20,20,ClrDarkBlue);				//1
					TP_Drow_Touch_Point(GrContextDpyWidthGet(&g_sContext)-20,20,ClrRed);	//2
					break;
				case 2:
 					TP_Drow_Touch_Point(GrContextDpyWidthGet(&g_sContext)-20,20,ClrDarkBlue);	//2
					TP_Drow_Touch_Point(20,GrContextDpyHeightGet(&g_sContext)-20,ClrRed);	//3
					break;
				case 3:
 					TP_Drow_Touch_Point(20,GrContextDpyHeightGet(&g_sContext)-20,ClrDarkBlue);			//3
 					TP_Drow_Touch_Point(GrContextDpyWidthGet(&g_sContext)-20,
 							GrContextDpyHeightGet(&g_sContext)-20,ClrRed);	//4
					break;
				case 4:	 //ȫĸѾõ
	    		    //Ա
					tem1=abs(pos_temp[0][0]-pos_temp[1][0]);//x1-x2
					tem2=abs(pos_temp[0][1]-pos_temp[1][1]);//y1-y2
					tem1*=tem1;
					tem2*=tem2;
					d1=sqrt(tem1+tem2);//õ1,2ľ

					tem1=abs(pos_temp[2][0]-pos_temp[3][0]);//x3-x4
					tem2=abs(pos_temp[2][1]-pos_temp[3][1]);//y3-y4
					tem1*=tem1;
					tem2*=tem2;
					d2=sqrt(tem1+tem2);//õ3,4ľ
					fac=(float)d1/d2;
					if(fac<0.95||fac>1.05||d1==0||d2==0)//ϸ
					{
						cnt=0;
 				    	TP_Drow_Touch_Point(GrContextDpyWidthGet(&g_sContext)-20,
 	 							GrContextDpyHeightGet(&g_sContext)-20,ClrDarkBlue);	//4
   	 					TP_Drow_Touch_Point(20,20,ClrRed);								//1
   	 					GrContextForegroundSet(&g_sContext, ClrRed);
   	 					GrStringDrawCentered(&g_sContext, "Calibrate fail!   try again  1 ", -1,
   	 					                         GrContextDpyWidthGet(&g_sContext) / 2,
   	 					                         GrContextDpyHeightGet(&g_sContext) / 2, 0);
// 						TP_Adj_Info_Show(pos_temp[0][0],pos_temp[0][1],pos_temp[1][0],pos_temp[1][1],pos_temp[2][0],pos_temp[2][1],pos_temp[3][0],pos_temp[3][1],fac*100);//ʾ
 						continue;
					}
					tem1=abs(pos_temp[0][0]-pos_temp[2][0]);//x1-x3
					tem2=abs(pos_temp[0][1]-pos_temp[2][1]);//y1-y3
					tem1*=tem1;
					tem2*=tem2;
					d1=sqrt(tem1+tem2);//õ1,3ľ

					tem1=abs(pos_temp[1][0]-pos_temp[3][0]);//x2-x4
					tem2=abs(pos_temp[1][1]-pos_temp[3][1]);//y2-y4
					tem1*=tem1;
					tem2*=tem2;
					d2=sqrt(tem1+tem2);//õ2,4ľ
					fac=(float)d1/d2;
					if(fac<0.95||fac>1.05)//ϸ
					{
						cnt=0;
						TP_Drow_Touch_Point(GrContextDpyWidthGet(&g_sContext)-20,
								GrContextDpyHeightGet(&g_sContext)-20,ClrDarkBlue);	//4
						TP_Drow_Touch_Point(20,20,ClrRed);								//1
						GrContextForegroundSet(&g_sContext, ClrRed);
						GrStringDrawCentered(&g_sContext, "Calibrate fail!   try again  2 ", -1,
												 GrContextDpyWidthGet(&g_sContext) / 2,
												 GrContextDpyHeightGet(&g_sContext) / 2, 0);
// 						TP_Adj_Info_Show(pos_temp[0][0],pos_temp[0][1],pos_temp[1][0],pos_temp[1][1],pos_temp[2][0],pos_temp[2][1],pos_temp[3][0],pos_temp[3][1],fac*100);//ʾ
						continue;
					}//ȷ

					//Խ
					tem1=abs(pos_temp[1][0]-pos_temp[2][0]);//x1-x3
					tem2=abs(pos_temp[1][1]-pos_temp[2][1]);//y1-y3
					tem1*=tem1;
					tem2*=tem2;
					d1=sqrt(tem1+tem2);//õ1,4ľ

					tem1=abs(pos_temp[0][0]-pos_temp[3][0]);//x2-x4
					tem2=abs(pos_temp[0][1]-pos_temp[3][1]);//y2-y4
					tem1*=tem1;
					tem2*=tem2;
					d2=sqrt(tem1+tem2);//õ2,3ľ
					fac=(float)d1/d2;
					if(fac<0.95||fac>1.05)//ϸ
					{
						cnt=0;
						TP_Drow_Touch_Point(GrContextDpyWidthGet(&g_sContext)-20,
								GrContextDpyHeightGet(&g_sContext)-20,ClrDarkBlue);	//4
						TP_Drow_Touch_Point(20,20,ClrRed);								//1
						GrContextForegroundSet(&g_sContext, ClrRed);
						GrStringDrawCentered(&g_sContext, "Calibrate fail!   try again  3 ", -1,
												 GrContextDpyWidthGet(&g_sContext) / 2,
												 GrContextDpyHeightGet(&g_sContext) / 2, 0);
// 						TP_Adj_Info_Show(pos_temp[0][0],pos_temp[0][1],pos_temp[1][0],pos_temp[1][1],pos_temp[2][0],pos_temp[2][1],pos_temp[3][0],pos_temp[3][1],fac*100);//ʾ
						continue;
					}//ȷ
					//

					xscale=(float)(GrContextDpyWidthGet(&g_sContext)-40)/(pos_temp[1][0]-pos_temp[0][0]);//õxfac
					xoffset=(GrContextDpyWidthGet(&g_sContext)-xscale*(pos_temp[1][0]+pos_temp[0][0]))/2;//õxoff

					yscale=(float)(GrContextDpyHeightGet(&g_sContext)-40)/(pos_temp[2][1]-pos_temp[0][1]);//õyfac
					yoffset=(GrContextDpyHeightGet(&g_sContext)-yscale*(pos_temp[2][1]+pos_temp[0][1]))/2;//õyoff
//					if(abs(tp_dev.xfac)>2||abs(tp_dev.yfac)>2)//Ԥ෴.
//					{
//						cnt=0;
// 				    	TP_Drow_Touch_Point(lcddev.width-20,lcddev.height-20,WHITE);	//4
//   	 					TP_Drow_Touch_Point(20,20,RED);								//1
//						LCD_ShowString(40,26,lcddev.width,lcddev.height,16,"TP Need readjust!");
//						tp_dev.touchtype=!tp_dev.touchtype;//޸Ĵ.
//						if(tp_dev.touchtype)//X,YĻ෴
//						{
//							CMD_RDX=0X90;
//							CMD_RDY=0XD0;
//						}else				   //X,YĻͬ
//						{
//							CMD_RDX=0XD0;
//							CMD_RDY=0X90;
//						}
//						continue;
//					}
					TP_Drow_Touch_Point(GrContextDpyWidthGet(&g_sContext)-20,
										GrContextDpyHeightGet(&g_sContext)-20,ClrDarkBlue);	//4

					GrContextForegroundSet(&g_sContext, ClrRed);//У
					GrStringDrawCentered(&g_sContext, "Touch Screen Adjust OK!", -1,
											 GrContextDpyWidthGet(&g_sContext) / 2,
											 GrContextDpyHeightGet(&g_sContext) / 2, 0);
//					TP_Save_Adjdata();
// 					LCD_Clear(WHITE);//
					return;//У
			}
		}
//		delay_ms(10);
//		outtime++;
//		if(outtime>1000)
//		{
//			TP_Get_Adjdata();
//			break;
//	 	}
 	}
}

/****************************** End of file **********************************/



