/****************************************************************************/
/*                                                                          */
/*              grlib_demo                                                     */
/*                                                                          */
/*              20140807                                              */
/*                                                                          */
/****************************************************************************/
#include "hw_types.h"
#include "raster.h"
#include "psc.h"
#include "interrupt.h"
#include "TL6748.h"
#include "soc_C6748.h"
#include "hw_psc_C6748.h"
#include "i2c.h"
#include "grlib.h"
#include "widget.h"
#include "canvas.h"
#include "pushbutton.h"
#include "checkbox.h"
#include "radiobutton.h"
#include "container.h"
#include "slider.h"
#include "gpio.h"
#include "lcd.h"
#include "hw_syscfg0_C6748.h"

/****************************************************************************/
/*                                                                          */
/*              궨                                                      */
/*                                                                          */
/****************************************************************************/
// LCD ʱ
#define LCD_SIZE 261156
#define LCD_CLK  228000000

#define PALETTE_OFFSET	4
#define FRAME_BUFFER_0	0
#define FRAME_BUFFER_1	1

#define PINMUX18_GPIO8_10_ENABLE    (SYSCFG_PINMUX18_PINMUX18_31_28_GPIO8_10 << \
							SYSCFG_PINMUX18_PINMUX18_31_28_SHIFT)


/****************************************************************************/
/*                                                                          */
/*              ȫֱ                                                    */
/*                                                                          */
/****************************************************************************/
// LCDʼ
#pragma DATA_ALIGN(g_pucBuffer, 4);
unsigned char g_pucBuffer[GrOffScreen16BPPSize(LCD_WIDTH, LCD_HEIGHT)];

// ͼοʾṹ
tDisplay g_sSHARP800x480x16Display;

// ɫ
unsigned short palette_32b[PALETTE_SIZE/2] = 
            {0x4000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u,
             0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u, 0x0000u};

// ȫʾ
tContext sContext;

static void SetUpLCD(void);

void LcdInit(void)
{
    unsigned int i = 0;
    unsigned char *dest;
    unsigned char *src;

    //жϳʼ
//    SetupIntc();
    // עжϷ
	IntRegister(C674X_MASK_INT6, LCDIsr);

	// ӳж¼
	IntEventMap(C674X_MASK_INT6, SYS_INT_LCDC_INT);

	// ʹܿж
	IntEnable(C674X_MASK_INT6);

    //LCDʼ
    SetUpLCD();
  
    // û
    RasterDMAFBConfig(SOC_LCDC_0_REGS, 
                      (unsigned int)(g_pucBuffer+PALETTE_OFFSET),
                      (unsigned int)(g_pucBuffer+PALETTE_OFFSET) + sizeof(g_pucBuffer) - 2 -
					  PALETTE_OFFSET, FRAME_BUFFER_0);

    RasterDMAFBConfig(SOC_LCDC_0_REGS, 
                      (unsigned int)(g_pucBuffer+PALETTE_OFFSET),
                      (unsigned int)(g_pucBuffer+PALETTE_OFFSET) + sizeof(g_pucBuffer) - 2 - 
					  PALETTE_OFFSET, FRAME_BUFFER_1);

    src = (unsigned char *) palette_32b;
    dest = (unsigned char *) (g_pucBuffer+PALETTE_OFFSET);

    // ɫ嵽Դ
    for( i = PALETTE_OFFSET; i < (PALETTE_SIZE+PALETTE_OFFSET); i++)
	{
		*dest++ = *src++;
	}

    // ʼԴ
	GrOffScreen16BPPInit(&g_sSHARP800x480x16Display, g_pucBuffer, LCD_WIDTH, LCD_HEIGHT);
	
	// ʼԴ.
	GrContextInit(&sContext, &g_sSHARP800x480x16Display);

	// ʹLCD֡ж
    RasterEndOfFrameIntEnable(SOC_LCDC_0_REGS);

    // ʹܹդ
    RasterEnable(SOC_LCDC_0_REGS);
    ConfigRasterDisplayEnable();	
}

/*
** Configures raster to display image 
*/
static void SetUpLCD(void)
{
	unsigned int val;
	volatile unsigned int savePinMux = 0;

	PSCModuleControl(SOC_PSC_1_REGS, HW_PSC_LCDC, PSC_POWERDOMAIN_ALWAYS_ON,
             PSC_MDCTL_NEXT_ENABLE);
    LCDPinMuxSetup();

    savePinMux = HWREG(SOC_SYSCFG_0_REGS + SYSCFG0_PINMUX(18)) & \
								 ~(SYSCFG_PINMUX18_PINMUX18_31_28);

	HWREG(SOC_SYSCFG_0_REGS + SYSCFG0_PINMUX(18)) = \
			 (PINMUX18_GPIO8_10_ENABLE | savePinMux);

	/*GPIO8[10]Ϊģʽ*/
	GPIODirModeSet(SOC_GPIO_0_REGS, 139, GPIO_DIR_OUTPUT);

	GPIOPinWrite(SOC_GPIO_0_REGS, 139, GPIO_PIN_HIGH);
    // ùդ
    RasterDisable(SOC_LCDC_0_REGS);
    
    // ʱ
    RasterClkConfig(SOC_LCDC_0_REGS, 28800000, LCD_CLK);

    //  LCD DMA 
    RasterDMAConfig(SOC_LCDC_0_REGS, RASTER_DOUBLE_FRAME_BUFFER,
                    RASTER_BURST_SIZE_16, RASTER_FIFO_THRESHOLD_8,
                    RASTER_BIG_ENDIAN_DISABLE);

    // ģʽ(:TFT  STN,ɫߺڰ ȵ)
    RasterModeConfig(SOC_LCDC_0_REGS, RASTER_DISPLAY_MODE_TFT,
                     RASTER_PALETTE_DATA, RASTER_COLOR, RASTER_RIGHT_ALIGNED);

    // ֡ LSB ʽ
    RasterLSBDataOrderSelect(SOC_LCDC_0_REGS);
    
    //  Nibble ģʽ
    RasterNibbleModeDisable(SOC_LCDC_0_REGS);
   
    // ùդ
    RasterTiming2Configure(SOC_LCDC_0_REGS, RASTER_FRAME_CLOCK_LOW |
                                            RASTER_LINE_CLOCK_LOW  |
                                            RASTER_PIXEL_CLOCK_LOW |
                                            RASTER_SYNC_EDGE_RISING|
                                            RASTER_SYNC_CTRL_ACTIVE|
                                            RASTER_AC_BIAS_HIGH     , 0, 255);

    // ˮƽ / ֱ
    RasterHparamConfig(SOC_LCDC_0_REGS, 800, 63, 70, 70);
	RasterVparamConfig(SOC_LCDC_0_REGS, 480, 4, 1, 23);

   //  FIFO DMA ʱ
   RasterFIFODMADelayConfig(SOC_LCDC_0_REGS, (17647058/8823529));

   //޸ȼ
    val = HWREG(0x01C14118);
	val &= 0x0fffffff;
	HWREG(0x01C14118) = val;

}

/****************************************************************************/
/*                                                                          */
/*              LCDжϷ                                    	        */
/*                                                                          */
/****************************************************************************/
void LCDIsr(void)
{
    unsigned int  status;

    IntEventClear(SYS_INT_LCDC_INT);

    status = RasterIntStatus(SOC_LCDC_0_REGS,RASTER_END_OF_FRAME0_INT_STAT |
                                             RASTER_END_OF_FRAME1_INT_STAT );

    status = RasterClearGetIntStatus(SOC_LCDC_0_REGS, status);   

    if (status & RASTER_END_OF_FRAME0_INT_STAT)
    {
        RasterDMAFBConfig(SOC_LCDC_0_REGS, 
                          (unsigned int)(g_pucBuffer+4),
                          (unsigned int)(g_pucBuffer+4) + sizeof(g_pucBuffer) - 2 - 4,
                          0);
    }

    if(status & RASTER_END_OF_FRAME1_INT_STAT)
    {

        RasterDMAFBConfig(SOC_LCDC_0_REGS,
                          (unsigned int)(g_pucBuffer+4),
                          (unsigned int)(g_pucBuffer+4) + sizeof(g_pucBuffer) - 2 - 4,
                          1);
    }
}

