/****************************************************************************/
/*                                                                          */
/*              ݴӿƼ޹˾                                    */
/*                                                                          */
/*              Copyright 2015 Tronlong All rights reserved                 */
/*                                                                          */
/****************************************************************************/
/****************************************************************************/
/*                                                                          */
/*              AD8568 (EMIF нӿ,ʹöʱ510K)       */
/*                                                                          */
/*              20150616                                                 */
/*                                                                          */
/****************************************************************************/
#include "TL6748.h"                 //  DSP6748 
#include "hw_types.h"               // 
#include "stdio.h"
#include "hw_syscfg0_C6748.h"       // ϵͳģĴ
#include "soc_C6748.h"              // DSP C6748 Ĵ

#include "psc.h"                    // Դ˯߿ƺ꼰豸㺯
#include "gpio.h"                   // ͨں꼰豸㺯

#include "interrupt.h"             // DSP C6748 жӦóӿںϵͳ¼Ŷ

#include "emifa.h"                 // ⲿ洢ӿں꼰豸㺯

#include "uartStdio.h"             // ڱ׼ն˺
#include "timer.h"
#include "raster.h"
#include "dspcache.h"

#include "grlib.h"
#include "widget.h"
#include "canvas.h"
#include "pushbutton.h"
#include "checkbox.h"
#include "radiobutton.h"
#include "container.h"
#include "slider.h"
#include "lcd.h"
#include "demotouch.h"
#include "EMIFAPinmuxSetup.h"
#include "FFT.h"
#include "gpio_key_fun.h"

/****************************************************************************/
/*                                                                          */
/*              궨                                                      */
/*                                                                          */
/****************************************************************************/
#define PINMUX11_BUSY_ENABLE     (SYSCFG_PINMUX11_PINMUX11_19_16_GPIO5_11 << \
                                    SYSCFG_PINMUX11_PINMUX11_19_16_SHIFT)

#define PINMUX11_CONVST_ENABLE   (SYSCFG_PINMUX11_PINMUX11_11_8_GPIO5_13 << \
                                    SYSCFG_PINMUX11_PINMUX11_11_8_SHIFT)

#define PINMUX11_RESRT_ENABLE    (SYSCFG_PINMUX11_PINMUX11_15_12_GPIO5_12 << \
                                    SYSCFG_PINMUX11_PINMUX11_15_12_SHIFT)

#define NUM_BUF 2

#define AD8568_WRITE_ENABLE     (0x80000000u)
#define AD8568_READ_ENABLE      (0x40000000u)

#define AD8568_CLKSEL_INTERNAL  (0x00000000u)
#define AD8568_CLKSEL_EXTERNAL  (0x20000000u)

#define AD8568_BUSY_PIN_MODE    (0x00000000u)
#define AD8568_INT_PIN_MODE     (0x08000000u)

#define AD8568_BUSY_POL_HIGH    (0x00000000u)
#define AD8568_BUSY_POL_LOW     (0x04000000u)

#define AD8568_PowerDown        (0x02000000u)

#define AD8568_RangeA_4VREF     (0x00000000u)
#define AD8568_RangeA_2VREF     (0x01000000u)

#define AD8568_RangeB_4VREF     (0x00000000u)
#define AD8568_RangeB_2VREF     (0x00800000u)

#define AD8568_RangeC_4VREF     (0x00000000u)
#define AD8568_RangeC_2VREF     (0x00200000u)

#define AD8568_RangeD_4VREF     (0x00000000u)
#define AD8568_RangeD_2VREF     (0x00080000u)

#define AD8568_PowerUpB         (0x00000000u)
#define AD8568_PowerDownB       (0x00400000u)

#define AD8568_PowerUpC         (0x00000000u)
#define AD8568_PowerDownC       (0x00100000u)

#define AD8568_PowerUpD         (0x00000000u)
#define AD8568_PowerDownD       (0x00040000u)

#define AD8568_REF_DISABLE      (0x00000000u)
#define AD8568_REF_ENABLE       (0x00008000u)

#define AD8568_REFBUF_ENABLE    (0x00000000u)
#define AD8568_REFBUF_DISABLE   (0x00004000u)

#define AD8568_REF_SET2V5       (0x00000000u)
#define AD8568_REF_SET3V        (0x00002000u)

#define AD8568_REFDAC_FULL      (0x000003FFu)


/****************************************************************************/
/*                                                                          */
/*              ȫֱ                                                    */
/*                                                                          */
/****************************************************************************/
/*************************GPIO_KEYеı*************************************/
// ϵ



// 64λ ʱ / 
// ʱʱ 1 
// 32λ
//#define Fs 1000
//#define Tn 800
unsigned int TMR_PERIOD_LSB32=0;
// 32λ 0
unsigned int TMR_PERIOD_MSB32=0;
unsigned char NewDisBuf=0, OldDisBuf=1;
unsigned short emif_rbuffer[8];
short display_count=0;
int j=0;
//ͼ
int display_buffer[2][Tn];
int display_buffer_square[2][Tn];
int display_buffer_reconstruct[2][Tn];
// ͼοʾṹ
extern tDisplay g_sSHARP800x480x16Display;
// ȫʾ
extern tContext sContext;
//־
extern char touch_flag;
extern float Cmo[Tn];
extern float Cmo_Old[Tn];
extern float FN[Tn];
extern int freq_max;
extern float Cmo_max;
char Cmo_max_display[20];
char freq_max_display[10];      //׼ϰ%d
char freq_base_display[20];
char SMI_amp_display[20];
char p_num_display[20];
char freq_display[30];
int countFringeNumDisp=0;
float fringeNumDisplay=0;
float  emif[Tn];
float  emif3[Tn];
int emifSquare[Tn];
int reversePoint[Tn];                 //洢ķתꣻ
int edgeNumArray[Tn][2];                //һд洢תڶд洢һתĺ
int extremePoint[Tn];
int reconstruct[Tn];
int  extremeValue[Tn];
float reconstructPoint[Tn];
int edge[Tn];                   //洢
float fringeNum=0;            //ܻ2.5
int edgeNum=0;
extern unsigned char g_pucBuffer[GrOffScreen16BPPSize(LCD_WIDTH, LCD_HEIGHT)];
typedef struct{                               //Ҫextern Para GetParameter(float Input[])ǰ棬ֵǿķֵʵеķֵԱͲƥҪĺֵ
    int freq;
    float amp;
}Para;
Para pp;
typedef struct {
    float  value;
    int  key;
    int freq_base;
    int p_num;          //peak number
} div;
div getF;
float SMI_amp;
//int test_bug=0;
//int test_bug1=0;
//int hol[800]={0,0,0,0,0,0,0,0,0,50,50,50,50,50,50,50,50,50,50,50,50,0,0,0,0,0,0,0,0,0,0,80,0,0,0};
/****************************************************************************/
/*                                                                          */
/*                                                                  */
/*                                                                          */
/****************************************************************************/

/*************************GPIO_KEYеı*************************************/
// ʹ
void PSCInit(void);

// DSP жϳʼ
void InterruptInit(void);

//**************************//
void Delay(volatile unsigned int count);
void AD8568GPIOInit(void);

void AD8568Isr(void);
void GPIOPinMuxSetup(void);

void EMIFAInit(void);
void AD8568Reset(void);
void AD8568Start(void);
void AD8568Init(unsigned int SamplingRate);
void AD8568_WriteReg(unsigned int value);

// жϷ
void TimerIsr(void);
// ʱ / ʼ
void TimerInit(unsigned int period);
// ʱ / жϳʼ
void TimerInterruptInit(void);
extern Para GetParameter(float Input[]);
extern div Search(float a[]);
extern void Grline2(int x,int y,int num);
extern void Grline(int x,int y,int num);
int tt=0,TT,reconstructAmp=5,shiyuAmp=2,SquareAmp=60;
int frequencyOfInput=0;
/****************************************************************************/
/*                                                                          */
/*                                                                    */
/*                                                                          */
/****************************************************************************/
int main(void)
{
    int i;
    //ʹܻ
    CacheEnableMAR((unsigned int)0xC0000000, (unsigned int)0x8000000);
    CacheEnable(L1DCFG_L1DMODE_32K | L1PCFG_L1PMODE_32K | L2CFG_L2MODE_256K);
//ʼ˳н
     // ʹ
    PSCInit();

    // GPIO ܽŸ
    GPIOBankPinMuxSet();

    // GPIO ܽųʼ
    GPIOBankPinInit();

    // DSP жϳʼ
    InterruptInit();

    // GPIO ܽжϳʼ
    GPIOBankPinInterruptInit();

    //ʼLCD   //ģںԭʾЧGPIOǰͻע
    LcdInit();

    // ʼ
    TouchInit();


    // AD8568 ʼ 510K
    AD8568Init(Fs);           ////GPIO÷ڲ֮ADģʧЧʾʾǰжЧǰ򵱰Ӽ밴жǣFs=0,LCDʾ88888½ǻʾp'num.ʾܺڴй


    //display_LED();
                   //ûЩʼͲܿն˷Fs


    while(1)
    {

       //display_LED();       //Ӱزʹ
         if(display_count >= Tn)
         {
             if(countFringeNumDisp>5)
             {
                 fringeNumDisplay=fringeNum;
                 countFringeNumDisp=0;
             }
             else
                 countFringeNumDisp++;
             //test_bug1++;
             //һ֡
            // pp = GetParameter(emif);
             Grline(1,1,10);
           //  sprintf(freq_display,"freq= %d um",pp.freq);
            // sprintf(freq_max_display,"freq_max= %d Hz",getF.key);
            // sprintf(p_num_display,"p_num= %d ",getF.p_num);       //׼ϰ%d
             sprintf(freq_base_display,"Freq= %d" ,frequencyOfInput);
             sprintf(SMI_amp_display,"Amp= %.0f ",325*fringeNumDisplay);


             GrContextForegroundSet(&sContext, ClrRed);
             Grline(1,1,11);
             GrContextForegroundSet(&sContext, ClrWhite);
             GrLineDraw(&sContext, 400, 0, 400, 240);
             GrLineDraw(&sContext, 0, 240, 800, 240);
             /*************3ͨ****************/
             GrContextForegroundSet(&sContext, ClrBlack);  //ȥһλ
             for(i=0; i<800-1; i++)
             {
                 GrLineDraw(&sContext, i, display_buffer[OldDisBuf][i], i+1, display_buffer[OldDisBuf][i+1]);
             }
             //²ɼһ֡
             GrContextForegroundSet(&sContext, ClrBlue);  //sContextһĳĵıʶ
             for(i=0; i<800-1; i++)
             {
                 GrLineDraw(&sContext, i, display_buffer[NewDisBuf][i], i+1, display_buffer[NewDisBuf][i+1]);  //һλ(x1,y1;x2,y2)
             }

             /*********3ͨβ***********/
             /*GrContextForegroundSet(&sContext, ClrBlack);
             for(i=0; i<800; i++)
             {
                 GrLineDraw(&sContext, i,display_buffer_square[OldDisBuf][i],i+1, display_buffer_square[OldDisBuf][i+1]);
             }
             //²ɼһ֡
             GrContextForegroundSet(&sContext, ClrWhite);  //sContextһĳĵıʶ
             for(i=0; i<800; i++)
             {
                 GrLineDraw(&sContext, i,display_buffer_square[NewDisBuf][i],i+1, display_buffer_square[NewDisBuf][i+1]); //һλ(x1,y1;x2,y2)
             }
             */
             int m,k=0,kk=0;
             for( m=1;m<Tn;m++)
             {                                      //kǱ
                 if(emifSquare[m]!=emifSquare[m-1])
                 {
                    edge[k]=m;                      //ұغ
                    k++;
                 }
             }
             for(m=3;m<k-1;m++)
             {
                 if((edge[m]-edge[m-1])>2*(edge[m-2]-edge[m-3]))
                 {                                         // ҵתʱ
                     reversePoint[kk]=edge[m];                  //ҵת
                     kk++;                                      //ת
                 }
             }
             int yy;            //ת
             for(yy=0;yy<kk-1;yy++)        //ת֮¼edgeNumArrayУ
             {
                 for(i=reversePoint[yy];i<reversePoint[yy+1];i++)
                 {
                     if(emifSquare[i]!=emifSquare[i-1])
                         edgeNum++;
                 }
                 edgeNumArray[tt][0]=edgeNum;
                 edgeNumArray[tt][1]=reversePoint[yy+1]-reversePoint[yy];
                 edgeNum=0;
                 tt++;
             }
             int n=0,countEdgeNum=0,edgeNumMax=0;        //edgeNumMaxͬת
             for(m=0;m<tt;m++)
             {
                 for(n=0;n<tt;n++)
                 {
                     if(edgeNumArray[m][0]==edgeNumArray[n][0])
                         countEdgeNum++;
                 }
                 if(countEdgeNum>edgeNumMax)
                 {
                     edgeNumMax=edgeNumArray[m][0];
                     frequencyOfInput=Fs/(2*edgeNumArray[m][1]);
                 }
                 countEdgeNum=0;
             }
             fringeNum=edgeNumMax/2;
             edgeNum=0;
             TT=tt;
             tt=0;
             int  x=0;
             for(n=0;n<Tn;n++){
                     //ƵԵ͵ź˵Լֵļټټֵ㣬ǶԸƵźſ
                 if((emif[n]-emif[n-1])*(emif[n+1]-emif[n])<0&&(emif[n]-emif[n-4])*(emif[n+4]-emif[n])<0){
                     extremePoint[x]=n;                 //洢ֵĺ
                     x++;
                 }
             }
             for(m=0;m<Tn;m++)
                 extremeValue[m]=0;
             for(m=0;m<x-3;m=m+2){
                 if((extremePoint[m+1]-extremePoint[m])>(extremePoint[m+2]-extremePoint[m+1]))
                     extremeValue[extremePoint[m+1]]=1 ;                                                //бӦԭ
                 else
                     extremeValue[extremePoint[m+1]]=-1 ;
             }
             for(m=x-1;m<Tn;m++){           //ȥһεβͣ⸲˱ε
                 extremeValue[extremePoint[m]]=0;
             }
             for(n=0;n<Tn;n++){
                 reconstruct[0]=0;
                 reconstruct[n]=reconstruct[n-1]+extremeValue[n];
                 display_buffer_reconstruct[NewDisBuf][n]=150+reconstructAmp*reconstruct[n]; //ع񶯲
             }
                                                                                    //*******************************freq_baseǸֵĲ ֮
             /************ع***************/
             GrContextForegroundSet(&sContext, ClrBlack);
             for(i=0; i<800; i++)
             {
                 GrLineDraw(&sContext, i,display_buffer_reconstruct[OldDisBuf][i],i+1, display_buffer_reconstruct[OldDisBuf][i+1]);
             }
             //²ɼһ֡
             GrContextForegroundSet(&sContext, ClrYellow);  //sContextһĳĵıʶ
             for(i=0; i<800; i++)
             {
                 GrLineDraw(&sContext, i+400,display_buffer_reconstruct[NewDisBuf][i],i+401, display_buffer_reconstruct[NewDisBuf][i+1]); //һλ(x1,y1;x2,y2)
             }

             //д
             CacheWB((unsigned int)g_pucBuffer, sizeof(g_pucBuffer));
             RasterDisable(SOC_LCDC_0_REGS);
             RasterEnable(SOC_LCDC_0_REGS);

             OldDisBuf = NewDisBuf;
             NewDisBuf = (NewDisBuf + 1) % NUM_BUF;
            // test_bug=1;

             //ͣAD8568
             if(TouchDetect())
             {
                 Delay(0xaffff); //
                 TimerIntDisable(SOC_TMR_2_REGS, TMR_INT_TMR12_NON_CAPT_MODE);
                 while(!PEN);  //ȴͷ
                 Delay(0xaffff); //
                 touch_flag = 0;
             }
             display_count = 0;
         }
         //AD8568
         if((TouchDetect() == TRUE) && (display_count == 0))
         {
             Delay(0xaffff); //
             // óʼֵ
             // 
             TimerPeriodSet(SOC_TMR_2_REGS, TMR_TIMER12, TMR_PERIOD_LSB32);
             // ʹ ʱ /  ж
             TimerIntEnable(SOC_TMR_2_REGS, TMR_INT_TMR12_NON_CAPT_MODE);
             while(!PEN);   //ȴͷ
             Delay(0xaffff); //
             touch_flag = 0;
         }
     }
 }

/****************************************************************************/
/*                                                                          */
/*              AD8568 ʼ,Ϊ250K                              */
/*                                                                          */
/****************************************************************************/
void AD8568Init(unsigned int SamplingRate)                                         //#########################
{
    // GPIO ܽŸ
    GPIOPinMuxSetup();

    // ʱ / ʼ
    if(SamplingRate > 510000) SamplingRate = 510000;
    TMR_PERIOD_LSB32 = 228000000/SamplingRate;      //ʱÿٸʱڽһжҲǼ0ǵTMR_PERIOD_LSB32¿ʼ
    TimerInit(TMR_PERIOD_LSB32);

    //ʱ / жϳʼ
    TimerInterruptInit();

    // AD8568  IOʼ
    AD8568GPIOInit();

    // EMIF ʼ
    EMIFAInit();

    AD8568Reset();

    // ʹREF,Ϊ+-12V
    AD8568_WriteReg(AD8568_WRITE_ENABLE | AD8568_REF_ENABLE |
                    AD8568_REF_SET3V | AD8568_REFDAC_FULL);
}

/****************************************************************************/
/*                                                                          */
/*              ʱ / ʼ                                    */
/*                                                                          */
/****************************************************************************/
void TimerInit(unsigned int period)
{
    //  ʱ /  2 Ϊ 64 λģʽ
    TimerConfigure(SOC_TMR_2_REGS, TMR_CFG_64BIT_CLK_INT);

    // 
    TimerPeriodSet(SOC_TMR_2_REGS, TMR_TIMER12, period);
    TimerPeriodSet(SOC_TMR_2_REGS, TMR_TIMER34, TMR_PERIOD_MSB32);

    // ʹ ʱ /  2
    TimerEnable(SOC_TMR_2_REGS, TMR_TIMER12, TMR_ENABLE_CONT);
}

/****************************************************************************/
/*                                                                          */
/*              ʱ / жϳʼ                                  */
/*                                                                          */
/****************************************************************************/
void TimerInterruptInit(void)
{
    // עжϷ
    IntRegister(C674X_MASK_INT5, TimerIsr);

    // ӳжϵ DSP ж
    IntEventMap(C674X_MASK_INT5, SYS_INT_T64P2_TINTALL);

    // ʹ DSP ж
    IntEnable(C674X_MASK_INT5);

    // ʹ ʱ /  ж
    TimerIntEnable(SOC_TMR_2_REGS, TMR_INT_TMR12_NON_CAPT_MODE);
}


/****************************************************************************/
/*                                                                          */
/*              жϷ                                              */
/*                                                                          */
/****************************************************************************/
void TimerIsr(void)                                                                     //*##########################
{
    // жϱ־
    IntEventClear(SYS_INT_T64P2_TINTALL);

    TimerIntStatusClear(SOC_TMR_2_REGS, TMR_INT_TMR12_NON_CAPT_MODE);

    //AD8568ת
    AD8568Start();


    if(display_count <Tn)
    {
        emif_rbuffer[0] = ((short *)SOC_EMIFA_CS2_ADDR)[1];
        emif_rbuffer[1] = ((short *)SOC_EMIFA_CS2_ADDR)[2];
        emif_rbuffer[2] = ((short *)SOC_EMIFA_CS2_ADDR)[3];
        emif_rbuffer[3] = ((short *)SOC_EMIFA_CS2_ADDR)[4];
        emif_rbuffer[4] = ((short *)SOC_EMIFA_CS2_ADDR)[5];
        emif_rbuffer[5] = ((short *)SOC_EMIFA_CS2_ADDR)[6];
        emif_rbuffer[6] = ((short *)SOC_EMIFA_CS2_ADDR)[7];
        emif_rbuffer[7] = ((short *)SOC_EMIFA_CS2_ADDR)[8];

        if(emif_rbuffer[2] < 32768){
            emif[j] = (float)emif_rbuffer[2]*12/32768;    //float  emif[Tn]ǽɼĵѹתΪʵʵĵѹֵ
            display_buffer[NewDisBuf][display_count] = 380 + emif_rbuffer[2]/160*shiyuAmp;                //ʾķ
         }
        else{
            emif[j] =(float) -((65536-emif_rbuffer[2])*12)/32768;//οѹΪ12V
            display_buffer[NewDisBuf][display_count] = 380 - (65536-emif_rbuffer[2])/160*shiyuAmp;
        }
        /************ʾͨĲ*************/
        if(emif_rbuffer[5] < 32768){
            emif[j] = (float)emif_rbuffer[2]*12/32768;    //float  emif[Tn]ǽɼĵѹתΪʵʵĵѹֵ
            display_buffer[NewDisBuf][display_count] = 380 + emif_rbuffer[2]/160*shiyuAmp;                //ʾķ
         }
        else{
            emif[j] =(float) -((65536-emif_rbuffer[2])*12)/32768;//οѹΪ12V
            display_buffer[NewDisBuf][display_count] = 380 - (65536-emif_rbuffer[2])/160*shiyuAmp;
        }

        //2ͨĲαɷ
        if(emif[j]>0)
        {
            emifSquare[j]=1;
            display_buffer_square[NewDisBuf][j]=200+SquareAmp*emifSquare[j];
        }
        else
        {
            emifSquare[j]=0;
            display_buffer_square[NewDisBuf][j]=200+SquareAmp*emifSquare[j];
        }
        j++;
        display_count++;
        if(j>=Tn) j=0;
    }
}
/****************************************************************************/
/*                                                                          */
/*              AD8568 IOʼ
/*                                                                          */
/****************************************************************************/
void AD8568GPIOInit(void)
{
    //  GPIO5[11]/BUSY Ϊģʽ
    GPIODirModeSet(SOC_GPIO_0_REGS, 92, GPIO_DIR_INPUT);

    //  GPIO5[12]/RESET Ϊģʽ
    GPIODirModeSet(SOC_GPIO_0_REGS, 93, GPIO_DIR_OUTPUT);
    GPIOPinWrite(SOC_GPIO_0_REGS, 93, GPIO_PIN_HIGH);

    //  GPIO5[13]/CONVST Ϊģʽ
    GPIODirModeSet(SOC_GPIO_0_REGS, 94, GPIO_DIR_OUTPUT);
    GPIOPinWrite(SOC_GPIO_0_REGS, 94, GPIO_PIN_LOW);
}

/****************************************************************************/
/*                                                                          */
/*              DSP жϳʼ                                              */
/*                                                                          */
/****************************************************************************/
void InterruptInit(void)
{
    // ʼ DSP жϿ
    IntDSPINTCInit();

    // ʹ DSP ȫж
    IntGlobalEnable();
}

/****************************************************************************/
/*                                                                          */
/*               GPIO ܽŸ                                          */
/*                                                                          */
/****************************************************************************/
void GPIOPinMuxSetup(void)
{
    volatile unsigned int savePinMux = 0;

    savePinMux = HWREG(SOC_SYSCFG_0_REGS + SYSCFG0_PINMUX(11)) & \
                         ~(SYSCFG_PINMUX11_PINMUX11_19_16 | SYSCFG_PINMUX11_PINMUX11_15_12 | SYSCFG_PINMUX11_PINMUX11_11_8);

    HWREG(SOC_SYSCFG_0_REGS + SYSCFG0_PINMUX(11)) = \
             (PINMUX11_BUSY_ENABLE | PINMUX11_CONVST_ENABLE | PINMUX11_RESRT_ENABLE | savePinMux);
}

/****************************************************************************/
/*                                                                          */
/*              PSC ʼ                                                  */
/*                                                                          */
/****************************************************************************/
void PSCInit(void)
{
    // ʹ GPIO ģ
    PSCModuleControl(SOC_PSC_1_REGS, HW_PSC_GPIO, PSC_POWERDOMAIN_ALWAYS_ON, PSC_MDCTL_NEXT_ENABLE);

    // ʹ EMIFA ģ
    PSCModuleControl(SOC_PSC_0_REGS, HW_PSC_EMIFA, PSC_POWERDOMAIN_ALWAYS_ON, PSC_MDCTL_NEXT_ENABLE);
}

/****************************************************************************/
/*                                                                          */
/*              EMIFA ʼ                                                */
/*                                                                          */
/****************************************************************************/
void EMIFAInit(void)
{

    //  EMIFA ظ
    EMIFAPinMuxSetup();

    //  16bit
    EMIFAAsyncDevDataBusWidthSelect(SOC_EMIFA_0_REGS,EMIFA_CHIP_SELECT_2, EMIFA_DATA_BUSWITTH_16BIT);

    // ѡ Normal ģʽ
    EMIFAAsyncDevOpModeSelect(SOC_EMIFA_0_REGS,EMIFA_CHIP_SELECT_2, EMIFA_ASYNC_INTERFACE_STROBE_MODE );//EMIFA_ASYNC_INTERFACE_NORMAL_MODE

    // ֹWAIT
    EMIFAExtendedWaitConfig(SOC_EMIFA_0_REGS,EMIFA_CHIP_SELECT_2, EMIFA_EXTENDED_WAIT_DISABLE);

    //  W_SETUP/R_SETUP W_STROBE/R_STROBE W_HOLD/R_HOLD   TA Ȳ
    EMIFAWaitTimingConfig(SOC_EMIFA_0_REGS,EMIFA_CHIP_SELECT_2, EMIFA_ASYNC_WAITTIME_CONFIG(1, 5, 1, 1, 5, 1, 0 ));
}

/****************************************************************************/
/*                                                                          */
/*              AD8568 λ                                                 */
/*                                                                          */
/****************************************************************************/
void AD8568Reset(void)
{
    GPIOPinWrite(SOC_GPIO_0_REGS, 93, GPIO_PIN_HIGH);
    Delay(0x1FFF);
    GPIOPinWrite(SOC_GPIO_0_REGS, 93, GPIO_PIN_LOW);
}

/****************************************************************************/
/*                                                                          */
/*               AD8568 ת                                            */
/*                                                                          */
/****************************************************************************/
void AD8568Start(void)
{
    GPIOPinWrite(SOC_GPIO_0_REGS, 94, GPIO_PIN_LOW);
    GPIOPinWrite(SOC_GPIO_0_REGS, 94, GPIO_PIN_HIGH);
}

/****************************************************************************/
/*                                                                          */
/*               AD8568 дĴ                                            */
/*                                                                          */
/****************************************************************************/
void AD8568_WriteReg(unsigned int value)
{
    ((short *)SOC_EMIFA_CS2_ADDR)[0] = (value >> 16) & 0x0000FFFF;
    ((short *)SOC_EMIFA_CS2_ADDR)[0] = value & 0x0000FFFF;
}

/****************************************************************************/
/*                                                                          */
/*              ʱ                                                        */
/*                                                                          */
/****************************************************************************/
void Delay(volatile unsigned int count)
{
    while(count--);
}

void display_LED(void)
{
    // ʹ
        PSCInit();                     //ûЩʼͲܿն˷Fs

        // GPIO ܽŸ
        GPIOBankPinMuxSet();

        // GPIO ܽųʼ
        GPIOBankPinInit();

        // DSP жϳʼ
        InterruptInit();

        // GPIO ܽжϳʼ
        GPIOBankPinInterruptInit();

}
void GPIOBankPinMuxSet(void)
{
    // Ӧ GPIO ڹΪͨ
    // İ LED
    GPIOBank6Pin12PinMuxSetup();
    GPIOBank6Pin13PinMuxSetup();

    // װ尴
    GPIOBank0Pin6PinMuxSetup();
    GPIOBank6Pin1PinMuxSetup();
}

void GPIOBankPinInit(void)
{
    //  LED ӦܽΪܽ
    // OMAPL138  DSP C6748  144  GPIO
    // Ϊ GPIO BANK ʼܽŶӦֵ
    // Χ 1-144
    // GPIO0[0] 1
    // GPIO1[0] 17
    // GPIO2[0] 33
    // GPIO3[0] 49
    // GPIO4[0] 65
    // GPIO5[0] 81
    // GPIO6[0] 97
    // GPIO7[0] 113
    // GPIO8[0] 129
    // İ LED
    GPIODirModeSet(SOC_GPIO_0_REGS, 3, GPIO_DIR_OUTPUT);  // GPIO6[12]
    GPIODirModeSet(SOC_GPIO_0_REGS, 1, GPIO_DIR_OUTPUT);  // GPIO6[13]

    // װ尴
    GPIODirModeSet(SOC_GPIO_0_REGS, 7, GPIO_DIR_INPUT);     // USER0 KEY GPIO0[6]
    GPIODirModeSet(SOC_GPIO_0_REGS, 98, GPIO_DIR_INPUT);    // USER1 KEY GPIO6[1]
}

void GPIOBankPinInterruptInit(void)
{
    // װ尴ж
    //  USER0 KEY GPIO0[6] Ϊ½ش
    GPIOIntTypeSet(SOC_GPIO_0_REGS, 7, GPIO_INT_TYPE_FALLEDGE);
    //  USER1 KEY GPIO6[1] Ϊؼ½ش
    GPIOIntTypeSet(SOC_GPIO_0_REGS, 98, GPIO_INT_TYPE_BOTHEDGE);

    // ʹ GPIO BANK ж
    GPIOBankIntEnable(SOC_GPIO_0_REGS, 0);                  // USER0 KEY GPIO0
    GPIOBankIntEnable(SOC_GPIO_0_REGS, 6);                  // USER1 KEY GPIO6

    // עжϷ
    IntRegister(C674X_MASK_INT4, USER0KEYIsr);
    IntRegister(C674X_MASK_INT5, USER1KEYIsr);

    // ӳжϵ DSP ж
    IntEventMap(C674X_MASK_INT4, SYS_INT_GPIO_B0INT);
    IntEventMap(C674X_MASK_INT5, SYS_INT_GPIO_B6INT);

    // ʹ DSP ж
    IntEnable(C674X_MASK_INT4);
    IntEnable(C674X_MASK_INT5);
}

void USER0KEYIsr(void)
{
    // ϵ 
    //SW_BREAKPOINT;

    //  GPIO BANK 0 ж
    GPIOBankIntDisable(SOC_GPIO_0_REGS, 0);

    //  GPIO BANK 0 ж״̬
    IntEventClear(SYS_INT_GPIO_B0INT);
   // unsigned int i;
    if(GPIOPinIntStatus(SOC_GPIO_0_REGS, 7) == GPIO_INT_PEND)
    {
        //  GPIO0[6] ж״̬
        GPIOPinIntClear(SOC_GPIO_0_REGS, 7);
            /*for( i=0x00FFFFFF;i>0;i--);                          // ʱ
            GPIOPinWrite(SOC_GPIO_0_REGS, 3, GPIO_PIN_LOW);  //109 original code
            GPIOPinWrite(SOC_GPIO_0_REGS, 1, GPIO_PIN_HIGH);//110 original code

            for(i=0x00FFFFFF;i>0;i--);                          // ʱ
            GPIOPinWrite(SOC_GPIO_0_REGS, 3, GPIO_PIN_HIGH);//109 original code
            GPIOPinWrite(SOC_GPIO_0_REGS, 1, GPIO_PIN_LOW);//110 original code*/
        Flag_gpio_key=1;
        Fs=Fs*2;
    }

    // ʹ GPIO BANK 0 ж
    GPIOBankIntEnable(SOC_GPIO_0_REGS, 0);
}

void USER1KEYIsr(void)
{
    // ϵ 
    //SW_BREAKPOINT;

    //  GPIO BANK 6 ж
    GPIOBankIntDisable(SOC_GPIO_0_REGS, 6);

    //  GPIO BANK 6 ж״̬
    IntEventClear(SYS_INT_GPIO_B6INT);

    if(GPIOPinIntStatus(SOC_GPIO_0_REGS, 98) == GPIO_INT_PEND)
    {
        //  GPIO6[1] ж״̬
        GPIOPinIntClear(SOC_GPIO_0_REGS, 98);
        Flag_gpio_key=2;
        Fs=Fs/2;
    }

    // ʹ GPIO BANK 6 ж
    GPIOBankIntEnable(SOC_GPIO_0_REGS, 6);
}
