/*
 *
 * Copyright (c) 2017 Texas Instruments Incorporated
 *
 * All rights reserved not granted herein.
 *
 * Limited License.
 *
 * Texas Instruments Incorporated grants a world-wide, royalty-free, non-exclusive
 * license under copyrights and patents it now or hereafter owns or controls to make,
 * have made, use, import, offer to sell and sell ("Utilize") this software subject to the
 * terms herein.  With respect to the foregoing patent license, such license is granted
 * solely to the extent that any such patent is necessary to Utilize the software alone.
 * The patent license shall not apply to any combinations which include this software,
 * other than combinations with devices manufactured by or for TI ("TI Devices").
 * No hardware patent is licensed hereunder.
 *
 * Redistributions must preserve existing copyright notices and reproduce this license
 * (including the above copyright notice and the disclaimer and (if applicable) source
 * code license limitations below) in the documentation and/or other materials provided
 * with the distribution
 *
 * Redistribution and use in binary form, without modification, are permitted provided
 * that the following conditions are met:
 *
 * *       No reverse engineering, decompilation, or disassembly of this software is
 * permitted with respect to any software provided in binary form.
 *
 * *       any redistribution and use are licensed by TI for use only with TI Devices.
 *
 * *       Nothing shall obligate TI to provide you with source code for the software
 * licensed and provided to you in object code.
 *
 * If software source code is provided to you, modification and redistribution of the
 * source code are permitted provided that the following conditions are met:
 *
 * *       any redistribution and use of the source code, including any resulting derivative
 * works, are licensed by TI for use only with TI Devices.
 *
 * *       any redistribution and use of any object code compiled from the source code
 * and any resulting derivative works, are licensed by TI for use only with TI Devices.
 *
 * Neither the name of Texas Instruments Incorporated nor the names of its suppliers
 *
 * may be used to endorse or promote products derived from this software without
 * specific prior written permission.
 *
 * DISCLAIMER.
 *
 * THIS SOFTWARE IS PROVIDED BY TI AND TI'S LICENSORS "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL TI AND TI'S LICENSORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include "app_convert_module.h"

vx_status app_init_convert(vx_context context, ConvertObj *convertObj)
{
    vx_status status = VX_SUCCESS;

    vx_image output  = vxCreateImage(context, convertObj->info_Output.width, convertObj->info_Output.height, convertObj->info_Output.dataFormat);
    convertObj->arr_Output  = vxCreateObjectArray(context, (vx_reference)output, convertObj->numCH);
    vxReleaseImage(&output);

    if (vxGetStatus((vx_reference)convertObj->arr_Output) != VX_SUCCESS)
    {
        status = VX_FAILURE;
        APP_PRINTF("init convert failed\n");
    }
    return status;
}

void app_deinit_convert(ConvertObj *convertObj)
{
    vxReleaseObjectArray(&convertObj->arr_Output);

    return;
}

void app_delete_convert(ConvertObj *convertObj)
{
    if(convertObj->node != NULL)
    {
        vxReleaseNode(&convertObj->node);
    }

    return;
}

vx_status app_create_graph_convert(vx_graph graph, ConvertObj *convertObj, vx_object_array arrInput)
{
    vx_status status = VX_SUCCESS;

    vx_image imgInput = (vx_image)vxGetObjectArrayItem(arrInput, 0);
    vx_image imgOutput = (vx_image)vxGetObjectArrayItem(convertObj->arr_Output, 0);

    convertObj->node = vxColorConvertNode(graph, imgInput, imgOutput);
    vxSetNodeTarget(convertObj->node, VX_TARGET_STRING, convertObj->name_Target);
    vxSetReferenceName((vx_reference)convertObj->node, convertObj->name_NodeObj);
    if (1 < convertObj->numCH)
    {
        vxReplicateNode(graph, convertObj->node, convertObj->arr_Replicate, 2);
    }

    if (vxGetStatus((vx_reference)convertObj->node) != VX_SUCCESS)
    {
        status = VX_FAILURE;
        APP_PRINTF("convertObj->node create failed\n");
    }
    vxReleaseImage(&imgInput);
    vxReleaseImage(&imgOutput);

  return status;
}

