/*
 *
 * Copyright (c) 2019 Texas Instruments Incorporated
 *
 * All rights reserved not granted herein.
 *
 * Limited License.
 *
 * Texas Instruments Incorporated grants a world-wide, royalty-free, non-exclusive
 * license under copyrights and patents it now or hereafter owns or controls to make,
 * have made, use, import, offer to sell and sell ("Utilize") this software subject to the
 * terms herein.  With respect to the foregoing patent license, such license is granted
 * solely to the extent that any such patent is necessary to Utilize the software alone.
 * The patent license shall not apply to any combinations which include this software,
 * other than combinations with devices manufactured by or for TI ("TI Devices").
 * No hardware patent is licensed hereunder.
 *
 * Redistributions must preserve existing copyright notices and reproduce this license
 * (including the above copyright notice and the disclaimer and (if applicable) source
 * code license limitations below) in the documentation and/or other materials provided
 * with the distribution
 *
 * Redistribution and use in binary form, without modification, are permitted provided
 * that the following conditions are met:
 *
 * *       No reverse engineering, decompilation, or disassembly of this software is
 * permitted with respect to any software provided in binary form.
 *
 * *       any redistribution and use are licensed by TI for use only with TI Devices.
 *
 * *       Nothing shall obligate TI to provide you with source code for the software
 * licensed and provided to you in object code.
 *
 * If software source code is provided to you, modification and redistribution of the
 * source code are permitted provided that the following conditions are met:
 *
 * *       any redistribution and use of the source code, including any resulting derivative
 * works, are licensed by TI for use only with TI Devices.
 *
 * *       any redistribution and use of any object code compiled from the source code
 * and any resulting derivative works, are licensed by TI for use only with TI Devices.
 *
 * Neither the name of Texas Instruments Incorporated nor the names of its suppliers
 *
 * may be used to endorse or promote products derived from this software without
 * specific prior written permission.
 *
 * DISCLAIMER.
 *
 * THIS SOFTWARE IS PROVIDED BY TI AND TI'S LICENSORS "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL TI AND TI'S LICENSORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**** Number of Cameras  **************************/
int ldcLUT_numCams = 4;

/**** Distortion Centers **************************/
/*    format: cam0_x, cam0_y, cam1_x, cam1_y, ... */
int ldcLUT_distortionCenters[] = {640,360,640,360,640,360,640,360};

/**** Focal Length [pixels] **********************/
float ldcLUT_focalLength = 3.1183330e+02f;

/**** LDC LUT common parameters ******/
int ldcLUT_data_type = 0; 
int ldcLUT_interp_method = 2; 

/**** LDC LUT undistorted to distorted ******/
int ldcLUT_U2D_type = 2; 
int ldcLUT_U2D_length = 1024; 
float ldcLUT_U2D_step = 1.5354803e-03f;
float ldcLUT_U2D_table[]= {
0.0000000e+00f,4.7883115e-01f,9.5786308e-01f,1.4369391e+00f,1.9158500e+00f,2.3947841e+00f,2.8737873e+00f,3.3526448e+00f,3.8317115e+00f,4.3107728e+00f,4.7896164e+00f,5.2686245e+00f,5.7476861e+00f,6.2267393e+00f,6.7057925e+00f,7.1848420e+00f,7.6639099e+00f,8.1431843e+00f,8.6222461e+00f,9.1012793e+00f,9.5804799e+00f,1.0059754e+01f,1.0539017e+01f,1.1018280e+01f,1.1497542e+01f,1.1976805e+01f,1.2456056e+01f,1.2935504e+01f,1.3414982e+01f,1.3894454e+01f,1.4373926e+01f,1.4853398e+01f,1.5332868e+01f,1.5812347e+01f,1.6292031e+01f,1.6771713e+01f,1.7251377e+01f,1.7731211e+01f,1.8211000e+01f,1.8690734e+01f,1.9170640e+01f,1.9650544e+01f,2.0130651e+01f,2.0610752e+01f,2.1090853e+01f,2.1570953e+01f,2.2051040e+01f,2.2531220e+01f,2.3011542e+01f,2.3491873e+01f,
2.3972403e+01f,2.4452922e+01f,2.4933442e+01f,2.5413944e+01f,2.5894572e+01f,2.6375416e+01f,2.6856308e+01f,2.7337048e+01f,2.7818000e+01f,2.8298929e+01f,2.8780059e+01f,2.9261194e+01f,2.9742476e+01f,3.0223847e+01f,3.0705196e+01f,3.1186591e+01f,3.1668172e+01f,3.2149739e+01f,3.2631291e+01f,3.3113015e+01f,3.3594943e+01f,3.4076941e+01f,3.4558918e+01f,3.5040945e+01f,3.5523177e+01f,3.6005592e+01f,3.6487767e+01f,3.6970326e+01f,3.7452952e+01f,3.7935551e+01f,3.8418254e+01f,3.8901089e+01f,3.9383938e+01f,3.9866988e+01f,4.0350231e+01f,4.0833475e+01f,4.1316700e+01f,4.1800059e+01f,4.2283624e+01f,4.2767295e+01f,4.3250989e+01f,4.3734885e+01f,4.4218971e+01f,4.4703052e+01f,4.5187097e+01f,4.5671480e+01f,4.6155867e+01f,4.6640294e+01f,4.7125033e+01f,4.7609760e+01f,
4.8094688e+01f,4.8579594e+01f,4.9064677e+01f,4.9549963e+01f,5.0035297e+01f,5.0520710e+01f,5.1006323e+01f,5.1492122e+01f,5.1978099e+01f,5.2464055e+01f,5.2950210e+01f,5.3436373e+01f,5.3922663e+01f,5.4409147e+01f,5.4895815e+01f,5.5382670e+01f,5.5869697e+01f,5.6356703e+01f,5.6843898e+01f,5.7331296e+01f,5.7818719e+01f,5.8306245e+01f,5.8793969e+01f,5.9281877e+01f,5.9769969e+01f,6.0258248e+01f,6.0746492e+01f,6.1235123e+01f,6.1723807e+01f,6.2212614e+01f,6.2701507e+01f,6.3190511e+01f,6.3679858e+01f,6.4169181e+01f,6.4658917e+01f,6.5148639e+01f,6.5638518e+01f,6.6128603e+01f,6.6618748e+01f,6.7109022e+01f,6.7599664e+01f,6.8090461e+01f,6.8581237e+01f,6.9072186e+01f,6.9563523e+01f,7.0054935e+01f,7.0546440e+01f,7.1038142e+01f,7.1530028e+01f,7.2022099e+01f,
7.2514354e+01f,7.3006793e+01f,7.3499416e+01f,7.3992241e+01f,7.4485102e+01f,7.4978137e+01f,7.5471515e+01f,7.5965060e+01f,7.6458789e+01f,7.6952713e+01f,7.7446607e+01f,7.7940834e+01f,7.8435310e+01f,7.8929961e+01f,7.9424796e+01f,7.9919815e+01f,8.0415018e+01f,8.0910406e+01f,8.1405978e+01f,8.1901734e+01f,8.2397658e+01f,8.2893901e+01f,8.3390356e+01f,8.3886876e+01f,8.4383763e+01f,8.4880614e+01f,8.5377861e+01f,8.5875304e+01f,8.6372928e+01f,8.6870737e+01f,8.7368730e+01f,8.7866902e+01f,8.8365285e+01f,8.8864051e+01f,8.9363002e+01f,8.9861923e+01f,9.0361157e+01f,9.0860801e+01f,9.1360609e+01f,9.1860446e+01f,9.2360521e+01f,9.2860973e+01f,9.3361597e+01f,9.3862389e+01f,9.4363566e+01f,9.4864807e+01f,9.5366257e+01f,9.5868028e+01f,9.6369962e+01f,9.6872099e+01f,
9.7374627e+01f,9.7877114e+01f,9.8379946e+01f,9.8883186e+01f,9.9386533e+01f,9.9890035e+01f,1.0039388e+02f,1.0089792e+02f,1.0140234e+02f,1.0190670e+02f,1.0241165e+02f,1.0291666e+02f,1.0342194e+02f,1.0392738e+02f,1.0443300e+02f,1.0493912e+02f,1.0544521e+02f,1.0595169e+02f,1.0645856e+02f,1.0696562e+02f,1.0747287e+02f,1.0798029e+02f,1.0848798e+02f,1.0899601e+02f,1.0950422e+02f,1.1001281e+02f,1.1052159e+02f,1.1103053e+02f,1.1153981e+02f,1.1204935e+02f,1.1255915e+02f,1.1306928e+02f,1.1357958e+02f,1.1409006e+02f,1.1460093e+02f,1.1511198e+02f,1.1562338e+02f,1.1613501e+02f,1.1664693e+02f,1.1715915e+02f,1.1767158e+02f,1.1818439e+02f,1.1869736e+02f,1.1921072e+02f,1.1972428e+02f,1.2023799e+02f,1.2075213e+02f,1.2126661e+02f,1.2178113e+02f,1.2229606e+02f,
1.2281135e+02f,1.2332682e+02f,1.2384265e+02f,1.2435869e+02f,1.2487504e+02f,1.2539168e+02f,1.2590854e+02f,1.2642578e+02f,1.2694340e+02f,1.2746117e+02f,1.2797933e+02f,1.2849768e+02f,1.2901635e+02f,1.2953530e+02f,1.3005448e+02f,1.3057404e+02f,1.3109397e+02f,1.3161406e+02f,1.3213454e+02f,1.3265520e+02f,1.3317618e+02f,1.3369755e+02f,1.3421921e+02f,1.3474107e+02f,1.3526333e+02f,1.3578595e+02f,1.3630874e+02f,1.3683189e+02f,1.3735542e+02f,1.3787920e+02f,1.3840323e+02f,1.3892765e+02f,1.3945241e+02f,1.3997734e+02f,1.4050265e+02f,1.4102833e+02f,1.4155439e+02f,1.4208069e+02f,1.4260726e+02f,1.4313414e+02f,1.4366125e+02f,1.4418894e+02f,1.4471678e+02f,1.4524500e+02f,1.4577342e+02f,1.4630213e+02f,1.4683135e+02f,1.4736092e+02f,1.4789055e+02f,1.4842076e+02f,
1.4895112e+02f,1.4948208e+02f,1.5001304e+02f,1.5054443e+02f,1.5107630e+02f,1.5160844e+02f,1.5214079e+02f,1.5267353e+02f,1.5320664e+02f,1.5374013e+02f,1.5427377e+02f,1.5480794e+02f,1.5534241e+02f,1.5587714e+02f,1.5641225e+02f,1.5694773e+02f,1.5748357e+02f,1.5801957e+02f,1.5855615e+02f,1.5909294e+02f,1.5963004e+02f,1.6016752e+02f,1.6070537e+02f,1.6124359e+02f,1.6178218e+02f,1.6232114e+02f,1.6286025e+02f,1.6339992e+02f,1.6393985e+02f,1.6448005e+02f,1.6502063e+02f,1.6556163e+02f,1.6610317e+02f,1.6664485e+02f,1.6718693e+02f,1.6772916e+02f,1.6827189e+02f,1.6881507e+02f,1.6935862e+02f,1.6990247e+02f,1.7044654e+02f,1.7099119e+02f,1.7153598e+02f,1.7208135e+02f,1.7262693e+02f,1.7317297e+02f,1.7371936e+02f,1.7426606e+02f,1.7481326e+02f,1.7536063e+02f,
1.7590837e+02f,1.7645670e+02f,1.7700523e+02f,1.7755406e+02f,1.7810340e+02f,1.7865315e+02f,1.7920309e+02f,1.7975344e+02f,1.8030435e+02f,1.8085542e+02f,1.8140704e+02f,1.8195890e+02f,1.8251119e+02f,1.8306386e+02f,1.8361680e+02f,1.8417031e+02f,1.8472416e+02f,1.8527840e+02f,1.8583279e+02f,1.8638769e+02f,1.8694304e+02f,1.8749873e+02f,1.8805480e+02f,1.8861123e+02f,1.8916805e+02f,1.8972544e+02f,1.9028300e+02f,1.9084089e+02f,1.9139930e+02f,1.9195818e+02f,1.9251733e+02f,1.9307674e+02f,1.9363672e+02f,1.9419705e+02f,1.9475775e+02f,1.9531880e+02f,1.9588040e+02f,1.9644230e+02f,1.9700454e+02f,1.9756726e+02f,1.9813018e+02f,1.9869367e+02f,1.9925753e+02f,1.9982174e+02f,2.0038651e+02f,2.0095155e+02f,2.0151697e+02f,2.0208284e+02f,2.0264891e+02f,2.0321558e+02f,
2.0378282e+02f,2.0435022e+02f,2.0491795e+02f,2.0548620e+02f,2.0605492e+02f,2.0662399e+02f,2.0719342e+02f,2.0776323e+02f,2.0833339e+02f,2.0890414e+02f,2.0947526e+02f,2.1004675e+02f,2.1061859e+02f,2.1119090e+02f,2.1176367e+02f,2.1233664e+02f,2.1291019e+02f,2.1348410e+02f,2.1405836e+02f,2.1463316e+02f,2.1520840e+02f,2.1578399e+02f,2.1635995e+02f,2.1693631e+02f,2.1751322e+02f,2.1809028e+02f,2.1866789e+02f,2.1924609e+02f,2.1982454e+02f,2.2040338e+02f,2.2098273e+02f,2.2156242e+02f,2.2214250e+02f,2.2272315e+02f,2.2330416e+02f,2.2388555e+02f,2.2446728e+02f,2.2504951e+02f,2.2563222e+02f,2.2621529e+02f,2.2679872e+02f,2.2738252e+02f,2.2796690e+02f,2.2855163e+02f,2.2913692e+02f,2.2972249e+02f,2.3030840e+02f,2.3089492e+02f,2.3148192e+02f,2.3206908e+02f,
2.3265683e+02f,2.3324493e+02f,2.3383357e+02f,2.3442265e+02f,2.3501207e+02f,2.3560194e+02f,2.3619229e+02f,2.3678284e+02f,2.3737418e+02f,2.3796566e+02f,2.3855768e+02f,2.3915011e+02f,2.3974303e+02f,2.4033633e+02f,2.4092994e+02f,2.4152427e+02f,2.4211875e+02f,2.4271380e+02f,2.4330922e+02f,2.4390516e+02f,2.4450155e+02f,2.4509829e+02f,2.4569545e+02f,2.4629316e+02f,2.4689122e+02f,2.4748964e+02f,2.4808862e+02f,2.4868799e+02f,2.4928786e+02f,2.4988819e+02f,2.5048889e+02f,2.5108994e+02f,2.5169138e+02f,2.5229338e+02f,2.5289595e+02f,2.5349891e+02f,2.5410223e+02f,2.5470590e+02f,2.5531003e+02f,2.5591468e+02f,2.5651970e+02f,2.5712529e+02f,2.5773123e+02f,2.5833773e+02f,2.5894463e+02f,2.5955188e+02f,2.6015960e+02f,2.6076783e+02f,2.6137641e+02f,2.6198536e+02f,
2.6259489e+02f,2.6320477e+02f,2.6381520e+02f,2.6442603e+02f,2.6503734e+02f,2.6564915e+02f,2.6626130e+02f,2.6687384e+02f,2.6748694e+02f,2.6810042e+02f,2.6871423e+02f,2.6932873e+02f,2.6994363e+02f,2.7055885e+02f,2.7117460e+02f,2.7179071e+02f,2.7240740e+02f,2.7302444e+02f,2.7364204e+02f,2.7426004e+02f,2.7487839e+02f,2.7549721e+02f,2.7611653e+02f,2.7673623e+02f,2.7735650e+02f,2.7797713e+02f,2.7859811e+02f,2.7921961e+02f,2.7984169e+02f,2.8046423e+02f,2.8108711e+02f,2.8171040e+02f,2.8233425e+02f,2.8295844e+02f,2.8358321e+02f,2.8420836e+02f,2.8483387e+02f,2.8545984e+02f,2.8608640e+02f,2.8671342e+02f,2.8734063e+02f,2.8796864e+02f,2.8859678e+02f,2.8922566e+02f,2.8985482e+02f,2.9048437e+02f,2.9111451e+02f,2.9174515e+02f,2.9237613e+02f,2.9300749e+02f,
2.9363943e+02f,2.9427172e+02f,2.9490455e+02f,2.9553779e+02f,2.9617150e+02f,2.9680572e+02f,2.9744028e+02f,2.9807522e+02f,2.9871073e+02f,2.9934682e+02f,2.9998308e+02f,3.0061998e+02f,3.0125728e+02f,3.0189498e+02f,3.0253332e+02f,3.0317183e+02f,3.0381092e+02f,3.0445058e+02f,3.0509062e+02f,3.0573101e+02f,3.0637189e+02f,3.0701325e+02f,3.0765502e+02f,3.0829733e+02f,3.0894000e+02f,3.0958324e+02f,3.1022685e+02f,3.1087082e+02f,3.1151528e+02f,3.1216032e+02f,3.1280578e+02f,3.1345148e+02f,3.1409795e+02f,3.1474456e+02f,3.1539171e+02f,3.1603944e+02f,3.1668759e+02f,3.1733608e+02f,3.1798502e+02f,3.1863449e+02f,3.1928432e+02f,3.1993472e+02f,3.2058548e+02f,3.2123680e+02f,3.2188835e+02f,3.2254043e+02f,3.2319312e+02f,3.2384615e+02f,3.2449955e+02f,3.2515331e+02f,
3.2580764e+02f,3.2646253e+02f,3.2711783e+02f,3.2777348e+02f,3.2842959e+02f,3.2908621e+02f,3.2974319e+02f,3.3040053e+02f,3.3105846e+02f,3.3171673e+02f,3.3237555e+02f,3.3303480e+02f,3.3369439e+02f,3.3435442e+02f,3.3501503e+02f,3.3567616e+02f,3.3633744e+02f,3.3699929e+02f,3.3766151e+02f,3.3832426e+02f,3.3898744e+02f,3.3965106e+02f,3.4031521e+02f,3.4097971e+02f,3.4164457e+02f,3.4230979e+02f,3.4297556e+02f,3.4364192e+02f,3.4430855e+02f,3.4497553e+02f,3.4564310e+02f,3.4631117e+02f,3.4697939e+02f,3.4764819e+02f,3.4831758e+02f,3.4898716e+02f,3.4965718e+02f,3.5032780e+02f,3.5099882e+02f,3.5167006e+02f,3.5234190e+02f,3.5301429e+02f,3.5368684e+02f,3.5435992e+02f,3.5503341e+02f,3.5570738e+02f,3.5638183e+02f,3.5705664e+02f,3.5773182e+02f,3.5840737e+02f,
3.5908327e+02f,3.5975971e+02f,3.6043675e+02f,3.6111407e+02f,3.6179174e+02f,3.6246987e+02f,3.6314824e+02f,3.6382739e+02f,3.6450666e+02f,3.6518651e+02f,3.6586657e+02f,3.6654706e+02f,3.6722814e+02f,3.6790963e+02f,3.6859135e+02f,3.6927365e+02f,3.6995630e+02f,3.7063931e+02f,3.7132268e+02f,3.7200659e+02f,3.7269082e+02f,3.7337537e+02f,3.7406046e+02f,3.7474589e+02f,3.7543170e+02f,3.7611786e+02f,3.7680460e+02f,3.7749157e+02f,3.7817895e+02f,3.7886684e+02f,3.7955501e+02f,3.8024340e+02f,3.8093238e+02f,3.8162171e+02f,3.8231140e+02f,3.8300165e+02f,3.8369218e+02f,3.8438296e+02f,3.8507421e+02f,3.8576595e+02f,3.8645785e+02f,3.8715012e+02f,3.8784298e+02f,3.8853603e+02f,3.8922956e+02f,3.8992343e+02f,3.9061761e+02f,3.9131229e+02f,3.9200715e+02f,3.9270260e+02f,
3.9339821e+02f,3.9409416e+02f,3.9479066e+02f,3.9548747e+02f,3.9618453e+02f,3.9688197e+02f,3.9757979e+02f,3.9827796e+02f,3.9897629e+02f,3.9967518e+02f,4.0037449e+02f,4.0107402e+02f,4.0177382e+02f,4.0247400e+02f,4.0317455e+02f,4.0387546e+02f,4.0457653e+02f,4.0527818e+02f,4.0598005e+02f,4.0668222e+02f,4.0738479e+02f,4.0808764e+02f,4.0879070e+02f,4.0949415e+02f,4.1019797e+02f,4.1090194e+02f,4.1160649e+02f,4.1231111e+02f,4.1301609e+02f,4.1372147e+02f,4.1442707e+02f,4.1513303e+02f,4.1583915e+02f,4.1654566e+02f,4.1725255e+02f,4.1795965e+02f,4.1866691e+02f,4.1937456e+02f,4.2008261e+02f,4.2079066e+02f,4.2149912e+02f,4.2220795e+02f,4.2291695e+02f,4.2362632e+02f,4.2433592e+02f,4.2504569e+02f,4.2575572e+02f,4.2646609e+02f,4.2717665e+02f,4.2788759e+02f,
4.2859848e+02f,4.2930994e+02f,4.3002149e+02f,4.3073326e+02f,4.3144535e+02f,4.3215760e+02f,4.3287003e+02f,4.3358265e+02f,4.3429566e+02f,4.3500886e+02f,4.3572224e+02f,4.3643580e+02f,4.3714955e+02f,4.3786348e+02f,4.3857763e+02f,4.3929215e+02f,4.4000662e+02f,4.4072150e+02f,4.4143639e+02f,4.4215157e+02f,4.4286692e+02f,4.4358231e+02f,4.4429790e+02f,4.4501368e+02f,4.4572987e+02f,4.4644604e+02f,4.4716217e+02f,4.4787863e+02f,4.4859522e+02f,4.4931197e+02f,4.5002896e+02f,4.5074578e+02f,4.5146302e+02f,4.5218022e+02f,4.5289761e+02f,4.5361519e+02f,4.5433283e+02f,4.5505055e+02f,4.5576841e+02f,4.5648628e+02f,4.5720435e+02f,4.5792239e+02f,4.5864064e+02f,4.5935889e+02f,4.6007729e+02f,4.6079578e+02f,4.6151425e+02f,4.6223276e+02f,4.6295145e+02f,4.6367014e+02f,
4.6438882e+02f,4.6510749e+02f,4.6582633e+02f,4.6654512e+02f,4.6726386e+02f,4.6798277e+02f,4.6870167e+02f,4.6942056e+02f,4.7013945e+02f,4.7085835e+02f,4.7157724e+02f,4.7229614e+02f,4.7301504e+02f,4.7373388e+02f,4.7445257e+02f,4.7517147e+02f,4.7589016e+02f,4.7660886e+02f,4.7732736e+02f,4.7804597e+02f,4.7876459e+02f,4.7948298e+02f,4.8020123e+02f,4.8091950e+02f,4.8163777e+02f,4.8235586e+02f,4.8307374e+02f,4.8379158e+02f,4.8450945e+02f,4.8522715e+02f,4.8594454e+02f,4.8666197e+02f,4.8737941e+02f,4.8809644e+02f,4.8881327e+02f,4.8953008e+02f,4.9024677e+02f,4.9096327e+02f,4.9167960e+02f,4.9239570e+02f,4.9311143e+02f,4.9382720e+02f,4.9454279e+02f,4.9525803e+02f,4.9597302e+02f,4.9668784e+02f,4.9740248e+02f,4.9811690e+02f,4.9883094e+02f,4.9954482e+02f,
5.0025831e+02f,5.0097161e+02f,5.0168458e+02f,5.0239730e+02f,5.0310976e+02f,5.0382188e+02f,5.0453382e+02f,5.0524537e+02f,5.0595656e+02f,5.0666738e+02f,5.0737781e+02f,5.0808802e+02f,5.0879787e+02f,5.0950725e+02f,5.1021642e+02f,5.1092502e+02f,5.1163325e+02f,5.1234133e+02f,5.1304872e+02f,5.1375576e+02f,5.1446243e+02f,5.1516867e+02f,5.1587466e+02f,5.1657987e+02f,5.1728474e+02f,5.1798926e+02f,5.1869324e+02f,5.1939665e+02f,5.2009963e+02f,5.2080217e+02f,5.2150415e+02f,5.2220558e+02f,5.2290668e+02f,5.2360699e+02f,5.2430693e+02f,5.2500638e+02f,5.2570512e+02f,5.2640330e+02f,5.2710103e+02f,5.2779802e+02f,5.2849447e+02f,5.2919037e+02f,5.2988552e+02f,5.3058028e+02f,5.3127428e+02f,5.3196752e+02f,5.3266024e+02f,5.3335237e+02f,5.3404375e+02f,5.3473461e+02f,
5.3542452e+02f,5.3611385e+02f,5.3680248e+02f,5.3749050e+02f,5.3817782e+02f,5.3886423e+02f,5.3954992e+02f,5.4023487e+02f,5.4091930e+02f,5.4160284e+02f,5.4228541e+02f,5.4296732e+02f,5.4364853e+02f,5.4432884e+02f,5.4500840e+02f,5.4568703e+02f,5.4636471e+02f,5.4704188e+02f,5.4771801e+02f,5.4839327e+02f,5.4906773e+02f,5.4974124e+02f,5.5041387e+02f,5.5108576e+02f,5.5175650e+02f,5.5242654e+02f,5.5309550e+02f,5.5376349e+02f,5.5443055e+02f,5.5509670e+02f,5.5576193e+02f,5.5642623e+02f,5.5708939e+02f,5.5775165e+02f,5.5841299e+02f,5.5907328e+02f,5.5973243e+02f,5.6039057e+02f,5.6104776e+02f,5.6170382e+02f,5.6235878e+02f,5.6301284e+02f,5.6366560e+02f,5.6431741e+02f,5.6496802e+02f,5.6561752e+02f,5.6626608e+02f,5.6691348e+02f,5.6755958e+02f,5.6820458e+02f,
5.6884848e+02f,5.6949129e+02f,5.7013287e+02f,5.7077313e+02f,5.7141217e+02f,5.7205012e+02f,5.7268696e+02f,5.7332249e+02f,5.7395672e+02f,5.7458985e+02f,5.7522172e+02f,5.7585231e+02f,5.7648160e+02f,5.7710960e+02f,5.7773631e+02f,5.7836173e+02f,5.7898588e+02f,5.7960852e+02f,5.8023003e+02f,5.8085018e+02f,5.8146893e+02f,5.8208641e+02f,5.8270256e+02f,5.8331723e+02f,5.8393064e+02f,5.8454255e+02f,5.8515317e+02f,5.8575814e+02f,5.8639530e+02f,5.8705406e+02f,5.8765254e+02f,5.8818295e+02f,5.8878670e+02f,5.8938766e+02f,5.8998678e+02f,5.9058438e+02f,5.9118051e+02f,5.9177517e+02f,5.9236835e+02f,5.9296006e+02f,5.9355029e+02f,5.9413906e+02f,5.9472617e+02f,5.9531178e+02f,5.9589579e+02f,5.9647822e+02f,5.9705919e+02f,5.9763867e+02f,5.9821647e+02f,5.9879259e+02f,
5.9936726e+02f,5.9994030e+02f,6.0051166e+02f,6.0108148e+02f,6.0164969e+02f,6.0221610e+02f,6.0278107e+02f,6.0334435e+02f,6.0390599e+02f,6.0446596e+02f,6.0502427e+02f,6.0558093e+02f,6.0613593e+02f,6.0668923e+02f,6.0724069e+02f,6.0779050e+02f,6.0833865e+02f,6.0888515e+02f,6.0943000e+02f,6.0999582e+02f,6.1042539e+02f,6.1065792e+02f,6.1096261e+02f,6.1157939e+02f};

/**** LDC LUT distorted to undistorted ******/
int ldcLUT_D2U_type = 0; 
int ldcLUT_D2U_length = 1024;
float ldcLUT_D2U_step = 3.5889965e+02f;
float ldcLUT_D2U_table[]= {
1.0000000e+00f,1.0003009e+00f,1.0008707e+00f,1.0014571e+00f,1.0020337e+00f,1.0026195e+00f,1.0032056e+00f,1.0037920e+00f,1.0043806e+00f,1.0049704e+00f,1.0055644e+00f,1.0061591e+00f,1.0067547e+00f,1.0073532e+00f,1.0079548e+00f,1.0085569e+00f,1.0091623e+00f,1.0097695e+00f,1.0103769e+00f,1.0109890e+00f,1.0116002e+00f,1.0122134e+00f,1.0128299e+00f,1.0134480e+00f,1.0140685e+00f,1.0146891e+00f,1.0153141e+00f,1.0159409e+00f,1.0165677e+00f,1.0171979e+00f,1.0178271e+00f,1.0184627e+00f,1.0190957e+00f,1.0197336e+00f,1.0203720e+00f,1.0210137e+00f,1.0216562e+00f,1.0223024e+00f,1.0229488e+00f,1.0235969e+00f,1.0242470e+00f,1.0248993e+00f,1.0255544e+00f,1.0262106e+00f,1.0268694e+00f,1.0275284e+00f,1.0281901e+00f,1.0288545e+00f,1.0295196e+00f,1.0301879e+00f,
1.0308575e+00f,1.0315296e+00f,1.0322030e+00f,1.0328778e+00f,1.0335548e+00f,1.0342346e+00f,1.0349142e+00f,1.0355974e+00f,1.0362821e+00f,1.0369689e+00f,1.0376586e+00f,1.0383493e+00f,1.0390415e+00f,1.0397365e+00f,1.0404314e+00f,1.0411304e+00f,1.0418300e+00f,1.0425319e+00f,1.0432363e+00f,1.0439416e+00f,1.0446497e+00f,1.0453598e+00f,1.0460716e+00f,1.0467846e+00f,1.0475006e+00f,1.0482176e+00f,1.0489378e+00f,1.0496575e+00f,1.0503807e+00f,1.0511070e+00f,1.0518332e+00f,1.0525630e+00f,1.0532941e+00f,1.0540267e+00f,1.0547609e+00f,1.0554973e+00f,1.0562370e+00f,1.0569768e+00f,1.0577205e+00f,1.0584642e+00f,1.0592118e+00f,1.0599598e+00f,1.0607097e+00f,1.0614621e+00f,1.0622172e+00f,1.0629726e+00f,1.0637309e+00f,1.0644917e+00f,1.0652537e+00f,1.0660180e+00f,
1.0667839e+00f,1.0675519e+00f,1.0683224e+00f,1.0690934e+00f,1.0698686e+00f,1.0706444e+00f,1.0714226e+00f,1.0722020e+00f,1.0729845e+00f,1.0737685e+00f,1.0745548e+00f,1.0753430e+00f,1.0761322e+00f,1.0769248e+00f,1.0777190e+00f,1.0785155e+00f,1.0793123e+00f,1.0801134e+00f,1.0809151e+00f,1.0817191e+00f,1.0825255e+00f,1.0833345e+00f,1.0841441e+00f,1.0849562e+00f,1.0857710e+00f,1.0865868e+00f,1.0874059e+00f,1.0882265e+00f,1.0890495e+00f,1.0898734e+00f,1.0907000e+00f,1.0915292e+00f,1.0923595e+00f,1.0931935e+00f,1.0940275e+00f,1.0948651e+00f,1.0957040e+00f,1.0965455e+00f,1.0973887e+00f,1.0982337e+00f,1.0990815e+00f,1.0999316e+00f,1.1007829e+00f,1.1016370e+00f,1.1024939e+00f,1.1033518e+00f,1.1042120e+00f,1.1050742e+00f,1.1059395e+00f,1.1068052e+00f,
1.1076748e+00f,1.1085457e+00f,1.1094190e+00f,1.1102937e+00f,1.1111713e+00f,1.1120505e+00f,1.1129332e+00f,1.1138162e+00f,1.1147030e+00f,1.1155912e+00f,1.1164817e+00f,1.1173744e+00f,1.1182696e+00f,1.1191665e+00f,1.1200661e+00f,1.1209679e+00f,1.1218712e+00f,1.1227771e+00f,1.1236858e+00f,1.1245957e+00f,1.1255086e+00f,1.1264240e+00f,1.1273409e+00f,1.1282603e+00f,1.1291814e+00f,1.1301054e+00f,1.1310323e+00f,1.1319613e+00f,1.1328915e+00f,1.1338240e+00f,1.1347594e+00f,1.1356977e+00f,1.1366378e+00f,1.1375804e+00f,1.1385248e+00f,1.1394717e+00f,1.1404204e+00f,1.1413717e+00f,1.1423259e+00f,1.1432819e+00f,1.1442404e+00f,1.1452020e+00f,1.1461653e+00f,1.1471313e+00f,1.1480991e+00f,1.1490696e+00f,1.1500420e+00f,1.1510169e+00f,1.1519948e+00f,1.1529748e+00f,
1.1539571e+00f,1.1549426e+00f,1.1559296e+00f,1.1569187e+00f,1.1579112e+00f,1.1589057e+00f,1.1599029e+00f,1.1609020e+00f,1.1619041e+00f,1.1629079e+00f,1.1639147e+00f,1.1649246e+00f,1.1659362e+00f,1.1669508e+00f,1.1679674e+00f,1.1689866e+00f,1.1700090e+00f,1.1710338e+00f,1.1720604e+00f,1.1730891e+00f,1.1741210e+00f,1.1751559e+00f,1.1761926e+00f,1.1772325e+00f,1.1782743e+00f,1.1793189e+00f,1.1803667e+00f,1.1814171e+00f,1.1824693e+00f,1.1835239e+00f,1.1845827e+00f,1.1856421e+00f,1.1867059e+00f,1.1877709e+00f,1.1888392e+00f,1.1899107e+00f,1.1909841e+00f,1.1920598e+00f,1.1931387e+00f,1.1942208e+00f,1.1953050e+00f,1.1963922e+00f,1.1974820e+00f,1.1985741e+00f,1.1996695e+00f,1.2007669e+00f,1.2018675e+00f,1.2029714e+00f,1.2040779e+00f,1.2051865e+00f,
1.2062975e+00f,1.2074131e+00f,1.2085296e+00f,1.2096500e+00f,1.2107730e+00f,1.2118979e+00f,1.2130272e+00f,1.2141587e+00f,1.2152924e+00f,1.2164291e+00f,1.2175691e+00f,1.2187124e+00f,1.2198578e+00f,1.2210066e+00f,1.2221580e+00f,1.2233121e+00f,1.2244696e+00f,1.2256293e+00f,1.2267923e+00f,1.2279588e+00f,1.2291282e+00f,1.2303001e+00f,1.2314742e+00f,1.2326527e+00f,1.2338338e+00f,1.2350170e+00f,1.2362047e+00f,1.2373950e+00f,1.2385877e+00f,1.2397832e+00f,1.2409823e+00f,1.2421850e+00f,1.2433902e+00f,1.2445984e+00f,1.2458101e+00f,1.2470242e+00f,1.2482419e+00f,1.2494625e+00f,1.2506859e+00f,1.2519141e+00f,1.2531440e+00f,1.2543768e+00f,1.2556131e+00f,1.2568531e+00f,1.2580966e+00f,1.2593432e+00f,1.2605925e+00f,1.2618445e+00f,1.2631000e+00f,1.2643591e+00f,
1.2656218e+00f,1.2668870e+00f,1.2681558e+00f,1.2694283e+00f,1.2707044e+00f,1.2719832e+00f,1.2732655e+00f,1.2745513e+00f,1.2758398e+00f,1.2771320e+00f,1.2784279e+00f,1.2797275e+00f,1.2810300e+00f,1.2823352e+00f,1.2836439e+00f,1.2849574e+00f,1.2862738e+00f,1.2875936e+00f,1.2889172e+00f,1.2902437e+00f,1.2915738e+00f,1.2929076e+00f,1.2942443e+00f,1.2955848e+00f,1.2969291e+00f,1.2982773e+00f,1.2996294e+00f,1.3009850e+00f,1.3023436e+00f,1.3037052e+00f,1.3050710e+00f,1.3064415e+00f,1.3078149e+00f,1.3091915e+00f,1.3105715e+00f,1.3119567e+00f,1.3133453e+00f,1.3147370e+00f,1.3161318e+00f,1.3175314e+00f,1.3189353e+00f,1.3203424e+00f,1.3217526e+00f,1.3231666e+00f,1.3245859e+00f,1.3260085e+00f,1.3274344e+00f,1.3288635e+00f,1.3302977e+00f,1.3317362e+00f,
1.3331778e+00f,1.3346236e+00f,1.3360734e+00f,1.3375265e+00f,1.3389837e+00f,1.3404452e+00f,1.3419109e+00f,1.3433809e+00f,1.3448551e+00f,1.3463336e+00f,1.3478159e+00f,1.3493017e+00f,1.3507908e+00f,1.3522848e+00f,1.3537838e+00f,1.3552860e+00f,1.3567929e+00f,1.3583050e+00f,1.3598198e+00f,1.3613384e+00f,1.3628627e+00f,1.3643905e+00f,1.3659224e+00f,1.3674599e+00f,1.3690015e+00f,1.3705467e+00f,1.3720955e+00f,1.3736491e+00f,1.3752082e+00f,1.3767709e+00f,1.3783378e+00f,1.3799093e+00f,1.3814855e+00f,1.3830662e+00f,1.3846517e+00f,1.3862414e+00f,1.3878349e+00f,1.3894340e+00f,1.3910380e+00f,1.3926457e+00f,1.3942581e+00f,1.3958753e+00f,1.3974973e+00f,1.3991240e+00f,1.4007556e+00f,1.4023913e+00f,1.4040313e+00f,1.4056773e+00f,1.4073279e+00f,1.4089825e+00f,
1.4106420e+00f,1.4123066e+00f,1.4139771e+00f,1.4156523e+00f,1.4173316e+00f,1.4190159e+00f,1.4207053e+00f,1.4223998e+00f,1.4240988e+00f,1.4258021e+00f,1.4275113e+00f,1.4292261e+00f,1.4309460e+00f,1.4326706e+00f,1.4343995e+00f,1.4361343e+00f,1.4378749e+00f,1.4396207e+00f,1.4413714e+00f,1.4431263e+00f,1.4448873e+00f,1.4466542e+00f,1.4484254e+00f,1.4502019e+00f,1.4519848e+00f,1.4537725e+00f,1.4555649e+00f,1.4573636e+00f,1.4591681e+00f,1.4609770e+00f,1.4627915e+00f,1.4646125e+00f,1.4664391e+00f,1.4682711e+00f,1.4701078e+00f,1.4719500e+00f,1.4737987e+00f,1.4756533e+00f,1.4775134e+00f,1.4793792e+00f,1.4812508e+00f,1.4831279e+00f,1.4850111e+00f,1.4869010e+00f,1.4887966e+00f,1.4906970e+00f,1.4926032e+00f,1.4945154e+00f,1.4964342e+00f,1.4983595e+00f,
1.5002906e+00f,1.5022276e+00f,1.5041707e+00f,1.5061198e+00f,1.5080748e+00f,1.5100368e+00f,1.5120054e+00f,1.5139791e+00f,1.5159587e+00f,1.5179455e+00f,1.5199387e+00f,1.5219381e+00f,1.5239437e+00f,1.5259556e+00f,1.5279744e+00f,1.5300003e+00f,1.5320324e+00f,1.5340709e+00f,1.5361157e+00f,1.5381673e+00f,1.5402264e+00f,1.5422917e+00f,1.5443624e+00f,1.5464408e+00f,1.5485275e+00f,1.5506199e+00f,1.5527183e+00f,1.5548243e+00f,1.5569376e+00f,1.5590573e+00f,1.5611841e+00f,1.5633186e+00f,1.5654602e+00f,1.5676085e+00f,1.5697637e+00f,1.5719258e+00f,1.5740954e+00f,1.5762727e+00f,1.5784578e+00f,1.5806506e+00f,1.5828493e+00f,1.5850549e+00f,1.5872694e+00f,1.5894921e+00f,1.5917217e+00f,1.5939585e+00f,1.5962026e+00f,1.5984543e+00f,1.6007144e+00f,1.6029819e+00f,
1.6052567e+00f,1.6075395e+00f,1.6098305e+00f,1.6121298e+00f,1.6144373e+00f,1.6167523e+00f,1.6190749e+00f,1.6214060e+00f,1.6237455e+00f,1.6260925e+00f,1.6284474e+00f,1.6308120e+00f,1.6331853e+00f,1.6355652e+00f,1.6379530e+00f,1.6403507e+00f,1.6427572e+00f,1.6451714e+00f,1.6475941e+00f,1.6500256e+00f,1.6524660e+00f,1.6549153e+00f,1.6573735e+00f,1.6598408e+00f,1.6623167e+00f,1.6648008e+00f,1.6672938e+00f,1.6697960e+00f,1.6723074e+00f,1.6748281e+00f,1.6773580e+00f,1.6798972e+00f,1.6824458e+00f,1.6850038e+00f,1.6875713e+00f,1.6901484e+00f,1.6927345e+00f,1.6953292e+00f,1.6979341e+00f,1.7005497e+00f,1.7031745e+00f,1.7058081e+00f,1.7084521e+00f,1.7111070e+00f,1.7137713e+00f,1.7164445e+00f,1.7191283e+00f,1.7218232e+00f,1.7245282e+00f,1.7272434e+00f,
1.7299688e+00f,1.7327047e+00f,1.7354503e+00f,1.7382054e+00f,1.7409714e+00f,1.7437487e+00f,1.7465374e+00f,1.7493376e+00f,1.7521480e+00f,1.7549680e+00f,1.7577992e+00f,1.7606425e+00f,1.7634964e+00f,1.7663598e+00f,1.7692351e+00f,1.7721237e+00f,1.7750234e+00f,1.7779329e+00f,1.7808539e+00f,1.7837873e+00f,1.7867325e+00f,1.7896890e+00f,1.7926570e+00f,1.7956365e+00f,1.7986278e+00f,1.8016319e+00f,1.8046483e+00f,1.8076762e+00f,1.8107162e+00f,1.8137691e+00f,1.8168347e+00f,1.8199122e+00f,1.8230019e+00f,1.8261047e+00f,1.8292206e+00f,1.8323488e+00f,1.8354894e+00f,1.8386432e+00f,1.8418106e+00f,1.8449907e+00f,1.8481833e+00f,1.8513894e+00f,1.8546092e+00f,1.8578427e+00f,1.8610902e+00f,1.8643511e+00f,1.8676249e+00f,1.8709123e+00f,1.8742141e+00f,1.8775300e+00f,
1.8808601e+00f,1.8842046e+00f,1.8875637e+00f,1.8909372e+00f,1.8943243e+00f,1.8977253e+00f,1.9011420e+00f,1.9045747e+00f,1.9080215e+00f,1.9114824e+00f,1.9149583e+00f,1.9184495e+00f,1.9219561e+00f,1.9254780e+00f,1.9290155e+00f,1.9325686e+00f,1.9361374e+00f,1.9397219e+00f,1.9433224e+00f,1.9469388e+00f,1.9505714e+00f,1.9542201e+00f,1.9578851e+00f,1.9615665e+00f,1.9652642e+00f,1.9689792e+00f,1.9727122e+00f,1.9764617e+00f,1.9802266e+00f,1.9840086e+00f,1.9878090e+00f,1.9916272e+00f,1.9954624e+00f,1.9993152e+00f,2.0031866e+00f,2.0070767e+00f,2.0109836e+00f,2.0149073e+00f,2.0188496e+00f,2.0228111e+00f,2.0267917e+00f,2.0307917e+00f,2.0348107e+00f,2.0388481e+00f,2.0429044e+00f,2.0469794e+00f,2.0510736e+00f,2.0551878e+00f,2.0593221e+00f,2.0634767e+00f,
2.0676519e+00f,2.0718470e+00f,2.0760618e+00f,2.0802967e+00f,2.0845512e+00f,2.0888265e+00f,2.0931244e+00f,2.0974445e+00f,2.1017851e+00f,2.1061464e+00f,2.1105287e+00f,2.1149317e+00f,2.1193572e+00f,2.1238064e+00f,2.1282784e+00f,2.1327730e+00f,2.1372903e+00f,2.1418293e+00f,2.1463906e+00f,2.1509751e+00f,2.1555832e+00f,2.1602149e+00f,2.1648703e+00f,2.1695496e+00f,2.1742529e+00f,2.1789807e+00f,2.1837343e+00f,2.1885134e+00f,2.1933161e+00f,2.1981428e+00f,2.2029945e+00f,2.2078716e+00f,2.2127748e+00f,2.2177052e+00f,2.2226621e+00f,2.2276449e+00f,2.2326541e+00f,2.2376899e+00f,2.2427525e+00f,2.2478420e+00f,2.2529585e+00f,2.2581031e+00f,2.2632766e+00f,2.2684786e+00f,2.2737082e+00f,2.2789661e+00f,2.2842537e+00f,2.2895713e+00f,2.2949178e+00f,2.3002930e+00f,
2.3056984e+00f,2.3111348e+00f,2.3166019e+00f,2.3220986e+00f,2.3276258e+00f,2.3331848e+00f,2.3387759e+00f,2.3443983e+00f,2.3500517e+00f,2.3557372e+00f,2.3614560e+00f,2.3672080e+00f,2.3729934e+00f,2.3788126e+00f,2.3846658e+00f,2.3905533e+00f,2.3964754e+00f,2.4024328e+00f,2.4084249e+00f,2.4144508e+00f,2.4205116e+00f,2.4266101e+00f,2.4327467e+00f,2.4389189e+00f,2.4451262e+00f,2.4513711e+00f,2.4576556e+00f,2.4639790e+00f,2.4703406e+00f,2.4767409e+00f,2.4831790e+00f,2.4896545e+00f,2.4961710e+00f,2.5027316e+00f,2.5093336e+00f,2.5159741e+00f,2.5226546e+00f,2.5293783e+00f,2.5361459e+00f,2.5429549e+00f,2.5498041e+00f,2.5566969e+00f,2.5636371e+00f,2.5706232e+00f,2.5776533e+00f,2.5847280e+00f,2.5918478e+00f,2.5990130e+00f,2.6062250e+00f,2.6134849e+00f,
2.6207931e+00f,2.6281500e+00f,2.6355561e+00f,2.6430105e+00f,2.6505132e+00f,2.6580660e+00f,2.6656701e+00f,2.6733258e+00f,2.6810337e+00f,2.6887942e+00f,2.6966062e+00f,2.7044698e+00f,2.7123880e+00f,2.7203636e+00f,2.7283948e+00f,2.7364796e+00f,2.7446193e+00f,2.7528159e+00f,2.7610699e+00f,2.7693830e+00f,2.7777572e+00f,2.7861911e+00f,2.7946823e+00f,2.8032326e+00f,2.8118459e+00f,2.8205230e+00f,2.8292630e+00f,2.8380657e+00f,2.8469323e+00f,2.8558632e+00f,2.8648592e+00f,2.8739230e+00f,2.8830558e+00f,2.8922551e+00f,2.9015189e+00f,2.9108519e+00f,2.9202593e+00f,2.9297402e+00f,2.9392919e+00f,2.9489152e+00f,2.9586114e+00f,2.9683807e+00f,2.9782251e+00f,2.9881471e+00f,2.9981469e+00f,3.0082233e+00f,3.0183767e+00f,3.0286115e+00f,3.0389311e+00f,3.0493334e+00f,
3.0598162e+00f,3.0703816e+00f,3.0810326e+00f,3.0917705e+00f,3.1025945e+00f,3.1135037e+00f,3.1245018e+00f,3.1355934e+00f,3.1467786e+00f,3.1580564e+00f,3.1694278e+00f,3.1808943e+00f,3.1924576e+00f,3.2041179e+00f,3.2158739e+00f,3.2277276e+00f,3.2396846e+00f,3.2517464e+00f,3.2639139e+00f,3.2761894e+00f,3.2885723e+00f,3.3010594e+00f,3.3136534e+00f,3.3263603e+00f,3.3391824e+00f,3.3521189e+00f,3.3651693e+00f,3.3783369e+00f,3.3916252e+00f,3.4050356e+00f,3.4185697e+00f,3.4322302e+00f,3.4460151e+00f,3.4599215e+00f,3.4739552e+00f,3.4881255e+00f,3.5024331e+00f,3.5168744e+00f,3.5314499e+00f,3.5461643e+00f,3.5610211e+00f,3.5760218e+00f,3.5911687e+00f,3.6064640e+00f,3.6219071e+00f,3.6374983e+00f,3.6532442e+00f,3.6691520e+00f,3.6852209e+00f,3.7014474e+00f,
3.7178340e+00f,3.7343893e+00f,3.7511180e+00f,3.7680196e+00f,3.7850946e+00f,3.8023466e+00f,3.8197784e+00f,3.8373926e+00f,3.8551923e+00f,3.8731802e+00f,3.8913595e+00f,3.9097324e+00f,3.9283030e+00f,3.9470778e+00f,3.9660604e+00f,3.9852507e+00f,4.0046510e+00f,4.0242655e+00f,4.0440971e+00f,4.0641502e+00f,4.0844320e+00f,4.1049462e+00f,4.1256964e+00f,4.1466877e+00f,4.1679219e+00f,4.1893996e+00f,4.2111268e+00f,4.2331118e+00f,4.2553589e+00f,4.2778725e+00f,4.3006584e+00f,4.3237189e+00f,4.3470543e+00f,4.3706725e+00f,4.3945876e+00f,4.4188059e+00f,4.4433238e+00f,4.4681419e+00f,4.4932735e+00f,4.5187328e+00f,4.5445219e+00f,4.5706374e+00f,4.5970859e+00f,4.6238792e+00f,4.6510240e+00f,4.6785298e+00f,4.7064082e+00f,4.7346643e+00f,4.7633007e+00f,4.7923257e+00f,
4.8217475e+00f,4.8515744e+00f,4.8818149e+00f,4.9124762e+00f,4.9435693e+00f,4.9751083e+00f,5.0071024e+00f,5.0395610e+00f,5.0724959e+00f,5.1059128e+00f,5.1398187e+00f,5.1742260e+00f,5.2091450e+00f,5.2445876e+00f,5.2805718e+00f,5.3171110e+00f,5.3542171e+00f,5.3919049e+00f,5.4301850e+00f,5.4690639e+00f,5.5085587e+00f,5.5486912e+00f,5.5894772e+00f,5.6309318e+00f,5.6730717e+00f,5.7159140e+00f,5.7594761e+00f,5.8037768e+00f,5.8488344e+00f,5.8946690e+00f,5.9413005e+00f,5.9887500e+00f,6.0370392e+00f,6.0861884e+00f,6.1362248e+00f,6.1871828e+00f,6.2390864e+00f,6.2919404e+00f,6.3457668e+00f,6.4006130e+00f,6.4565196e+00f,6.5135068e+00f,6.5715973e+00f,6.6308271e+00f,6.6912282e+00f,6.7528359e+00f,6.8156975e+00f,6.8798575e+00f,6.9453445e+00f,7.0121899e+00f,
7.0804463e+00f,7.1501709e+00f,7.2214085e+00f,7.2941925e+00f,7.3685734e+00f,7.4446648e+00f,7.5235016e+00f,7.6022422e+00f,7.6770735e+00f,7.7510941e+00f,7.8300279e+00f,7.9135196e+00f,8.0046170e+00f,8.1097435e+00f,8.2150288e+00f,8.3121420e+00f,8.4091465e+00f,8.5103718e+00f,8.6142605e+00f,8.7209349e+00f,8.8305017e+00f,8.9430536e+00f,9.0587175e+00f,9.1776244e+00f,9.2999140e+00f,9.4257327e+00f,9.5552341e+00f,9.6885852e+00f,9.8259561e+00f,9.9675366e+00f,1.0113518e+01f,1.0264113e+01f,1.0419540e+01f,1.0580031e+01f,1.0745867e+01f,1.0917340e+01f,1.1094714e+01f,1.1278262e+01f,1.1468345e+01f,1.1665348e+01f,1.1869654e+01f,1.2081623e+01f,1.2301705e+01f,1.2530373e+01f,1.2768130e+01f,1.3015577e+01f,1.3273333e+01f,1.3542056e+01f,1.3822457e+01f,1.4115311e+01f,
1.4421378e+01f,1.4741625e+01f,1.5077104e+01f,1.5428946e+01f,1.5798358e+01f,1.6186715e+01f,1.6595428e+01f,1.7026064e+01f,1.7480630e+01f,1.7961288e+01f,1.8470234e+01f,1.9009778e+01f,1.9582960e+01f,2.0193041e+01f,2.0843788e+01f,2.1539292e+01f,2.2284439e+01f,2.3084660e+01f,2.3946343e+01f,2.4876862e+01f,2.5884724e+01f,2.6980181e+01f,2.8174848e+01f,2.9483341e+01f};
