#ifndef _AVM_H_
#define _AVM_H_

#ifdef __cplusplus
extern "C" {
#endif

#include <stdbool.h>


#define BIT_2D_3D      31
#define BIT_ORI_UND    30
#define BIT_3D_MOVE    29

/* bit[31]: 0---2DView
*           1---3DView
*  bit[30]: 0---2DorignalView
*           1---2DUndistView
*/
typedef enum{
    /*No View*/
    AVM_DISPLAY_STATE_NONE                      = 0x00,
    /*Draw spliter picture*/
    AVM_DISPLAY_STATE_SPLITER                   = 0x01,
    /*2D View*/
    AVM_DISPLAY_STATE_QUADRI_GRID               = (0<<BIT_2D_3D)|(0<<BIT_ORI_UND)|0x02,
    AVM_DISPLAY_STATE_ORIGNAL_FRONT             = (0<<BIT_2D_3D)|(0<<BIT_ORI_UND)|0x03,
    AVM_DISPLAY_STATE_ORIGNAL_REAR              = (0<<BIT_2D_3D)|(0<<BIT_ORI_UND)|0x04,
    AVM_DISPLAY_STATE_ORIGNAL_LEFT              = (0<<BIT_2D_3D)|(0<<BIT_ORI_UND)|0x05,
    AVM_DISPLAY_STATE_ORIGNAL_RIGHT             = (0<<BIT_2D_3D)|(0<<BIT_ORI_UND)|0x06,

    AVM_DISPLAY_STATE_CORRECT_FRONT             = (0<<BIT_2D_3D)|(1<<BIT_ORI_UND)|0x00,
    AVM_DISPLAY_STATE_CORRECT_REAR              = (0<<BIT_2D_3D)|(1<<BIT_ORI_UND)|0x01,
    AVM_DISPLAY_STATE_CORRECT_LEFT              = (0<<BIT_2D_3D)|(1<<BIT_ORI_UND)|0x02,
    AVM_DISPLAY_STATE_CORRECT_RIGHT             = (0<<BIT_2D_3D)|(1<<BIT_ORI_UND)|0x03,
    AVM_DISPLAY_STATE_CORRECT_LR_FRONT          = (0<<BIT_2D_3D)|(1<<BIT_ORI_UND)|0x04,
    AVM_DISPLAY_STATE_CORRECT_LR_REAR           = (0<<BIT_2D_3D)|(1<<BIT_ORI_UND)|0x05,
    AVM_DISPLAY_STATE_CORRECT_180_FRONT         = (0<<BIT_2D_3D)|(1<<BIT_ORI_UND)|0x06,
    AVM_DISPLAY_STATE_CORRECT_180_REAR          = (0<<BIT_2D_3D)|(1<<BIT_ORI_UND)|0x07,
    AVM_DISPLAY_STATE_BIRD_VIEW                 = (0<<BIT_2D_3D)|(1<<BIT_ORI_UND)|0x08,

    /*3D View*/
    AVM_DISPLAY_STATE_3D_TOP                    = (1<<BIT_2D_3D)|(0<<BIT_ORI_UND)|0x00,

     AVM_DISPLAY_STATE_3D_FRONT                 = (1<<BIT_2D_3D)|(0<<BIT_ORI_UND)|(1<<BIT_3D_MOVE)|0x01,
    AVM_DISPLAY_STATE_3D_LEFT_FRONT             = (1<<BIT_2D_3D)|(0<<BIT_ORI_UND)|(1<<BIT_3D_MOVE)|0x02,
    AVM_DISPLAY_STATE_3D_LEFT                   = (1<<BIT_2D_3D)|(0<<BIT_ORI_UND)|(1<<BIT_3D_MOVE)|0x03,
    AVM_DISPLAY_STATE_3D_LEFT_REAR              = (1<<BIT_2D_3D)|(0<<BIT_ORI_UND)|(1<<BIT_3D_MOVE)|0x04,
    AVM_DISPLAY_STATE_3D_REAR                   = (1<<BIT_2D_3D)|(0<<BIT_ORI_UND)|(1<<BIT_3D_MOVE)|0x05,
    AVM_DISPLAY_STATE_3D_RIGHT_REAR             = (1<<BIT_2D_3D)|(0<<BIT_ORI_UND)|(1<<BIT_3D_MOVE)|0x06,
    AVM_DISPLAY_STATE_3D_RIGHT                  = (1<<BIT_2D_3D)|(0<<BIT_ORI_UND)|(1<<BIT_3D_MOVE)|0x07,
    AVM_DISPLAY_STATE_3D_RIGHT_FRONT            = (1<<BIT_2D_3D)|(0<<BIT_ORI_UND)|(1<<BIT_3D_MOVE)|0x08,

    AVM_DISPLAY_STATE_3D_TOP_FRONT              = (1<<BIT_2D_3D)|(0<<BIT_ORI_UND)|0x09,
    AVM_DISPLAY_STATE_3D_TOP_REAR               = (1<<BIT_2D_3D)|(0<<BIT_ORI_UND)|0x0A,
    AVM_DISPLAY_STATE_3D_LOOKDOWN_FRONT         = (1<<BIT_2D_3D)|(0<<BIT_ORI_UND)|0x0B,
    AVM_DISPLAY_STATE_3D_LOOKDOWN_REAR          = (1<<BIT_2D_3D)|(0<<BIT_ORI_UND)|0x0C,
    AVM_DISPLAY_STATE_3D_ANYVIEW                = (1<<BIT_2D_3D)|(0<<BIT_ORI_UND)|0x0D,
    AVM_DISPLAY_STATE_3D_CRUISE_VIEW            = (1<<BIT_2D_3D)|(0<<BIT_ORI_UND)|0x0E,
}avmViewState;

typedef struct __ConfigFile {
            int   numLuts;
            int   numCarModel;
            int   numPicture;
     char *lutsPath;
     char *carModelPath;
     char *picturePath;
} ConfigFile;


typedef struct _WindowPos
{
            bool    valid;       //ǰڲǷЧǷҪơ0-Ч1-Ч
    unsigned int    startX;     //ǰ½SurfaceеꡣSuefaceϵ½Ϊԭ㣬ΪXΪY
    unsigned int    startY;
    unsigned int    width;
    unsigned int    height;
    avmViewState    whitchView;     //ǰڻͼ
}WindowPos;


typedef struct _VideoList
{
    unsigned char camState;         //ǰ---
              int width;
              int height;
          void ** videoBuffer;      //ǰ---
}VideoList;

typedef struct _CtrlSignal
{
    bool lineOn;
//    int verPercent;     //ԤĬ0
//    int horAngle;       //ԤĬ0
}CtrlSignal;

typedef struct _VehicleSignal
{
    int steeringAngle;
    int speed;
    int gear;       //0--back off   1--go forward
//    bool apaSwitch;
//    int fr;
    unsigned char doors;    //bit0-bit3:ǰ/ǰ//Һ
    unsigned int leftTurnLight;
    unsigned int rightTurnLight;
    unsigned int brakeLight;
}VehicleSignal;


bool avmInit(ConfigFile stConfigFile);

avmViewState *avmRenderer(WindowPos *stWindowPos[], VideoList *stVideoList, CtrlSignal *stCtrlSignal, VehicleSignal *stVehicleSignal, unsigned int *texidYUV);

#ifdef __cplusplus
}
#endif

#endif /* _AVM_H_ */

