#include <stdio.h>
#include <stdarg.h>
#include "Avm_log.h"


void avm_error(const char *fmt, ...)
{
	va_list ap;
	char error_fmt[2*1024] = {0};
	int ret = 0;

	ret = sprintf(error_fmt, RED("%s"), fmt);
	/*eat tail '\n'*/
	if (ret < (int)sizeof(error_fmt))
	{
		error_fmt[ret] = '\0';
	}
	else
	{
		error_fmt[sizeof(error_fmt)-1] = '\0';
	}

	va_start(ap, fmt);
	vprintf(error_fmt, ap);
	va_end(ap);
}

void avm_debug(const char *fmt, ...)
{
	va_list ap;
	char error_fmt[2*1024] = {0};
	int ret = 0;

	ret = sprintf(error_fmt, GREEN("%s"), fmt);
	/*eat tail '\n'*/
	if (ret < (int)sizeof(error_fmt))
	{
		error_fmt[ret] = '\0';
	}
	else
	{
		error_fmt[sizeof(error_fmt)-1] = '\0';
	}

	va_start(ap, fmt);
	vprintf(error_fmt, ap);
	va_end(ap);
}

void avm_info(const char *fmt, ...)
{
	va_list ap;
	char error_fmt[2*1024] = {0};
	int ret = 0;

	ret = sprintf(error_fmt, WHITE("%s"), fmt);
	/*eat tail '\n'*/
	if (ret < (int)sizeof(error_fmt))
	{
		error_fmt[ret] = '\0';
	}
	else
	{
		error_fmt[sizeof(error_fmt)-1] = '\0';
	}

	va_start(ap, fmt);
	vprintf(error_fmt, ap);
	va_end(ap);
}

void avm_loacation(const char *fmt, ...)
{
	va_list ap;
	char error_fmt[2*1024] = {0};
	int ret = 0;

	ret = sprintf(error_fmt, BLUE("%s"), fmt);
	/*eat tail '\n'*/
	if (ret < (int)sizeof(error_fmt))
	{
		error_fmt[ret] = '\0';
	}
	else
	{
		error_fmt[sizeof(error_fmt)-1] = '\0';
	}

	va_start(ap, fmt);
	vprintf(error_fmt, ap);
	va_end(ap);
}

