#ifndef _AVM_LOG_H_
#define _AVM_LOG_H_

#ifndef MODULE_NAME
#define MODULE_NAME "moduleX"
#endif

#define RED(str)            "\033[1;31m" str "\033[0m"
#define GREEN(str)          "\033[1;32m" str "\033[0m"
#define YELLOW(str)         "\033[1;33m" str "\033[0m"
#define BLUE(str)           "\033[1;34m" str "\033[0m"
#define MAGENTA(str)        "\033[1;35m" str "\033[0m"
#define CYAN(str)           "\033[1;36m" str "\033[0m"
#define WHITE(str)          "\033[1;37m" str "\033[0m"

void avm_error(const char *fmt, ...);
void avm_debug(const char *fmt, ...);
void avm_info(const char *fmt, ...);
void avm_loacation(const char *fmt, ...);


#ifndef AVM_INFO_SWITCH
#define AVM_INFO_SWITCH           1
#endif

#ifndef AVM_DEBUG_SWITCH
#define AVM_DEBUG_SWITCH          0
#endif

#ifndef AVM_LOCATION_SWITCH
#define AVM_LOCATION_SWITCH       0
#endif

#define AVM_ERROR(fmt, ...) \
    avm_error("[%-20s][Error     ]:   %s:%d:" fmt, MODULE_NAME, __func__, __LINE__, ##__VA_ARGS__)

#if (AVM_INFO_SWITCH)
#define AVM_INFO(fmt, ...) \
    avm_info("[%-20s][info      ]:   " fmt, MODULE_NAME, ##__VA_ARGS__)
#else
#define AVM_INFO(fmt, ...)
#endif

#if (AVM_DEBUG_SWITCH)
#define AVM_DEBUG(fmt, ...) \
    avm_debug("[%-20s][debug     ]:   " fmt, MODULE_NAME, ##__VA_ARGS__)
#else
#define AVM_DEBUG(fmt, ...)
#endif

#if (AVM_LOCATION_SWITCH)
#define AVM_LOCATION() \
    avm_loacation("[%-20s][location  ]:   %s:%d:OK!\n", MODULE_NAME, __func__, __LINE__)
#else
#define AVM_LOCATION()
#endif

#endif
