#include "Avm_out.h"
#include "Common.h"
#include "AVM.h"

#define MODULE_NAME "AVM_out"
#define AVM_DEBUG_SWITCH            0
#include "Avm_log.h"


WindowPos  *testWindowPos[2];
VideoList  testVideoList;
CtrlSignal testCtrlSignal;
VehicleSignal testVehicleSignal;

#define BOWL_PICS     "./avmtestfile/samples/"
#define BOWL_luts     "./avmtestfile/luts/"
#define CARMODELS     "./avmtestfile/carmodel/"
#define PICTURES      "./avmtestfile/pictures/"

#define BOWL_FRONT    BOWL_PICS"bowl_front.dat"
#define BOWL_REAR     BOWL_PICS"bowl_rear.dat"
#define BOWL_LEFT     BOWL_PICS"bowl_left.dat"
#define BOWL_RIGHT    BOWL_PICS"bowl_right.dat"

#define NUM_LUTS    7
#define NUM_CARMODEL    1
#define NUM_PICTURE     1

#define LENGTH_FILEPATH   100


void getVideo(UChar **bufArray, int num)
{
    FILE *pPicFile = NULL;
    int i,datasize,readsize;
    const char *SamplePic[4] = {
        BOWL_FRONT,
        BOWL_REAR,
        BOWL_LEFT,
        BOWL_RIGHT
    };

    for (i=0; i<num; i++)
    {
        pPicFile = fopen(SamplePic[i], "rb");
        if (pPicFile == NULL)
        {
            AVM_ERROR("fopen %s failed\n", SamplePic[i]);
            continue;
        }
        fseek(pPicFile, 0, SEEK_END);
        datasize = ftell(pPicFile);
        AVM_DEBUG("getVideo:datasize=%d\n", datasize);
        fseek(pPicFile, 0, SEEK_SET);
        bufArray[i] = (UChar*)malloc(datasize);
        readsize = fread((void *)bufArray[i], 1, datasize, pPicFile);
        if (readsize != datasize)
        {
            AVM_ERROR("fread %s failed, want:%d, get:%d\n", SamplePic[i], datasize, readsize);
        }
        fclose(pPicFile);
    }
}


void testInit(ConfigFile *pConfigFile, WindowPos *pWindowPos[], VideoList *pVideoList, CtrlSignal *pCtrlSignal, VehicleSignal *pVehicleSignal)
{
    int i=0;

    pConfigFile->numLuts = NUM_LUTS;
    pConfigFile->numCarModel = NUM_CARMODEL;
    pConfigFile->numPicture = 1;//NUM_PICTURE;    //dead zone

    pConfigFile->lutsPath = (char *)malloc(LENGTH_FILEPATH*sizeof(char));
    memset(pConfigFile->lutsPath, 0, LENGTH_FILEPATH*sizeof(char));
    strcpy(pConfigFile->lutsPath, BOWL_luts);

    pConfigFile->carModelPath = (char *)malloc(LENGTH_FILEPATH*sizeof(char));
    memset(pConfigFile->carModelPath, 0, LENGTH_FILEPATH*sizeof(char));
    strcpy(pConfigFile->carModelPath, CARMODELS);


    pConfigFile->picturePath = (char *)malloc(LENGTH_FILEPATH*sizeof(char));
    memset(pConfigFile->picturePath, 0, LENGTH_FILEPATH*sizeof(char));
    strcpy(pConfigFile->picturePath, PICTURES);


    pWindowPos[1]->valid = 1;
    pWindowPos[1]->startX = 10;
    pWindowPos[1]->startY = 50;
    pWindowPos[1]->width = 640;//1280;
    pWindowPos[1]->height = 360;//720;
    pWindowPos[1]->whitchView = AVM_DISPLAY_STATE_3D_TOP;//AVM_DISPLAY_STATE_3D_FRONT;//AVM_DISPLAY_STATE_CORRECT_FRONT;

    pWindowPos[0]->valid = 1;
    pWindowPos[0]->startX = pWindowPos[1]->startX + pWindowPos[1]->width +10;
    pWindowPos[0]->startY = pWindowPos[1]->startY;
    pWindowPos[0]->width = 160;//320;//1080;
    pWindowPos[0]->height = pWindowPos[1]->height;
    pWindowPos[0]->whitchView = AVM_DISPLAY_STATE_QUADRI_GRID;//AVM_DISPLAY_STATE_3D_TOP;//AVM_DISPLAY_STATE_ORIGNAL_LEFT;

    pVideoList->camState = 0;
    pVideoList->width = 1280;
    pVideoList->height = 720;

    pVideoList->videoBuffer = (void **)malloc(4*sizeof(void*));
    getVideo((UChar **)pVideoList->videoBuffer, 4);
    for (i=0; i<4; i++)
    {
        if (pVideoList->videoBuffer[i] == NULL)
        {
            AVM_ERROR("failed to getVideo, videoBuffer[%d] is NULL\n", i);
        }
        else
        {
            AVM_DEBUG("pVideoList->videoBuffer[i]=%p\n", pVideoList->videoBuffer[i]);
        }
    }

    pCtrlSignal->lineOn = 0;

    pVehicleSignal->steeringAngle = 0;
    pVehicleSignal->speed = 0;
    pVehicleSignal->gear = 0;
    pVehicleSignal->doors = 0;
    pVehicleSignal->leftTurnLight  = 0;
    pVehicleSignal->rightTurnLight = 0;
    pVehicleSignal->brakeLight = 0;
}


void demoInit ()
{
    int i = 0;
    ConfigFile testConfigFile;
    void demoDraw(unsigned int *camtexid, Uint32 fbWidth, Uint32 fbHeight);

    printf("entry demoInit====\n");
    for (i=0; i<2; i++)
    {
        testWindowPos[i] = (WindowPos*)malloc(sizeof(WindowPos));
    }

    testInit(&testConfigFile, testWindowPos, &testVideoList, &testCtrlSignal, &testVehicleSignal);

    avmInit(testConfigFile);
    printf("demoInit OK !!!!!!!!!!\n");
}


void demoDraw(unsigned int *camtexid, Uint32 fbWidth, Uint32 fbHeight)
{
    testWindowPos[0]->startX = 0;
    testWindowPos[0]->startY = 0;
    testWindowPos[0]->width = 420;//fbWidth*2/3;
    testWindowPos[0]->height = fbHeight;

    testWindowPos[1]->startX = 430;//fbWidth*2/3;
    testWindowPos[1]->startY = 0;
    testWindowPos[1]->width = 210;//fbWidth/3;
    testWindowPos[1]->height = fbHeight;

    avmRenderer(testWindowPos, &testVideoList, &testCtrlSignal, &testVehicleSignal, camtexid);
}

