/*
* This flie is aimed to do everything about 3D-Bowl
* 1.Create Bowl-Shader
* 2.Load BowlLuts file to get Ver&Tex Coords
* 3.Update Bowlluts file when calibrated sueccess
* 4.Draw 3D Bowl
*/
#include "Bowl.h"
#ifndef STANDALONE
#include <utils/opengl/include/app_gl_egl_utils.h>
#endif

#define MODULE_NAME "AVM_Bowl"
#define AVM_DEBUG_SWITCH     1
#include "Avm_log.h"

typedef struct
{
    // Handle to a program object
    GLuint programObj;

    // Attribute locations
    GLint   positionLoc;
    GLint   texCoordLoc;
    GLint   alpha;

    // Uniform locations
    GLint   projectionLoc;
    GLint   camMatrixLoc;
    GLint   blendFlagLoc;
    GLint   wbFactorLoc;

    // Sampler location
    GLint   sampler2DLoc;

} OesObj_bowl;
OesObj_bowl objBowl;

#define LUTS_BOWL             "3DLUTS.BIN"

static BowlVerTex *g_BowlVerTex = NULL;
static int g_BowlRender_Status = 1;
static GLuint vbo_bowl = 0;
static GLuint ibo_bowl = 0;
static int Bowl_floor = 0;
static int Floor_pointsFB = 0;
static int Floor_pointsLR = 0;
static int offset_ver[4] = {0, 0, 0, 0};       // left -right - front - rear
static int offset_tex[4] = {0, 0, 0, 0};


/*****************functions Lev 3**********************************/
bool VIBOInit(GLuint *pviboID, int dataSize, void *data,  GLenum bufType)
{
    bool ret = FALSE;

    glGenBuffers(1, pviboID);
    glBindBuffer(bufType, *pviboID);
    glBufferData(bufType, dataSize, data, GL_STATIC_DRAW);
    glBindBuffer(bufType, 0);
    ret = AVM_GL_CHECK("VIBOInit");

    return ret;
}


void initBowlIndexArray(GLushort *idxArray, int bowlFloors, int bowlFBPoints, int bowlLRPoints)
{
    int t = 0;
    int k = 0;
    int baseidx = 0;
    int idx_i = 0;

    for(t=0;t<bowlFloors;t++)
    {
        for(k=0; k<bowlFBPoints; k++)
        {
            idxArray[idx_i++] = k + bowlFBPoints*t;
            idxArray[idx_i++] = k + bowlFBPoints*(t+1);
        }
    }
    baseidx = idxArray[idx_i-1] + 1;
    for(t=0;t<bowlFloors;t++)
    {
        for(k=0; k<bowlFBPoints; k++)
        {
            idxArray[idx_i++] = k + bowlFBPoints*t + baseidx;
            idxArray[idx_i++] = k + bowlFBPoints*(t+1) + baseidx;
        }
    }
    baseidx = idxArray[idx_i-1] + 1;
    for(t=0;t<bowlFloors;t++)
    {
        for(k=0; k<bowlLRPoints; k++)
        {
            idxArray[idx_i++] = k + bowlLRPoints*t + baseidx;
            idxArray[idx_i++] = k + bowlLRPoints*(t+1) + baseidx;
        }
    }
    baseidx = idxArray[idx_i-1] + 1;
    for(t=0;t<bowlFloors;t++)
    {
        for(k=0; k<bowlLRPoints; k++)
        {
            idxArray[idx_i++] = k + bowlLRPoints*t + baseidx;
            idxArray[idx_i++] = k + bowlLRPoints*(t+1) + baseidx;
        }
    }
}

/*****************functions Lev 2**********************************/
void esInitProgram_Bowl()
{
    AVM_DEBUG("entry bowl init\n");
    static const char vshader_bowl[] =
        "precision  mediump float;\n"

        "attribute vec3 bowl_position;\n"
        "attribute vec2 bowl_uv;\n"
        "attribute float bowl_alpha;\n"

        "uniform   mat4 bowl_projection;\n"
        "uniform   mat4 bowl_matView;\n"

        "varying mediump vec2 bowl_outUV;\n"
        "varying mediump float bowl_outAlpha;\n"

        "void main()\n"
        "{\n"
        "    vec4    pos    =   vec4(bowl_position.xyz, 1.0);\n"
        "    gl_Position    =   bowl_projection * (bowl_matView * pos);\n"
        "    gl_PointSize   =   3.0;\n"
        "    bowl_outAlpha  =   bowl_alpha;\n"
    //    "    bowl_outUV     =   bowl_uv;\n"
        "    bowl_outUV     =   vec2(bowl_uv.x, 1.0-bowl_uv.y);\n"
        "}\n";

    static const char fshader_bowl[] =
#ifndef STANDALONE
        " #extension GL_OES_EGL_image_external : require \n"
#endif
        "precision highp float;\n"
#ifndef STANDALONE
        " uniform samplerExternalOES _texture2D;\n "
#else
        " uniform sampler2D _texture2D;\n "
#endif
        "uniform bool       bowl_isBlend;\n"
        "uniform float      bowl_WBfactor;\n"

        "varying mediump vec2 bowl_outUV;\n"
        "varying mediump float bowl_outAlpha;\n"

        "void main()\n"
        "{\n"
        "    vec4 texcolor;\n"
        "    float Alpha;\n"
        "    texcolor  =   texture2D(_texture2D, bowl_outUV);\n"
        "    Alpha    =   bowl_isBlend ? bowl_outAlpha : texcolor.w;\n"
//        "    gl_FragColor   =   vec4(bowl_WBfactor*texcolor.x, bowl_WBfactor*texcolor.y, bowl_WBfactor*texcolor.z, Alpha);\n"
        "    gl_FragColor   =   vec4(bowl_WBfactor*texcolor.z, bowl_WBfactor*texcolor.y, bowl_WBfactor*texcolor.x, Alpha);\n"
        "   gl_FragColor.a =  0.0;\n"
        "}\n";

    objBowl.programObj = esLoadProgram(vshader_bowl, fshader_bowl);

    objBowl.positionLoc = glGetAttribLocation(objBowl.programObj, "bowl_position");
    objBowl.texCoordLoc = glGetAttribLocation(objBowl.programObj, "bowl_uv");
    objBowl.alpha    = glGetAttribLocation(objBowl.programObj, "bowl_alpha");

    objBowl.projectionLoc = glGetUniformLocation(objBowl.programObj,  "bowl_projection");
    objBowl.camMatrixLoc  = glGetUniformLocation(objBowl.programObj,  "bowl_matView");
    objBowl.wbFactorLoc   = glGetUniformLocation(objBowl.programObj,  "bowl_WBfactor");
    objBowl.blendFlagLoc  = glGetUniformLocation(objBowl.programObj,  "bowl_isBlend");
    objBowl.sampler2DLoc  = glGetUniformLocation(objBowl.programObj,  "_texture2D");
}

/*
*/صGPUVBO,ݼصGPUIBO
*/
bool LoadBowlLuts(BowlVerTex * BowlData, unsigned int bowlsize, OVSBasicInfo pOVSBasicInfo)
{
    bool ret = FALSE;
    GLushort *VerIndex = NULL;
    int vbo_size = 0;
    int ibo_size = 0;

    do
    {
        g_BowlRender_Status = 0;
        if (0 == bowlsize)
        {
            AVM_ERROR("bowlsize = 0\n");
            break;
        }
        Bowl_floor = pOVSBasicInfo.stBowlVerTexParam.iBottomLayerNum+pOVSBasicInfo.stBowlVerTexParam.iWallLayerNum-1;
        Floor_pointsFB = pOVSBasicInfo.stBowlVerTexParam.iPointNum;
        Floor_pointsLR = pOVSBasicInfo.stBowlVerTexParam.iPointNumLR;

        offset_ver[2] = 0;
        offset_tex[2] = sizeof(BowlData->pfVerF) + sizeof(BowlData->pfVerB) + sizeof(BowlData->pfVerL) + sizeof(BowlData->pfVerR);

         vbo_size =  sizeof(BowlData->pfVerF) + sizeof(BowlData->pfTexF)
                  + sizeof(BowlData->pfVerB) + sizeof(BowlData->pfTexB)
                  + sizeof(BowlData->pfVerL) + sizeof(BowlData->pfTexL)
                  + sizeof(BowlData->pfVerR) + sizeof(BowlData->pfTexR);

        if (FALSE == VIBOInit(&vbo_bowl, vbo_size, BowlData->pfVerF, GL_ARRAY_BUFFER))
        {
            AVM_ERROR("Failed to init vbo_bowl\n");
            break;
        }

        ibo_size = sizeof(GLushort) * 2 * Bowl_floor * (Floor_pointsFB * 2 + Floor_pointsLR * 2);
        VerIndex = (GLushort *)malloc(ibo_size);
        initBowlIndexArray(VerIndex, Bowl_floor, Floor_pointsFB, Floor_pointsLR);        /*defined by algrithm*/

        if (FALSE ==VIBOInit(&ibo_bowl, ibo_size, VerIndex, GL_ELEMENT_ARRAY_BUFFER))
        {
            AVM_ERROR("Failed to init ibo_bowl\n");
            break;
        }
        g_BowlRender_Status = 1;

        ret = TRUE;
    }while(0);

    if (NULL != VerIndex)
    {
        free(VerIndex);
        VerIndex = NULL;
    }

    AVM_DEBUG("g_BowlRender_Status=%d, Bowl_floor=%d, Floor_pointsFB=%d, Floor_pointsLR=%d, \n",
            g_BowlRender_Status, Bowl_floor, Floor_pointsFB, Floor_pointsLR);
    AVM_DEBUG("offset_ver=%d, offset_tex=%d, vbo_size=%d, vbo_bowl=%d, ibo_bowl=%d\n",
                offset_ver[2], offset_tex[2], vbo_size, vbo_bowl, ibo_bowl);

    return ret;
}

void GenerateBowlLuts(OVSBasicInfo pOVSBasicInfo, UChar**dataBowl)
{

}


/*****************functions Lev 1**********************************/
bool bowlInit(char *dirBowl, OVSBasicInfo pOVSBasicInfo)
{
    int datasize = 0;
    bool ret = FALSE;

    do
    {
        //ʼģȾ
        esInitProgram_Bowl();

        //ػģļ
        if (NULL == g_BowlVerTex)
        {
            g_BowlVerTex = (BowlVerTex *)malloc(sizeof(BowlVerTex));
        }
        datasize = LoadFile(dirBowl, LUTS_BOWL, (UChar**)&g_BowlVerTex, sizeof(BowlVerTex));
        if (datasize != sizeof(BowlVerTex))
        {
            AVM_ERROR("failed to load bowl---bowlsize= %d,  sizeof(BowlVerTex)=%dline:%d\n", datasize, sizeof(BowlVerTex), __LINE__);
            GenerateBowlLuts(pOVSBasicInfo, (UChar**)&g_BowlVerTex);
        }

        //ʼVBOIBO
        if (FALSE == LoadBowlLuts(g_BowlVerTex, datasize, pOVSBasicInfo))
        {
            AVM_ERROR("failed to LoadBowlLuts\n");
            break;
        }

        ret = TRUE;
    } while(0);

    return ret;
}

void SetMatrix_Bowl(const float *camMatrixBowl, float *projectionBowl)
{
    glUseProgram(objBowl.programObj);
    glUniformMatrix4fv(objBowl.camMatrixLoc,    1, GL_FALSE, camMatrixBowl);
    glUniformMatrix4fv(objBowl.projectionLoc,   1, GL_FALSE, projectionBowl);
    glUseProgram(0);
}

void Bowlrender(GLuint *texbowl, double *wbFactor)
{
    int offset_idx[4] = {0, 0, 0, 0};
    static int pflag = 1;
    float colorBD[6] = {0.9, 0.9, 0.5, 0.5, 0.0, 0.0};

    float colorAC[6] = {0.0, 0.0, 0.5, 0.5, 0.9, 0.9};

    float VerBlend[18], TexBlend[12];
    int i, j, t, k;

    if (1 == g_BowlRender_Status)
    {
        glUseProgram(objBowl.programObj);
//		glEnable(GL_TEXTURE_2D);
        glEnableVertexAttribArray(objBowl.positionLoc);
        glEnableVertexAttribArray(objBowl.texCoordLoc);
        glUniform1i(objBowl.blendFlagLoc, 0);
        glUniform1i(objBowl.sampler2DLoc, 0);
        glActiveTexture(GL_TEXTURE0);


        // elements draw: VBO IBO
        glBindBuffer(GL_ARRAY_BUFFER, vbo_bowl);
        glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, ibo_bowl);

        glVertexAttribPointer(objBowl.positionLoc, 3, GL_FLOAT, GL_FALSE, 0, (void*)offset_ver[2]);
        glVertexAttribPointer(objBowl.texCoordLoc, 2, GL_FLOAT, GL_FALSE, 0, (void*)offset_tex[2]);

        //draw front
#ifndef STANDALONE
        glBindTexture(GL_TEXTURE_EXTERNAL_OES, texbowl[2]);      //2front //0left //3tail //1right
#else
        glBindTexture(GL_TEXTURE_2D, texbowl[2]);      //2front //0left //3tail //1right
#endif
        glUniform1f(objBowl.wbFactorLoc, wbFactor[2]);
        for(t=0;t<Bowl_floor;t++)
        {
            offset_idx[2] = t*2*Floor_pointsFB*sizeof(GLushort);
            glDrawElements(GL_TRIANGLE_STRIP, 2*Floor_pointsFB, GL_UNSIGNED_SHORT, (void*)offset_idx[2]);
        }
        offset_idx[2] = t*2*Floor_pointsFB*sizeof(GLushort);

        //draw rear
#ifndef STANDALONE
        glBindTexture(GL_TEXTURE_EXTERNAL_OES, texbowl[3]);      //2front //0left //3tail //1right
#else
        glBindTexture(GL_TEXTURE_2D, texbowl[3]);      //2front //0left //3tail //1right
#endif
        glUniform1f(objBowl.wbFactorLoc, wbFactor[3]);
        for(t=0;t<Bowl_floor;t++)
        {
            offset_idx[3] = t*2*Floor_pointsFB*sizeof(GLushort) + offset_idx[2];
            glDrawElements(GL_TRIANGLE_STRIP, 2*Floor_pointsFB, GL_UNSIGNED_SHORT, (void*)offset_idx[3]);
        }
        offset_idx[3] = t*2*Floor_pointsFB*sizeof(GLushort) + offset_idx[2];

        //draw left
#ifndef STANDALONE
        glBindTexture(GL_TEXTURE_EXTERNAL_OES, texbowl[0]);      //2front //0left //3tail //1right
#else
        glBindTexture(GL_TEXTURE_2D, texbowl[0]);      //2front //0left //3tail //1right
#endif
        glUniform1f(objBowl.wbFactorLoc, wbFactor[0]);
        for(t=0;t<Bowl_floor;t++)
        {
            offset_idx[0] = t*2*Floor_pointsLR*sizeof(GLushort) + offset_idx[3];
            glDrawElements(GL_TRIANGLE_STRIP, 2*Floor_pointsLR, GL_UNSIGNED_SHORT, (void*)offset_idx[0]);
        }
         offset_idx[0] = t*2*Floor_pointsLR*sizeof(GLushort) + offset_idx[3];

        //draw right
#ifndef STANDALONE
        glBindTexture(GL_TEXTURE_EXTERNAL_OES, texbowl[1]);      //2front //0left //3tail //1right
#else
        glBindTexture(GL_TEXTURE_2D, texbowl[1]);      //2front //0left //3tail //1right
#endif
        glUniform1f(objBowl.wbFactorLoc, wbFactor[1]);
        for(t=0;t<Bowl_floor;t++)
        {
            offset_idx[1] = t*2*Floor_pointsLR*sizeof(GLushort) + offset_idx[0];
            glDrawElements(GL_TRIANGLE_STRIP, 2*Floor_pointsLR, GL_UNSIGNED_SHORT, (void*)offset_idx[1]);
        }
        if (pflag == 1)
        {
            pflag = 0;
            AVM_DEBUG("WbFactor[0-3]=%.2f, %.2f, %.2f, %.2f\n", wbFactor[0], wbFactor[1], wbFactor[2], wbFactor[3]);
            AVM_DEBUG("offset_idx[2]=%d  offset_idx[3]=%d  offset_idx[0]=%d  offset_idx[1]=%d\n",
                    offset_idx[2], offset_idx[3], offset_idx[0], offset_idx[1]);
        }
        glBindBuffer(GL_ARRAY_BUFFER, 0);
        glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, 0);

        //draw corner : AF and DF
#ifndef STANDALONE
        glBindTexture(GL_TEXTURE_EXTERNAL_OES, texbowl[2]);      //2front //0left //3tail //1right
#else
        glBindTexture(GL_TEXTURE_2D, texbowl[2]);      //2front //0left //3tail //1right
#endif
        glUniform1f(objBowl.wbFactorLoc, wbFactor[2]);
        for(t=0;t<Bowl_floor;t++)
        {
            for(k=0,i=0,j=0; k<3; k++,i+=6,j+=4)
            {
                VerBlend[i+0]=g_BowlVerTex->pfVerBlendA[k*3+0+9*t];
                VerBlend[i+1]=g_BowlVerTex->pfVerBlendA[k*3+1+9*t];
                VerBlend[i+2]=g_BowlVerTex->pfVerBlendA[k*3+2+9*t];
                VerBlend[i+3]=g_BowlVerTex->pfVerBlendA[k*3+0+9*(t+1)];
                VerBlend[i+4]=g_BowlVerTex->pfVerBlendA[k*3+1+9*(t+1)];
                VerBlend[i+5]=g_BowlVerTex->pfVerBlendA[k*3+2+9*(t+1)];

                TexBlend[j+0]=g_BowlVerTex->pfTexBlendAF[k*2+0+6*t];
                TexBlend[j+1]=g_BowlVerTex->pfTexBlendAF[k*2+1+6*t];
                TexBlend[j+2]=g_BowlVerTex->pfTexBlendAF[k*2+0+6*(t+1)];
                TexBlend[j+3]=g_BowlVerTex->pfTexBlendAF[k*2+1+6*(t+1)];
            }
            glVertexAttribPointer(objBowl.positionLoc, 3, GL_FLOAT, GL_FALSE,0, VerBlend);
            glVertexAttribPointer(objBowl.texCoordLoc, 2, GL_FLOAT, GL_FALSE,0, TexBlend);
            glDrawArrays(GL_TRIANGLE_STRIP,0,6);                // paste front yuv to corner_leftfront
        }

        //draw corner : AF and DF
        for(t=0;t<Bowl_floor;t++)
        {
            for(k=0,i=0,j=0; k<3; k++,i+=6,j+=4)
            {
                VerBlend[i+0]=g_BowlVerTex->pfVerBlendD[k*3+0+9*t];
                VerBlend[i+1]=g_BowlVerTex->pfVerBlendD[k*3+1+9*t];
                VerBlend[i+2]=g_BowlVerTex->pfVerBlendD[k*3+2+9*t];
                VerBlend[i+3]=g_BowlVerTex->pfVerBlendD[k*3+0+9*(t+1)];
                VerBlend[i+4]=g_BowlVerTex->pfVerBlendD[k*3+1+9*(t+1)];
                VerBlend[i+5]=g_BowlVerTex->pfVerBlendD[k*3+2+9*(t+1)];

                TexBlend[j+0]=g_BowlVerTex->pfTexBlendDF[k*2+0+6*t];
                TexBlend[j+1]=g_BowlVerTex->pfTexBlendDF[k*2+1+6*t];
                TexBlend[j+2]=g_BowlVerTex->pfTexBlendDF[k*2+0+6*(t+1)];
                TexBlend[j+3]=g_BowlVerTex->pfTexBlendDF[k*2+1+6*(t+1)];
            }
            glVertexAttribPointer(objBowl.positionLoc, 3, GL_FLOAT, GL_FALSE,0, VerBlend);
            glVertexAttribPointer(objBowl.texCoordLoc, 2, GL_FLOAT, GL_FALSE,0, TexBlend);
            glDrawArrays(GL_TRIANGLE_STRIP,0,6);                // paste front yuv to corner_rightfront
        }

        //draw corner : BB and BC
#ifndef STANDALONE
        glBindTexture(GL_TEXTURE_EXTERNAL_OES, texbowl[3]);      //2front //0left //3tail //1right
#else
        glBindTexture(GL_TEXTURE_2D, texbowl[3]);      //2front //0left //3tail //1right
#endif
        glUniform1f(objBowl.wbFactorLoc, wbFactor[3]);
        for(t=0;t<Bowl_floor;t++)
        {
            for(k=0,i=0,j=0; k<3; k++,i+=6,j+=4)
            {
                VerBlend[i+0]=g_BowlVerTex->pfVerBlendB[k*3+0+9*t];
                VerBlend[i+1]=g_BowlVerTex->pfVerBlendB[k*3+1+9*t];
                VerBlend[i+2]=g_BowlVerTex->pfVerBlendB[k*3+2+9*t];
                VerBlend[i+3]=g_BowlVerTex->pfVerBlendB[k*3+0+9*(t+1)];
                VerBlend[i+4]=g_BowlVerTex->pfVerBlendB[k*3+1+9*(t+1)];
                VerBlend[i+5]=g_BowlVerTex->pfVerBlendB[k*3+2+9*(t+1)];

                TexBlend[j+0]=g_BowlVerTex->pfTexBlendBB[k*2+0+6*t];
                TexBlend[j+1]=g_BowlVerTex->pfTexBlendBB[k*2+1+6*t];
                TexBlend[j+2]=g_BowlVerTex->pfTexBlendBB[k*2+0+6*(t+1)];
                TexBlend[j+3]=g_BowlVerTex->pfTexBlendBB[k*2+1+6*(t+1)];
            }
            glVertexAttribPointer(objBowl.positionLoc, 3, GL_FLOAT, GL_FALSE,0, VerBlend);
            glVertexAttribPointer(objBowl.texCoordLoc, 2, GL_FLOAT, GL_FALSE,0, TexBlend);
            glDrawArrays(GL_TRIANGLE_STRIP,0,6);                // paste rear yuv to corner_leftrear
        }

        //draw corner : BB and BC
        for(t=0;t<Bowl_floor;t++)
        {
            for(k=0,i=0,j=0; k<3; k++,i+=6,j+=4)
            {
                VerBlend[i+0]=g_BowlVerTex->pfVerBlendC[k*3+0+9*t];
                VerBlend[i+1]=g_BowlVerTex->pfVerBlendC[k*3+1+9*t];
                VerBlend[i+2]=g_BowlVerTex->pfVerBlendC[k*3+2+9*t];
                VerBlend[i+3]=g_BowlVerTex->pfVerBlendC[k*3+0+9*(t+1)];
                VerBlend[i+4]=g_BowlVerTex->pfVerBlendC[k*3+1+9*(t+1)];
                VerBlend[i+5]=g_BowlVerTex->pfVerBlendC[k*3+2+9*(t+1)];

                TexBlend[j+0]=g_BowlVerTex->pfTexBlendCB[k*2+0+6*t];
                TexBlend[j+1]=g_BowlVerTex->pfTexBlendCB[k*2+1+6*t];
                TexBlend[j+2]=g_BowlVerTex->pfTexBlendCB[k*2+0+6*(t+1)];
                TexBlend[j+3]=g_BowlVerTex->pfTexBlendCB[k*2+1+6*(t+1)];
            }
            glVertexAttribPointer(objBowl.positionLoc, 3, GL_FLOAT, GL_FALSE,0, VerBlend);
            glVertexAttribPointer(objBowl.texCoordLoc, 2, GL_FLOAT, GL_FALSE,0, TexBlend);
            glDrawArrays(GL_TRIANGLE_STRIP,0,6);                // paste rear yuv to corner_rightrear
        }

        /*********BLEND***********/
        glEnable(GL_BLEND);
        glDepthMask(GL_FALSE);
        glBlendFuncSeparate(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA, GL_ONE, GL_ONE);
        glUniform1i(objBowl.blendFlagLoc, 1);
        glEnableVertexAttribArray(objBowl.alpha);

#ifndef STANDALONE
        glBindTexture(GL_TEXTURE_EXTERNAL_OES, texbowl[0]);      //2front //0left //3tail //1right
#else
        glBindTexture(GL_TEXTURE_2D, texbowl[0]);      //2front //0left //3tail //1right
#endif
        glUniform1f(objBowl.wbFactorLoc, wbFactor[0]);
        for(t=0;t<Bowl_floor;t++)
        {
             for(k=0,i=0,j=0; k<3; k++,i+=6,j+=4)
             {
                 VerBlend[i+0]=g_BowlVerTex->pfVerBlendA[k*3+0+9*t];
                 VerBlend[i+1]=g_BowlVerTex->pfVerBlendA[k*3+1+9*t];
                 VerBlend[i+2]=g_BowlVerTex->pfVerBlendA[k*3+2+9*t];
                 VerBlend[i+3]=g_BowlVerTex->pfVerBlendA[k*3+0+9*(t+1)];
                 VerBlend[i+4]=g_BowlVerTex->pfVerBlendA[k*3+1+9*(t+1)];
                 VerBlend[i+5]=g_BowlVerTex->pfVerBlendA[k*3+2+9*(t+1)];

                 TexBlend[j+0]=g_BowlVerTex->pfTexBlendAL[k*2+0+6*t];
                 TexBlend[j+1]=g_BowlVerTex->pfTexBlendAL[k*2+1+6*t];
                 TexBlend[j+2]=g_BowlVerTex->pfTexBlendAL[k*2+0+6*(t+1)];
                 TexBlend[j+3]=g_BowlVerTex->pfTexBlendAL[k*2+1+6*(t+1)];
             }
            glVertexAttribPointer(objBowl.positionLoc, 3, GL_FLOAT, GL_FALSE, 0, VerBlend);
            glVertexAttribPointer(objBowl.texCoordLoc, 2, GL_FLOAT, GL_FALSE, 0, TexBlend);
            glVertexAttribPointer(objBowl.alpha, 1, GL_FLOAT, GL_FALSE, 0, colorAC);
            glDrawArrays(GL_TRIANGLE_STRIP,0,6);
        }
        for(t=0;t<Bowl_floor;t++)
        {
             for(k=0,i=0,j=0; k<3; k++,i+=6,j+=4)
             {
                 VerBlend[i+0]=g_BowlVerTex->pfVerBlendB[k*3+0+9*t];
                 VerBlend[i+1]=g_BowlVerTex->pfVerBlendB[k*3+1+9*t];
                 VerBlend[i+2]=g_BowlVerTex->pfVerBlendB[k*3+2+9*t];
                 VerBlend[i+3]=g_BowlVerTex->pfVerBlendB[k*3+0+9*(t+1)];
                 VerBlend[i+4]=g_BowlVerTex->pfVerBlendB[k*3+1+9*(t+1)];
                 VerBlend[i+5]=g_BowlVerTex->pfVerBlendB[k*3+2+9*(t+1)];

                 TexBlend[j+0]=g_BowlVerTex->pfTexBlendBL[k*2+0+6*t];
                 TexBlend[j+1]=g_BowlVerTex->pfTexBlendBL[k*2+1+6*t];
                 TexBlend[j+2]=g_BowlVerTex->pfTexBlendBL[k*2+0+6*(t+1)];
                 TexBlend[j+3]=g_BowlVerTex->pfTexBlendBL[k*2+1+6*(t+1)];
             }
            glVertexAttribPointer(objBowl.positionLoc, 3, GL_FLOAT, GL_FALSE, 0, VerBlend);
            glVertexAttribPointer(objBowl.texCoordLoc, 2, GL_FLOAT, GL_FALSE, 0, TexBlend);
            glVertexAttribPointer(objBowl.alpha, 1, GL_FLOAT, GL_FALSE, 0, colorBD);
            glDrawArrays(GL_TRIANGLE_STRIP,0,6);                // blend left yuv to corner_leftrear
        }
#ifndef STANDALONE
        glBindTexture(GL_TEXTURE_EXTERNAL_OES, texbowl[1]);      //2front //0left //3tail //1right
#else
        glBindTexture(GL_TEXTURE_2D, texbowl[1]);      //2front //0left //3tail //1right
#endif
        glUniform1f(objBowl.wbFactorLoc, wbFactor[1]);
        for(t=0;t<Bowl_floor;t++)
        {
            for(k=0,i=0,j=0; k<3; k++,i+=6,j+=4)
            {
                VerBlend[i+0]=g_BowlVerTex->pfVerBlendC[k*3+0+9*t];
                VerBlend[i+1]=g_BowlVerTex->pfVerBlendC[k*3+1+9*t];
                VerBlend[i+2]=g_BowlVerTex->pfVerBlendC[k*3+2+9*t];
                VerBlend[i+3]=g_BowlVerTex->pfVerBlendC[k*3+0+9*(t+1)];
                VerBlend[i+4]=g_BowlVerTex->pfVerBlendC[k*3+1+9*(t+1)];
                VerBlend[i+5]=g_BowlVerTex->pfVerBlendC[k*3+2+9*(t+1)];

                TexBlend[j+0]=g_BowlVerTex->pfTexBlendCR[k*2+0+6*t];
                TexBlend[j+1]=g_BowlVerTex->pfTexBlendCR[k*2+1+6*t];
                TexBlend[j+2]=g_BowlVerTex->pfTexBlendCR[k*2+0+6*(t+1)];
                TexBlend[j+3]=g_BowlVerTex->pfTexBlendCR[k*2+1+6*(t+1)];
            }
            glVertexAttribPointer(objBowl.positionLoc, 3, GL_FLOAT, GL_FALSE, 0, VerBlend);
            glVertexAttribPointer(objBowl.texCoordLoc, 2, GL_FLOAT, GL_FALSE, 0, TexBlend);
            glVertexAttribPointer(objBowl.alpha, 1, GL_FLOAT, GL_FALSE, 0, colorAC);
            glDrawArrays(GL_TRIANGLE_STRIP,0,6);                // blend right yuv to corner_rightrear
        }
        for(t=0;t<Bowl_floor;t++)
        {
             for(k=0,i=0,j=0; k<3; k++,i+=6,j+=4)
             {
                 VerBlend[i+0]=g_BowlVerTex->pfVerBlendD[k*3+0+9*t];
                 VerBlend[i+1]=g_BowlVerTex->pfVerBlendD[k*3+1+9*t];
                 VerBlend[i+2]=g_BowlVerTex->pfVerBlendD[k*3+2+9*t];
                 VerBlend[i+3]=g_BowlVerTex->pfVerBlendD[k*3+0+9*(t+1)];
                 VerBlend[i+4]=g_BowlVerTex->pfVerBlendD[k*3+1+9*(t+1)];
                 VerBlend[i+5]=g_BowlVerTex->pfVerBlendD[k*3+2+9*(t+1)];

                 TexBlend[j+0]=g_BowlVerTex->pfTexBlendDR[k*2+0+6*t];
                 TexBlend[j+1]=g_BowlVerTex->pfTexBlendDR[k*2+1+6*t];
                 TexBlend[j+2]=g_BowlVerTex->pfTexBlendDR[k*2+0+6*(t+1)];
                 TexBlend[j+3]=g_BowlVerTex->pfTexBlendDR[k*2+1+6*(t+1)];
             }

            glVertexAttribPointer(objBowl.positionLoc, 3, GL_FLOAT, GL_FALSE, 0, VerBlend);
            glVertexAttribPointer(objBowl.texCoordLoc, 2, GL_FLOAT, GL_FALSE, 0, TexBlend);
            glVertexAttribPointer(objBowl.alpha, 1, GL_FLOAT, GL_FALSE, 0, colorBD);
            glDrawArrays(GL_TRIANGLE_STRIP,0,6);
        }

#ifndef STANDALONE
        glBindTexture(GL_TEXTURE_EXTERNAL_OES, 0);      //2front //0left //3tail //1right
#else
        glBindTexture(GL_TEXTURE_2D, 0);      //2front //0left //3tail //1right
#endif
        glDepthMask(GL_TRUE);
        glDisable(GL_BLEND);
        glUniform1i(objBowl.blendFlagLoc, 0);
        glUniform1f(objBowl.wbFactorLoc, 1.0);
        glDisableVertexAttribArray(objBowl.positionLoc);
        glDisableVertexAttribArray(objBowl.texCoordLoc);
        glDisableVertexAttribArray(objBowl.alpha);
        glUseProgram(0);

        AVM_GL_CHECK("test define glcheck\n");
    }
}



