#ifndef _CALIBRATION_H_
#define _CALIBRATION_H_

#include "AVM.h"
#include "Common.h"

#define LAB_SCALE    1

typedef struct _Corner
{
    int FL[8],FR[8];
    int BL[8],BR[8];
    int LF[8],LB[8];
    int RF[8],RB[8];
}Corner;

#define LARGE_TRACK_SEGMENT    200

typedef struct _LineSegmentLarge
{// defines the common lines, which can be SEPARATED segments or CONTINUES lines, distinguished by ucType.
    unsigned char ucCount;      // segments count
    float usaXCoor[LARGE_TRACK_SEGMENT];
    float usaYCoor[LARGE_TRACK_SEGMENT];
}LineSegmentLarge;

typedef struct _VehicleTracks
{
    LineSegmentLarge staFrontDynamic[3][2];   // (外中内)/ (left\right)
    LineSegmentLarge staFrontDynamicS;
    LineSegmentLarge staRearDynamic[3][2];   // (外中内)/ (left\right)
    LineSegmentLarge staRearDynamicS;
    float backupX[12];
    float backupY[12];
    float backupEndX[12];
    float backupEndY[12];
}VehicleTracks;

typedef struct _BirdviewTracks
{
    LineSegmentLarge staFrontDynamic[3][2];   // (ÍâÖÐÄÚ)/ (left\right)
    LineSegmentLarge staRearDynamic[3][2];   // (ÍâÖÐÄÚ)/ (left\right)
}BirdviewTrack;

typedef struct _Coord
{
    double x;
    double y;
}Coord;


void AlgParamInit(char *dirLuts, OVSBasicInfo *pOVSBasicInfo);
void ApicaliInit();

void ApiOfflineCali(VideoList *stVideoList, Coord outCorners[4][23]);  //ȡǵ꼰
void ApiSaleCali(Corner* pCorner);
void ApiGenerateLuts();


bool avmDefaultCorner(Corner *stCorner);

int GenTrackFrontDynamic(OVSBasicInfo *pOVSBasicInfo, VehicleTracks *pVehicleTracks, int angle, int fr);
int GenTrackRearDynamic(OVSBasicInfo *pOVSBasicInfo, VehicleTracks *pVehicleTracks, int angle, int fr);
int GenFrontTrackDynaBirdImg(OVSBasicInfo *pOVSBasicInfo, BirdviewTrack *pBirdviewTrack, int angle);
int GenRearTrackDynaBirdImg(OVSBasicInfo *pOVSBasicInfo,BirdviewTrack *pBirdviewTrack, int angle);


int algWBCalculate(unsigned char **videoList, unsigned char camState, double *factor);  //videolise[0-3]:front-rear-left-right;    camstate:bit0-bit3:front-rear-left-right;    factor[0-3]:front-rear-left-right
int funWBCalculate(UChar **videoList, UChar camState, double *factor);  //videolise[0-3]:front-rear-left-right;    camstate:bit0-bit3:front-rear-left-right;    factor[0-3]:left-right-front-rear



#endif /* _CALIBRATION_H_ */

