/*
* This flie is aimed to do everything about 3D-Bowl
* 1.Create Car-Shader
* 2.Load Car model
* 3.Draw 3D Car and DeadZone
*/
#include "Car.h"
#include "PlanView.h"

#define MODULE_NAME "AVM_Car"
#define AVM_INFO_SWITCH     1
#include "Avm_log.h"


//#define ANYVIEW
#define DRAW_DEADZONE 0

static const char *vshader_car = {
    "precision  mediump float;"
    "uniform   mat4 car_projection;"
    "uniform   mat4 car_matView;"
    "uniform   mat4 car_offset1;"

    "attribute vec3 car_position;"
    "attribute vec2 car_uv;"

    "varying   vec2 car_outUV;"

    "void main()                                                                \n"
    "{                                                                          \n"
    "   vec4    pos =   vec4(car_position.x, car_position.y + 0.1790, car_position.z, 1.0);\n"
    "   gl_Position =   car_projection * (car_matView * (car_offset1 * pos));            \n"
    "    car_outUV   =   car_uv;                                                    \n"
    "}                                                                          \n"
};

static const char *fshader_car = {
    "precision  mediump float;"
    "uniform    sampler2D   car_texture;"
    "uniform    bool        _isTurn;"
    "uniform    bool        _isBrake;"
    "varying    vec2        car_outUV;"

    "void main()                                                                \n"
    "{                                                                          \n"
    "   if (_isTurn)                                                            \n"
    "   {                                                                       \n"
    "       gl_FragColor = vec4(1.0, 0.7843, 0.3529, 1.0);                      \n"
    "   }                                                                       \n"
    "   else if (_isBrake)                                                      \n"
    "   {                                                                       \n"
    "       gl_FragColor = vec4(0.9843, 0.2275, 0.0431, 1.0);                   \n"
    "   }                                                                       \n"
    "   else"
    "   {                                                                       \n"
    "       gl_FragColor = texture2D(car_texture, car_outUV);                   \n"
    "   }                                                                       \n"
    "   gl_FragColor.a =  0.0;\n"
    "}"
};

#define ATTR_POSITION_CAR    "car_position"
#define ATTR_UV_CAR          "car_uv"
#define CAR_PATH             "modelA26.dat"
#define PICTURE_DEADZONE     "A26Deadzone.dat"

GLuint programCar = 0;
CObj * pCObj = NULL;

static GLuint vsCar_position3 = 100;
static GLuint vsCar_uv2 = 100;

static int cntfaces = 0;
static const float Carscale = 700.3017;
static UChar *pCarModelData = NULL;
static CarInfo stTmpCarParams;

#define NUM_RADAR_PIC    39
GLuint texidRadar[NUM_RADAR_PIC] = {0};

static GLuint DeadZoneTexID = 0;
static float verDeadZone[12];
static float texDeadZone[8] = {
    0.0, 1.0,
    0.0, 0.0,
    1.0, 1.0,
    1.0, 0.0
};
static float offset1[16] = {
    1.0, 0.0, 0.0, 0.0,
    0.0, 1.0, 0.0, 0.0,
    0.0, 0.0, 1.0, 0.0,
    0.0, 0.0, 0.0, 1.0
};



/*****************functions Lev 3**********************************/
bool CObj::LoadObj(UChar *pCarmodel, unsigned int datasize)
{
    bool ret = FALSE;
    UInt retCount = 0;
    int i = 0;
    static int cntmtls = 0;
    static int cnttexs = 0;
    unsigned int vbooffset;
    UChar *startfaces;
    UChar *startmtls;

    do
    {
        vbooffset  = *((unsigned int *)pCarmodel);
        cntfaces   = *((int *)(pCarmodel + 4));
        cntmtls    = *((int *)(pCarmodel + 8));
        cnttexs    = *((int *)(pCarmodel + 12));


        m_fs = new CFace[cntfaces];
        if (m_fs == NULL)
        {
            AVM_ERROR("new m_fs failed\n");
            break;
        }
        m_ms = new CMaterial[cntmtls];
        if (m_ms == NULL)
        {
            AVM_ERROR("new m_ms failed\n");
            break;
        }

        AVM_INFO("vbooffset :%d\n", vbooffset);
        AVM_INFO("cntfaces  :%d\n", cntfaces);
        AVM_INFO("cntmtls   :%d\n", cntmtls);
        AVM_INFO("cnttexs   :%d\n", cnttexs);

        startfaces            = (UChar*)pCarmodel + 16;
        startmtls            = startfaces + cntfaces * sizeof(FileFace);

        if (0 == m_vbo)
        {
            glGenBuffers(1, &m_vbo);
        }
        glBindBuffer(GL_ARRAY_BUFFER, m_vbo);
        glBufferData(GL_ARRAY_BUFFER, datasize - vbooffset, pCarmodel + vbooffset, GL_STATIC_DRAW);
        glBindBuffer(GL_ARRAY_BUFFER,0);
        if (FALSE == AVM_GL_CHECK("init m_vbo"))
        {
            retCount++;
        }

        UChar * tmpfaceaddr = (UChar*)startfaces;
        for (i = 0; i < cntfaces; i++)
        {
            if (memcpy((void *)(&(m_fs[i].m_fileface)), (void *)tmpfaceaddr, sizeof(FileFace)) == NULL)
            {
                AVM_ERROR("memcpy failed, cntfaces:%d\n", cntfaces);
                retCount++;
            }
            tmpfaceaddr += sizeof(FileFace);
            AVM_INFO("m_fs[%d]...mtlindex=%d  g_type=%d\n", i, m_fs[i].m_fileface.mtlindex, m_fs[i].m_fileface.g_type);
        }
        UChar * tmpmtladdr = (UChar*)startmtls;
        for (i = 0; i < cntmtls; i++)    //CFyh
        {
            memcpy((void *)(&(m_ms[i].m_filemtl)), (void *)tmpmtladdr, sizeof(FileMaterial));
            m_ms[i].InitTex((UChar*)pCarmodel);
            if (FALSE == AVM_GL_CHECK("m_ms[i].InitTex"))
            {
                retCount++;
            }
            tmpmtladdr += sizeof(FileMaterial);
        }

        ret = (0 == retCount) ? TRUE : FALSE;
    } while(0);

    return ret;
}


void CFace::wheelflMat(int steeringAngle, unsigned int speed, unsigned int stall)
{
    static float wheelrot_x = 0.0;
    float wheelrot_y = steeringAngle / 159.8;
    float speed_step;

    CELL::matrix4 Translate1;
    CELL::matrix4 Translate2;
    CELL::matrix4 RotateX;
    CELL::matrix4 RotateY;

    Translate1.translate(CELL::float3( 790.963 /Carscale, -(353.22 / Carscale + 0.1790),   1438.603 / Carscale));
    Translate2.translate(CELL::float3(-790.963 / Carscale, (353.22 / Carscale + 0.1790), -1438.603 / Carscale));

    RotateX.rotateX(wheelrot_x);
    RotateY.rotateY(wheelrot_y);

    if (1 == stall)
    {
        speed_step = speed*1.56;
    }
    else
    {
        speed_step = 0-speed*1.56;
    }

    wheelrot_x += speed_step;

    if (wheelrot_x <= -360)
    {
        wheelrot_x += 360.0;
    }
    else if (wheelrot_x >= 360)
    {
        wheelrot_x -= 360.0;
    }

    CELL::matrix4 mat4WheelFL = Translate2 * RotateY * RotateX * Translate1;
    glUniformMatrix4fv(glGetUniformLocation(programCar,"car_offset1"), 1, GL_FALSE, mat4WheelFL.data());
}


void CFace::wheelfrMat(int steeringAngle, unsigned int speed, unsigned int stall)
{
    static float wheelrot_x = 0.0;
    float wheelrot_y = steeringAngle / 159.8;
    float speed_step;

    CELL::matrix4 Translate1;
    CELL::matrix4 Translate2;
    CELL::matrix4 RotateX;
    CELL::matrix4 RotateY;

    Translate1.translate(CELL::float3( -790.963 / Carscale,  -(353.22 / Carscale + 0.1790),  1438.603/ Carscale));
    Translate2.translate(CELL::float3( 790.963 /Carscale, (353.22 / Carscale + 0.1790), -1438.603 / Carscale));

    RotateX.rotateX(wheelrot_x);
    RotateY.rotateY(wheelrot_y);

    if (1 == stall)
    {
        speed_step = speed*1.56;
    }
    else
    {
        speed_step = 0-speed*1.56;
    }

    wheelrot_x += speed_step;

    if (wheelrot_x <= -360)
    {
        wheelrot_x += 360.0;
    }
    else if (wheelrot_x >= 360)
    {
        wheelrot_x -= 360.0;
    }

    CELL::matrix4 mat4WheelFR = Translate2 * RotateY * RotateX * Translate1;
    glUniformMatrix4fv(glGetUniformLocation(programCar,"car_offset1"), 1, GL_FALSE, mat4WheelFR.data());
}


void CFace::wheelrlMat(unsigned int speed, unsigned int stall)
{
    static float wheelrot_x = 0.0;
    float speed_step;

    CELL::matrix4 Translate1;
    CELL::matrix4 Translate2;
    CELL::matrix4 RotateX;

    Translate1.translate(CELL::float3( 790.963 / Carscale,  -(353.22 / Carscale + 0.1790),  -1285.04 / Carscale));
    Translate2.translate(CELL::float3( -790.963 / Carscale,   (353.22/ Carscale + 0.1790), 1285.04 / Carscale));
    RotateX.rotateX(wheelrot_x);

    if (1 == stall)
    {
        speed_step = speed*1.56;
    }
    else
    {
        speed_step = 0-speed*1.56;
    }

    wheelrot_x += speed_step;

    if (wheelrot_x <= -360)
    {
        wheelrot_x += 360.0;
    }
    else if (wheelrot_x >= 360)
    {
        wheelrot_x -= 360.0;
    }

    CELL::matrix4 mat4WheelRL = Translate2 * RotateX * Translate1;
    glUniformMatrix4fv(glGetUniformLocation(programCar,"car_offset1"), 1, GL_FALSE, mat4WheelRL.data());
}


void CFace::wheelrrMat(unsigned int speed, unsigned int stall)
{
    static float wheelrot_x = 0.0;
    float speed_step;

    CELL::matrix4 Translate1;
    CELL::matrix4 Translate2;
    CELL::matrix4 RotateX;

    Translate1.translate(CELL::float3( -790.963 / Carscale,  -(353.22 / Carscale + 0.1790), -1285.04 / Carscale));
    Translate2.translate(CELL::float3( 790.963 / Carscale,   (353.22 / Carscale + 0.1790), 1285.04 / Carscale));
    RotateX.rotateX(wheelrot_x);

    if (1 == stall)
    {
        speed_step = speed*1.56;
    }
    else
    {
        speed_step = 0-speed*1.56;
    }

    wheelrot_x += speed_step;

    if (wheelrot_x <= -360)
    {
        wheelrot_x += 360.0;
    }
    else if (wheelrot_x >= 360)
    {
        wheelrot_x -= 360.0;
    }

    CELL::matrix4 mat4WheelRR = Translate2 * RotateX * Translate1;
    glUniformMatrix4fv(glGetUniformLocation(programCar,"car_offset1"), 1, GL_FALSE, mat4WheelRR.data());
}


void CFace::doorflMat(unsigned int fldoor)
{
    static float doorroy   = 0.0;
    static float doorrot_y = 0.0;

    if ((0 == fldoor) && (doorrot_y < 0.0) && (doorrot_y >= -70.0))
        doorroy = 10.0;
    else if ((1 == fldoor) && (doorrot_y <= 0.0) && (doorrot_y > -70.0))
        doorroy = -10.0;
    else
        doorroy = 0.0;

    doorrot_y += doorroy;
    if (doorrot_y < -70.0)
        doorrot_y = -70.0;
    else if (doorrot_y > 0.0)
        doorrot_y = 0.0;

    CELL::matrix4 Translate1;
    CELL::matrix4 Translate2;
    CELL::matrix4 RotateY;

    Translate1.translate(CELL::float3( 92.115 / Carscale,-(109.662 / Carscale + 0.1790), 86.494 / Carscale));
    Translate2.translate(CELL::float3(-92.115 / Carscale, (109.662 / Carscale + 0.1790),-86.494 / Carscale));

    RotateY.rotateY(doorrot_y);

    CELL::matrix4 mat4DoorFL = Translate2 * RotateY * Translate1;
    glUniformMatrix4fv(glGetUniformLocation(programCar,"car_offset1"), 1, GL_FALSE, mat4DoorFL.data());
}


void CFace::doorfrMat(unsigned int frdoor)
{
    static float doorroy   = 0.0;
    static float doorrot_y = 0.0;

    if (0 == frdoor && doorrot_y > 0.0 && doorrot_y <= 70.0)
        doorroy = -10.0;
    else if (1 == frdoor && doorrot_y >= 0.0 && doorrot_y < 70.0)
        doorroy = 10.0;
    else
        doorroy = 0.0;

    doorrot_y += doorroy;
    if (doorrot_y < 0.0)
        doorrot_y = 0.0;
    else if (doorrot_y > 70.0)
        doorrot_y = 70.0;

    CELL::matrix4 Translate1;
    CELL::matrix4 Translate2;
    CELL::matrix4 RotateY;

    Translate1.translate(CELL::float3(-91.422 / Carscale, -(109.662 / Carscale + 0.1790), 87.019 / Carscale));
    Translate2.translate(CELL::float3( 91.422 / Carscale,  (109.662 / Carscale + 0.1790),-87.019 / Carscale));

    RotateY.rotateY(doorrot_y);

    CELL::matrix4 mat4DoorFR = Translate2 * RotateY * Translate1;
    glUniformMatrix4fv(glGetUniformLocation(programCar,"car_offset1"), 1, GL_FALSE, mat4DoorFR.data());
}


void CFace::doorrlMat(unsigned int rldoor)
{
    static float doorroy   = 0.0;
    static float doorrot_y = 0.0;

    if (0 == rldoor && doorrot_y < 0.0 && doorrot_y >= -70.0)
        doorroy = 10.0;
    else if (1 == rldoor && doorrot_y <= 0.0 && doorrot_y > -70.0)
        doorroy = -10.0;
    else
        doorroy = 0.0;

    doorrot_y += doorroy;
    if (doorrot_y < -70.0)
        doorrot_y = -70.0;
    else if (doorrot_y > 0.0)
        doorrot_y = 0.0;

    CELL::matrix4 Translate1;
    CELL::matrix4 Translate2;
    CELL::matrix4 RotateY;

    Translate1.translate(CELL::float3( 93.44 / Carscale,-(113.881 / Carscale + 0.1790),-22.12 / Carscale));
    Translate2.translate(CELL::float3(-93.44 / Carscale, (113.881 / Carscale + 0.1790), 22.12 / Carscale));

    RotateY.rotateY(doorrot_y);

    CELL::matrix4 mat4DoorRL = Translate2 * RotateY * Translate1;
    glUniformMatrix4fv(glGetUniformLocation(programCar,"car_offset1"), 1, GL_FALSE, mat4DoorRL.data());
}


void CFace::doorrrMat(unsigned int rrdoor)
{
    static float doorroy   = 0.0;
    static float doorrot_y = 0.0;

    if (0 == rrdoor && doorrot_y > 0.0 && doorrot_y <= 70.0)
        doorroy = -10.0;
    else if (1 == rrdoor && doorrot_y >= 0.0 && doorrot_y < 70.0)
        doorroy = 10.0;
    else
        doorroy = 0.0;

    doorrot_y += doorroy;
    if (doorrot_y < 0.0)
        doorrot_y = 0.0;
    else if (doorrot_y > 70.0)
        doorrot_y = 70.0;

    CELL::matrix4 Translate1;
    CELL::matrix4 Translate2;
    CELL::matrix4 RotateY;

    Translate1.translate(CELL::float3(-92.746 / Carscale,-(113.881 / Carscale + 0.1790),-21.594 / Carscale));
    Translate2.translate(CELL::float3( 92.746 / Carscale, (113.881 / Carscale + 0.1790), 21.594 / Carscale));

    RotateY.rotateY(doorrot_y);

    CELL::matrix4 mat4DoorRR = Translate2 * RotateY * Translate1;
    glUniformMatrix4fv(glGetUniformLocation(programCar,"car_offset1"), 1, GL_FALSE, mat4DoorRR.data());
}

void CFace::lightTurn(unsigned int Turn)
{
    if (1 == Turn)
    {
        glUniform1i(glGetUniformLocation(programCar, "_isTurn"), 1);
    }
}

void CFace::lightStop(unsigned int Break)
{
    if (1 == Break)
    {
        glUniform1i(glGetUniformLocation(programCar, "_isBrake"), 1);
    }
}

void CFace::othersMat()
{
    glUniformMatrix4fv(glGetUniformLocation(programCar,"car_offset1"), 1, GL_FALSE, offset1);
}


/*****************functions Lev 2**********************************/
void CFace::RenderObj(CObj& obj, VehicleSignal *stAVMVehicleSignal)
{
    int ver_offset = 0;
    int tex_offset = 0;

    glUseProgram(programCar);
    if (m_fileface.mtlindex != -1)
    {
        glUniform1i(glGetUniformLocation(programCar, "_isTurn"), 0);
        glUniform1i(glGetUniformLocation(programCar, "_isBrake"), 0);
        glUniform1i(glGetUniformLocation(programCar, "car_texture"), 0);
        glActiveTexture(GL_TEXTURE0);
        obj.m_ms[m_fileface.mtlindex].Set();
    }
    switch(m_fileface.g_type)
    {
        case LIGHTTL:
            lightTurn(stAVMVehicleSignal->leftTurnLight);
            othersMat();
            break;
        case LIGHTTR:
            lightTurn(stAVMVehicleSignal->rightTurnLight);
            othersMat();
            break;
        case LIGHTSTOP:
            lightStop(stAVMVehicleSignal->brakeLight);
            othersMat();
            break;
        case WHEELFL:
            wheelflMat(stAVMVehicleSignal->steeringAngle, stAVMVehicleSignal->speed, stAVMVehicleSignal->gear);
            break;
        case WHEELFR:
            wheelfrMat(stAVMVehicleSignal->steeringAngle, stAVMVehicleSignal->speed, stAVMVehicleSignal->gear);
            break;
        case WHEELRL:
            wheelrlMat(stAVMVehicleSignal->speed, stAVMVehicleSignal->gear);
            break;
        case WHEELRR:
            wheelrrMat(stAVMVehicleSignal->speed, stAVMVehicleSignal->gear);
            break;
        case DOORFL:
            doorflMat((stAVMVehicleSignal->doors>>0)&0x01);
            break;
        case DOORFR:
            doorfrMat((stAVMVehicleSignal->doors>>1)&0x01);
            break;
        case DOORRL:
            doorrlMat((stAVMVehicleSignal->doors>>2)&0x01);
            break;
        case DOORRR:
            doorrrMat((stAVMVehicleSignal->doors>>3)&0x01);
            break;
        default:
            othersMat();
            break;
    }
    glBindBuffer(GL_ARRAY_BUFFER, obj.m_vbo);
    glEnableVertexAttribArray(vsCar_position3);
    glEnableVertexAttribArray(vsCar_uv2);

    ver_offset = m_fileface.VerBegin * sizeof(float);
    tex_offset = ver_offset + 3*sizeof(float);
    glVertexAttribPointer(vsCar_position3, 3, GL_FLOAT, GL_FALSE, 20, (const GLvoid*)ver_offset);
    glVertexAttribPointer(vsCar_uv2, 2, GL_FLOAT, GL_FALSE, 20, (const GLvoid*)tex_offset);
    glDrawArrays(GL_TRIANGLES, 0, m_fileface.VerCount);

    glUniform1i(glGetUniformLocation(programCar, "_isTurn"), 0);
    glUniform1i(glGetUniformLocation(programCar, "_isBrake"), 0);
    glBindBuffer(GL_ARRAY_BUFFER,0);
    glBindTexture(GL_TEXTURE_2D, 0);
    glDisableVertexAttribArray(vsCar_position3);
    glDisableVertexAttribArray(vsCar_uv2);
    glUseProgram(0);
}


bool LoadCarModel(UChar *CarModelAddr, unsigned int cardatasize)
{
    bool ret = FALSE;

    do
    {
        if (pCObj == NULL)
        {
            pCObj = new CObj();
            if (pCObj == NULL)
            {
                AVM_ERROR("Create CObj failed!!!!!\n");
                break;
            }
        }
        if (FALSE == pCObj->LoadObj(CarModelAddr, cardatasize))
        {
            AVM_ERROR("failed to pCObj->LoadObj\n");
            break;
        }

        ret = TRUE;
    } while(0);

    return ret;
}


void esInitProgram_Car()
{
    GLuint hdVerShader = 0;
    GLuint hdFrgShader = 0;
    GLuint hdCarAttrib[2] = {0,0};

    esApplyAttribHandle(2, hdCarAttrib);
    vsCar_position3 = hdCarAttrib[0];
    vsCar_uv2 = hdCarAttrib[1];

    esLoadShader(&vshader_car, &fshader_car, &hdVerShader, &hdFrgShader);
    programCar = glCreateProgram();
    glAttachShader(programCar, hdVerShader);
    glAttachShader(programCar, hdFrgShader);
    glBindAttribLocation(programCar, vsCar_position3, ATTR_POSITION_CAR);
    glBindAttribLocation(programCar, vsCar_uv2, ATTR_UV_CAR);
    glLinkProgram(programCar);
}


void InitDeadZoneCoord(CarInfo stCarInfo, GLfloat *verCoords)
{
    float carLength, carWidth, zoneFront, zoneRear, zoneLR, picRatioLength, picRatioWidth;
    float X, Zup, Zdown;

    carLength = stCarInfo.carlength;//4748.0;
    carWidth  = stCarInfo.carwidth;//1875.0;
    zoneFront = stCarInfo.deadzoneFront;//100.0;
    zoneRear  = stCarInfo.deadzoneRear;//100.0;
    zoneLR    = stCarInfo.deadzoneLR;//120.0;
    picRatioLength = 0.9429;
    picRatioWidth  = 0.8846;

    X = ((carWidth/2.0 + zoneLR)/700.0)/picRatioWidth;
    Zup = -(((carLength/2.0 + zoneFront)/700.0)/picRatioLength);
    Zdown = ((carLength/2.0 + zoneRear)/700.0)/picRatioLength;

    verCoords[0] = -X;
    verCoords[1] = 0.2;
    verCoords[2] = Zup;

    verCoords[3] = -X;
    verCoords[4] = 0.2;
    verCoords[5] = Zdown;

    verCoords[6] = X;
    verCoords[7] = 0.2;
    verCoords[8] = Zup;

    verCoords[9] = X;
    verCoords[10] = 0.2;
    verCoords[11] = Zdown;
}


/*3Dռõͼ*/
void Load3DPic(const char *picFilePath[])
{
    char *tmppath = NULL;

    tmppath = (char*)malloc(100);
    strcpy(tmppath, picFilePath[0]);
    strcat(tmppath, PICTURE_DEADZONE);


    /*ä*/
    loadPicFile((const char **)&tmppath, 1, &DeadZoneTexID);

    /*״*/
//    loadPicFile(picFilePath, NUM_RADAR_PIC, texidRadar);
}

/*****************functions Lev 1**********************************/
bool carInit(char *dirCar, char *dirPic)
{
    int datasize = 0;
    bool ret = FALSE;

    do
    {
        esInitProgram_Car();

        datasize = LoadFile(dirCar, CAR_PATH, &pCarModelData, 0);      // pCarModelData is malloced here
        if ((0 == datasize) || ( NULL == pCarModelData))
        {
            AVM_ERROR("failed to load carmodel---datasize=%d\n", datasize);
            break;
        }

        if (FALSE ==LoadCarModel(pCarModelData, datasize))
        {
            AVM_ERROR("failed to LoadCarModel\n");
            break;
        }

        Load3DPic((const char**)&dirCar);
#if DRAW_DEADZONE
        stTmpCarParams.carlength = 4748.0;
        stTmpCarParams.carwidth = 1875.0;
        stTmpCarParams.deadzoneFront = 100.0;
        stTmpCarParams.deadzoneRear = 100.0;
        stTmpCarParams.deadzoneLR = 120.0;
#endif
        InitDeadZoneCoord(stTmpCarParams, verDeadZone);
        ret = TRUE;
    } while(0);

    if (NULL != pCarModelData)
    {
        free(pCarModelData);
        pCarModelData = NULL;
    }

    return ret;
}


void CObj::RenderCar(VehicleSignal *stAVMVehicleSignal)
{
    int i;
    /* draw faces */
    for (i = 0; i < cntfaces; ++i)
    {
        m_fs[i].RenderObj(*this, stAVMVehicleSignal);
    }
}

void DeadZoneRender()
{
    glUseProgram(programCar);
    glEnable(GL_BLEND);
    glDepthMask(GL_FALSE);
//    glBlendFuncSeparate(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA, GL_ONE, GL_ONE);
    glEnableVertexAttribArray(vsCar_position3);
    glEnableVertexAttribArray(vsCar_uv2);

    glUniformMatrix4fv(glGetUniformLocation(programCar,"car_offset1"), 1, GL_FALSE, offset1);
    glUniform1i(glGetUniformLocation(programCar,"car_texture"),0);
    glActiveTexture(GL_TEXTURE0);
    glBindTexture(GL_TEXTURE_2D, DeadZoneTexID);
    glVertexAttribPointer(vsCar_position3, 3, GL_FLOAT, GL_FALSE, 0, verDeadZone);
    glVertexAttribPointer(vsCar_uv2, 2, GL_FLOAT, GL_FALSE, 0, texDeadZone);
    glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);

    glDepthMask(GL_TRUE);
    glDisable(GL_BLEND);
    glBindTexture(GL_TEXTURE_2D, 0);
    glDisableVertexAttribArray(vsCar_position3);
    glDisableVertexAttribArray(vsCar_uv2);
    glUseProgram(0);
}

#ifdef ANYVIEW
void AngletoCoord(float angle, float&a, float&b, float&x, float&z)
{
    float radions = angle / 180.0 * PI;
    if ((int)angle%90 == 0)
    {
        switch ((int)angle)
        {
            case 0:
            case 360:
                x =  0.0;
                z = -b;
                break;
            case 90:
                x =  a;
                z =  0.0;
                break;
            case 180:
                x =  0.0;
                z =  b;
                break;
            case 270:
                x = -a;
                z =  0.0;
                break;
            default:
                break;
        }
    } else
    {
        if ((angle<270.0) && (angle>90.0))
        {
            z =  sqrt(pow(a * b, 2) / (pow(a, 2) + pow((b * tan(radions)), 2)));
        } else
        {
            z = -sqrt(pow(a * b, 2) / (pow(a, 2) + pow((b * tan(radions)), 2)));
        }
            x = -z * tan(radions);
    }
}


bool SetAnyPosCamera(int WhichView, float Tar_Agl, float Tar_yPercent, bool isAuto)
{
    bool ret = FALSE;
    do
    {
        AngletoCoord();
        ret = TRUE;
    } while(0);

    return ret;
}
#endif

void picRender3D(GLuint texid, GLfloat *verCoord, GLfloat *texCoord, int pointNum)
{}



