#ifndef __OBJ_H__
#define __OBJ_H__


#include "Material.h"
#include "Common.h"
#include "AVM.h"

using namespace std;


typedef struct _CarInfo
{
    float carlength;    /*λ: mm*/
    float carwidth;
    float deadzoneFront;
    float deadzoneRear;
    float deadzoneLR;
}CarInfo;

typedef enum {
    WHEELFL = 0,
    WHEELFR = 1,
    WHEELRL = 2,
    WHEELRR = 3,
    DOORFL  = 4,
    DOORFR  = 5,
    DOORRL  = 6,
    DOORRR  = 7,
    LIGHTFL = 8,
    LIGHTFR = 9,
    LIGHTRL = 10,
    LIGHTRR = 11,
    OTHERS  = 12,
    CARD_F  = 13,
    CARD_R  = 14,
    FOGLIGHT  = 15,
    INT        = 16,
    GLASS_FTB = 17,
    GLASS_FL  = 18,
    GLASS_FR  = 19,
    GLASS_RL  = 20,
    GLASS_RR  = 21,
    LIGHTSTOP = 22,
    LIGHTTL   = 23,
    LIGHTTR   = 24
} G_TYPE;

typedef struct fileface
{
    G_TYPE                    g_type;
    bool                    IsUv;
    bool                    IsNor;
    unsigned int             VerBegin;
    unsigned int             VerCount;
    int                        mtlindex;
} FileFace;

class CFace
{
    friend class CObj;
    typedef unsigned int Uniform;
public:
    CFace() {m_fileface.mtlindex = -1; m_fileface.g_type = OTHERS;}
    ~CFace() {}
    void lightTurn(unsigned int Turn);
    void lightStop(unsigned int Break);
    void wheelflMat(int steeringAngle, unsigned int speed, unsigned int stall);
    void wheelfrMat(int steeringAngle, unsigned int speed, unsigned int stall);
    void wheelrlMat(unsigned int speed, unsigned int stall);
    void wheelrrMat(unsigned int speed, unsigned int stall);
    void doorflMat(unsigned int fldoor);
    void doorfrMat(unsigned int frdoor);
    void doorrlMat(unsigned int rldoor);
    void doorrrMat(unsigned int rrdoor);
    void othersMat();
    void RenderObj(CObj& obj, VehicleSignal *stAVMVehicleSignal);

public:
    FileFace m_fileface;
};


class CObj
{
    friend class CPoint;
    friend class CLine;
    friend class CFace;

    enum {VERTEX = 0, TEXTURE = 1, NORMAL = 2};
public:
    CObj() {
        m_fs  = NULL;
        m_ms  = NULL;
        m_vbo = 0;
    }
    ~CObj(){}
    bool LoadObj(UChar *pCarmodel, unsigned int datasize);
    void RenderCar(VehicleSignal *stAVMVehicleSignal);

public:
    unsigned int                         m_vbo;
    CFace                                *m_fs;
    CMaterial                            *m_ms;
};

bool carInit(char *dirCar, char *dirPic);

void DeadZoneRender();

void picRender3D(GLuint texid, GLfloat *verCoord, GLfloat *texCoord, int pointNum);

#endif



