/*  BEGIN_FILE_HDR
************************************************************************************************
*   NOTICE
*   This software is the property of INVO Co.,Ltd.. Any information contained in this
*   doc should not be reproduced, or used, or disclosed without the written authorization from
*   INVO Co.,Ltd..
************************************************************************************************
*   File Name       : CommonTypes.h
*   Processor       : DM6437
*   Description     : Contains definitions of basic types, which can be used in user application.
************************************************************************************************
*    END_FILE_HDR*/

#ifndef COMMON_TYPES_H
#define COMMON_TYPES_H

#include "stdint.h"

#ifndef Uint8
typedef unsigned char               Uint8;
#endif

#ifndef Uint16
typedef unsigned short              Uint16;
#endif

#ifndef Uint32
typedef unsigned int                Uint32;
#endif


#ifndef Int8
typedef signed char                 Int8;
#endif

#ifndef Int16
typedef signed short                Int16;
#endif

#ifndef Int32
typedef signed int                  Int32;
#endif

#ifndef Uint64
typedef unsigned long long          Uint64;
#endif

#ifndef Int64
typedef signed long long            Int64;
#endif

#ifndef byte
typedef unsigned char               byte;
#endif

#ifndef word
typedef unsigned short              word;
#endif

#ifndef BOOL
typedef unsigned int                BOOL;
#endif

#ifndef TRUE
#define TRUE                        1
#endif

#ifndef FALSE
#define FALSE                       0
#endif

#ifndef NULL
#define NULL                        (void*)0
#endif


#endif /* COMMON_TYPES_H */

