#ifndef _LINE_H_
#define _LINE_H_

#include "Common.h"
#include "Calibration.h"

typedef struct _Corners
{
    int FL[6],FR[6];
    int BL[6],BR[6];
    int LF[6],LB[6];
    int RF[6],RB[6];
}Corners;

typedef struct __ModFrame
{
    int x;          /* X-coordinate in 1280 pixel */
    int y;          /* Y-coordinate in 720 pixel */
    int weight;
    int hight;
} ModFrame;

typedef struct __ModFrameInfo
{
    int carmeraIndex;   /* 0-1-2-3 : left-right-front-rear */
    int framenum;       /* cnt of detected obj, maximum is 3 */
    ModFrame frames[3]; /* position of detected obj */
} ModFrameInfo;

typedef struct _UndistViewTrack
{
    float Ltrack[10];
    float Rtrack[10];
}UndistViewTrack;

typedef struct _UndistLRViewTrack
{
    float Ltrack[10];
    float Rtrack[10];
} UndistLRViewTrack;

typedef enum __enumTracks
{
    TRACKS_CORRECTFRONT     = 0x00,
    TRACKS_CORRECTREAR      = 0x01,
    TRACKS_CORRECTLEFT      = 0x02,
    TRACKS_CORRECTRIGHT     = 0x03,
    TRACKS_CORRECT_LR_FRONT = 0x04,
    TRACKS_CORRECT_LR_REAR  = 0x05,
    TRACKS_3DTOPVIEW        = 0x06,
    TRACKS_NONE             =100
}enumTracks;

void LineInit ();

void SetMatrix_Tracks ( const float *camMatrixBowl, float *projectionBowl );

enumTracks SetPlaneTracksType ( avmViewState viewType );

void lineOfflineCorner ( Coord offlineCorner[4][23] );

void LineSaleCaliCorner ( int witchView);

void LineOrigViewMOD ( int camIdx );

void LineUndistViewMOD_Front ();

void LineUndistViewMOD_Rear ();

void LineUndistViewMOD_Left ();

void LineUndistViewMOD_Right ();

void LineTopViewModRender ();

void LineTracksRender ( OVSBasicInfo *pOVSBasicInfo_track, enumTracks frontrear, VehicleSignal* pstVehicleSignal );


#endif
