#ifndef __MATERIAL_H__
#define __MATERIAL_H__

#include <cstring>
#include <vector>
#include "CELLMath.h"
#include "Common.h"

using namespace std;
using namespace CELL;
class CObj;



struct SVertex
{
    float fX;
    float fY;
    float fZ;
};


struct SRgb
{
    float fR;
    float fG;
    float fB;
    float fA;
};

typedef struct filematerial
{
    SRgb             ambient;                                    //²ÄÖÊµÄ»·Ÿ³ÑÕÉ«
    SRgb             diffuse;                                    //²ÄÖÊµÄÉ¢ÉäÑÕÉ«
    SRgb             specular;                                    //²ÄÖÊµÄžß¹âÑÕÉ«
    SRgb             emission;                                    //²ÄÖÊµÄ
    float             Ns;                                              //žß¹âµÄŒ¯ÖÐ¶È
    float             Ni;
    float             fTrans;                                        //ÍžÃ÷¶È
    int             illum;
    float3            Tf;
    float              Tr;
    unsigned int     texoffset;
} FileMaterial;

typedef int Uniform;

class CTgaTex
{
public:
    CTgaTex() { m_byData = NULL; m_uTexName = 0;}
    ~CTgaTex() { if (m_byData) m_byData = NULL; }

    void InitTex(UChar * textureAddr);
    void SetTexture();

public:
    UChar*                m_byData;
    int                 m_width;
    int                    m_height;
    unsigned int        m_uTexName;
};

class CMaterial
{
    friend class CObj;
public:
    CMaterial()
    {
        memset((void *)(&m_filemtl), 0, sizeof(FileMaterial));
    }
    ~CMaterial() {}
    void Set();
    void InitTex(UChar *modelAddr);
    static void Init();
public:
    static Uniform      m_light_dir;
    static Uniform      m_light_amb;
    static Uniform      m_light_diff;
    static Uniform      m_light_spec;

    static Uniform      m_mater_amb;
    static Uniform      m_mater_diff;
    static Uniform      m_mater_spec;
    static Uniform      m_mater_spec_exp;

    static SVertex         m_light_direction;
    static SRgb            m_light_ambient_color;
    static SRgb            m_light_diffuse_color;
    static SRgb            m_light_specular_color;

public:
    FileMaterial     m_filemtl;
    CTgaTex         m_tgaTex;
};


#endif
