/**********************************************************************
***********************************************************************
**
**         Filename: Initialization.h 
**    
**           Author: Joe Cely
**          Created: 4/27/2018
**
**     Last Edit By: 
**        Last Edit: 
**    
**      Description: 
**	 Header file for the Initialization.c file.  
**
** 	Revision History:
**
**	    Code Review: 
**
**
***********************************************************************
**********************************************************************/


// Next two lines and the ending #endif guard against multiple inclusion
// thus making the header file idempotent.
#ifndef HEADER_INITIALIZATION_H_
#define HEADER_INITIALIZATION_H_


/*===================================================================*/
/*  T Y P E   D E C L A R A T I O N S                                */
/*===================================================================*/
// See Typedefs.h


/*===================================================================*/
/*  M A C R O S                                                      */
/*===================================================================*/
// None


/*===================================================================*/
/*  D E F I N I T I O N S                                            */
/*===================================================================*/
#define MISO_PORT        (GPIO_PIN_0 | GPIO_PIN_1 | GPIO_PIN_2 | GPIO_PIN_3 | GPIO_PIN_4 | GPIO_PIN_5 | GPIO_PIN_6 | GPIO_PIN_7)
#define MISO_SCLK        GPIO_PIN_3
#define SENSOR_SEL_1_4   (GPIO_PIN_0 | GPIO_PIN_1 | GPIO_PIN_2 | GPIO_PIN_3)
#define SENSOR_SEL_5_8   (GPIO_PIN_0 | GPIO_PIN_1 | GPIO_PIN_2 | GPIO_PIN_3)
#define SPI0_PORT_PINS   (GPIO_PIN_2 | GPIO_PIN_3 | GPIO_PIN_4 | GPIO_PIN_5)
#define SPI3_PORT_PINS   (GPIO_PIN_0 | GPIO_PIN_1 | GPIO_PIN_2 | GPIO_PIN_3)
//*****************************************************************************
//
// Values that can be passed to GPIODirModeSet as the ui32PinIO parameter, and
// returned from GPIODirModeGet.
//
//*****************************************************************************
#define GPIO_DIR_MODE_IN      0x00000000  // Pin is a GPIO input
#define GPIO_DIR_MODE_OUT     0x00000001  // Pin is a GPIO output
#define GPIO_DIR_MODE_HW      0x00000002  // Pin is a peripheral function

#define GPIO_PA0_U0RX           0x00000001
#define GPIO_PA1_U0TX           0x00000401
#define GPIO_PA2_SSI0CLK        0x0000080F
//-- Logic Levels --
#define LOGIC_TRUE            0x00000001
#define LOGIC_FALSE           0x00000000

//-- Error Codes --
#define NO_ERROR              0x00000000
#define ERR_TIMEOUT           0x00000001
#define ERR_CORRUPTDATA       0x00000002
#define ERR_TEST_ERROR        0x00000003

//-- SPI Communication Variables --
#define SPI_READ              0x00000080
#define SPI_WRITE             0x00000000
/*===================================================================*/
/*  F U N C T I O N   P R O T O T Y P E S                            */
/*===================================================================*/

//----- EXTERNAL ----------
extern void TD_HW_Initialization(void);
extern void TD_SW_Init_Routine(void);
/*===================================================================*/
/*  V A R I A B L E S                                                */
/*===================================================================*/
//----- MISO SHIFT REGISTER ARRAYS
//Measurement Reading format
//  g_aryMISO_SENSORx[0] - LHR_DATA_LSB
//  g_aryMISO_SENSORx[1] - LHR_DATA_MID
//  g_aryMISO_SENSORx[2] - LHR_DATA_MSB
//  g_aryMISO_SENSORx[3] - LHR_STATUS

extern volatile uint32_t  g_aryMISO_SENSOR1[10];
extern volatile uint32_t  g_aryMISO_SENSOR2[10];
extern volatile uint32_t  g_aryMISO_SENSOR3[10];
extern volatile uint32_t  g_aryMISO_SENSOR4[10];
extern volatile uint32_t  g_aryMISO_SENSOR5[10];
extern volatile uint32_t  g_aryMISO_SENSOR6[10];
extern volatile uint32_t  g_aryMISO_SENSOR7[10];
extern volatile uint32_t  g_aryMISO_SENSOR8[10];

//---- MISO SHIFT REGISTER PORT ARRAY
//This variable is used when reading 8 bits of information from
//the GroupChat Operation.  This is an 8 variable array where each
//double word represents one bit from SENSORS 1 - 8.
//
// g_dwMtrx_ShiftRegPort[0] is the MSB from the 8 bit reading
// g_dwMtrx_ShiftRegPort[7] is the LSB from the 8 bit reading
//
// uint32_t format = 0x000000[S8,S7,S6,S5,S4,S3,S2,S1]

extern volatile uint32_t g_dwMtrx_ShiftRegPort[8];

extern volatile bool  g_boolShiftRegPort_Flag;
extern volatile uint32_t g_dwINT_ShiftRegBitCount;
/*===================================================================*/
/*  M I S C                                                          */
/*===================================================================*/
// None

/************************************************************
 *              CONFIGURATION DIRECTIVES
 ************************************************************/
// The definitions below are code directives used to select
// code and configurations for the code build.
//----------------------------------------------------------

//-------------------------------------------
//         DIRECTIVE_SENSOR_TYPE
//-------------------------------------------
/*  1 -  35mm, 10 Turn Inductor, 14.91uH
 *  2 -  .8", 21uH
 *  3 -  14mm, 15 turns, ~7.4uH
 */
//-------------------------------------------
#define  DIRECTIVE_SENSOR_TYPE        SENSOR1
#define  SENSOR1   1
#define  SENSOR2   2
#define  SENSOR3   3


//-------------------------------------------
//         DIRECTIVE_USER_INTERFACE
//-------------------------------------------
/*  1 - UART Interface
 *  2 - ETHERNet Interface
 *  3 - ETHERCat Interface
 */
//-------------------------------------------
#define DIRECTIVE_USER_INTERFACE     UART
#define UART     1
#define ETHERNET 2
#define ETHERCAT 3

//-------------------------------------------
//   DIRECTIVE_INTERRUPT_LATENCY_TEST
//-------------------------------------------
/*  This directive configures PN0 to an output
 *  This port is toggled each time the Interrupt
 *  routine is entered.
 */
//-------------------------------------------
#define DIRECTIVE_INTERRUPT_LATENCY_TEST      OFF
#define OFF  0
#define ON   1

//-------------------------------------------
//   DIRECTIVE_INTERRUPT_LATENCY_TEST
//-------------------------------------------
/*  This directive is used to set the number of
 * bits being sent for the LHR reading.
 * 24 sends all 24 bits.  Any other number
 * configures the message for 14 ENOB.
 */
//-------------------------------------------
#define DIRECTIVE_NUMBEROFBYTES    24

/************************************************************
 *            CONFIGURATION DIRECTIVES END
 ************************************************************/

#endif  // HEADER_INITIALIZATION_H_
