/**********************************************************************
***********************************************************************
**
**         Filename: Main.h
**    
**           Author: Joe Cely
**          Created: 5/3/2017
**
**     Last Edit By: 
**        Last Edit: 
**    
**      Description: 
**	 Header file for TD_Main.c file and defines the Event Manager..
**
** 	Revision History:
**
**	    Code Review: 
**
**
***********************************************************************
**********************************************************************/


// Next two lines and the ending #endif guard against multiple inclusion
// thus making the header file idempotent.
#ifndef HEADER_TD_MAIN_H_
#define HEADER_TD_MAIN_H_


/*===================================================================*/
/*  T Y P E   D E C L A R A T I O N S                                */
/*===================================================================*/
//-- Event Handler bitwise definitions.
// These bits are normally Low.  When the bit is set high, the Event
// will be scheduled.

typedef struct sTag_EventHandler
{
//------------------ EVENT FLAGS --------------------
   /*BIT 00:  Flag used to indicate that a new Measurement has been made
    * and needs processing.
    */
    volatile uint32_t   EVENT_NewMeasurement   :1;

   /*BIT 01: Flag used to indicate a new EtherNetIP message is making a request.
    */
    volatile uint32_t   EVENT_NewEtherNetMsg   :1;

   /*BIT 02: Flag used to indicate a new message is ready to send out the UART.
    */
    volatile uint32_t   EVENT_SendUARTMessage   :1;

   /*BIT 03: Flag used to indicate a new message is ready to send out the UART.
     */
     volatile uint32_t   EVENT_NewUARTMessage  :1;

   /*BIT 04 - BIT8: UNDEFINED bits.
      */
      volatile uint32_t   EVENT_UNDEFINED       :4;

//------------------ STATUS FLAGS --------------------
    /*BIT 08: Flag used to indicate that the START MEASUREMENT command was issued.
     * this flag is used to activate the EVENT_SendMeasurement Flag after the defined
     * delay.
     */
    volatile uint32_t   STATUS_ActiveMeasurement :1;

     /*BIT 09 - 15: UNDEFINED
      */
    volatile uint32_t   STATUS_Undefined         :7;

//----------------- ERROR FLAGS -----------------------
     /* BIT16-23:  UNDEFINED
      */
    volatile uint32_t   ERROR_Undefined          :8;

//---------------- UNDEFINED --------------------------
     /* BIT 24 - 31:  UNDEFINED
      */
    volatile uint32_t    UNDEFINED_Undefined     :8;

} s_EventHandler_t;

typedef union uTag_EventHandler
{
    uint32_t          abyEventHandler;
    s_EventHandler_t  s_dwEventHandler;
}u_EventHandler_t;


//-- Operating Modes
typedef enum Op_modes_tag
{
    /** Uninitialized/Stopped **/
    STOPPED  =    1,
    READY    =    2,
    ACTIVE   =    3
} OpMode_t;

typedef struct sTag_OpMode
{
    /*
     * BITS0 - 7: Operating Mode of Devices
     */
    OpMode_t    byOperatingMode           :8;

    /*
     * BIT8: Sensor1 Error Indicator
     */
    uint32_t  ERRORIND_Sensor1            :1;

    /*
     * BIT9: Sensor1 Error Indicator
     */
    uint32_t  ERRORIND_Sensor2            :1;

    /*
     * BIT10: Sensor1 Error Indicator
     */
    uint32_t  ERRORIND_Sensor3            :1;

    /*
     * BIT11: Sensor1 Error Indicator
     */
    uint32_t  ERRORIND_Sensor4            :1;

    /*
     * BIT12: Sensor1 Error Indicator
     */
    uint32_t  ERRORIND_Sensor5            :1;

    /*
     * BIT13: Sensor1 Error Indicator
     */
    uint32_t   ERRORIND_Sensor6           :1;

    /*
     * BIT14: Sensor1 Error Indicator
     */
    uint32_t  ERRORIND_Sensor7            :1;

    /*
     * BIT15: Sensor1 Error Indicator
     */
    uint32_t  ERRORIND_Sensor8            :1;

    /*
     * UNDEFINED
     */
    uint32_t  UNDEFINED_OP                :16;
}s_OperatingMode_t;

/*===================================================================*/
/*  M A C R O S                                                      */
/*===================================================================*/
#define  BIT_TEST(var,pos)  ((var & (1<<(pos)))


/*===================================================================*/
/*  D E F I N I T I O N S                                            */
/*===================================================================*/


/*===================================================================*/
/*  F U N C T I O N   P R O T O T Y P E S                            */
/*===================================================================*/
extern void SensorClockStart(void);
extern void SensorClockStop(void);

/*===================================================================*/
/*  V A R I A B L E S                                                */
/*===================================================================*/
// None
extern volatile u_EventHandler_t  g_dwEventHandler;
extern volatile s_OperatingMode_t g_dwOperatingRegister;
extern uint32_t g_dwNumberOfDataBits;
/*===================================================================*/
/*  M I S C                                                          */
/*===================================================================*/
// None
#endif  // HEADER_INITIALIZATION_H_
