/**********************************************************************
***********************************************************************
**
**         Filename: TireDetectGPIOConfig.h 
**    
**           Author: Joe Cely
**          Created: 9/12/2017
**
**     Last Edit By: 
**        Last Edit: 
**    
**      Description: 
**	 Header file containing definitions and variables for the Tire Detect GPIOs.
**
** 	Revision History:
**
**	    Code Review: 
**
**
***********************************************************************
**********************************************************************/


// Next two lines and the ending #endif guard against multiple inclusion
// thus making the header file idempotent.
#ifndef HEADER_TD_GPIO_CONFIG_H_
#define HEADER_TD_GPIO_CONFIG_H_


/*===================================================================*/
/*  T Y P E   D E C L A R A T I O N S                                */
/*===================================================================*/
/* ON Board LED pins which are connected to GPIO pins. */
typedef enum GPIO_LED {
    USER_LED1 = 0,
    USER_LED2,
    USER_LED3,
    USER_LED4
}GPIO_LED;



/*===================================================================*/
/*  M A C R O S                                                      */
/*===================================================================*/


/*===================================================================*/
/*  D E F I N I T I O N S                                            */
/*===================================================================*/

#define GPIO_BASE_ADDR GPIO_INTR_LED_BASE_ADDR
#define GPIO_LED_PIN   GPIO_LED_PIN_NUM
#define GPIO_PIN_VAL_LOW     (0U)
#define GPIO_PIN_VAL_HIGH    (1U)

/*===================================================================*/
/*  F U N C T I O N   P R O T O T Y P E S                            */
/*===================================================================*/

/*===================================================================*/
/*  V A R I A B L E S                                                */
/*===================================================================*/


/*===================================================================*/
/*  M I S C                                                          */
/*===================================================================*/
// None
#endif  // HEADER_TD_GPIO_CONFIG_H_
