/**********************************************************************
***********************************************************************
**
**         Filename: Initialization.h 
**    
**           Author: Joe Cely
**          Created: 9/12/2017
**
**     Last Edit By: 
**        Last Edit: 
**    
**      Description: 
**	 Header file for the Initialization.c file.  
**
** 	Revision History:
**
**	    Code Review: 
**
**
***********************************************************************
**********************************************************************/


// Next two lines and the ending #endif guard against multiple inclusion
// thus making the header file idempotent.
#ifndef HEADER_UARTMESSAGAES_H_
#define HEADER_UARTMESSAGAES_H_


/*===================================================================*/
/*  T Y P E   D E C L A R A T I O N S                                */
/*===================================================================*/
// See Typedefs.h


/*===================================================================*/
/*  M A C R O S                                                      */
/*===================================================================*/
// None


/*===================================================================*/
/*  D E F I N I T I O N S                                            */
/*===================================================================*/
//These definitions are used by the UART_Message routine to determine
//which message should be displayed.

#define   UART_OPENING_MSG     1
#define   UART_MEASUREMENT_MSG 2
#define   UART_STOP_MSG       '#'
#define   UART_PROGRAM_MSG    'P'
#define   UART_START_MSG      'S'
#define   UART_STATUS_MSG     'A'
#define   UART_COMMTEST_MSG   'C'
#define   UART_VERSION_MSG    'V'
#define   UART_ERROR_MSG      20
#define   UART_PROGRAM_OK     21
#define   UART_PROGRAM_FAIL   22


/*===================================================================*/
/*  F U N C T I O N   P R O T O T Y P E S                            */
/*===================================================================*/

//----- EXTERNAL ----------
extern void UART_Message(uint32_t dwMessage);
extern void UART_Initialization(void);
extern uint32_t UART_CheckForMessage(void);
/*===================================================================*/
/*  V A R I A B L E S                                                */
/*===================================================================*/
// None


/*===================================================================*/
/*  M I S C                                                          */
/*===================================================================*/
// None
#endif  // HEADER_INITIALIZATION_H_
