/**********************************************************************
***********************************************************************
**
**         Filename: Initialization.c
**
**           Author: J. Cely
**          Created: 04/27/2018
**
**      Description:
**   This file contains the routines used to initialize the settings and
**   peripherals of the AM335x
**
**
** Revision History:
**
**
***********************************************************************
**********************************************************************/

/*===================================================================*/
/*  I N C L U D E    F I L E S                                       */
/*===================================================================*/
//-- Required --



//-- Additional --
/* TI-RTOS Header files */
#include <ti/drv/gpio/GPIO.h>
#include <ti/drv/gpio/soc/GPIO_soc.h>

#include <ti/drv/gpio/test/led_blink/src/GPIO_log.h>

#include <ti/board/board.h>
#include "TireDetectGPIOConfig.h"
#include "Initialization.h"
#include "Utility_Routines.h"


/*===================================================================*/
/*  D E F I N I T I O N S                                            */
/*===================================================================*/




/*===================================================================*/
/*  F U N C T I O N   P R O T O T Y P E S                            */
/*===================================================================*/


/*===================================================================*/
/*  V A R I A B L E S                                                */
/*===================================================================*/
volatile uint32_t  g_aryMISO_SENSOR1[10];
volatile uint32_t  g_aryMISO_SENSOR2[10];
volatile uint32_t  g_aryMISO_SENSOR3[10];
volatile uint32_t  g_aryMISO_SENSOR4[10];
volatile uint32_t  g_aryMISO_SENSOR5[10];
volatile uint32_t  g_aryMISO_SENSOR6[10];
volatile uint32_t  g_aryMISO_SENSOR7[10];
volatile uint32_t  g_aryMISO_SENSOR8[10];
volatile uint32_t  g_dwMtrx_ShiftRegPort[8];
volatile bool  g_boolShiftRegPort_Flag;
volatile uint32_t g_dwINT_ShiftRegBitCount;

/*===================================================================*/
/*  T Y P E   D E C L A R A T I O N S                                */
/*===================================================================*/


/*===================================================================*/
/*  M A C R O S                                                      */
/*===================================================================*/


/*===================================================================*/
/*  M A J O R    R O U T I N E S                                     */
/*===================================================================*/


/***********************************************************************
**
**            Filename: Initialization.c
**        Routine Name: TD_Initialization
**
**              Author: Joe Cely
**             Created: 4/27/2018
**
**        Last Edit By:
**           Last Edit:
**
**  Function Arguments: None
**    Function Returns: None
**
**         Description:
** This routine is called by the main() routine and is used to initialize the
** board peripherals and setup the proper SYSBIOS drivers.
** Tire Detect Sensors.
**
**  PORT     DESCRIPTION                 SIGNAL       DIR
**--------------------------------------------------------
** SPI0
**   PA2     GROUP CHAT SPI CLOCK        SSI0CLK       O
**   PA3     GROUP CHAT SPI CHIP SEL     SSI0FSS       O
**   PA4     GROUP CHAT SPI MOSI         SSI0XDAT0     O
**   PA5     GROUP CHAT SPI MISO         SSI0XDAT1     I
**
**SPI3
**   PQ0     ONE ON ONE SPI CLOCK        SSI3CLK       O
**   PQ1     ONE ON ONE SPI CHIP SEL     SSI3FSS       O
**   PQ2     ONE ON ONE SPI MOSI         SSI3XDAT0     O
**   PQ3     ONE ON ONE SPI MISO         SSI3XDAT1     I
**
**SHIFT REGISTER
**   PK0     GROUP CHAT MISO SENSOR 1    MISO1         I
**   PK1     GROUP CHAT MISO SENSOR 2    MISO2         I
**   PK2     GROUP CHAT MISO SENSOR 3    MISO3         I
**   PK3     GROUP CHAT MISO SENSOR 4    MISO4         I
**   PK4     GROUP CHAT MISO SENSOR 5    MISO5         I
**   PK5     GROUP CHAT MISO SENSOR 6    MISO6         I
**   PK6     GROUP CHAT MISO SENSOR 7    MISO7         I
**   PK6     GROUP CHAT MISO SENSOR 8    MISO8         I
**
**   PP3     GROUP CHAT SPIOCLK FEED     SPIOCLK_FEED  I
**
**SPI PORT SELECTION
**   PE0     SINGLE CHIP CONFIG SENSOR1  SENSOR1       O
**   PE1     SINGLE CHIP CONFIG SENSOR1  SENSOR2       O
**   PE2     SINGLE CHIP CONFIG SENSOR1  SENSOR3       O
**   PE3     SINGLE CHIP CONFIG SENSOR1  SENSOR4       O
**   PH0     SINGLE CHIP CONFIG SENSOR1  SENSOR5       O
**   PH1     SINGLE CHIP CONFIG SENSOR1  SENSOR6       O
**   PH2     SINGLE CHIP CONFIG SENSOR1  SENSOR7       O
**   PH3     SINGLE CHIP CONFIG SENSOR1  SENSOR8       O
**
**REFERENCE CLOCK
**   PQ4     REFERENCE CLOCK             DIVSCLK       O
***********************************************************************/
void TD_HW_Initialization(void)
{
    Board_initCfg boardCfg;


    boardCfg = BOARD_INIT_PINMUX_CONFIG |
               BOARD_INIT_MODULE_CLOCK |
              BOARD_INIT_UART_STDIO;

    /*The Board_init routine can be found in
     * C:\ti\pdk_am335x_1_0_9\packages\ti\board\src\icev2AM335x
     * This routine takes the boardCfg variable and determines which peripheral
     * to initialize.  All of the .c files in this directory are used primarily
     * for initialization of the specific board.
     */
    Board_init(boardCfg);

 //   ConfigPWM2();

}



/***********************************************************************
**
**            Filename: Initialization.c
**        Routine Name: TD_SW_Init_Routine
**
**              Author: Joe Cely
**             Created: 4/27/2018
**
**        Last Edit By:
**           Last Edit:
**
**  Function Arguments: None
**    Function Returns: None
**
**         Description:
** This routine is used to initialize the software parameters used by the
** Hardware peripherals.  This initialization is primarily the peripheral
** structures that setup the specific parameters of the peripheral.  (i.e. UART
** speed, I/O direction, etc)
**
**
***********************************************************************/
void TD_SW_Init_Routine(void)
{
    /* GPIO initialization */
        GPIO_init();
    
}


