/**********************************************************************
***********************************************************************
**
**         Filename: TireDetectGPIOConfig.c
**
**           Author: Joe Cely
**          Created: 4/25/2018
**
**     Last Edit By:
**        Last Edit:
**
**      Description:
**   This file contains the definitions for the GPIO pins in the Tire
**   Detect Architecture.  The GPIO_v1_config structure is required by 
**   SYSBIOS GPIO_driver files.
**   
**   This structure is composed of how the pin should be setup, the 
**   callback routine, if it's an interrupt, and the size of this structure
**   
**
**  Revision History:
**
**      Code Review:
**
**
***********************************************************************
**********************************************************************/

/*===================================================================*/
/*  I N C L U D E    F I L E S                                       */
/*===================================================================*/
#include <stdio.h>
#include <ti/drv/gpio/GPIO.h>
#include <ti/drv/gpio/soc/GPIO_soc.h>
#include "TireDetectGPIOConfig.h"

/*===================================================================*/
/*  T Y P E   D E C L A R A T I O N S                                */
/*===================================================================*/
// See Typedefs.h


/*===================================================================*/
/*  M A C R O S                                                      */
/*===================================================================*/
// None


/*===================================================================*/
/*  D E F I N I T I O N S                                            */
/*===================================================================*/
//MISO PORT PINS
#define MISO1_PIN_NUM       (0x0C)
#define MISO2_PIN_NUM       (0x0D)
#define MISO3_PIN_NUM       (0x08)
#define MISO4_PIN_NUM       (0x12)
#define MISO5_PIN_NUM       (0x13)
#define MISO6_PIN_NUM       (0x14)
#define MISO7_PIN_NUM       (0x15)
#define MISO8_PIN_NUM       (0x09)

#define MISO_PORT_NUM0      (0x00)
#define MISO_PORT_NUM1      (0x01)
#define MISO_PORT_NUM3      (0x03)


// LED Pin and Port Numbers
#define LED1_PIN_NUM        (0x11)
#define LED2_PIN_NUM        (0x10)
#define LED3_PIN_NUM        (0x09)
#define LED4_PIN_NUM        (0x1D)

#define LED1_PORT_NUM        (0x00)
#define LED2_PORT_NUM        (0x00)
#define LED3_PORT_NUM        (0x03)
#define LED4_PORT_NUM        (0x01)


/* GPIO Driver board specific pin configuration structure */
GPIO_PinConfig gpioPinConfigs[] = {
    /*SENSOR MISO PORTS*/
    /* These are input ports that are used for the Group Chat SPI
     * communications
     */
    GPIO_DEVICE_CONFIG((MISO_PORT_NUM0 + 1), MISO1_PIN_NUM) |GPIO_CFG_INPUT,
    GPIO_DEVICE_CONFIG((MISO_PORT_NUM0 + 1), MISO2_PIN_NUM) |GPIO_CFG_INPUT,
    GPIO_DEVICE_CONFIG((MISO_PORT_NUM1 + 1), MISO3_PIN_NUM) |GPIO_CFG_INPUT,
    GPIO_DEVICE_CONFIG((MISO_PORT_NUM3 + 1), MISO4_PIN_NUM) |GPIO_CFG_INPUT,
    GPIO_DEVICE_CONFIG((MISO_PORT_NUM3 + 1), MISO5_PIN_NUM) |GPIO_CFG_INPUT,
    GPIO_DEVICE_CONFIG((MISO_PORT_NUM3 + 1), MISO6_PIN_NUM) |GPIO_CFG_INPUT,
    GPIO_DEVICE_CONFIG((MISO_PORT_NUM3 + 1), MISO7_PIN_NUM) |GPIO_CFG_INPUT,
    GPIO_DEVICE_CONFIG((MISO_PORT_NUM1 + 1), MISO8_PIN_NUM) |GPIO_CFG_INPUT,

    /* LEDs on the ICEv2 Platform */
    GPIO_DEVICE_CONFIG((LED1_PORT_NUM + 1), LED1_PIN_NUM) |GPIO_CFG_OUTPUT,
    GPIO_DEVICE_CONFIG((LED2_PORT_NUM + 1), LED2_PIN_NUM) |GPIO_CFG_OUTPUT,
    GPIO_DEVICE_CONFIG((LED3_PORT_NUM + 1), LED3_PIN_NUM) |GPIO_CFG_OUTPUT,
    GPIO_DEVICE_CONFIG((LED4_PORT_NUM + 1), LED4_PIN_NUM) |GPIO_CFG_OUTPUT
   
    
    /* Input pin with interrupt enabled : User LED */
    //GPIO_DEVICE_CONFIG((GPIO_USER0_LED_PORT_NUM + 1), GPIO_USER0_LED_PIN_NUM) |
    //GPIO_CFG_IN_INT_RISING | GPIO_CFG_INPUT,

    /* Output pin : User LED */
    //GPIO_DEVICE_CONFIG((GPIO_USER1_LED_PORT_NUM + 1), GPIO_USER1_LED_PIN_NUM) |
    //GPIO_CFG_OUTPUT
};

/* GPIO Driver call back functions */
GPIO_CallbackFxn gpioCallbackFunctions[] = {
    NULL,
    NULL,
    NULL,
    NULL
};

/* GPIO Driver configuration structure */
GPIO_v1_Config GPIO_v1_config = {
    gpioPinConfigs,
    gpioCallbackFunctions,
    sizeof(gpioPinConfigs) / sizeof(GPIO_PinConfig),
    sizeof(gpioCallbackFunctions) / sizeof(GPIO_CallbackFxn),
    0x1U,
    };
